/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.converter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class DocumentConverter
extends AbstractConverter<Document> {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public <G> G convert(Type targetType, Object sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        if (sourceValue instanceof Document) {
            return this.convertFromType(targetType, sourceValue);
        }
        return (G)super.convert(targetType, sourceValue);
    }

    public Document convertToType(Type targetType, Object sourceValue) {
        if (sourceValue instanceof XWikiDocument) {
            return ((XWikiDocument)sourceValue).newDocument((XWikiContext)this.contextProvider.get());
        }
        throw new ConversionException(String.format("Unsupported source type [%s]", sourceValue.getClass()));
    }

    private <G> G convertFromType(Type targetType, Object sourceValue) {
        if (targetType.equals(String.class)) {
            return (G)this.convertToString((Document)sourceValue);
        }
        if (EntityReference.class.isAssignableFrom(ReflectionUtils.getTypeClass((Type)targetType))) {
            return (G)this.convertToEntityReference((Document)sourceValue);
        }
        if (targetType == XWikiDocument.class) {
            return (G)this.convertToXWikiDocument((Document)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private EntityReference convertToEntityReference(Document document) {
        return document.getDocumentReference();
    }

    private XWikiDocument convertToXWikiDocument(Document document) {
        return document.getDocument();
    }

    protected String convertToString(Document value) {
        return (String)this.serializer.serialize((EntityReference)value.getDocumentReference(), new Object[0]);
    }
}

