/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.context;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.context.RequestInitializer;
import com.xpn.xwiki.internal.context.SerializableHttpSessionWrapper;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.context.internal.concurrent.AbstractContextStore;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
@Named(value="XWikiContext")
public class XWikiContextContextStore
extends AbstractContextStore {
    public static final String PROP_WIKI = "wiki";
    public static final String PROP_USER = "user";
    public static final String PROP_SECURE_AUTHOR = "author";
    public static final String PROP_SECURE_DOCUMENT = "secureDocument";
    public static final String PROP_LOCALE = "locale";
    public static final String PROP_ACTION = "action";
    public static final String PREFIX_PROP_REQUEST = "request.";
    public static final String SUFFIX_PROP_REQUEST_BASE = "base";
    public static final String SUFFIX_PROP_REQUEST_URL = "url";
    public static final String SUFFIX_PROP_REQUEST_CONTEXTPATH = "contextpath";
    public static final String SUFFIX_PROP_REQUEST_PARAMETERS = "parameters";
    public static final String SUFFIX_PROP_REQUEST_COOKIES = "cookies";
    public static final String SUFFIX_PROP_REQUEST_HEADERS = "headers";
    public static final String SUFFIX_PROP_REQUEST_REMOTE_ADDR = "remoteAddr";
    public static final String SUFFIX_PROP_REQUEST_SESSION = "session";
    public static final String SUFFIX_PROP_REQUEST_WIKI = "wiki";
    public static final String PROP_REQUEST_BASE = "request.base";
    public static final String PROP_REQUEST_URL = "request.url";
    public static final String PROP_REQUEST_CONTEXTPATH = "request.contextpath";
    public static final String PROP_REQUEST_PARAMETERS = "request.parameters";
    public static final String PROP_REQUEST_COOKIES = "request.cookies";
    public static final String PROP_REQUEST_HEADERS = "request.headers";
    public static final String PROP_REQUEST_REMOTE_ADDR = "request.remoteAddr";
    public static final String PROP_REQUEST_SESSION = "request.session";
    public static final String PROP_REQUEST_WIKI = "request.wiki";
    public static final String PREFIX_PROP_DOCUMENT = "doc.";
    public static final String SUFFIX_PROP_DOCUMENT_REFERENCE = "reference";
    public static final String SUFFIX_PROP_DOCUMENT_REVISION = "revision";
    public static final String PROP_DOCUMENT_REFERENCE = "doc.reference";
    public static final String PROP_DOCUMENT_REVISION = "doc.revision";
    private static final String REV = "rev";
    private static final DocumentReference SUPERADMIN_REFERENCE = new DocumentReference("xwiki", "XWiki", "superadmin");
    @Inject
    private Provider<XWikiContext> writeProvider;
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> readProvider;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private RequestInitializer requestInitializer;
    @Inject
    private Logger logger;
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;

    public XWikiContextContextStore() {
        super(new String[]{"wiki", PROP_USER, PROP_LOCALE, PROP_ACTION, PROP_REQUEST_BASE, PROP_REQUEST_URL, PROP_REQUEST_PARAMETERS, PROP_REQUEST_HEADERS, PROP_REQUEST_COOKIES, PROP_REQUEST_REMOTE_ADDR, PROP_REQUEST_SESSION, PROP_REQUEST_WIKI, PROP_DOCUMENT_REFERENCE, PROP_DOCUMENT_REVISION});
    }

    public void save(Map<String, Serializable> contextStore, Collection<String> entries) {
        XWikiContext xcontext = (XWikiContext)this.readProvider.get();
        if (xcontext != null) {
            this.save(contextStore, "wiki", (Serializable)((Object)xcontext.getWikiId()), entries);
            this.save(contextStore, PROP_USER, (Serializable)xcontext.getUserReference(), entries);
            this.save(contextStore, PROP_SECURE_AUTHOR, (Serializable)xcontext.getAuthorReference(), entries);
            this.save(contextStore, PROP_LOCALE, xcontext.getLocale(), entries);
            this.save(contextStore, PROP_ACTION, (Serializable)((Object)xcontext.getAction()), entries);
            this.saveDocument(contextStore, PREFIX_PROP_DOCUMENT, xcontext, entries);
            this.save(contextStore, PREFIX_PROP_REQUEST, xcontext.getRequest(), entries, xcontext);
        }
    }

    private void saveDocument(Map<String, Serializable> contextStore, String prefix, XWikiContext xcontext, Collection<String> entries) {
        XWikiDocument document = xcontext.getDoc();
        if (document != null) {
            this.save((key, subkey) -> {
                switch (subkey) {
                    case "reference": {
                        contextStore.put(key, (Serializable)document.getDocumentReferenceWithLocale());
                        break;
                    }
                    case "revision": {
                        if (!Objects.equals(document.getVersion(), xcontext.get(REV))) break;
                        contextStore.put(key, (Serializable)((Object)document.getVersion()));
                        break;
                    }
                }
            }, prefix, entries);
        }
    }

    private void save(Map<String, Serializable> contextStore, String prefix, XWikiRequest request, Collection<String> entries, XWikiContext xcontext) {
        if (request != null) {
            this.save((key, subkey) -> {
                switch (subkey) {
                    case "base": {
                        this.saveRequestBase(contextStore, request);
                        break;
                    }
                    case "url": {
                        this.saveRequestURL(contextStore, request);
                        break;
                    }
                    case "parameters": {
                        this.saveRequestParameters(contextStore, request);
                        break;
                    }
                    case "headers": {
                        this.saveRequestHeaders(contextStore, request);
                        break;
                    }
                    case "cookies": {
                        this.saveRequestCookies(contextStore, request);
                        break;
                    }
                    case "remoteAddr": {
                        this.saveRequestRemoteAddr(contextStore, request);
                        break;
                    }
                    case "session": {
                        this.saveRequestSession(contextStore, request);
                        break;
                    }
                    case "wiki": {
                        contextStore.put(key, (Serializable)((Object)xcontext.getOriginalWikiId()));
                        break;
                    }
                    default: {
                        this.saveRequestAll(contextStore, key, request);
                    }
                }
            }, prefix, entries);
        }
    }

    private void saveRequestBase(Map<String, Serializable> contextStore, XWikiRequest request) {
        URL url = HttpServletUtils.getSourceURL((HttpServletRequest)request);
        try {
            contextStore.put(PROP_REQUEST_BASE, new URL(url.getProtocol(), url.getHost(), url.getPort(), ""));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.saveRequestContextPath(contextStore, request);
    }

    private void saveRequestURL(Map<String, Serializable> contextStore, XWikiRequest request) {
        contextStore.put(PROP_REQUEST_URL, HttpServletUtils.getSourceURL((HttpServletRequest)request));
        this.saveRequestContextPath(contextStore, request);
    }

    private void saveRequestContextPath(Map<String, Serializable> contextStore, XWikiRequest request) {
        contextStore.put(PROP_REQUEST_CONTEXTPATH, (Serializable)((Object)request.getContextPath()));
    }

    private void saveRequestParameters(Map<String, Serializable> contextStore, XWikiRequest request) {
        contextStore.put(PROP_REQUEST_PARAMETERS, new LinkedHashMap(request.getParameterMap()));
    }

    private void saveRequestHeaders(Map<String, Serializable> contextStore, XWikiRequest request) {
        if (request.getHeaderNames() != null) {
            Map headers = Collections.list(request.getHeaderNames()).stream().map(headerName -> Map.entry(headerName, Collections.list(request.getHeaders((String)headerName)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right, () -> new LinkedHashMap()));
            contextStore.put(PROP_REQUEST_HEADERS, (Serializable)((Object)headers));
        }
    }

    private void saveRequestCookies(Map<String, Serializable> contextStore, XWikiRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            cookies = (Cookie[])Stream.of(cookies).map(Cookie::clone).toArray(Cookie[]::new);
        }
        contextStore.put(PROP_REQUEST_COOKIES, (Serializable)cookies);
    }

    private void saveRequestRemoteAddr(Map<String, Serializable> contextStore, XWikiRequest request) {
        contextStore.put(PROP_REQUEST_REMOTE_ADDR, (Serializable)((Object)request.getRemoteAddr()));
    }

    private void saveRequestSession(Map<String, Serializable> contextStore, XWikiRequest request) {
        contextStore.put(PROP_REQUEST_SESSION, new SerializableHttpSessionWrapper(request.getSession()));
    }

    private void saveRequestAll(Map<String, Serializable> contextStore, String key, XWikiRequest request) {
        this.saveRequestURL(contextStore, request);
        this.saveRequestParameters(contextStore, request);
        this.saveRequestHeaders(contextStore, request);
        this.saveRequestCookies(contextStore, request);
        this.saveRequestRemoteAddr(contextStore, request);
        this.saveRequestSession(contextStore, request);
    }

    public void restore(Map<String, Serializable> contextStore) {
        boolean restricted;
        XWikiContext xcontext = (XWikiContext)this.writeProvider.get();
        String storedWikiId = null;
        if (contextStore.containsKey("wiki")) {
            storedWikiId = (String)((Object)contextStore.get("wiki"));
            xcontext.setWikiId(storedWikiId);
        }
        Object userReference = contextStore.containsKey(PROP_USER) ? (DocumentReference)contextStore.get(PROP_USER) : (contextStore.containsKey(PROP_SECURE_AUTHOR) ? ((restricted = ((Boolean)this.get(contextStore, "rendering.restricted", false)).booleanValue()) ? null : (DocumentReference)contextStore.get(PROP_SECURE_AUTHOR)) : SUPERADMIN_REFERENCE);
        xcontext.setUserReference((DocumentReference)userReference);
        if (contextStore.containsKey(PROP_LOCALE)) {
            xcontext.setLocale((Locale)contextStore.get(PROP_LOCALE));
        }
        if (contextStore.containsKey(PROP_ACTION)) {
            xcontext.setAction((String)((Object)contextStore.get(PROP_ACTION)));
        }
        this.restoreDocument(storedWikiId, contextStore, xcontext);
        this.restoreAuthor(contextStore, xcontext);
        this.requestInitializer.restoreRequest(storedWikiId, contextStore, xcontext);
    }

    private void restoreAuthor(Map<String, Serializable> contextStore, XWikiContext xcontext) {
        if (contextStore.containsKey(PROP_SECURE_AUTHOR)) {
            DocumentReference authorReference = (DocumentReference)contextStore.get(PROP_SECURE_AUTHOR);
            this.restoreAuthor(contextStore, authorReference, xcontext);
        }
    }

    private void restoreAuthor(Map<String, Serializable> contextStore, DocumentReference authorReference, XWikiContext xcontext) {
        DocumentReference secureDocumentReference = (DocumentReference)contextStore.get(PROP_SECURE_DOCUMENT);
        XWikiDocument secureDocument = null;
        if (secureDocumentReference != null) {
            secureDocument = this.getSecureDocument(secureDocumentReference, authorReference, xcontext);
        }
        if (secureDocument == null) {
            secureDocument = new XWikiDocument(new DocumentReference(authorReference != null ? authorReference.getWikiReference().getName() : xcontext.getMainXWiki(), "SUSpace", "SUPage"));
            secureDocument.setAuthorReference(authorReference);
            secureDocument.setCreatorReference(authorReference);
        }
        secureDocument.setContentAuthorReference(authorReference);
        xcontext.put("sdoc", secureDocument);
    }

    private XWikiDocument getSecureDocument(DocumentReference secureDocumentReference, DocumentReference authorReference, XWikiContext xcontext) {
        XWikiDocument secureDocument = (XWikiDocument)xcontext.get("sdoc");
        if (secureDocument != null && secureDocument.getDocumentReference().equals((Object)secureDocumentReference)) {
            if (!Objects.equals(secureDocument.getContentAuthorReference(), authorReference)) {
                secureDocument = secureDocument.clone();
            }
        } else {
            try {
                secureDocument = xcontext.getWiki().getDocument(secureDocumentReference, xcontext);
                if (!Objects.equals(secureDocument.getContentAuthorReference(), authorReference)) {
                    secureDocument = secureDocument.clone();
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to load secure document [{}]", (Object)secureDocumentReference, (Object)e);
                secureDocument = new XWikiDocument(secureDocumentReference);
                secureDocument.setAuthorReference(authorReference);
                secureDocument.setCreatorReference(authorReference);
            }
        }
        return secureDocument;
    }

    private void restoreDocument(String storedWikiId, Map<String, Serializable> contextStore, XWikiContext xcontext) {
        if (contextStore.containsKey(PROP_DOCUMENT_REVISION)) {
            xcontext.put(REV, contextStore.get(PROP_DOCUMENT_REVISION));
        }
        if (contextStore.containsKey(PROP_DOCUMENT_REFERENCE)) {
            DocumentReference document = (DocumentReference)contextStore.get(PROP_DOCUMENT_REFERENCE);
            this.restoreDocument(document, xcontext);
            if (storedWikiId == null) {
                xcontext.setWikiReference(document.getWikiReference());
            }
        } else if (storedWikiId != null) {
            try {
                WikiDescriptor wikiDescriptor = this.wikis.getById(storedWikiId);
                if (wikiDescriptor != null) {
                    this.restoreDocument(wikiDescriptor.getMainPageReference(), xcontext);
                }
            }
            catch (WikiManagerException e) {
                this.logger.warn("Can't access the descriptor of the restored context wiki [{}]", (Object)storedWikiId, (Object)e);
            }
        }
    }

    private void restoreDocument(DocumentReference documentReference, XWikiContext xcontext) {
        XWikiDocument document;
        try {
            document = xcontext.getWiki().getDocument(documentReference, xcontext);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to load document [{}]", (Object)documentReference, (Object)e);
            return;
        }
        String revision = (String)xcontext.get(REV);
        if (StringUtils.isNotEmpty((CharSequence)revision)) {
            try {
                document = this.documentRevisionProvider.getRevision(document, revision);
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to load revision [{}] of document [{}]. Root cause is [{}].", new Object[]{revision, documentReference, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
        xcontext.setDoc(document.clone());
    }
}

