/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.context;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.context.SerializableHttpSessionWrapper;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiServletRequestStub;
import com.xpn.xwiki.web.XWikiServletURLFactory;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletSession;

@Component(roles={RequestInitializer.class})
@Singleton
public class RequestInitializer {
    @Inject
    private Container container;
    @Inject
    private Logger logger;

    private URL restoreURL(String storedWikiId, Map<String, Serializable> contextStore, XWikiContext xcontext) {
        String requestWiki = (String)((Object)contextStore.get("request.wiki"));
        if (requestWiki == null) {
            requestWiki = storedWikiId;
        }
        xcontext.setOriginalWikiId(requestWiki);
        URL url = (URL)contextStore.get("request.url");
        if (url == null) {
            url = (URL)contextStore.get("request.base");
        }
        if (url == null && requestWiki != null) {
            try {
                url = xcontext.getWiki().getServerURL(requestWiki, xcontext);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Failed to get the URL for stored context wiki [{}]", (Object)requestWiki);
            }
            if (url == null) {
                url = HttpServletUtils.getSourceURL((HttpServletRequest)xcontext.getRequest());
            }
        }
        return url;
    }

    public void restoreRequest(String storedWikiId, XWikiContext xcontext) {
        this.restoreRequest(storedWikiId, Collections.emptyMap(), xcontext);
    }

    public void restoreRequest(String storedWikiId, Map<String, Serializable> contextStore, XWikiContext xcontext) {
        boolean daemon;
        URL url = this.restoreURL(storedWikiId, contextStore, xcontext);
        Map parameters = (Map)((Object)contextStore.get("request.parameters"));
        Map headers = (Map)((Object)contextStore.get("request.headers"));
        Cookie[] cookies = (Cookie[])contextStore.get("request.cookies");
        String remoteAddr = (String)((Object)contextStore.get("request.remoteAddr"));
        SerializableHttpSessionWrapper sessionWrapper = (SerializableHttpSessionWrapper)contextStore.get("request.session");
        HttpSession session = sessionWrapper != null ? sessionWrapper.getSession() : null;
        String contextPath = null;
        if (url == null) {
            XWikiRequest request = xcontext.getRequest();
            if (request != null) {
                url = HttpServletUtils.getSourceURL((HttpServletRequest)request);
                contextPath = request.getContextPath();
                if (parameters == null) {
                    parameters = request.getParameterMap();
                }
                if (cookies == null) {
                    cookies = request.getCookies();
                }
                if (remoteAddr == null) {
                    remoteAddr = request.getRemoteAddr();
                }
                if (session == null) {
                    session = request.getSession();
                }
            }
            daemon = true;
        } else {
            contextPath = (String)((Object)contextStore.get("request.contextpath"));
            daemon = false;
        }
        if (url != null) {
            XWikiServletRequestStub stubRequest = new XWikiServletRequestStub.Builder().setRequestURL(url).setContextPath(contextPath).setRequestParameters(parameters).setHeaders(headers).setCookies(cookies).setRemoteAddr(remoteAddr).setHttpSession(session).build();
            stubRequest.setDaemon(daemon);
            this.restoreRequest(url, stubRequest, xcontext);
        }
    }

    private void restoreRequest(URL url, XWikiServletRequestStub stubRequest, XWikiContext xcontext) {
        xcontext.setRequest(stubRequest);
        this.container.setRequest((Request)new ServletRequest((HttpServletRequest)stubRequest));
        this.container.setSession((Session)new ServletSession((HttpServletRequest)stubRequest));
        XWikiURLFactory urlFactory = xcontext.getURLFactory();
        if (urlFactory == null) {
            urlFactory = new XWikiServletURLFactory();
            xcontext.setURLFactory(urlFactory);
        }
        urlFactory.init(xcontext);
        xcontext.setURL(url);
    }
}

