/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.cache.rendering;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.cache.DocumentCache;
import com.xpn.xwiki.internal.cache.rendering.CachedItem;
import com.xpn.xwiki.internal.cache.rendering.RenderingCache;
import com.xpn.xwiki.internal.cache.rendering.RenderingCacheAware;
import com.xpn.xwiki.internal.cache.rendering.RenderingCacheConfiguration;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.XWikiPluginManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultRenderingCache
implements RenderingCache,
Initializable {
    private static final String UTF8 = "UTF-8";
    private static final String NAME = "core.renderingcache";
    private static final String PARAMETER_REFRESH = "refresh";
    @Inject
    private RenderingCacheConfiguration configuration;
    @Inject
    private Provider<List<RenderingCacheAware>> renderingCacheAwareProvider;
    private List<RenderingCacheAware> legacyRenderingCacheAware;
    @Inject
    private DocumentCache<CachedItem> cache;

    public void initialize() throws InitializationException {
        if (this.configuration.isEnabled()) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setConfigurationId(NAME);
            LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
            lru.setMaxEntries(this.configuration.getSize());
            lru.setLifespan(this.configuration.getDuration());
            cacheConfiguration.put((Object)"eviction", (Object)lru);
            try {
                this.cache.create(cacheConfiguration);
            }
            catch (CacheException e) {
                throw new InitializationException("Failed to initialize core rendering cache", (Throwable)e);
            }
        }
    }

    @Override
    public String getRenderedContent(DocumentReference documentReference, String source, XWikiContext context) {
        String renderedContent = null;
        if (this.configuration.isCached(documentReference)) {
            CachedItem cachedItem;
            String refresh;
            String string = refresh = context.getRequest() != null ? context.getRequest().getParameter(PARAMETER_REFRESH) : null;
            if (!"1".equals(refresh) && (cachedItem = this.cache.get(documentReference, source, this.getAction(context), context.getLanguage(), this.getRequestParameters(context))) != null) {
                renderedContent = this.restoreCachedItem(context, cachedItem);
            }
        }
        return renderedContent;
    }

    @Override
    public void setRenderedContent(DocumentReference documentReference, String source, String renderedContent, XWikiContext context) {
        if (this.configuration.isCached(documentReference)) {
            this.cache.set(this.buildCachedItem(context, renderedContent), documentReference, source, this.getAction(context), context.getLanguage(), this.getRequestParameters(context));
        }
    }

    private CachedItem buildCachedItem(XWikiContext context, String renderedContent) {
        CachedItem cachedItem = new CachedItem();
        for (RenderingCacheAware renderingCacheAware : (List)this.renderingCacheAwareProvider.get()) {
            cachedItem.extensions.put(renderingCacheAware, renderingCacheAware.getCacheResources(context));
        }
        if (this.legacyRenderingCacheAware == null) {
            this.legacyRenderingCacheAware = new LinkedList<RenderingCacheAware>();
            XWikiPluginManager pluginManager = context.getWiki().getPluginManager();
            for (String pluginName : pluginManager.getPlugins()) {
                XWikiPluginInterface plugin = pluginManager.getPlugin(pluginName);
                if (!(plugin instanceof RenderingCacheAware)) continue;
                this.legacyRenderingCacheAware.add((RenderingCacheAware)((Object)plugin));
            }
        }
        for (RenderingCacheAware renderingCacheAware : this.legacyRenderingCacheAware) {
            cachedItem.extensions.put(renderingCacheAware, renderingCacheAware.getCacheResources(context));
        }
        cachedItem.rendered = renderedContent;
        return cachedItem;
    }

    private String restoreCachedItem(XWikiContext context, CachedItem cachedItem) {
        for (Map.Entry<RenderingCacheAware, CachedItem.UsedExtension> item : cachedItem.extensions.entrySet()) {
            item.getKey().restoreCacheResources(context, item.getValue());
        }
        return cachedItem.rendered;
    }

    private String getAction(XWikiContext context) {
        return context.getAction() != null ? context.getAction() : "view";
    }

    private String getRequestParameters(XWikiContext context) {
        Map parameters;
        if (context.getRequest() != null && (parameters = context.getRequest().getParameterMap()) != null) {
            TreeMap<String, String[]> sortedMap = new TreeMap<String, String[]>(parameters);
            return this.constructRequestString(sortedMap);
        }
        return "";
    }

    private String constructRequestString(SortedMap<String, String[]> sortedMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : sortedMap.entrySet()) {
            if (entry.getKey().equals(PARAMETER_REFRESH)) continue;
            for (String value : entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), UTF8)).append('=').append(URLEncoder.encode(value, UTF8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(String.format("Failed to URL encode [[%s]:[%s]] parameter using UTF-8.", entry.getKey(), entry.getValue()), e);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void flushCache(DocumentReference documentReference) {
        this.cache.removeAll(documentReference);
    }

    @Override
    public void flushWholeCache() {
        this.cache.removeAll();
    }
}

