/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.cache;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.cache.DocumentCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultDocumentCache<C>
implements DocumentCache<C> {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    protected Listener listener = new Listener();
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ObservationManager observationManager;
    private Cache<C> cache;
    private Cache<Collection<String>> mappingCache;
    private String name;

    @Override
    public void create(CacheConfiguration cacheConfiguration) throws CacheException {
        this.name = cacheConfiguration.getConfigurationId();
        this.cache = this.cacheManager.createNewCache(cacheConfiguration);
        CacheConfiguration mappingCacheConfiguration = (CacheConfiguration)cacheConfiguration.clone();
        mappingCacheConfiguration.setConfigurationId(cacheConfiguration.getConfigurationId() + ".mapping");
        this.mappingCache = this.cacheManager.createNewCache(mappingCacheConfiguration);
        this.observationManager.addListener((EventListener)this.listener, 100);
    }

    @Override
    public C get(DocumentReference documentReference, Object ... extensions) {
        return (C)this.cache.get(this.getKey(documentReference, extensions));
    }

    @Override
    public void set(C data, DocumentReference documentReference, Object ... extensions) {
        String key = this.getKey(documentReference, extensions);
        this.cache.set(key, data);
        String documentReferenceString = (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
        HashSet<String> keys = (HashSet<String>)this.mappingCache.get(documentReferenceString);
        if (keys == null) {
            keys = new HashSet<String>();
            this.mappingCache.set(documentReferenceString, keys);
        }
        keys.add(key);
    }

    protected String getKey(DocumentReference documentReference, Object ... extensions) {
        StringBuilder buffer = new StringBuilder();
        if (extensions.length > 0) {
            buffer.append(this.escape((String)this.serializer.serialize((EntityReference)documentReference, new Object[0])));
            for (Object extension : extensions) {
                buffer.append(':');
                buffer.append(this.escape(extension != null ? extension.toString() : ""));
            }
        } else {
            buffer.append((String)this.serializer.serialize((EntityReference)documentReference, new Object[0]));
        }
        return buffer.toString();
    }

    private String escape(String str) {
        return str.replace("\\", "\\\\").replace(":", "\\:");
    }

    @Override
    public void remove(C data, DocumentReference documentReference, Object ... extensions) {
        String key = this.getKey(documentReference, extensions);
        this.cache.remove(key);
        String documentReferenceString = (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
        Collection keys = (Collection)this.mappingCache.get(documentReferenceString);
        if (keys != null) {
            keys.remove(key);
        }
    }

    @Override
    public void removeAll() {
        if (this.cache != null) {
            this.cache.removeAll();
        }
        if (this.mappingCache != null) {
            this.mappingCache.removeAll();
        }
    }

    @Override
    public void removeAll(DocumentReference documentReference) {
        String documentReferenceString = (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
        Collection keys = (Collection)this.mappingCache.get(documentReferenceString);
        if (keys != null) {
            for (String key : keys) {
                this.cache.remove(key);
            }
            this.mappingCache.remove(documentReferenceString);
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.mappingCache.dispose();
    }

    protected class Listener
    implements EventListener {
        protected Listener() {
        }

        public String getName() {
            return DefaultDocumentCache.this.name;
        }

        public List<Event> getEvents() {
            return EVENTS;
        }

        public void onEvent(Event event, Object source, Object data) {
            XWikiDocument doc = (XWikiDocument)source;
            DefaultDocumentCache.this.removeAll(doc.getDocumentReference());
        }
    }
}

