/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextInitializer;

@Component
@Singleton
@Named(value="XWikiStubContextInitializer")
public class XWikiStubContextInitializer
implements ExecutionContextInitializer {
    @Inject
    private XWikiStubContextProvider stubContextProvider;
    @Inject
    private Container container;

    public void initialize(ExecutionContext context) throws ExecutionContextException {
        XWikiContext stubContext;
        if (!context.hasProperty("xwikicontext") && (stubContext = this.stubContextProvider.createStubContext()) != null) {
            stubContext.declareInExecutionContext(context);
            if (this.container.getRequest() == null && stubContext.getRequest() != null) {
                this.container.setRequest((Request)new ServletRequest((HttpServletRequest)stubContext.getRequest()));
                this.container.setSession((Session)new ServletSession((HttpServletRequest)stubContext.getRequest()));
            }
            if (this.container.getResponse() == null && stubContext.getResponse() != null) {
                this.container.setResponse((Response)new ServletResponse((HttpServletResponse)stubContext.getResponse()));
            }
        }
    }
}

