/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component
@Singleton
public class XWikiContextProvider
implements Provider<XWikiContext> {
    @Inject
    private XWikiStubContextProvider contextProvider;
    @Inject
    private Execution execution;
    @Inject
    private Container container;

    public XWikiContext get() {
        return this.getXWikiContext();
    }

    private XWikiContext getXWikiContext() {
        XWikiContext xcontext;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
            if (xcontext == null) {
                xcontext = this.createStubContext(econtext);
            }
        } else {
            xcontext = null;
        }
        return xcontext;
    }

    private XWikiContext createStubContext(ExecutionContext econtext) {
        XWikiContext xcontext = this.contextProvider.createStubContext();
        if (xcontext != null) {
            xcontext.declareInExecutionContext(econtext);
            if (this.container.getRequest() == null && xcontext.getRequest() != null) {
                this.container.setRequest((Request)new ServletRequest((HttpServletRequest)xcontext.getRequest()));
                this.container.setSession((Session)new ServletSession((HttpServletRequest)xcontext.getRequest()));
            }
            if (this.container.getResponse() == null && xcontext.getResponse() != null) {
                this.container.setResponse((Response)new ServletResponse((HttpServletResponse)xcontext.getResponse()));
            }
        }
        return xcontext;
    }
}

