/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.WikiInitializerJobStatus;
import com.xpn.xwiki.internal.WikiInitializerRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="wiki.init")
public class WikiInitializerJob
extends AbstractJob<WikiInitializerRequest, WikiInitializerJobStatus> {
    public static final String JOBTYPE = "wiki.init";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ObservationManager observation;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> resolver;

    protected WikiInitializerJobStatus createNewStatus(WikiInitializerRequest request) {
        return new WikiInitializerJobStatus(request, this.observationManager, this.loggerManager);
    }

    public String getType() {
        return JOBTYPE;
    }

    protected void runInternal() throws Exception {
        String wikiId = ((WikiInitializerRequest)this.getRequest()).getWikiId();
        this.logger.info("Start initialization of wiki [{}]", (Object)wikiId);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        xcontext.setWikiId(wikiId);
        xcontext.setOriginalWikiId(wikiId);
        this.progressManager.pushLevelProgress(3, (Object)this);
        try {
            this.progressManager.startStep((Object)this, "Initialize mandatory document");
            xcontext.getWiki().initializeMandatoryDocuments(xcontext);
            this.progressManager.startStep((Object)this, "Initialize plugins");
            xcontext.getWiki().getPluginManager().virtualInit(xcontext);
            this.logger.info("Initialization of wiki [{}] done", (Object)wikiId);
            this.progressManager.startStep((Object)this, "Call listeners");
            this.observation.notify((Event)new WikiReadyEvent(wikiId), (Object)wikiId, (Object)xcontext);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

