/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletRequestStub;
import com.xpn.xwiki.web.XWikiServletResponse;
import com.xpn.xwiki.web.XWikiServletResponseStub;
import com.xpn.xwiki.web.XWikiURLFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultXWikiStubContextProvider
implements XWikiStubContextProvider {
    static final String XCONTEXT_STUB = DefaultXWikiStubContextProvider.class.getName();
    @Inject
    private Logger logger;
    @Inject
    private Provider<DocumentReference> defaultDocumentReferenceProvider;
    @Inject
    private Execution execution;
    private XWikiContext initialContext;

    @Override
    public void initialize(XWikiContext context) {
        XWikiContext newContext = context.clone();
        newContext.setCacheDuration(0);
        newContext.setUserReference(null);
        newContext.setLocale(null);
        newContext.setWikiId(context.getMainXWiki());
        newContext.setURLFactory(null);
        newContext.flushClassCache();
        if (newContext.getRequest() != null) {
            XWikiServletRequestStub initialRequest = new XWikiServletRequestStub(context.getRequest());
            XWikiServletRequest request = new XWikiServletRequest(initialRequest);
            newContext.setRequest(request);
        }
        if (newContext.getResponse() != null) {
            XWikiServletResponseStub initialResponse = new XWikiServletResponseStub();
            XWikiServletResponse response = new XWikiServletResponse(initialResponse);
            newContext.setResponse(response);
        }
        this.initialContext = newContext;
        this.logger.debug("Stub context initialized.");
    }

    @Override
    public XWikiContext createStubContext() {
        XWikiContext stubContext;
        if (this.initialContext != null) {
            ExecutionContext econtext = this.execution.getContext();
            if (econtext != null && (stubContext = (XWikiContext)econtext.getProperty(XCONTEXT_STUB)) != null) {
                return stubContext;
            }
            try {
                stubContext = this.initialContext.clone();
                if (econtext != null) {
                    econtext.setProperty(XCONTEXT_STUB, (Object)stubContext);
                }
                this.initiazeXWikiContext(stubContext);
            }
            finally {
                if (econtext != null) {
                    econtext.removeProperty(XCONTEXT_STUB);
                }
            }
        } else {
            stubContext = null;
        }
        return stubContext;
    }

    private void initiazeXWikiContext(XWikiContext stubContext) {
        if (this.initialContext.getRequest() != null) {
            XWikiServletRequestStub stubRequest = new XWikiServletRequestStub(this.initialContext.getRequest());
            XWikiServletRequest request = new XWikiServletRequest(stubRequest);
            stubContext.setRequest(request);
            if (stubContext.getWiki() != null) {
                XWikiURLFactory urlf = stubContext.getWiki().getURLFactoryService().createURLFactory(0, stubContext);
                stubContext.setURLFactory(urlf);
            }
        }
        if (this.initialContext.getResponse() != null) {
            XWikiServletResponseStub stubResponse = new XWikiServletResponseStub();
            XWikiServletResponse response = new XWikiServletResponse(stubResponse);
            stubContext.setResponse(response);
        }
        stubContext.setDoc(new XWikiDocument((DocumentReference)this.defaultDocumentReferenceProvider.get()));
    }
}

