/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiContextInitializer;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.context.ExecutionContext;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXWikiContextInitializer
implements XWikiContextInitializer {
    @Inject
    private Container container;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitResolver;
    @Inject
    private XWikiStubContextProvider contextProvider;
    @Inject
    private Logger logger;
    private boolean authenticate;
    private boolean fallbackOnStub;

    @Override
    public XWikiContextInitializer authenticate() {
        this.authenticate = true;
        return this;
    }

    @Override
    public XWikiContextInitializer fallbackOnStub() {
        this.fallbackOnStub = true;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XWikiContext initialize(ExecutionContext econtext) throws XWikiException {
        XWikiContext xcontext;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest servletRequest = (ServletRequest)request;
            try {
                HttpServletRequest httpServletRequest = servletRequest.getRequest();
                HttpServletResponse httpServletReponse = ((ServletResponse)this.container.getResponse()).getResponse();
                xcontext = DefaultXWikiContextInitializer.initializeXWikiContext(httpServletRequest, httpServletReponse);
                if (econtext != null) {
                    xcontext.declareInExecutionContext(econtext);
                }
                if (this.authenticate) {
                    this.authenticate(xcontext);
                }
            }
            catch (XWikiException e) {
                if (!this.fallbackOnStub) {
                    throw new XWikiException(8, 8001, "Failed to initialize XWikiContext", e);
                }
                xcontext = this.contextProvider.createStubContext();
            }
        } else {
            if (!this.fallbackOnStub) {
                throw new XWikiException(8, 8001, "Unsupported request type [" + String.valueOf(request.getClass()) + "]");
            }
            xcontext = this.contextProvider.createStubContext();
        }
        if (econtext != null) {
            xcontext.declareInExecutionContext(econtext);
        }
        return xcontext;
    }

    private static XWikiContext initializeXWikiContext(HttpServletRequest request, HttpServletResponse response) throws XWikiException {
        XWikiServletContext xwikiEngine = new XWikiServletContext(JakartaServletBridge.toJavax((ServletContext)request.getServletContext()));
        XWikiServletRequest xwikiRequest = new XWikiServletRequest(JakartaServletBridge.toJavax((HttpServletRequest)request));
        XWikiServletResponse xwikiResponse = new XWikiServletResponse(JakartaServletBridge.toJavax((HttpServletResponse)response));
        XWikiContext context = Utils.prepareContext("", xwikiRequest, xwikiResponse, xwikiEngine);
        XWiki xwiki = XWiki.getXWiki(context);
        context.setURLFactory(xwiki.getURLFactoryService().createURLFactory(context.getMode(), context));
        xwiki.prepareResources(context);
        return context;
    }

    private void authenticate(XWikiContext xcontext) throws XWikiException {
        xcontext.setUserReference(null);
        XWikiUser xwikiUser = xcontext.getWiki().checkAuth(xcontext);
        if (xwikiUser != null) {
            SpaceReference defaultUserSpace = new SpaceReference("XWiki", new WikiReference(xcontext.getWikiId()));
            DocumentReference userReference = this.explicitResolver.resolve((Object)xwikiUser.getUser(), new Object[]{defaultUserSpace});
            xcontext.setUserReference("XWikiGuest".equals(userReference.getName()) ? null : userReference);
            this.logger.debug("Authenticated as [{}].", (Object)xwikiUser.getUser());
        }
    }
}

