/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultMandatoryDocumentInitializerManager
implements MandatoryDocumentInitializerManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private Logger logger;

    @Override
    public MandatoryDocumentInitializer getMandatoryDocumentInitializer(DocumentReference documentReference) {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        String fullReference = (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
        try {
            if (componentManager.hasComponent(MandatoryDocumentInitializer.class, fullReference)) {
                return (MandatoryDocumentInitializer)componentManager.getInstance(MandatoryDocumentInitializer.class, fullReference);
            }
            String localReference = (String)this.localSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (componentManager.hasComponent(MandatoryDocumentInitializer.class, localReference)) {
                return (MandatoryDocumentInitializer)componentManager.getInstance(MandatoryDocumentInitializer.class, localReference);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to initialize component [{}] for document", new Object[]{MandatoryDocumentInitializer.class, documentReference, e});
        }
        return null;
    }
}

