/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractNotifyOnUpdateList<E>
implements List<E> {
    private final List<E> list;

    protected AbstractNotifyOnUpdateList(List<E> list) {
        this.list = list;
    }

    protected abstract void onUpdate();

    protected void added(E element) {
    }

    @Override
    public boolean add(E e) {
        boolean ret = this.list.add(e);
        if (ret) {
            this.onUpdate();
            this.added(e);
        }
        return ret;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.onUpdate();
        this.added(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = this.list.addAll(c);
        if (ret) {
            this.onUpdate();
            for (E e : c) {
                this.added(e);
            }
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean ret = this.list.addAll(index, c);
        if (ret) {
            this.onUpdate();
            for (E e : c) {
                this.added(e);
            }
        }
        return ret;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.onUpdate();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.list.iterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(this.list.listIterator(index));
    }

    @Override
    public E remove(int index) {
        E ret = this.list.remove(index);
        this.onUpdate();
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.list.remove(o);
        if (ret) {
            this.onUpdate();
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = this.list.removeAll(c);
        if (ret) {
            this.onUpdate();
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = this.list.retainAll(c);
        if (ret) {
            this.onUpdate();
        }
        return ret;
    }

    @Override
    public E set(int index, E element) {
        E ret = this.list.set(index, element);
        this.onUpdate();
        this.added(element);
        return ret;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new AbstractNotifyOnUpdateList<E>(this.list.subList(fromIndex, toIndex)){

            @Override
            public void onUpdate() {
                AbstractNotifyOnUpdateList.this.onUpdate();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }

    private class Itr
    implements Iterator<E> {
        private final Iterator<E> iterator;

        Itr(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            AbstractNotifyOnUpdateList.this.onUpdate();
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        private final ListIterator<E> iterator;

        ListItr(ListIterator<E> iterator) {
            super(iterator);
            this.iterator = iterator;
        }

        @Override
        public void add(E e) {
            this.iterator.add(e);
            AbstractNotifyOnUpdateList.this.onUpdate();
            AbstractNotifyOnUpdateList.this.added(e);
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            return this.iterator.previous();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void set(E e) {
            this.iterator.set(e);
            AbstractNotifyOnUpdateList.this.onUpdate();
            AbstractNotifyOnUpdateList.this.added(e);
        }
    }
}

