/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc.rcs;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.rcs.XWikiPatchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.util.ToString;

public class XWikiPatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiPatch.class);
    private String content;
    private boolean isDiff;

    public XWikiPatch() {
    }

    public XWikiPatch(String content, boolean isDiff) {
        this.setContent(content);
        this.setDiff(isDiff);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    private boolean isContentDiff() {
        return !this.content.startsWith("<");
    }

    public boolean isDiff() {
        if (this.content != null && this.isDiff != this.isContentDiff()) {
            LOGGER.warn("isDiff: Patch is inconsistent. Content and diff field are contradicting");
            return this.isContentDiff();
        }
        return this.isDiff;
    }

    public void setDiff(boolean isDiff) {
        if (this.content != null && isDiff != this.isContentDiff()) {
            LOGGER.warn("setDiff: Patch is inconsistent. Content and diff field are contradicting");
            this.isDiff = this.isContentDiff();
            return;
        }
        this.isDiff = isDiff;
    }

    public XWikiPatch setFullVersion(XWikiDocument version, XWikiContext context) throws XWikiException {
        return this.setFullVersion(version.toXML(context));
    }

    public XWikiPatch setFullVersion(String versionXml) throws XWikiException {
        this.setContent(versionXml);
        this.setDiff(false);
        return this;
    }

    public XWikiPatch setDiffVersion(XWikiDocument originalVersion, XWikiDocument newVersion, XWikiContext context) throws XWikiException {
        return this.setDiffVersion(originalVersion.toXML(context), newVersion.toXML(context), newVersion.getFullName());
    }

    public XWikiPatch setDiffVersion(String originalVersionXml, XWikiDocument newVersion, XWikiContext context) throws XWikiException {
        return this.setDiffVersion(originalVersionXml, newVersion.toXML(context), newVersion.getFullName());
    }

    public XWikiPatch setDiffVersion(String originalVersionXml, String newVersionXml, String docName) throws XWikiException {
        try {
            this.setContent(XWikiPatchUtils.getDiff(newVersionXml, originalVersionXml));
            this.setDiff(true);
        }
        catch (Exception e) {
            Object[] args = new Object[]{docName};
            throw new XWikiException(13, 13027, "Failed to create diff for doc {0}", e, args);
        }
        return this;
    }

    public void patch(List<String> origText) throws XWikiException {
        if (!this.isDiff()) {
            origText.clear();
            origText.addAll(new ArrayList<String>(Arrays.asList(ToString.stringToArray((String)this.getContent()))));
        } else {
            try {
                XWikiPatchUtils.patch(origText, this.getContent());
            }
            catch (Exception e) {
                throw new XWikiException(13, 13027, "Exception while patching", e);
            }
        }
    }
}

