/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.LocalStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.LocalUidStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;

public class XWikiSpace {
    private static final String CURRENT = "current";
    private static final LocalStringEntityReferenceSerializer SERIALIZER = new LocalStringEntityReferenceSerializer((SymbolScheme)new DefaultSymbolScheme());
    private XWikiStoreInterface store;
    private Long id;
    private String name;
    private String parent;
    private boolean hidden;
    private SpaceReference reference;

    protected XWikiSpace() {
        this(null, null);
    }

    public XWikiSpace(SpaceReference reference) {
        this(reference, null);
    }

    public XWikiSpace(SpaceReference reference, boolean hidden) {
        this(reference, null);
        this.setHidden(hidden);
    }

    public XWikiSpace(SpaceReference reference, XWikiStoreInterface store) {
        this.reference = reference;
        this.store = store;
    }

    private static SpaceReferenceResolver<String> getCurrentSpaceResolver() {
        return (SpaceReferenceResolver)Utils.getComponent(SpaceReferenceResolver.TYPE_STRING, CURRENT);
    }

    public XWikiStoreInterface getStore() {
        return this.store;
    }

    public void setStore(XWikiStoreInterface store) {
        this.store = store;
    }

    public static long getId(SpaceReference spaceReference) {
        return Util.getHash(LocalUidStringEntityReferenceSerializer.INSTANCE.serialize((EntityReference)spaceReference, new Object[0]));
    }

    public long getId() {
        if (this.id == null) {
            this.id = XWikiSpace.getId(this.getSpaceReference());
        }
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public String getName() {
        if (this.name == null && this.reference != null) {
            this.name = this.reference.getName();
        }
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getParent() {
        if (this.parent == null && this.reference != null) {
            this.parent = this.reference.getParent().getType() == EntityType.SPACE ? SERIALIZER.serialize(this.reference.getParent(), new Object[0]) : "";
        }
        return StringUtils.isEmpty((CharSequence)this.parent) ? null : this.parent;
    }

    protected void setParent(String parent) {
        this.parent = StringUtils.isEmpty((CharSequence)parent) ? "" : parent;
    }

    public String getReference() {
        return SERIALIZER.serialize((EntityReference)this.reference, new Object[0]);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void setReference(String reference) {
        this.reference = XWikiSpace.getCurrentSpaceResolver().resolve((Object)reference, new Object[0]);
    }

    public SpaceReference getSpaceReference() {
        return this.reference;
    }

    public String toString() {
        return this.getSpaceReference().toString();
    }
}

