/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.rcs.XWikiPatch;
import com.xpn.xwiki.doc.rcs.XWikiRCSArchive;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeContent;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.util.ToString;
import org.xwiki.model.reference.WikiReference;

public class XWikiDocumentArchive {
    private final WikiReference wikiReference;
    private long id;
    private SortedMap<Version, XWikiRCSNodeInfo> versionToNode = new TreeMap<Version, XWikiRCSNodeInfo>();
    private SortedSet<Version> fullVersions = new TreeSet<Version>();
    private Set<XWikiRCSNodeInfo> deletedNodes = new TreeSet<XWikiRCSNodeInfo>();
    private Set<XWikiRCSNodeInfo> updatedNodeInfos = new TreeSet<XWikiRCSNodeInfo>();
    private Set<XWikiRCSNodeContent> updatedNodeContents = new TreeSet<XWikiRCSNodeContent>();

    public XWikiDocumentArchive(WikiReference wikiReference, long id) {
        this.wikiReference = wikiReference;
        this.id = id;
    }

    @Deprecated(since="13.10.7")
    public XWikiDocumentArchive(long id) {
        this(null, id);
    }

    @Deprecated(since="13.10.7")
    public XWikiDocumentArchive() {
        this.wikiReference = null;
    }

    protected Version createNextVersion(Version cur, boolean isMinor) {
        Version result = cur == null ? new Version(1, 1) : (!isMinor ? cur.getBase(1).next().newBranch(1) : cur.next());
        return result;
    }

    protected void updateNode(XWikiRCSNodeInfo node) {
        Version ver = node.getId().getVersion();
        this.versionToNode.put(ver, node);
        if (!node.isDiff()) {
            this.fullVersions.add(ver);
        } else {
            this.fullVersions.remove(ver);
        }
    }

    protected XWikiRCSNodeContent makePatch(XWikiRCSNodeInfo newnode, XWikiDocument doc, XWikiContext context) throws XWikiException {
        XWikiRCSNodeContent result = new XWikiRCSNodeContent();
        result.setPatch(new XWikiPatch().setFullVersion(doc, context));
        newnode.setContent(result);
        XWikiRCSNodeInfo latestNode = this.getLatestNode();
        if (latestNode != null) {
            int nodesPerFull;
            int nodesCount = this.getNodes().size();
            int n = nodesPerFull = context.getWiki() == null ? 1 : Integer.parseInt(context.getWiki().getConfig().getProperty("xwiki.store.rcs.nodesPerFull", "1"));
            if (nodesPerFull <= 0 || nodesCount % nodesPerFull != 0) {
                XWikiRCSNodeContent latestContent = latestNode.getContent(context);
                latestContent.getPatch().setDiffVersion(latestContent.getPatch().getContent(), doc, context);
                latestNode.setContent(latestContent);
                this.updateNode(latestNode);
                this.getUpdatedNodeContents().add(latestContent);
            }
        }
        return result;
    }

    public WikiReference getWikiReference() {
        return this.wikiReference;
    }

    public long getId() {
        return this.id;
    }

    @Deprecated(since="13.10.7")
    public void setId(long id) {
        this.id = id;
    }

    public Collection<XWikiRCSNodeInfo> getNodes() {
        return this.versionToNode.values();
    }

    public Collection<XWikiRCSNodeInfo> getNodes(Version upperBound, Version lowerBound) {
        int[] ito = lowerBound.getNumbers();
        if (ito.length > 1) {
            ito[1] = ito[1] - 1;
        }
        return this.versionToNode.subMap(upperBound, new Version(ito)).values();
    }

    public void setNodes(Collection<XWikiRCSNodeInfo> versions) {
        this.resetArchive();
        for (XWikiRCSNodeInfo node : versions) {
            this.updateNode(node);
        }
        if (!this.getNodes().isEmpty()) {
            this.getLatestNode().setDiff(false);
            this.updateNode(this.getLatestNode());
        }
    }

    public String getArchive(XWikiContext context) throws XWikiException {
        XWikiRCSArchive archive = new XWikiRCSArchive(this.getNodes(), context);
        return archive.toString();
    }

    public void setArchive(String text) throws XWikiException {
        try {
            XWikiRCSArchive archive = new XWikiRCSArchive(text);
            this.resetArchive();
            Collection nodes = archive.getNodes(this.getWikiReference(), this.getId());
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                XWikiRCSNodeInfo nodeInfo = (XWikiRCSNodeInfo)it.next();
                XWikiRCSNodeContent nodeContent = (XWikiRCSNodeContent)it.next();
                this.updateNode(nodeInfo);
                this.updatedNodeInfos.add(nodeInfo);
                this.updatedNodeContents.add(nodeContent);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{text, this.getId()};
            throw new XWikiException(13, 13021, "Exception while constructing archive for JRCS string [{0}] for document [{1}]", e, args);
        }
    }

    public void updateArchive(XWikiDocument doc, String author, Date date, String comment, Version version, XWikiContext context) throws XWikiException {
        Version oldLatestVer = this.getLatestVersion();
        Version newVer = version;
        if (newVer == null || oldLatestVer != null && newVer.compareVersions(oldLatestVer) <= 0) {
            newVer = this.createNextVersion(oldLatestVer, doc.isMinorEdit());
        }
        XWikiRCSNodeInfo newNode = new XWikiRCSNodeInfo(new XWikiRCSNodeId(this.getWikiReference(), this.getId(), newVer));
        newNode.setAuthor(author);
        newNode.setComment(comment);
        newNode.setDate(date);
        XWikiRCSNodeContent newContent = this.makePatch(newNode, doc, context);
        this.updateNode(newNode);
        this.updatedNodeInfos.add(newNode);
        this.updatedNodeContents.add(newContent);
    }

    public void removeVersions(Version newerVersion, Version olderVersion, XWikiContext context) throws XWikiException {
        Version upperBound = newerVersion;
        Version lowerBound = olderVersion;
        if (upperBound.compareVersions(lowerBound) < 0) {
            Version tmp = upperBound;
            upperBound = lowerBound;
            lowerBound = tmp;
        }
        Version firstVersionAfter = this.getNextVersion(upperBound);
        Version firstVersionBefore = this.getPrevVersion(lowerBound);
        if (!this.getNodes(upperBound, lowerBound).isEmpty()) {
            if (firstVersionAfter == null && firstVersionBefore == null) {
                this.resetArchive();
            } else {
                this.performSpecificVersionsRemoval(firstVersionBefore, firstVersionAfter, lowerBound, upperBound, context);
            }
        }
    }

    private void performSpecificVersionsRemoval(Version firstVersionBefore, Version firstVersionAfter, Version lowerBound, Version upperBound, XWikiContext context) throws XWikiException {
        if (firstVersionAfter == null) {
            String xmlBefore = this.getVersionXml(firstVersionBefore, context);
            XWikiRCSNodeInfo niBefore = this.getNode(firstVersionBefore);
            XWikiRCSNodeContent ncBefore = niBefore.getContent(context);
            ncBefore.getPatch().setFullVersion(xmlBefore);
            niBefore.setContent(ncBefore);
            this.updateNode(niBefore);
            this.getUpdatedNodeContents().add(ncBefore);
        } else if (firstVersionBefore != null) {
            String xmlAfter = this.getVersionXml(firstVersionAfter, context);
            String xmlBefore = this.getVersionXml(firstVersionBefore, context);
            XWikiRCSNodeInfo niBefore = this.getNode(firstVersionBefore);
            XWikiRCSNodeContent ncBefore = niBefore.getContent(context);
            ncBefore.getPatch().setDiffVersion(xmlBefore, xmlAfter, "");
            niBefore.setContent(ncBefore);
            this.updateNode(niBefore);
            this.getUpdatedNodeContents().add(ncBefore);
        }
        Iterator<XWikiRCSNodeInfo> it = this.getNodes(upperBound, lowerBound).iterator();
        while (it.hasNext()) {
            XWikiRCSNodeInfo ni = it.next();
            this.fullVersions.remove(ni.getId().getVersion());
            this.deletedNodes.add(ni);
            it.remove();
        }
    }

    public XWikiDocument loadDocument(Version version, XWikiContext context) throws XWikiException {
        XWikiRCSNodeInfo nodeInfo = this.getNode(version);
        if (nodeInfo == null) {
            return null;
        }
        try {
            String content = this.getVersionXml(version, context);
            XWikiDocument doc = new XWikiDocument();
            doc.fromXML(content);
            doc.setRCSVersion(version);
            doc.setComment(nodeInfo.getComment());
            doc.setAuthor(nodeInfo.getAuthor());
            doc.setMinorEdit(nodeInfo.isMinorEdit());
            doc.setMostRecent(version.equals((Object)this.getLatestVersion()));
            doc.setNew(false);
            return doc;
        }
        catch (Exception e) {
            Object[] args = new Object[]{version.toString(), this.getId()};
            throw new XWikiException(3, 3103, "Exception while reading version [{0}] for document id [{1,number}]", e, args);
        }
    }

    public String getVersionXml(Version version, XWikiContext context) throws XWikiException {
        Version nextFullVersion = this.getNextFullVersion(version);
        List<XWikiRCSNodeContent> lstContent = this.loadRCSNodeContents(version, nextFullVersion, context);
        ArrayList<String> origText = new ArrayList<String>();
        for (XWikiRCSNodeContent nodeContent : lstContent) {
            nodeContent.getPatch().patch(origText);
        }
        return ToString.arrayToString((Object[])origText.toArray());
    }

    public XWikiRCSNodeInfo getNode(Version version) {
        return version == null ? null : (XWikiRCSNodeInfo)this.versionToNode.get(version);
    }

    public Version getLatestVersion() {
        return this.versionToNode.isEmpty() ? null : this.versionToNode.firstKey();
    }

    public XWikiRCSNodeInfo getLatestNode() {
        return this.getNode(this.getLatestVersion());
    }

    public Version getNextVersion(Version ver) {
        SortedMap<Version, XWikiRCSNodeInfo> headmap = this.versionToNode.headMap(ver);
        return headmap.isEmpty() ? null : headmap.lastKey();
    }

    public Version getPrevVersion(Version ver) {
        SortedMap<Version, XWikiRCSNodeInfo> tailmap = this.versionToNode.tailMap(ver);
        if (tailmap.size() <= 1) {
            return null;
        }
        Iterator<Version> it = tailmap.keySet().iterator();
        it.next();
        return it.next();
    }

    @Deprecated(since="14.10.12,15.5RC1")
    public Version getNearestFullVersion(Version ver) {
        return this.getNextFullVersion(ver);
    }

    public Version getNextFullVersion(Version ver) {
        if (this.fullVersions.contains(ver)) {
            return ver;
        }
        SortedSet<Version> headSet = this.fullVersions.headSet(ver);
        return headSet.isEmpty() ? null : headSet.last();
    }

    private List<XWikiRCSNodeContent> loadRCSNodeContents(Version lowerBound, Version upperBound, XWikiContext context) throws XWikiException {
        ArrayList<XWikiRCSNodeContent> result = new ArrayList<XWikiRCSNodeContent>();
        for (XWikiRCSNodeInfo nodeInfo : this.getNodes(upperBound, lowerBound)) {
            XWikiRCSNodeContent nodeContent = nodeInfo.getContent(context);
            result.add(nodeContent);
        }
        return result;
    }

    public void resetArchive() {
        this.versionToNode.clear();
        this.fullVersions.clear();
        this.deletedNodes.addAll(this.updatedNodeInfos);
        this.updatedNodeInfos.clear();
        this.updatedNodeContents.clear();
    }

    public Set<XWikiRCSNodeInfo> getDeletedNodeInfo() {
        return this.deletedNodes;
    }

    public Set<XWikiRCSNodeInfo> getUpdatedNodeInfos() {
        return this.updatedNodeInfos;
    }

    public Set<XWikiRCSNodeContent> getUpdatedNodeContents() {
        return this.updatedNodeContents;
    }

    public XWikiDocumentArchive clone(long docId, XWikiContext context) throws XWikiException {
        XWikiDocumentArchive result = new XWikiDocumentArchive(this.wikiReference, docId);
        result.setArchive(this.getArchive(context));
        return result;
    }
}

