/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.CoreConfiguration;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiConstant;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.DocumentSection;
import com.xpn.xwiki.criteria.impl.RevisionCriteria;
import com.xpn.xwiki.doc.AttachmentDiff;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.MetaDataDiff;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.doc.XWikiDocumentCompatibilityAspect;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xpn.xwiki.internal.cache.rendering.RenderingCache;
import com.xpn.xwiki.internal.doc.BaseObjects;
import com.xpn.xwiki.internal.doc.XWikiAttachmentList;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterUtils;
import com.xpn.xwiki.internal.render.OldRendering;
import com.xpn.xwiki.internal.xml.DOMXMLWriter;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseElement;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.ListProperty;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.store.AttachmentRecycleBinStore;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.store.XWikiVersioningStoreInterface;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.validation.XWikiValidationInterface;
import com.xpn.xwiki.validation.XWikiValidationStatus;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.ObjectAddForm;
import com.xpn.xwiki.web.ObjectPolicyType;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Provider;
import javax.xml.transform.Result;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.util.ToString;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.cache.CacheControl;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.diff.Delta;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.DefaultOutputStreamOutputTarget;
import org.xwiki.filter.output.DefaultWriterOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.filter.xml.output.DefaultResultOutputTarget;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.link.LinkException;
import org.xwiki.link.LinkStore;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.model.EntityType;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.internal.document.DefaultDocumentAuthors;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.internal.reference.LocalStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.LocalUidStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.ObjectReferenceResolver;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.internal.parser.LinkParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.store.merge.MergeDocumentResult;
import org.xwiki.store.merge.MergeManager;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserConfiguration;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityContext;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.HTMLUtils;

public class XWikiDocument
implements DocumentModelBridge,
Cloneable,
DisposableCacheValue {
    private static final Logger LOGGER;
    private static final String TM_FAILEDDOCUMENTPARSE = "core.document.error.failedParse";
    private static final String[] HTML_MACRO_SEARCH_STRINGS;
    private static final String[] HTML_MACRO_REPLACE_STRINGS;
    private static final Pattern HTML_TAG_PATTERN;
    public static final EntityReference COMMENTSCLASS_REFERENCE;
    public static final EntityReference SHEETCLASS_REFERENCE;
    public static final int HAS_ATTACHMENTS = 1;
    public static final int HAS_OBJECTS = 2;
    public static final int HAS_CLASS = 4;
    public static final String CKEY_SDOC = "sdoc";
    public static final String CKEY_CDOC = "cdoc";
    public static final String CKEY_TDOC = "tdoc";
    public static final String DB_SPACE_SEP = ":";
    public static final String SPACE_NAME_SEP = ".";
    private static final LocalStringEntityReferenceSerializer LOCAL_REFERENCE_SERIALIZER;
    private String title;
    private Object preparedTitle;
    private volatile LocalDateTime titlePrepareDate;
    private EntityReference parentReference;
    private DocumentReference documentReference;
    private Content content = new Content("", null);
    private String meta;
    private String format;
    private String customClass;
    private Date contentUpdateDate;
    private Date updateDate;
    private Date creationDate;
    protected Version version;
    private long id = 0L;
    private boolean mostRecent = true;
    private boolean isNew = true;
    private DocumentReference templateDocumentReference;
    private Locale locale;
    private Locale defaultLocale;
    private boolean hidden = false;
    private String comment;
    private boolean enforceRequiredRights = false;
    private boolean isMinorEdit = false;
    private boolean isContentDirty = true;
    private boolean isMetaDataDirty = true;
    private boolean changeTracked;
    private int elements = 3;
    private BaseClass xClass;
    private String xClassXML;
    private Map<DocumentReference, BaseObjects> xObjects = new ConcurrentSkipListMap<DocumentReference, BaseObjects>();
    private Map<DocumentReference, List<BaseObject>> publicXObjects = new Map<DocumentReference, List<BaseObject>>(){

        @Override
        public List<BaseObject> put(DocumentReference key, List<BaseObject> value) {
            return XWikiDocument.this.xObjects.put(key, value instanceof BaseObjects ? (BaseObjects)value : new BaseObjects(value));
        }

        @Override
        public void putAll(Map<? extends DocumentReference, ? extends List<BaseObject>> m) {
            m.forEach(this::put);
        }

        @Override
        public int size() {
            return XWikiDocument.this.xObjects.size();
        }

        @Override
        public boolean isEmpty() {
            return XWikiDocument.this.xObjects.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return XWikiDocument.this.xObjects.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return XWikiDocument.this.xObjects.containsValue(value);
        }

        @Override
        public List<BaseObject> get(Object key) {
            return XWikiDocument.this.xObjects.get(key);
        }

        @Override
        public List<BaseObject> remove(Object key) {
            return XWikiDocument.this.xObjects.remove(key);
        }

        @Override
        public void clear() {
            XWikiDocument.this.xObjects.clear();
        }

        @Override
        public Set<DocumentReference> keySet() {
            return XWikiDocument.this.xObjects.keySet();
        }

        @Override
        public Collection<List<BaseObject>> values() {
            return XWikiDocument.this.xObjects.values();
        }

        @Override
        public Set<Map.Entry<DocumentReference, List<BaseObject>>> entrySet() {
            return XWikiDocument.this.xObjects.entrySet();
        }
    };
    private final XWikiAttachmentList attachmentList = new XWikiAttachmentList(this);
    private boolean fromCache = false;
    private boolean cached;
    private List<BaseObject> xObjectsToRemove = new ArrayList<BaseObject>();
    private List<XWikiAttachmentToRemove> attachmentsToRemove = new ArrayList<XWikiAttachmentToRemove>();
    private String defaultTemplate;
    private String validationScript;
    private Object wikiNode;
    private SoftReference<XWikiDocumentArchive> archive;
    private XWikiStoreInterface store;
    private XWikiDocument originalDocument;
    private boolean restricted;
    private DocumentDisplayer documentDisplayer;
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    private DocumentReferenceResolver<EntityReference> explicitReferenceDocumentReferenceResolver;
    private PageReferenceResolver<EntityReference> pageReferenceResolver;
    private EntityReferenceSerializer<String> uidStringEntityReferenceSerializer;
    private Provider<OldRendering> oldRenderingProvider;
    private JobProgressManager progress;
    private ContextualLocalizationManager localization;
    private VelocityContextFactory velocityContextFactory;
    private EntityReferenceFactory entityReferenceFactory;
    private RenderingCache renderingCache;
    private DocumentReference parentReferenceCache;
    private DocumentReference documentReferenceWithLocaleCache;
    private PageReference pageReferenceCache;
    private PageReference pageReferenceWithLocaleCache;
    private String keyCache;
    private String localKeyCache;
    private RenderingContext renderingContext;
    private final DefaultDocumentAuthors authors = new DefaultDocumentAuthors(this);
    @Deprecated
    public static String XWIKI10_SYNTAXID;
    @Deprecated
    public static String XWIKI20_SYNTAXID;

    private static DocumentReferenceResolver<String> getCurrentDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
    }

    private static EntityReferenceResolver<ResourceReference> getResourceReferenceEntityReferenceResolver() {
        return (EntityReferenceResolver)Utils.getComponent((Type)new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{ResourceReference.class}));
    }

    private static EntityReferenceResolver<String> getXClassEntityReferenceResolver() {
        return (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "xclass");
    }

    private static DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    }

    private static DocumentReferenceResolver<EntityReference> getCurrentReferenceDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, "current");
    }

    private static EntityReferenceResolver<String> getRelativeEntityReferenceResolver() {
        return (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "relative");
    }

    private static EntityReferenceSerializer<String> getCompactEntityReferenceSerializer() {
        return (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compact");
    }

    private static EntityReferenceSerializer<String> getCompactWikiEntityReferenceSerializer() {
        return (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    }

    private static ObjectReferenceResolver<EntityReference> getCurrentReferenceObjectReferenceResolver() {
        return (ObjectReferenceResolver)Utils.getComponent(ObjectReferenceResolver.TYPE_REFERENCE, "current");
    }

    private static SyntaxRegistry getSyntaxRegistry() {
        return Utils.getComponent(SyntaxRegistry.class);
    }

    private static LinkParser getLinkParser() {
        return Utils.getComponent(LinkParser.class);
    }

    private static UserConfiguration getUserConfiguration() {
        return Utils.getComponent(UserConfiguration.class);
    }

    private static CacheControl getCacheControl() {
        return Utils.getComponent(CacheControl.class);
    }

    private static Transformation getMacroTransformation() {
        return Utils.getComponent(Transformation.class, "macro");
    }

    public XWikiDocument(DocumentReference reference) {
        this.init(reference);
    }

    public XWikiDocument(DocumentReference reference, Locale locale) {
        this.init(reference);
        this.locale = locale;
    }

    @Deprecated(since="2.2M1")
    public XWikiDocument() {
        this(null);
    }

    @Deprecated(since="2.2M1")
    public XWikiDocument(String space, String name) {
        this(null, space, name);
    }

    @Deprecated(since="2.2M1")
    public XWikiDocument(String wiki, String space, String name) {
        EntityReference contextReference = null;
        if (!StringUtils.isEmpty((CharSequence)space)) {
            contextReference = new EntityReference(space, EntityType.SPACE);
        }
        DocumentReference reference = XWikiDocument.getCurrentDocumentReferenceResolver().resolve((Object)name, new Object[]{contextReference});
        if (!StringUtils.isEmpty((CharSequence)wiki)) {
            reference = reference.replaceParent((EntityReference)reference.getWikiReference(), (EntityReference)new WikiReference(wiki));
        }
        this.init(reference);
    }

    public void dispose() throws Exception {
        this.setCached(false);
    }

    private DocumentReferenceResolver<String> getExplicitDocumentReferenceResolver() {
        if (this.explicitDocumentReferenceResolver == null) {
            this.explicitDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "explicit");
        }
        return this.explicitDocumentReferenceResolver;
    }

    private DocumentReferenceResolver<EntityReference> getExplicitReferenceDocumentReferenceResolver() {
        if (this.explicitReferenceDocumentReferenceResolver == null) {
            this.explicitReferenceDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, "explicit");
        }
        return this.explicitReferenceDocumentReferenceResolver;
    }

    private PageReferenceResolver<EntityReference> getPageReferenceResolver() {
        if (this.pageReferenceResolver == null) {
            this.pageReferenceResolver = (PageReferenceResolver)Utils.getComponent(PageReferenceResolver.TYPE_REFERENCE);
        }
        return this.pageReferenceResolver;
    }

    private EntityReferenceSerializer<String> getDefaultEntityReferenceSerializer() {
        if (this.defaultEntityReferenceSerializer == null) {
            this.defaultEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
        }
        return this.defaultEntityReferenceSerializer;
    }

    private EntityReferenceSerializer<String> getUidStringEntityReferenceSerializer() {
        if (this.uidStringEntityReferenceSerializer == null) {
            this.uidStringEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "uid");
        }
        return this.uidStringEntityReferenceSerializer;
    }

    private ContextualLocalizationManager getLocalization() {
        if (this.localization == null) {
            this.localization = Utils.getComponent(ContextualLocalizationManager.class);
        }
        return this.localization;
    }

    private OldRendering getOldRendering() {
        if (this.oldRenderingProvider == null) {
            this.oldRenderingProvider = (Provider)Utils.getComponent(OldRendering.TYPE_PROVIDER);
        }
        return (OldRendering)this.oldRenderingProvider.get();
    }

    private JobProgressManager getProgress() {
        if (this.progress == null) {
            this.progress = Utils.getComponent(JobProgressManager.class);
        }
        return this.progress;
    }

    private VelocityContextFactory getVelocityContextFactory() {
        if (this.velocityContextFactory == null) {
            this.velocityContextFactory = Utils.getComponent(VelocityContextFactory.class);
        }
        return this.velocityContextFactory;
    }

    private EntityReferenceFactory getEntityReferenceFactory() {
        if (this.entityReferenceFactory == null && Utils.getRootComponentManager() != null) {
            try {
                this.entityReferenceFactory = (EntityReferenceFactory)Utils.getRootComponentManager().getInstance(EntityReferenceFactory.class);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        return this.entityReferenceFactory;
    }

    private <E extends EntityReference> E intern(E reference) {
        EntityReferenceFactory factory = this.getEntityReferenceFactory();
        return (E)(factory != null ? factory.getReference(reference) : reference);
    }

    private String localizePlainOrKey(String key, Object ... parameters) {
        return StringUtils.defaultString((String)this.getLocalization().getTranslationPlain(key, parameters), (String)key);
    }

    private UserReferenceSerializer<DocumentReference> getUserReferenceDocumentReferenceSerializer() {
        return (UserReferenceSerializer)Utils.getComponent(UserReferenceSerializer.TYPE_DOCUMENT_REFERENCE, "document");
    }

    private UserReferenceResolver<DocumentReference> getUserReferenceDocumentReferenceResolver() {
        return (UserReferenceResolver)Utils.getComponent(UserReferenceResolver.TYPE_DOCUMENT_REFERENCE, "document");
    }

    private UserReferenceSerializer<String> getUserReferenceStringSerializer() {
        return (UserReferenceSerializer)Utils.getComponent(UserReferenceSerializer.TYPE_STRING);
    }

    private UserReferenceResolver<String> getUserReferenceStringResolver() {
        return (UserReferenceResolver)Utils.getComponent(UserReferenceResolver.TYPE_STRING);
    }

    private UserReferenceSerializer<String> getUserReferenceCompactWikiSerializer() {
        return (UserReferenceSerializer)Utils.getComponent(UserReferenceSerializer.TYPE_STRING, "compactwiki/document");
    }

    private LinkStore getLinkStore() {
        return Utils.getComponent(LinkStore.class);
    }

    public XWikiStoreInterface getStore(XWikiContext context) {
        return context.getWiki().getStore();
    }

    @Deprecated(since="9.9RC1")
    public XWikiAttachmentStoreInterface getAttachmentStore(XWikiContext context) {
        return context.getWiki().getAttachmentStore();
    }

    public XWikiVersioningStoreInterface getVersioningStore(XWikiContext context) {
        return context.getWiki().getVersioningStore();
    }

    public XWikiStoreInterface getStore() {
        return this.store;
    }

    public void setStore(XWikiStoreInterface store) {
        this.store = store;
    }

    private RenderingContext getRenderingContext() {
        if (this.renderingContext == null) {
            this.renderingContext = Utils.getComponent(RenderingContext.class);
        }
        return this.renderingContext;
    }

    private String getLocalKey() {
        if (this.localKeyCache == null) {
            this.localKeyCache = LocalUidStringEntityReferenceSerializer.INSTANCE.serialize((EntityReference)this.getDocumentReferenceWithLocale(), new Object[0]);
        }
        return this.localKeyCache;
    }

    public String getKey() {
        if (this.keyCache == null) {
            this.keyCache = (String)this.getUidStringEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReferenceWithLocale(), new Object[0]);
        }
        return this.keyCache;
    }

    public int hashCode() {
        return (int)Util.getHash(this.getLocalKey());
    }

    public long getId() {
        this.id = Util.getHash(this.getLocalKey());
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Deprecated(since="2.2M1")
    public String getSpace() {
        return LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.getDocumentReference().getLastSpaceReference(), new Object[0]);
    }

    @Deprecated(since="2.2M1")
    public void setSpace(String spaces) {
        if (spaces != null) {
            DocumentReference reference = this.getDocumentReference();
            EntityReference spaceReference = XWikiDocument.getRelativeEntityReferenceResolver().resolve((Object)spaces, EntityType.SPACE, new Object[0]);
            spaceReference = spaceReference.appendParent((EntityReference)this.getDocumentReference().getWikiReference());
            this.setDocumentReferenceInternal(new DocumentReference(reference.getName(), new SpaceReference(spaceReference)));
        }
    }

    @Deprecated
    public String getWeb() {
        return this.getSpace();
    }

    @Deprecated
    public void setWeb(String space) {
        this.setSpace(space);
    }

    public String getVersion() {
        return this.getRCSVersion().toString();
    }

    public void setVersion(String version) {
        if (!StringUtils.isEmpty((CharSequence)version)) {
            this.version = new Version(version);
        }
    }

    public Version getRCSVersion() {
        if (this.version == null) {
            return new Version("1.1");
        }
        return this.version;
    }

    public void setRCSVersion(Version version) {
        this.version = version;
    }

    public XWikiDocument getOriginalDocument() {
        return this.originalDocument;
    }

    public void setOriginalDocument(XWikiDocument originalDocument) {
        this.originalDocument = originalDocument;
    }

    public DocumentReference getParentReference() {
        if (this.parentReferenceCache == null && this.getRelativeParentReference() != null) {
            this.parentReferenceCache = this.intern(this.getExplicitReferenceDocumentReferenceResolver().resolve((Object)this.getRelativeParentReference(), new Object[]{this.getDocumentReference()}));
        }
        return this.parentReferenceCache;
    }

    @Deprecated(since="2.2M1")
    public String getParent() {
        String parentReferenceAsString = this.getParentReference() != null ? (String)this.getDefaultEntityReferenceSerializer().serialize(this.getRelativeParentReference(), new Object[0]) : "";
        return parentReferenceAsString;
    }

    @Deprecated(since="2.2M1")
    public XWikiDocument getParentDoc() {
        return new XWikiDocument(this.getParentReference());
    }

    public void setParentReference(EntityReference parentReference) {
        if (!Objects.equals(this.getRelativeParentReference(), parentReference)) {
            this.parentReference = this.intern(parentReference);
            this.parentReferenceCache = null;
            this.setMetaDataDirty(true);
        }
    }

    @Deprecated(since="2.2M1")
    public void setParent(String parent) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            this.setParentReference((EntityReference)null);
        } else {
            this.setParentReference(XWikiDocument.getRelativeEntityReferenceResolver().resolve((Object)parent, EntityType.DOCUMENT, new Object[0]));
        }
    }

    public String getContent() {
        return this.content.content;
    }

    public void setContent(String content) {
        this.setContent(content, this.content.syntax);
    }

    public void setContent(XDOM content) throws XWikiException {
        this.setContent(XWikiDocument.renderXDOM(content, this.getSyntax()));
    }

    public void setContent(String content, Syntax syntax) {
        if (content == null) {
            content = "";
        }
        if (!content.equals(this.content.content) || !Objects.equals(syntax, this.content.syntax)) {
            this.content = new Content(content, syntax);
            this.setContentDirty(true);
            this.setWikiNode(null);
        }
    }

    private RenderingCache getRenderingCache() {
        if (this.renderingCache == null) {
            this.renderingCache = (RenderingCache)Utils.getComponent(RenderingCache.class);
        }
        return this.renderingCache;
    }

    private DocumentDisplayer getDocumentDisplayer() {
        if (this.documentDisplayer == null) {
            this.documentDisplayer = (DocumentDisplayer)Utils.getComponent(DocumentDisplayer.class, "configured");
        }
        return this.documentDisplayer;
    }

    private Syntax getOutputSyntax() {
        return this.getRenderingContext().getTargetSyntax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String display(Syntax targetSyntax, boolean executionContextIsolated, boolean transformationContextIsolated, boolean transformationContextRestricted, boolean translate) throws XWikiException {
        this.getProgress().startStep((Object)this, "document.progress.render", "Render document [{}] in syntax [{}]", new Object[]{this.getDocumentReference(), targetSyntax});
        try {
            this.getProgress().pushLevelProgress(3, (Object)this.getDocumentReference());
            this.getProgress().startStep((Object)this.getDocumentReference(), "document.progress.render.translatedcontent", "Get translated content", new Object[0]);
            XWikiContext xcontext = this.getXWikiContext();
            XWikiDocument tdoc = translate ? this.getTranslatedDocument(xcontext) : this;
            String translatedContent = tdoc.getContent();
            this.getProgress().startStep((Object)this.getDocumentReference(), "document.progress.render.cache", "Try to get content from the cache", new Object[0]);
            String renderedContent = this.getRenderingCache().getRenderedContent(tdoc.getDocumentReferenceWithLocale(), translatedContent, xcontext);
            if (renderedContent == null) {
                this.getProgress().startStep((Object)this.getDocumentReference(), "document.progress.render.execute", "Execute content", new Object[0]);
                DocumentDisplayerParameters parameters = new DocumentDisplayerParameters();
                parameters.setExecutionContextIsolated(executionContextIsolated);
                parameters.setTransformationContextIsolated(transformationContextIsolated);
                parameters.setTransformationContextRestricted(transformationContextRestricted);
                parameters.setContentTranslated(tdoc != this);
                parameters.setTargetSyntax(targetSyntax);
                XDOM contentXDOM = this.getDocumentDisplayer().display((Object)this, (Object)parameters);
                renderedContent = XWikiDocument.renderXDOM(contentXDOM, targetSyntax);
                this.getRenderingCache().setRenderedContent(this.getDocumentReference(), translatedContent, renderedContent, xcontext);
            }
            String string = renderedContent;
            return string;
        }
        finally {
            this.getProgress().popLevelProgress((Object)this.getDocumentReference());
            this.getProgress().endStep((Object)this);
        }
    }

    public String getRenderedContent(Syntax targetSyntax, XWikiContext context) throws XWikiException {
        return this.getRenderedContent(targetSyntax, true, context);
    }

    public String getRenderedContent(boolean transformationContextIsolated, XWikiContext context) throws XWikiException {
        return this.getRenderedContent(this.getOutputSyntax(), transformationContextIsolated, context);
    }

    public String displayDocument(XWikiContext context) throws XWikiException {
        return this.displayDocument(this.getOutputSyntax(), context);
    }

    public String displayDocument(boolean restricted, XWikiContext context) throws XWikiException {
        return this.displayDocument(this.getOutputSyntax(), restricted, context);
    }

    public String displayDocument(Syntax targetSyntax, XWikiContext context) throws XWikiException {
        return this.getRenderedContent(targetSyntax, true, false, context, false);
    }

    public String displayDocument(Syntax targetSyntax, boolean restricted, XWikiContext context) throws XWikiException {
        return this.getRenderedContent(targetSyntax, true, restricted, context, false);
    }

    public String getRenderedContent(Syntax targetSyntax, boolean transformationContextIsolated, XWikiContext context) throws XWikiException {
        return this.getRenderedContent(targetSyntax, transformationContextIsolated, false, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRenderedContent(Syntax targetSyntax, boolean transformationContextIsolated, boolean transformationContextRestricted, XWikiContext context, boolean retrieveTranslation) throws XWikiException {
        Object currentSdoc = context.get(CKEY_SDOC);
        try {
            XWikiDocument sdoc = retrieveTranslation ? this.getTranslatedDocument(context) : this;
            context.put(CKEY_SDOC, sdoc);
            String string = this.display(targetSyntax, false, transformationContextIsolated, transformationContextRestricted, retrieveTranslation);
            return string;
        }
        finally {
            context.put(CKEY_SDOC, currentSdoc);
        }
    }

    public String getRenderedContent(XWikiContext context) throws XWikiException {
        return this.getRenderedContent(this.getOutputSyntax(), context);
    }

    public String getRenderedContent(String text, String syntaxId, XWikiContext context) {
        return this.getRenderedContent(text, syntaxId, this.getOutputSyntax().toIdString(), context);
    }

    public String getRenderedContent(String text, String syntaxId, boolean restrictedTransformationContext, XWikiContext context) {
        return this.getRenderedContent(text, syntaxId, this.getOutputSyntax().toIdString(), restrictedTransformationContext, context);
    }

    public String getRenderedContent(String text, String syntaxId, boolean restrictedTransformationContext, XWikiDocument sDocument, XWikiContext context) {
        return this.getRenderedContent(text, syntaxId, this.getOutputSyntax().toIdString(), restrictedTransformationContext, sDocument, context);
    }

    public String getRenderedContent(String text, String sourceSyntaxId, String targetSyntaxId, XWikiContext context) {
        return this.getRenderedContent(text, sourceSyntaxId, targetSyntaxId, false, context);
    }

    public String getRenderedContent(String text, String sourceSyntaxId, String targetSyntaxId, boolean restrictedTransformationContext, XWikiContext context) {
        return this.getRenderedContent(text, sourceSyntaxId, targetSyntaxId, restrictedTransformationContext, null, context);
    }

    public String getRenderedContent(String text, String sourceSyntaxId, String targetSyntaxId, boolean restrictedTransformationContext, XWikiDocument sDocument, XWikiContext context) {
        try {
            return this.getRenderedContent(text, Syntax.valueOf((String)sourceSyntaxId), Syntax.valueOf((String)targetSyntaxId), restrictedTransformationContext, sDocument, true, context);
        }
        catch (ParseException e) {
            LOGGER.warn("Failed to render content [{}]", (Object)text, (Object)e);
            return "";
        }
    }

    public String getRenderedContent(String text, Syntax sourceSyntaxId, XWikiDocument sDocument, boolean isolated, XWikiContext context) {
        return this.getRenderedContent(text, sourceSyntaxId, this.getOutputSyntax(), false, sDocument, isolated, context);
    }

    public String getRenderedContent(String text, Syntax sourceSyntaxId, boolean restrictedTransformationContext, XWikiDocument sDocument, boolean isolated, XWikiContext context) {
        return this.getRenderedContent(text, sourceSyntaxId, this.getOutputSyntax(), restrictedTransformationContext, sDocument, isolated, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedContent(String text, Syntax sourceSyntaxId, Syntax targetSyntaxId, boolean restrictedTransformationContext, XWikiDocument sDocument, boolean isolated, XWikiContext context) {
        HashMap<String, Object> backup = null;
        this.getProgress().startStep((Object)this, "document.progress.renderText", "Execute content [{}] in the context of document [{}]", new Object[]{StringUtils.substring((String)text, (int)0, (int)100) + (text.length() >= 100 ? "..." : ""), this.getDocumentReference()});
        XWikiDocument currentSDocument = (XWikiDocument)context.get(CKEY_SDOC);
        try {
            if (isolated && context.getDoc() != this) {
                backup = new HashMap<String, Object>();
                XWikiDocument.backupContext(backup, context);
                this.setAsContextDoc(context);
            }
            if (sDocument != null) {
                context.put(CKEY_SDOC, sDocument);
            }
            XWikiDocument fakeDocument = new XWikiDocument(this.getDocumentReference());
            fakeDocument.setSyntax(sourceSyntaxId);
            fakeDocument.setContent(text);
            fakeDocument.setRestricted(sDocument != null && sDocument.isRestricted());
            String string = fakeDocument.display(targetSyntaxId, false, isolated, restrictedTransformationContext, false);
            return string;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to render content [{}]", (Object)text, (Object)e);
        }
        finally {
            if (backup != null) {
                XWikiDocument.restoreContext(backup, context);
            }
            context.put(CKEY_SDOC, currentSDocument);
            this.getProgress().endStep((Object)this);
        }
        return "";
    }

    public String getEscapedContent(XWikiContext context) throws XWikiException {
        return XMLUtils.escape((String)this.getTranslatedContent(context));
    }

    @Deprecated(since="2.2M1")
    public String getName() {
        return this.getDocumentReference().getName();
    }

    @Deprecated(since="2.2M1")
    public void setName(String name) {
        if (name != null) {
            DocumentReference reference = this.getDocumentReference();
            this.setDocumentReferenceInternal(new DocumentReference(name, new SpaceReference(reference.getParent()), reference.getLocale()));
        }
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public PageReference getPageReference() {
        if (this.pageReferenceCache == null) {
            this.pageReferenceCache = this.intern(this.getPageReferenceResolver().resolve((Object)this.getDocumentReference(), new Object[0]));
        }
        return this.pageReferenceCache;
    }

    public PageReference getPageReferenceWithLocale() {
        if (this.pageReferenceWithLocaleCache == null) {
            this.pageReferenceWithLocaleCache = this.intern(new PageReference((EntityReference)this.getPageReference(), this.getLocale()));
        }
        return this.pageReferenceWithLocaleCache;
    }

    public DocumentReference getDocumentReferenceWithLocale() {
        if (this.documentReferenceWithLocaleCache == null) {
            this.documentReferenceWithLocaleCache = this.intern(new DocumentReference((EntityReference)this.documentReference, this.getLocale()));
        }
        return this.documentReferenceWithLocaleCache;
    }

    @Deprecated(since="2.2M1")
    public String getFullName() {
        return LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.getDocumentReference(), new Object[0]);
    }

    @Deprecated(since="2.2M1")
    public String getPrefixedFullName() {
        return (String)this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0]);
    }

    @Deprecated(since="2.2.3")
    public void setDocumentReference(DocumentReference reference) {
        if (reference != null) {
            DocumentReference referenceWithoutLocale;
            DocumentReference documentReference = referenceWithoutLocale = reference.getLocale() != null ? new DocumentReference((EntityReference)reference, (Locale)null) : reference;
            if (!referenceWithoutLocale.equals((Object)this.getDocumentReference())) {
                this.setDocumentReferenceInternal(referenceWithoutLocale);
            }
        }
    }

    private void setDocumentReferenceInternal(DocumentReference reference) {
        this.documentReference = this.intern(reference);
        this.setMetaDataDirty(true);
        this.keyCache = null;
        this.localKeyCache = null;
        this.parentReferenceCache = null;
        this.documentReferenceWithLocaleCache = null;
        this.pageReferenceCache = null;
        this.pageReferenceWithLocaleCache = null;
    }

    @Deprecated(since="2.2M1")
    public void setFullName(String name) {
        this.setFullName(name, null);
    }

    @Deprecated(since="2.2M1")
    public void setFullName(String fullName, XWikiContext context) {
        if (fullName != null) {
            this.setDocumentReference(XWikiDocument.getCurrentMixedDocumentReferenceResolver().resolve((Object)fullName, new Object[0]));
        }
    }

    @Deprecated(since="2.2M1")
    public String getWikiName() {
        return this.getDatabase();
    }

    @Deprecated(since="2.2M1")
    public String getSpaceName() {
        return this.getSpace();
    }

    @Deprecated(since="2.2M1")
    public String getPageName() {
        return this.getName();
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public Object getPreparedTitle() {
        if (this.titlePrepareDate != null && XWikiDocument.getCacheControl().isCacheReadAllowed((ChronoLocalDateTime)this.titlePrepareDate)) {
            return this.preparedTitle;
        }
        return null;
    }

    public void setPreparedTitle(Object preparedTitle) {
        this.preparedTitle = preparedTitle;
        this.titlePrepareDate = LocalDateTime.now();
    }

    public String getRenderedTitle(Syntax outputSyntax, XWikiContext context) {
        DocumentDisplayerParameters parameters = new DocumentDisplayerParameters();
        parameters.setTitleDisplayed(true);
        parameters.setExecutionContextIsolated(true);
        parameters.setTargetSyntax(outputSyntax);
        try {
            XDOM titleXDOM = this.getDocumentDisplayer().display((Object)this, (Object)parameters);
            return XWikiDocument.renderXDOM(titleXDOM, outputSyntax);
        }
        catch (Exception e) {
            LOGGER.error("Failed to render title for [{}]", (Object)this.getDocumentReference(), (Object)e);
            return this.getDocumentReference().getName();
        }
    }

    public String getRenderedTitle(XWikiContext context) {
        return this.getRenderedTitle(this.getOutputSyntax(), context);
    }

    public void setTitle(String title) {
        if (title != null && !title.equals(this.title)) {
            this.setContentDirty(true);
        }
        this.title = title;
        this.titlePrepareDate = null;
        this.preparedTitle = null;
    }

    public String getFormat() {
        return this.format != null ? this.format : "";
    }

    public void setFormat(String format) {
        if (!format.equals(this.format)) {
            this.format = format;
            this.setMetaDataDirty(true);
        }
    }

    private DocumentReference userStringToReference(String userString) {
        DocumentReference userReference;
        if (StringUtils.isEmpty((CharSequence)userString)) {
            userReference = null;
        } else {
            userReference = this.getExplicitReferenceDocumentReferenceResolver().resolve((Object)XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)userString, EntityType.DOCUMENT, new Object[0]), new Object[]{this.getDocumentReference()});
            if (userReference.getName().equals("XWikiGuest")) {
                userReference = null;
            }
        }
        return userReference;
    }

    private String userReferenceToString(DocumentReference userReference) {
        String userString = userReference != null ? (String)XWikiDocument.getCompactWikiEntityReferenceSerializer().serialize((EntityReference)userReference, new Object[]{this.getDocumentReference()}) : "XWiki.XWikiGuest";
        return userString;
    }

    private String userReferenceToString(UserReference userReference) {
        if ("document".equals(XWikiDocument.getUserConfiguration().getStoreHint())) {
            return (String)this.getUserReferenceCompactWikiSerializer().serialize(userReference, new Object[]{this.getDocumentReference()});
        }
        return (String)this.getUserReferenceStringSerializer().serialize(userReference);
    }

    private UserReference userStringToUserReference(String userString) {
        if ("document".equals(XWikiDocument.getUserConfiguration().getStoreHint())) {
            return this.getUserReferenceStringResolver().resolve((Object)userString, new Object[]{this.getDocumentReference().getWikiReference()});
        }
        return this.getUserReferenceStringResolver().resolve((Object)userString, new Object[0]);
    }

    @Deprecated(since="14.0RC1")
    public DocumentReference getAuthorReference() {
        UserReference effectiveMetadataAuthor = this.getAuthors().getEffectiveMetadataAuthor();
        if (this.getAuthors().getEffectiveMetadataAuthor() != null && effectiveMetadataAuthor != GuestUserReference.INSTANCE) {
            return (DocumentReference)this.getUserReferenceDocumentReferenceSerializer().serialize(effectiveMetadataAuthor);
        }
        return null;
    }

    @Deprecated(since="14.0RC1")
    public void setAuthorReference(DocumentReference authorReference) {
        if (authorReference == null) {
            this.authors.setEffectiveMetadataAuthor((UserReference)GuestUserReference.INSTANCE);
        } else {
            if (authorReference.getName().equals("XWikiGuest")) {
                LOGGER.warn("A reference to XWikiGuest user has been set instead of null. This is probably a mistake.", (Throwable)new Exception("See stack trace"));
            }
            UserReference user = this.getUserReferenceDocumentReferenceResolver().resolve((Object)authorReference, new Object[0]);
            this.authors.setEffectiveMetadataAuthor(user);
            this.authors.setOriginalMetadataAuthor(user);
        }
    }

    @Deprecated
    public String getAuthor() {
        return this.userReferenceToString(this.getAuthorReference());
    }

    @Deprecated(since="3.0M3")
    public void setAuthor(String author) {
        this.setAuthorReference(this.userStringToReference(author));
    }

    @Deprecated(since="14.0RC1")
    public DocumentReference getContentAuthorReference() {
        UserReference contentAuthor = this.getAuthors().getContentAuthor();
        if (contentAuthor != null && contentAuthor != GuestUserReference.INSTANCE) {
            return (DocumentReference)this.getUserReferenceDocumentReferenceSerializer().serialize(contentAuthor);
        }
        return null;
    }

    @Deprecated(since="14.0RC1")
    public void setContentAuthorReference(DocumentReference contentAuthorReference) {
        if (contentAuthorReference == null) {
            this.authors.setContentAuthor((UserReference)GuestUserReference.INSTANCE);
        } else {
            if (contentAuthorReference.getName().equals("XWikiGuest")) {
                LOGGER.warn("A reference to XWikiGuest user has been set instead of null. This is probably a mistake.", (Throwable)new Exception("See stack trace"));
            }
            UserReference user = this.getUserReferenceDocumentReferenceResolver().resolve((Object)contentAuthorReference, new Object[0]);
            this.authors.setContentAuthor(user);
        }
    }

    @Deprecated(since="3.0M3")
    public String getContentAuthor() {
        return this.userReferenceToString(this.getContentAuthorReference());
    }

    @Deprecated(since="3.0M3")
    public void setContentAuthor(String contentAuthor) {
        this.setContentAuthorReference(this.userStringToReference(contentAuthor));
    }

    @Deprecated(since="14.0RC1")
    public DocumentReference getCreatorReference() {
        UserReference creator = this.getAuthors().getCreator();
        if (creator != null && creator != GuestUserReference.INSTANCE) {
            return (DocumentReference)this.getUserReferenceDocumentReferenceSerializer().serialize(creator);
        }
        return null;
    }

    @Deprecated(since="14.0RC1")
    public void setCreatorReference(DocumentReference creatorReference) {
        if (creatorReference == null) {
            this.authors.setCreator((UserReference)GuestUserReference.INSTANCE);
        } else {
            if (creatorReference.getName().equals("XWikiGuest")) {
                LOGGER.warn("A reference to XWikiGuest user has been set instead of null. This is probably a mistake.", (Throwable)new Exception("See stack trace"));
            }
            UserReference user = this.getUserReferenceDocumentReferenceResolver().resolve((Object)creatorReference, new Object[0]);
            this.authors.setCreator(user);
        }
    }

    @Deprecated(since="3.0M2")
    public String getCreator() {
        return this.userReferenceToString(this.getCreatorReference());
    }

    @Deprecated(since="3.0M2")
    public void setCreator(String creator) {
        this.setCreatorReference(this.userStringToReference(creator));
    }

    public Date getDate() {
        if (this.updateDate == null) {
            return new Date();
        }
        return this.updateDate;
    }

    public void setDate(Date date) {
        if (date != null && !date.equals(this.updateDate)) {
            this.setMetaDataDirty(true);
        }
        if (date != null) {
            date.setTime(date.getTime() / 1000L * 1000L);
        }
        this.updateDate = date;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            return new Date();
        }
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        if (date != null && !date.equals(this.creationDate)) {
            this.setMetaDataDirty(true);
        }
        if (date != null) {
            date.setTime(date.getTime() / 1000L * 1000L);
        }
        this.creationDate = date;
    }

    public Date getContentUpdateDate() {
        if (this.contentUpdateDate == null) {
            return new Date();
        }
        return this.contentUpdateDate;
    }

    public void setContentUpdateDate(Date date) {
        if (date != null && !date.equals(this.contentUpdateDate)) {
            this.setMetaDataDirty(true);
        }
        if (date != null) {
            date.setTime(date.getTime() / 1000L * 1000L);
        }
        this.contentUpdateDate = date;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        if (meta == null) {
            if (this.meta != null) {
                this.setMetaDataDirty(true);
            }
        } else if (!meta.equals(this.meta)) {
            this.setMetaDataDirty(true);
        }
        this.meta = meta;
    }

    public void appendMeta(String meta) {
        StringBuilder buf = new StringBuilder(this.meta);
        buf.append(meta);
        buf.append("\n");
        this.meta = buf.toString();
        this.setMetaDataDirty(true);
    }

    public boolean isContentDirty() {
        return this.isContentDirty;
    }

    public void incrementVersion() {
        this.version = XWikiDocument.getNextVersion(this.version, this.isMinorEdit());
    }

    public static Version getNextVersion(Version version, boolean minorEdit) {
        if (version == null) {
            return new Version("1.1");
        }
        if (minorEdit) {
            return version.next();
        }
        return version.getBranchPoint().next().newBranch(1);
    }

    public void setContentDirty(boolean contentDirty) {
        this.isContentDirty = contentDirty;
    }

    public boolean isMetaDataDirty() {
        return this.isMetaDataDirty;
    }

    public void setMetaDataDirty(boolean metaDataDirty) {
        if (metaDataDirty && !this.isMetaDataDirty && this.isCached()) {
            LoggerConfiguration loggerConfiguration = Utils.getComponent(LoggerConfiguration.class);
            String logMessage = "Abusive modification of the cached document [{}]";
            IllegalStateException exception = new IllegalStateException("Abusive modification of the cached document");
            if (loggerConfiguration.isDeprecatedLogEnabled()) {
                LOGGER.warn(logMessage, (Object)this.getDocumentReferenceWithLocale(), (Object)exception);
            } else {
                LOGGER.debug(logMessage, (Object)this.getDocumentReferenceWithLocale(), (Object)exception);
            }
        }
        this.isMetaDataDirty = metaDataDirty;
    }

    @Unstable
    public void setDirty(boolean dirty, boolean deep) {
        this.setMetaDataDirty(dirty);
        this.setContentDirty(dirty);
        if (deep) {
            if (this.xClass != null) {
                this.xClass.setDirty(dirty, deep);
            }
            if (this.xObjects != null) {
                this.xObjects.values().forEach(objects -> objects.setDirty(dirty, deep));
            }
            this.attachmentList.setDirty(dirty, deep);
        }
    }

    @Unstable
    public boolean isChangeTracked() {
        return this.changeTracked;
    }

    @Unstable
    public void setChangeTracked(boolean changeTracked) {
        this.changeTracked = changeTracked;
    }

    public String getAttachmentURL(String filename, XWikiContext context) {
        return this.getAttachmentURL(filename, "download", context);
    }

    public String getAttachmentURL(String filename, String action, XWikiContext context) {
        return this.getAttachmentURL(filename, action, null, context);
    }

    public String getExternalAttachmentURL(String filename, String action, XWikiContext context) {
        URL url = context.getURLFactory().createAttachmentURL(filename, this.getSpace(), this.getName(), action, null, this.getDatabase(), context);
        return url.toString();
    }

    public String getAttachmentURL(String filename, String action, String querystring, XWikiContext context) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        return context.getWiki().getAttachmentURL(new AttachmentReference(filename, this.getDocumentReference()), action, querystring, context);
    }

    public String getAttachmentRevisionURL(String filename, String revision, XWikiContext context) {
        return this.getAttachmentRevisionURL(filename, revision, null, context);
    }

    public String getAttachmentRevisionURL(String filename, String revision, String querystring, XWikiContext context) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        return context.getWiki().getAttachmentRevisionURL(new AttachmentReference(filename, this.getDocumentReference()), revision, querystring, context);
    }

    public String getURL(String action, String params, boolean redirect, XWikiContext context) {
        URL url = context.getURLFactory().createURL(this.getSpace(), this.getName(), action, params, null, this.getDatabase(), context);
        if (redirect && this.isRedirectAbsolute(context)) {
            if (url == null) {
                return null;
            }
            return url.toString();
        }
        return context.getURLFactory().getURL(url, context);
    }

    private boolean isRedirectAbsolute(XWikiContext context) {
        return Strings.CS.equals("1", context.getWiki().Param("xwiki.redirect.absoluteurl"));
    }

    public String getURL(String action, boolean redirect, XWikiContext context) {
        return this.getURL(action, null, redirect, context);
    }

    public String getURL(String action, XWikiContext context) {
        return this.getURL(action, false, context);
    }

    public String getURL(String action, String querystring, XWikiContext context) {
        URL url = context.getURLFactory().createURL(this.getSpace(), this.getName(), action, querystring, null, this.getDatabase(), context);
        return context.getURLFactory().getURL(url, context);
    }

    public String getURL(String action, String querystring, String anchor, XWikiContext context) {
        URL url = context.getURLFactory().createURL(this.getSpace(), this.getName(), action, querystring, anchor, this.getDatabase(), context);
        return context.getURLFactory().getURL(url, context);
    }

    public String getExternalURL(String action, XWikiContext context) {
        URL url = context.getURLFactory().createExternalURL(this.getSpace(), this.getName(), action, null, null, this.getDatabase(), context);
        return url.toString();
    }

    public String getExternalURL(String action, String querystring, XWikiContext context) {
        URL url = context.getURLFactory().createExternalURL(this.getSpace(), this.getName(), action, querystring, null, this.getDatabase(), context);
        return url.toString();
    }

    public String getParentURL(XWikiContext context) throws XWikiException {
        XWikiDocument doc = new XWikiDocument(this.getParentReference());
        URL url = context.getURLFactory().createURL(doc.getSpace(), doc.getName(), "view", null, null, this.getDatabase(), context);
        return context.getURLFactory().getURL(url, context);
    }

    public XWikiDocumentArchive getDocumentArchive(XWikiContext context) throws XWikiException {
        this.loadArchive(context);
        return this.getDocumentArchive();
    }

    public com.xpn.xwiki.api.Document newDocument(String customClassName, XWikiContext context) {
        if (customClassName != null && !customClassName.equals("")) {
            try {
                return this.newDocument(Class.forName(customClassName), context);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to get java Class object from class name", (Throwable)e);
            }
        }
        return new com.xpn.xwiki.api.Document(this, context);
    }

    public com.xpn.xwiki.api.Document newDocument(Class<?> customClass, XWikiContext context) {
        if (customClass != null) {
            try {
                Class[] classes = new Class[]{XWikiDocument.class, XWikiContext.class};
                Object[] args = new Object[]{this, context};
                return (com.xpn.xwiki.api.Document)customClass.getConstructor(classes).newInstance(args);
            }
            catch (Exception e) {
                LOGGER.error("Failed to create a custom Document object", (Throwable)e);
            }
        }
        return new com.xpn.xwiki.api.Document(this, context);
    }

    public com.xpn.xwiki.api.Document newDocument(XWikiContext context) {
        String customClass = this.getCustomClass();
        return this.newDocument(customClass, context);
    }

    public void loadArchive(XWikiContext context) throws XWikiException {
        if (this.archive == null || this.archive.get() == null) {
            XWikiDocumentArchive arch = this.isNew() ? new XWikiDocumentArchive(this.getDocumentReference().getWikiReference(), this.getId()) : this.getVersioningStore(context).getXWikiDocumentArchive(this, context);
            this.archive = new SoftReference<XWikiDocumentArchive>(arch);
        }
    }

    public XWikiDocumentArchive getDocumentArchive() {
        if (this.archive != null) {
            return this.archive.get();
        }
        return null;
    }

    public XWikiDocumentArchive loadDocumentArchive() {
        XWikiDocumentArchive arch = this.getDocumentArchive();
        if (arch != null) {
            return arch;
        }
        if (this.isNew()) {
            arch = new XWikiDocumentArchive(this.getDocumentReference().getWikiReference(), this.getId());
            this.setDocumentArchive(arch);
            return arch;
        }
        XWikiContext xcontext = this.getXWikiContext();
        try {
            arch = this.getVersioningStore(xcontext).getXWikiDocumentArchive(this, xcontext);
            this.setDocumentArchive(arch);
            return arch;
        }
        catch (Exception e) {
            LOGGER.warn("Could not get document archive", (Throwable)e);
            return null;
        }
    }

    public void setDocumentArchive(XWikiDocumentArchive arch) {
        this.archive = arch != null ? new SoftReference<XWikiDocumentArchive>(arch) : null;
    }

    public void setDocumentArchive(String sarch) throws XWikiException {
        XWikiDocumentArchive xda = new XWikiDocumentArchive(this.getDocumentReference().getWikiReference(), this.getId());
        xda.setArchive(sarch);
        this.setDocumentArchive(xda);
    }

    public Version[] getRevisions(XWikiContext context) throws XWikiException {
        return this.getVersioningStore(context).getXWikiDocVersions(this, context);
    }

    @Unstable
    public long getRevisionsCount(RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        return this.getVersioningStore(context).getXWikiDocVersionsCount(this, criteria, context);
    }

    public String[] getRecentRevisions(int nb, XWikiContext context) throws XWikiException {
        try {
            Version[] revisions = this.getVersioningStore(context).getXWikiDocVersions(this, context);
            int length = nb;
            if (nb == 0) {
                length = revisions.length;
            }
            if (revisions.length < length) {
                length = revisions.length;
            }
            String[] recentrevs = new String[length];
            for (int i = 1; i <= length; ++i) {
                recentrevs[i - 1] = revisions[revisions.length - i].toString();
            }
            return recentrevs;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public List<String> getRevisions(RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        return this.getVersioningStore(context).getXWikiDocVersions(this, criteria, context).stream().map(ToString::toString).collect(Collectors.toCollection(ArrayList::new));
    }

    public XWikiRCSNodeInfo getRevisionInfo(String version, XWikiContext context) throws XWikiException {
        return this.getDocumentArchive(context).getNode(new Version(version));
    }

    public boolean isMostRecent() {
        return this.mostRecent;
    }

    public void setMostRecent(boolean mostRecent) {
        this.mostRecent = mostRecent;
    }

    public BaseClass getXClass() {
        if (this.xClass == null) {
            BaseClass emptyClass = new BaseClass();
            emptyClass.setDirty(false);
            this.setXClass(emptyClass);
        }
        return this.xClass;
    }

    public void setXClass(BaseClass xwikiClass) {
        xwikiClass.setOwnerDocument(this);
        this.xClass = xwikiClass;
    }

    public Map<DocumentReference, List<BaseObject>> getXObjects() {
        return this.publicXObjects;
    }

    public void setXObjects(Map<DocumentReference, List<BaseObject>> objects) {
        if (objects == null) {
            objects = new HashMap<DocumentReference, List<BaseObject>>();
        }
        boolean isDirty = false;
        for (List<BaseObject> objList : objects.values()) {
            for (BaseObject obj : objList) {
                obj.setOwnerDocument(this);
                isDirty = true;
            }
        }
        if (isDirty) {
            this.setMetaDataDirty(true);
        }
        ConcurrentSkipListMap<DocumentReference, BaseObjects> objectsCopy = new ConcurrentSkipListMap<DocumentReference, BaseObjects>();
        objects.forEach((k, v) -> objectsCopy.put((DocumentReference)k, new BaseObjects((Collection<BaseObject>)v)));
        this.xObjects = objectsCopy;
    }

    public BaseObject getXObject() {
        return this.getXObject(this.getDocumentReference());
    }

    @Deprecated(since="2.2M1")
    public BaseObject getxWikiObject() {
        return this.getXObject(this.getDocumentReference());
    }

    public List<BaseClass> getXClasses(XWikiContext context) {
        ArrayList<BaseClass> list = new ArrayList<BaseClass>();
        for (DocumentReference classReference : this.getXObjects().keySet()) {
            BaseClass bclass = null;
            List<BaseObject> objects = this.getXObjects(classReference);
            for (BaseObject obj : objects) {
                if (obj != null && (bclass = obj.getXClass(context)) != null) break;
            }
            if (bclass == null) continue;
            list.add(bclass);
        }
        return list;
    }

    public int createXObject(EntityReference classReference, XWikiContext context) throws XWikiException {
        DocumentReference absoluteClassReference = this.resolveClassReference(classReference);
        BaseObject object = BaseClass.newCustomClassInstance(absoluteClassReference, context);
        object.setOwnerDocument(this);
        object.setXClassReference(classReference);
        BaseObjects objects = this.xObjects.get(absoluteClassReference);
        if (objects == null) {
            objects = new BaseObjects();
            this.xObjects.put(absoluteClassReference, objects);
        }
        objects.add(object);
        int nb = objects.size() - 1;
        object.setNumber(nb);
        this.setMetaDataDirty(true);
        return nb;
    }

    @Deprecated(since="2.2M1")
    public int createNewObject(String className, XWikiContext context) throws XWikiException {
        return this.createXObject(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), context);
    }

    public int getXObjectSize(DocumentReference classReference) {
        try {
            return this.getXObjects().get(classReference).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getXObjectSize(EntityReference classReference) {
        return this.getXObjectSize(this.resolveClassReference(classReference));
    }

    @Deprecated(since="2.2M1")
    public int getObjectNumbers(String className) {
        return this.getXObjectSize(this.resolveClassReference(className));
    }

    public List<BaseObject> getXObjects(DocumentReference classReference) {
        List<BaseObject> xobjects = null;
        if (classReference != null) {
            xobjects = this.getXObjects().get(classReference);
        }
        return xobjects != null ? xobjects : Collections.emptyList();
    }

    public List<BaseObject> getXObjects(EntityReference reference) {
        if (reference.getType() == EntityType.DOCUMENT) {
            return this.getXObjects(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)reference, new Object[]{this.getDocumentReference()}));
        }
        return Collections.emptyList();
    }

    @Deprecated(since="2.2M1")
    public Vector<BaseObject> getObjects(String className) {
        List result = this.xObjects.get(this.resolveClassReference(className));
        return result == null ? null : new Vector(result);
    }

    public void setXObjects(DocumentReference classReference, List<BaseObject> objects) {
        List existingbjects = this.xObjects.get(classReference);
        if (existingbjects != null) {
            existingbjects.clear();
        }
        for (BaseObject obj : objects) {
            obj.setOwnerDocument(this);
        }
        this.xObjects.put(classReference, new BaseObjects(objects));
        this.setMetaDataDirty(true);
    }

    public BaseObject getXObject(EntityReference reference) {
        if (reference instanceof DocumentReference) {
            return this.getXObject((DocumentReference)reference);
        }
        if (reference.getType() == EntityType.DOCUMENT) {
            return this.getXObject(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)reference, new Object[]{this.getDocumentReference()}));
        }
        if (reference.getType() == EntityType.OBJECT) {
            return this.getXObject(XWikiDocument.getCurrentReferenceObjectReferenceResolver().resolve((Object)reference, new Object[]{this.getDocumentReference()}));
        }
        return null;
    }

    public BaseObject getXObject(DocumentReference classReference) {
        BaseObject result = null;
        List<BaseObject> objects = this.getXObjects().get(classReference);
        if (objects != null) {
            for (BaseObject object : objects) {
                if (object == null) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    public BaseObject getXObject(ObjectReference objectReference) {
        BaseObjectReference baseObjectReference = this.getBaseObjectReference(objectReference);
        return baseObjectReference.getObjectNumber() == null ? this.getXObject(baseObjectReference.getXClassReference()) : this.getXObject(baseObjectReference.getXClassReference(), (int)baseObjectReference.getObjectNumber());
    }

    public BaseObject getXObject(ObjectReference objectReference, boolean create, XWikiContext context) throws XWikiException {
        BaseObjectReference baseObjectReference = this.getBaseObjectReference(objectReference);
        if (baseObjectReference.getObjectNumber() == null) {
            return this.getXObject(baseObjectReference.getXClassReference(), create, context);
        }
        return this.getXObject((EntityReference)baseObjectReference.getXClassReference(), baseObjectReference.getObjectNumber(), create, context);
    }

    private BaseObjectReference getBaseObjectReference(ObjectReference objectReference) {
        if (objectReference instanceof BaseObjectReference) {
            return (BaseObjectReference)objectReference;
        }
        return new BaseObjectReference((EntityReference)objectReference);
    }

    public BaseProperty<ObjectPropertyReference> getXObjectProperty(ObjectPropertyReference objectPropertyReference) {
        BaseObject object = this.getXObject((ObjectReference)objectPropertyReference.getParent());
        if (object != null) {
            return (BaseProperty)object.getField(objectPropertyReference.getName());
        }
        return null;
    }

    @Deprecated(since="2.2M1")
    public BaseObject getObject(String className) {
        return this.getXObject(this.resolveClassReference(className));
    }

    public BaseObject getXObject(DocumentReference classReference, int nb) {
        List<BaseObject> objects = this.getXObjects().get(classReference);
        if (objects != null && objects.size() > nb) {
            return objects.get(nb);
        }
        return null;
    }

    public BaseObject getXObject(EntityReference classReference, int number, boolean create, XWikiContext xcontext) throws XWikiException {
        DocumentReference absoluteClassReference = this.resolveClassReference(classReference);
        BaseObject xobject = this.getXObject(absoluteClassReference, number);
        if (xobject == null && create) {
            xobject = BaseClass.newCustomClassInstance(absoluteClassReference, xcontext);
            this.setXObject(number, xobject);
        }
        return xobject;
    }

    public BaseObject getXObject(EntityReference classReference, int nb) {
        return this.getXObject(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)classReference, new Object[]{this.getDocumentReference()}), nb);
    }

    @Deprecated(since="2.2M1")
    public BaseObject getObject(String className, int nb) {
        return this.getXObject(this.resolveClassReference(className), nb);
    }

    public BaseObject getXObject(DocumentReference classReference, String key, String value) {
        return this.getXObject(classReference, key, value, false);
    }

    @Deprecated(since="2.2M1")
    public BaseObject getObject(String className, String key, String value) {
        return this.getObject(className, key, value, false);
    }

    public BaseObject getXObject(EntityReference reference, String key, String value, boolean failover) {
        if (reference instanceof DocumentReference) {
            return this.getXObject((DocumentReference)reference, key, value, failover);
        }
        if (reference.getType() == EntityType.DOCUMENT) {
            return this.getXObject(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)reference, new Object[]{this.getDocumentReference()}), key, value, failover);
        }
        return null;
    }

    public BaseObject getXObject(DocumentReference classReference, String key, String value, boolean failover) {
        try {
            if (value == null) {
                if (failover) {
                    return this.getXObject(classReference);
                }
                return null;
            }
            List<BaseObject> objects = this.getXObjects().get(classReference);
            if (objects == null || objects.size() == 0) {
                return null;
            }
            for (BaseObject obj : objects) {
                if (obj == null || !value.equals(obj.getStringValue(key))) continue;
                return obj;
            }
            if (failover) {
                return this.getXObject(classReference);
            }
            return null;
        }
        catch (Exception e) {
            if (failover) {
                return this.getXObject(classReference);
            }
            LOGGER.warn("Exception while accessing objects for document [{}]: {}", new Object[]{this.getDocumentReference(), e.getMessage(), e});
            return null;
        }
    }

    @Deprecated(since="2.2M1")
    public BaseObject getObject(String className, String key, String value, boolean failover) {
        return this.getXObject(this.resolveClassReference(className), key, value, failover);
    }

    @Deprecated
    public void addXObject(DocumentReference classReference, BaseObject object) {
        List vobj = this.xObjects.get(classReference);
        if (vobj == null) {
            this.setXObject(classReference, 0, object);
        } else {
            this.setXObject(classReference, vobj.size(), object);
        }
    }

    public void addXObject(BaseObject object) {
        object.setOwnerDocument(this);
        BaseObjects vobj = this.xObjects.get(object.getXClassReference());
        if (vobj == null) {
            this.setXObject(0, object);
        } else {
            this.setXObject(vobj.size(), object);
        }
    }

    @Deprecated(since="2.2M1")
    public void addObject(String className, BaseObject object) {
        this.addXObject(this.resolveClassReference(className), object);
    }

    @Deprecated
    public void setXObject(DocumentReference classReference, int nb, BaseObject object) {
        if (object != null) {
            object.setOwnerDocument(this);
            object.setNumber(nb);
        }
        BaseObjects objects = this.xObjects.computeIfAbsent(classReference, k -> new BaseObjects());
        objects.put(nb, object);
        this.setMetaDataDirty(true);
    }

    public void setXObject(int nb, BaseObject object) {
        object.setOwnerDocument(this);
        object.setNumber(nb);
        BaseObjects objects = this.xObjects.computeIfAbsent(object.getXClassReference(), k -> new BaseObjects());
        objects.put(nb, object);
        this.setMetaDataDirty(true);
    }

    @Deprecated(since="2.2M1")
    public void setObject(String className, int nb, BaseObject object) {
        this.setXObject(this.resolveClassReference(className), nb, object);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public void mergeXClass(XWikiDocument templatedoc) {
        BaseClass bclass = this.getXClass();
        BaseClass tbclass = templatedoc.getXClass();
        if (tbclass != null) {
            if (bclass == null) {
                this.setXClass(tbclass.clone());
            } else {
                this.getXClass().merge(tbclass.clone());
            }
        }
        this.setMetaDataDirty(true);
    }

    @Deprecated(since="2.2M1")
    public void mergexWikiClass(XWikiDocument templatedoc) {
        this.mergeXClass(templatedoc);
    }

    public void mergeXObjects(XWikiDocument templateDoc) {
        for (Map.Entry<DocumentReference, List<BaseObject>> entry : templateDoc.getXObjects().entrySet()) {
            DocumentReference classReference = entry.getKey().replaceParent((EntityReference)entry.getKey().getWikiReference(), (EntityReference)this.getDocumentReference().getWikiReference());
            if (this.getXObjectSize(classReference) != 0) continue;
            for (BaseObject object : entry.getValue()) {
                if (object == null) continue;
                this.addXObject(object.duplicate());
            }
        }
    }

    @Deprecated(since="2.2M1")
    public void mergexWikiObjects(XWikiDocument templatedoc) {
        this.mergeXObjects(templatedoc);
    }

    public void cloneXObjects(XWikiDocument templatedoc) {
        this.cloneXObjects(templatedoc, true);
    }

    public void duplicateXObjects(XWikiDocument templatedoc) {
        this.cloneXObjects(templatedoc, false);
    }

    private void cloneXObjects(XWikiDocument templateDocument, boolean keepsIdentity) {
        this.xObjects.clear();
        for (Map.Entry<DocumentReference, BaseObjects> entry : templateDocument.xObjects.entrySet()) {
            BaseObjects objects;
            BaseObjects tobjects = entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)tobjects) || (objects = new BaseObjects(this, tobjects, keepsIdentity)).isEmpty()) continue;
            DocumentReference xclassReference = entry.getKey();
            WikiReference wikiReference = this.getDocumentReference().getWikiReference();
            if (!wikiReference.equals((Object)xclassReference.getWikiReference())) {
                xclassReference = xclassReference.setWikiReference(wikiReference);
            }
            this.xObjects.put(xclassReference, objects);
        }
    }

    public DocumentReference getTemplateDocumentReference() {
        return this.templateDocumentReference;
    }

    @Deprecated(since="2.2M1")
    public String getTemplate() {
        DocumentReference templateDocumentReference = this.getTemplateDocumentReference();
        String templateReferenceAsString = templateDocumentReference != null ? LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)templateDocumentReference, new Object[0]) : "";
        return templateReferenceAsString;
    }

    public void setTemplateDocumentReference(DocumentReference templateDocumentReference) {
        if (!Objects.equals(this.getTemplateDocumentReference(), templateDocumentReference)) {
            this.templateDocumentReference = templateDocumentReference;
            this.setMetaDataDirty(true);
        }
    }

    @Deprecated(since="2.2M1")
    public void setTemplate(String template) {
        DocumentReference templateReference = null;
        if (!StringUtils.isEmpty((CharSequence)template)) {
            templateReference = XWikiDocument.getCurrentMixedDocumentReferenceResolver().resolve((Object)template, new Object[0]);
        }
        this.setTemplateDocumentReference(templateReference);
    }

    public String displayPrettyName(String fieldname, XWikiContext context) {
        return this.displayPrettyName(fieldname, false, true, context);
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, XWikiContext context) {
        return this.displayPrettyName(fieldname, showMandatory, true, context);
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, boolean before, XWikiContext context) {
        try {
            BaseObject object = this.getXObject();
            if (object == null) {
                object = this.getFirstObject(fieldname, context);
            }
            return this.displayPrettyName(fieldname, showMandatory, before, object, context);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String displayPrettyName(String fieldname, BaseObject obj, XWikiContext context) {
        return this.displayPrettyName(fieldname, false, true, obj, context);
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, BaseObject obj, XWikiContext context) {
        return this.displayPrettyName(fieldname, showMandatory, true, obj, context);
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, boolean before, BaseObject obj, XWikiContext context) {
        try {
            PropertyClass pclass = (PropertyClass)obj.getXClass(context).get(fieldname);
            String dprettyName = "";
            if (showMandatory) {
                dprettyName = context.getWiki().addMandatory(context);
            }
            if (before) {
                return dprettyName + pclass.getPrettyName(context);
            }
            return pclass.getPrettyName(context) + dprettyName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String display(String fieldname, XWikiContext context) {
        String result = "";
        try {
            BaseObject object = this.getXObject();
            if (object == null) {
                object = this.getFirstObject(fieldname, context);
            }
            result = this.display(fieldname, object, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to display field [" + fieldname + "] of document [" + (String)this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0]) + "]", (Throwable)e);
        }
        return result;
    }

    public String display(String fieldname, BaseObject obj, XWikiContext context) {
        String type = null;
        try {
            type = (String)context.get("display");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = "view";
        }
        return this.display(fieldname, type, obj, context);
    }

    public String display(String fieldname, String mode, XWikiContext context) {
        return this.display(fieldname, mode, "", context);
    }

    public String display(String fieldname, String type, BaseObject obj, XWikiContext context) {
        return this.display(fieldname, type, obj, true, context);
    }

    public String display(String fieldname, String type, BaseObject obj, boolean isolated, XWikiContext context) {
        return this.display(fieldname, type, "", obj, isolated, context);
    }

    @Unstable
    public String display(String fieldname, String type, BaseObject obj, boolean isolated, boolean number, XWikiContext context) {
        return this.display(fieldname, type, "", obj, isolated, number, context);
    }

    public String display(String fieldname, String mode, String prefix, XWikiContext context) {
        try {
            BaseObject object = this.getXObject();
            if (object == null) {
                object = this.getFirstObject(fieldname, context);
            }
            if (object == null) {
                return "";
            }
            return this.display(fieldname, mode, prefix, object, context);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String display(String fieldname, String type, BaseObject obj, String wrappingSyntaxId, XWikiContext context) {
        return this.display(fieldname, type, "", obj, wrappingSyntaxId, context);
    }

    public String display(String fieldname, String type, String pref, BaseObject obj, XWikiContext context) {
        return this.display(fieldname, type, pref, obj, true, context);
    }

    public String display(String fieldname, String type, String pref, BaseObject obj, boolean isolated, XWikiContext context) {
        return this.display(fieldname, type, pref, obj, context.getWiki().getCurrentContentSyntaxId(this.getSyntaxId(), context), isolated, context);
    }

    @Unstable
    public String display(String fieldname, String type, String pref, BaseObject obj, boolean isolated, boolean number, XWikiContext context) {
        return this.display(fieldname, type, pref, obj, context.getWiki().getCurrentContentSyntaxId(this.getSyntaxId(), context), isolated, number, context);
    }

    public String display(String fieldname, String type, String pref, BaseObject obj, String wrappingSyntaxId, XWikiContext context) {
        return this.display(fieldname, type, pref, obj, wrappingSyntaxId, true, context);
    }

    public String display(String fieldname, String type, String pref, BaseObject obj, String wrappingSyntaxId, boolean isolated, XWikiContext context) {
        return this.display(fieldname, type, pref, obj, wrappingSyntaxId, isolated, true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unstable
    public String display(String fieldname, String type, String pref, BaseObject obj, String wrappingSyntaxId, boolean isolated, boolean number, XWikiContext context) {
        if (obj == null) {
            return "";
        }
        boolean isInRenderingEngine = BooleanUtils.toBoolean((Boolean)((Boolean)context.get("isInRenderingEngine")));
        HashMap<String, Object> backup = new HashMap<String, Object>();
        XWikiDocument currentSDoc = (XWikiDocument)context.get(CKEY_SDOC);
        try {
            Object object;
            XWikiDocument sdoc;
            if (isolated) {
                XWikiDocument.backupContext(backup, context);
                this.setAsContextDoc(context);
            }
            if ((sdoc = obj.getOwnerDocument()) != null && !Objects.equals(sdoc.getContentAuthorReference(), sdoc.getAuthorReference())) {
                sdoc = sdoc.clone();
                sdoc.setContentAuthorReference(sdoc.getAuthorReference());
                context.put(CKEY_SDOC, sdoc);
            }
            type = type.toLowerCase();
            StringBuffer result = new StringBuffer();
            PropertyClass pclass = (PropertyClass)obj.getXClass(context).get(fieldname);
            StringBuilder builder = new StringBuilder(pref);
            builder.append(LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)obj.getXClass(context).getDocumentReference(), new Object[0]));
            if (number) {
                builder.append('_');
                builder.append(obj.getNumber());
            }
            builder.append('_');
            Object prefix = builder.toString();
            if (pclass == null) {
                String string = "";
                return string;
            }
            if (pclass.isCustomDisplayed(context)) {
                pclass.displayCustom(result, fieldname, (String)prefix, type, obj, context);
            } else if (type.equals("view")) {
                pclass.displayView(result, fieldname, (String)prefix, obj, isolated, context);
            } else if (type.equals("rendered")) {
                String fcontent = pclass.displayView(fieldname, (String)prefix, obj, context);
                if (this.is10Syntax(wrappingSyntaxId)) {
                    result.append(this.getRenderedContent(fcontent, this.getSyntaxId(), context));
                } else {
                    result.append(fcontent);
                }
            } else if (type.equals("edit")) {
                context.addDisplayedField(fieldname);
                if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                    result.append("{pre}");
                }
                pclass.displayEdit(result, fieldname, (String)prefix, obj, context);
                if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                    result.append("{/pre}");
                }
            } else if (type.equals("hidden")) {
                if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                    result.append("{pre}");
                }
                pclass.displayHidden(result, fieldname, (String)prefix, obj, context);
                if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                    result.append("{/pre}");
                }
            } else if (type.equals("search")) {
                Method searchMethod = null;
                for (Method method : pclass.getClass().getMethods()) {
                    if (!method.getName().equals("displaySearch") || method.getParameterTypes().length != 5) continue;
                    searchMethod = method;
                    break;
                }
                if (searchMethod != null) {
                    if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                        result.append("{pre}");
                    }
                    prefix = LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)obj.getXClass(context).getDocumentReference(), new Object[0]) + "_";
                    searchMethod.invoke((Object)pclass, result, fieldname, prefix, context.get("query"), context);
                    if (this.is10Syntax(wrappingSyntaxId) && isInRenderingEngine) {
                        result.append("{/pre}");
                    }
                } else {
                    pclass.displayView(result, fieldname, (String)prefix, obj, context);
                }
            } else {
                pclass.displayView(result, fieldname, (String)prefix, obj, context);
            }
            if (isInRenderingEngine && !this.is10Syntax(wrappingSyntaxId) && (HTMLUtils.containsElementText((CharSequence)result) || result.indexOf("{") != -1)) {
                object = "{{html clean=\"false\" wiki=\"false\"}}" + StringUtils.replaceEach((String)result.toString(), (String[])HTML_MACRO_SEARCH_STRINGS, (String[])HTML_MACRO_REPLACE_STRINGS) + "{{/html}}";
                return object;
            }
            object = result.toString();
            return object;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to display field [" + fieldname + "] in [" + type + "] mode for Object of Class [" + (String)this.getDefaultEntityReferenceSerializer().serialize((EntityReference)obj.getDocumentReference(), new Object[0]) + "]", (Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            if (!backup.isEmpty()) {
                XWikiDocument.restoreContext(backup, context);
            }
            context.put(CKEY_SDOC, currentSDoc);
        }
    }

    public String displayForm(DocumentReference classReference, String header, String format, XWikiContext context) {
        return this.displayForm(classReference, header, format, true, context);
    }

    @Deprecated(since="2.2M1")
    public String displayForm(String className, String header, String format, XWikiContext context) {
        return this.displayForm(className, header, format, true, context);
    }

    public String displayForm(DocumentReference classReference, String header, String format, boolean linebreak, XWikiContext context) {
        VelocityContext vcontext;
        List<BaseObject> objects = this.getXObjects(classReference);
        if (format.endsWith("\\n")) {
            linebreak = true;
        }
        BaseCollection firstobject = null;
        Iterator<BaseObject> foit = objects.iterator();
        while (firstobject == null && foit.hasNext()) {
            firstobject = foit.next();
        }
        if (firstobject == null) {
            return "";
        }
        BaseClass bclass = firstobject.getXClass(context);
        if (bclass.getPropertyList().size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            vcontext = this.getVelocityContextFactory().createContext();
        }
        catch (XWikiVelocityException e) {
            LOGGER.error("Failed to create a standard VelocityContext", (Throwable)e);
            vcontext = new XWikiVelocityContext();
        }
        for (String propertyName : bclass.getPropertyList()) {
            PropertyClass pclass = (PropertyClass)bclass.getField(propertyName);
            vcontext.put(pclass.getName(), (Object)pclass.getPrettyName());
        }
        result.append(this.evaluate(header, context.getDoc().getPrefixedFullName(), vcontext, context));
        if (linebreak) {
            result.append("\n");
        }
        for (int i = 0; i < objects.size(); ++i) {
            vcontext.put("id", (Object)(i + 1));
            BaseObject object = objects.get(i);
            if (object == null) continue;
            for (String name : bclass.getPropertyList()) {
                vcontext.put(name, (Object)this.display(name, object, context));
            }
            result.append(this.evaluate(format, context.getDoc().getPrefixedFullName(), vcontext, context));
            if (!linebreak) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private String evaluate(String content, String name, VelocityContext vcontext, XWikiContext context) {
        StringWriter writer = new StringWriter();
        try {
            VelocityManager velocityManager = Utils.getComponent(VelocityManager.class);
            velocityManager.getVelocityEngine().evaluate((Context)vcontext, (Writer)writer, name, content);
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing velocity template namespace [{}]", (Object)name, (Object)e);
            Object[] args = new Object[]{name};
            XWikiException xe = new XWikiException(4, 4001, "Error while parsing velocity page {0}", e, args);
            return Util.getHTMLExceptionMessage(xe, context);
        }
    }

    @Deprecated(since="2.2M1")
    public String displayForm(String className, String header, String format, boolean linebreak, XWikiContext context) {
        return this.displayForm(this.resolveClassReference(className), header, format, linebreak, context);
    }

    public String displayForm(DocumentReference classReference, XWikiContext context) {
        List<BaseObject> objects = this.getXObjects(classReference);
        if (objects == null) {
            return "";
        }
        BaseCollection firstobject = null;
        Iterator<BaseObject> foit = objects.iterator();
        while (firstobject == null && foit.hasNext()) {
            firstobject = foit.next();
        }
        if (firstobject == null) {
            return "";
        }
        BaseClass bclass = firstobject.getXClass(context);
        if (bclass.getPropertyList().size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("{table}\n");
        boolean first = true;
        for (String propertyName : bclass.getPropertyList()) {
            if (first) {
                first = false;
            } else {
                result.append("|");
            }
            PropertyClass pclass = (PropertyClass)bclass.getField(propertyName);
            result.append(pclass.getPrettyName());
        }
        result.append("\n");
        for (int i = 0; i < objects.size(); ++i) {
            BaseObject object = objects.get(i);
            if (object == null) continue;
            first = true;
            for (String propertyName : bclass.getPropertyList()) {
                if (first) {
                    first = false;
                } else {
                    result.append("|");
                }
                String data = this.display(propertyName, object, context);
                data = data.trim();
                data = data.replaceAll("\n", " ");
                if (data.length() == 0) {
                    result.append("&nbsp;");
                    continue;
                }
                result.append(data);
            }
            result.append("\n");
        }
        result.append("{table}\n");
        return result.toString();
    }

    @Deprecated(since="2.2M1")
    public String displayForm(String className, XWikiContext context) {
        return this.displayForm(this.resolveClassReference(className), context);
    }

    @Unstable
    public boolean isCached() {
        return this.cached;
    }

    @Unstable
    public void setCached(boolean cached) {
        this.cached = cached;
    }

    @Deprecated(since="16.10.0RC1")
    public boolean isFromCache() {
        return this.fromCache;
    }

    @Deprecated(since="16.10.0RC1")
    public void setFromCache(boolean fromCache) {
        this.fromCache = fromCache;
    }

    public void readDocMetaFromForm(EditForm eform, XWikiContext context) throws XWikiException {
        String syntaxId;
        String comment;
        String parent;
        String creator;
        String defaultTemplate;
        String defaultLanguage = eform.getDefaultLanguage();
        if (defaultLanguage != null) {
            this.setDefaultLanguage(defaultLanguage);
        }
        if ((defaultTemplate = eform.getDefaultTemplate()) != null) {
            this.setDefaultTemplate(defaultTemplate);
        }
        if ((creator = eform.getCreator()) != null && !creator.equals(this.getCreator()) && (this.getCreatorReference().equals((Object)context.getUserReference()) || context.getWiki().getRightService().hasAdminRights(context))) {
            this.setCreator(creator);
        }
        if ((parent = eform.getParent()) != null) {
            this.setParent(parent);
        }
        if ((comment = eform.getComment()) != null) {
            this.setComment(comment);
        }
        boolean minorEdit = context.getWiki().hasMinorEdit(context) && eform.isMinorEdit();
        this.setMinorEdit(minorEdit);
        String tags = eform.getTags();
        if (!StringUtils.isEmpty((CharSequence)tags)) {
            this.setTags(tags, context);
        }
        if ((syntaxId = eform.getSyntaxId()) != null) {
            this.setSyntax(this.resolveSyntax(syntaxId));
        }
        if (eform.getHidden() != null) {
            this.setHidden("1".equals(eform.getHidden()));
        }
        if (eform.getEnforceRequiredRights() != null) {
            this.setEnforceRequiredRights("1".equals(eform.getEnforceRequiredRights()));
        }
    }

    private Syntax resolveSyntax(String syntaxId) {
        Syntax syntax;
        try {
            syntax = XWikiDocument.getSyntaxRegistry().resolveSyntax(syntaxId);
        }
        catch (ParseException e) {
            syntax = this.getDefaultDocumentSyntax();
            LOGGER.warn("Failed to set syntax [{}] for [{}], setting syntax [{}] instead.", new Object[]{syntaxId, this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0]), syntax.toIdString(), e});
        }
        return syntax;
    }

    public void setTags(String tagsStr, XWikiContext context) throws XWikiException {
        BaseClass tagsClass = context.getWiki().getTagClass(context);
        StaticListClass tagProp = (StaticListClass)tagsClass.getField("tags");
        BaseObject tags = this.getObject("XWiki.TagClass", true, context);
        tags.safeput("tags", tagProp.fromString(tagsStr));
        this.setMetaDataDirty(true);
    }

    public String getTags(XWikiContext context) {
        ListProperty prop = (ListProperty)this.getTagProperty();
        return prop != null ? prop.toFormString() : "";
    }

    public List<String> getTagsList(XWikiContext context) {
        List tagList = List.of();
        BaseProperty prop = this.getTagProperty();
        if (prop != null) {
            tagList = (List)prop.getValue();
        }
        return tagList;
    }

    private BaseProperty getTagProperty() {
        BaseObject tags = this.getObject("XWiki.TagClass");
        return tags != null ? (BaseProperty)tags.safeget("tags") : null;
    }

    public List<String> getTagsPossibleValues(XWikiContext context) {
        try {
            BaseClass tagsClass = context.getWiki().getTagClass(context);
            String possibleValues = ((StaticListClass)tagsClass.getField("tags")).getValues();
            return ListClass.getListFromString(possibleValues);
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to get tag class", (Throwable)e);
            List<String> list = Collections.emptyList();
            return list;
        }
    }

    public void readTranslationMetaFromForm(EditForm eform, XWikiContext context) throws XWikiException {
        String title;
        String content = eform.getContent();
        if (content != null) {
            content = context.getUtil().substitute("s/<br class=\"htmlarea\" \\/>/\r\n/g", content);
            this.setContent(content);
        }
        if ((title = eform.getTitle()) != null) {
            this.setTitle(title);
        }
    }

    public void readObjectsFromForm(EditForm eform, XWikiContext context) throws XWikiException {
        for (DocumentReference reference : this.getXObjects().keySet()) {
            List<BaseObject> oldObjects = this.getXObjects(reference);
            BaseObjects newObjects = new BaseObjects();
            while (newObjects.size() < oldObjects.size()) {
                newObjects.add(null);
            }
            for (int i = 0; i < oldObjects.size(); ++i) {
                BaseObject oldobject = oldObjects.get(i);
                if (oldobject == null) continue;
                BaseClass baseclass = oldobject.getXClass(context);
                BaseObject newobject = (BaseObject)baseclass.fromMap(eform.getObject(LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)baseclass.getDocumentReference(), new Object[0]) + "_" + i), oldobject);
                newobject.setNumber(oldobject.getNumber());
                newobject.setGuid(oldobject.getGuid());
                newobject.setOwnerDocument(this);
                newObjects.set(newobject.getNumber(), newobject);
            }
            this.getXObjects().put(reference, newObjects);
        }
    }

    public void readObjectsFromFormUpdateOrCreate(EditForm eform, XWikiContext context) throws XWikiException {
        Map<String, SortedMap<Integer, Map<String, String[]>>> updateOrCreateMap = eform.getUpdateOrCreateMap();
        for (Map.Entry<String, SortedMap<Integer, Map<String, String[]>>> requestClassEntries : updateOrCreateMap.entrySet()) {
            String className = requestClassEntries.getKey();
            DocumentReference requestClassReference = XWikiDocument.getCurrentDocumentReferenceResolver().resolve((Object)className, new Object[0]);
            SortedMap<Integer, Map<String, String[]>> requestObjectMap = requestClassEntries.getValue();
            for (Map.Entry<Integer, Map<String, String[]>> requestObjectEntry : requestObjectMap.entrySet()) {
                Integer requestObjectNumber = requestObjectEntry.getKey();
                Map<String, String[]> requestObjectPropertyMap = requestObjectEntry.getValue();
                ArrayList<String> properties = new ArrayList<String>(requestObjectPropertyMap.keySet());
                try {
                    BaseClass xClass = context.getWiki().getDocument(requestClassReference, context).getXClass();
                    for (String property : properties) {
                        if (xClass.getPropertyList().contains(property)) continue;
                        requestObjectPropertyMap.remove(property);
                    }
                }
                catch (XWikiException e) {
                    LOGGER.warn("Failed to load document [{}], ignoring properties update [{}]. Reason: [{}]", new Object[]{requestClassReference, StringUtils.join(properties, (String)","), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    continue;
                }
                if (requestObjectPropertyMap.isEmpty()) continue;
                BaseObject oldObject = this.getXObject((EntityReference)requestClassReference, requestObjectNumber, true, context);
                BaseClass baseClass = oldObject.getXClass(context);
                BaseObject newObject = (BaseObject)baseClass.fromMap(requestObjectPropertyMap, oldObject);
                newObject.setNumber(oldObject.getNumber());
                newObject.setGuid(oldObject.getGuid());
                newObject.setOwnerDocument(this);
                this.setXObject(requestObjectNumber, newObject);
            }
        }
    }

    public void readFromForm(EditForm eform, XWikiContext context) throws XWikiException {
        this.readDocMetaFromForm(eform, context);
        this.readTranslationMetaFromForm(eform, context);
        this.readAddedUpdatedAndRemovedObjectsFromForm(eform, context);
        this.readTemporaryUploadedFiles(eform);
    }

    private TemporaryAttachmentSessionsManager getTemporaryAttachmentManager() {
        return Utils.getComponent(TemporaryAttachmentSessionsManager.class);
    }

    public void readTemporaryUploadedFiles(EditForm editForm) {
        this.getTemporaryAttachmentManager().attachTemporaryAttachmentsInDocument(this, editForm.getTemporaryUploadedFiles());
    }

    public void readAddedUpdatedAndRemovedObjectsFromForm(EditForm eform, XWikiContext context) throws XWikiException {
        Map<String, List<Integer>> objectsToAdd = eform.getObjectsToAdd();
        for (String className : objectsToAdd.keySet()) {
            DocumentReference classReference = this.resolveClassReference(className);
            List<Integer> classIds = objectsToAdd.get(className);
            for (Integer classId : classIds) {
                this.getXObject((EntityReference)classReference, classId, true, context);
            }
        }
        ObjectPolicyType objectPolicy = eform.getObjectPolicy();
        if (objectPolicy == null || objectPolicy.equals((Object)ObjectPolicyType.UPDATE)) {
            this.readObjectsFromForm(eform, context);
        } else if (objectPolicy.equals((Object)ObjectPolicyType.UPDATE_OR_CREATE)) {
            this.readObjectsFromFormUpdateOrCreate(eform, context);
        }
        Map<String, List<Integer>> objectsToRemove = eform.getObjectsToRemove();
        for (String className : objectsToRemove.keySet()) {
            DocumentReference classReference = this.resolveClassReference(className);
            List<Integer> classIds = objectsToRemove.get(className);
            for (Integer classId : classIds) {
                BaseObject xObject = this.getXObject(classReference, (int)classId);
                if (xObject == null) continue;
                this.removeXObject(xObject);
            }
        }
    }

    public void readFromTemplate(DocumentReference templateDocumentReference, XWikiContext context) throws XWikiException {
        if (templateDocumentReference != null) {
            String content = this.getContent();
            if (!(content.equals("\n") || content.equals("") || this.isNew())) {
                Object[] args = new Object[]{this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0])};
                throw new XWikiException(3, 11002, "Cannot add a template to document {0} because it already has content", null, args);
            }
            XWiki xwiki = context.getWiki();
            XWikiDocument templatedoc = xwiki.getDocument(templateDocumentReference, context);
            if (templatedoc.isNew()) {
                Object[] args = new Object[]{this.getDefaultEntityReferenceSerializer().serialize((EntityReference)templateDocumentReference, new Object[0]), XWikiDocument.getCompactEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0])};
                throw new XWikiException(3, 11001, "Template document {0} does not exist when adding to document {1}", null, args);
            }
            this.setTemplateDocumentReference(templateDocumentReference);
            this.setTitle(templatedoc.getTitle());
            this.setContent(templatedoc.getContent());
            this.setSyntax(templatedoc.getSyntax());
            if (this.getParentReference() == null) {
                this.setParentReference(templatedoc.getRelativeParentReference());
            }
            if (this.isNew()) {
                this.setXObjects(new TreeMap<DocumentReference, List<BaseObject>>());
            }
            this.mergeXObjects(templatedoc);
            this.copyAttachments(templatedoc, false, true);
        }
    }

    public void clone(XWikiDocument document) {
        this.id = document.id;
        this.setDocumentReference(document.getDocumentReference());
        this.setRCSVersion(document.getRCSVersion());
        this.setDocumentArchive(document.getDocumentArchive());
        this.setAuthorReference(document.getAuthorReference());
        this.setContentAuthorReference(document.getContentAuthorReference());
        this.setContent(document.getContent());
        this.setCreationDate(document.getCreationDate());
        this.setDate(document.getDate());
        this.setCustomClass(document.getCustomClass());
        this.setContentUpdateDate(document.getContentUpdateDate());
        this.setTitle(document.getTitle());
        this.setFormat(document.getFormat());
        this.setFromCache(document.isFromCache());
        this.setElements(document.getElements());
        this.setMeta(document.getMeta());
        this.setMostRecent(document.isMostRecent());
        this.setNew(document.isNew());
        this.setStore(document.getStore());
        this.setTemplateDocumentReference(document.getTemplateDocumentReference());
        this.setParentReference(document.getRelativeParentReference());
        this.setCreatorReference(document.getCreatorReference());
        this.setDefaultLocale(document.getDefaultLocale());
        this.setDefaultTemplate(document.getDefaultTemplate());
        this.setValidationScript(document.getValidationScript());
        this.setLocale(document.getLocale());
        this.setXClass(document.getXClass().clone());
        this.setXClassXML(document.getXClassXML());
        this.setComment(document.getComment());
        this.setMinorEdit(document.isMinorEdit());
        this.setSyntax(document.getSyntax());
        this.setHidden(document.isHidden());
        this.setEnforceRequiredRights(document.isEnforceRequiredRights());
        this.cloneXObjects(document);
        this.cloneAttachments(document);
        this.setContentDirty(document.isContentDirty());
        this.setMetaDataDirty(document.isMetaDataDirty());
        this.elements = document.elements;
        this.originalDocument = document.originalDocument;
    }

    public XWikiDocument clone() {
        return this.cloneInternal(this.getDocumentReference(), true, false);
    }

    public XWikiDocument duplicate(DocumentReference newDocumentReference) {
        return this.cloneInternal(newDocumentReference, false, false);
    }

    private void cloneDocumentArchive(XWikiDocument originalDocument) throws XWikiException {
        XWikiDocumentArchive documentArchive = originalDocument.getDocumentArchive();
        if (documentArchive != null) {
            this.setDocumentArchive(documentArchive.clone(this.getId(), this.getXWikiContext()));
        }
    }

    private XWikiDocument cloneInternal(DocumentReference newDocumentReference, boolean keepsIdentity, boolean cloneArchive) {
        XWikiDocument doc = null;
        try {
            Constructor<?> constructor = this.getClass().getConstructor(DocumentReference.class);
            doc = (XWikiDocument)constructor.newInstance(newDocumentReference);
            if (keepsIdentity && this.getDocumentReference().equals((Object)doc.getDocumentReference())) {
                doc.setChangeTracked(this.isChangeTracked());
            }
            doc.setLocale(this.getLocale());
            doc.version = this.version;
            doc.id = this.id;
            if (cloneArchive) {
                doc.cloneDocumentArchive(this);
            } else {
                doc.setDocumentArchive((XWikiDocumentArchive)null);
            }
            doc.getAuthors().copyAuthors(this.getAuthors());
            doc.setCreationDate(this.getCreationDate());
            doc.setDate(this.getDate());
            doc.setCustomClass(this.getCustomClass());
            doc.setContentUpdateDate(this.getContentUpdateDate());
            doc.setTitle(this.getTitle());
            doc.setFormat(this.getFormat());
            doc.setFromCache(this.isFromCache());
            doc.setElements(this.getElements());
            doc.setMeta(this.getMeta());
            doc.setMostRecent(this.isMostRecent());
            doc.setNew(this.isNew());
            doc.setStore(this.getStore());
            doc.setTemplateDocumentReference(this.getTemplateDocumentReference());
            doc.setParentReference(this.getRelativeParentReference());
            doc.setDefaultLocale(this.getDefaultLocale());
            doc.setDefaultTemplate(this.getDefaultTemplate());
            doc.setValidationScript(this.getValidationScript());
            doc.setComment(this.getComment());
            doc.setMinorEdit(this.isMinorEdit());
            doc.setHidden(this.isHidden());
            doc.setRestricted(this.isRestricted());
            doc.setEnforceRequiredRights(this.isEnforceRequiredRights());
            if (this.xClass != null) {
                doc.setXClass(this.xClass.clone(true));
            }
            if (keepsIdentity) {
                doc.setXClassXML(this.getXClassXML());
                doc.cloneAttachments(this);
            } else {
                doc.getXClass().setCustomMapping(null);
                doc.copyAttachments(this);
            }
            doc.cloneXObjects(this, keepsIdentity);
            doc.content = this.content;
            doc.setContentDirty(this.isContentDirty());
            doc.setMetaDataDirty(this.isMetaDataDirty());
            doc.elements = this.elements;
            doc.originalDocument = this.originalDocument;
        }
        catch (Exception e) {
            LOGGER.error("Exception while cloning document", (Throwable)e);
        }
        return doc;
    }

    private void cloneAttachments(XWikiDocument sourceDocument) {
        this.getAttachmentList().clear();
        for (XWikiAttachment attach : sourceDocument.getAttachmentList()) {
            XWikiAttachment newAttach = attach.clone();
            this.setAttachment(newAttach);
        }
    }

    public void copyAttachments(XWikiDocument sourceDocument) {
        this.copyAttachments(sourceDocument, true);
    }

    private void copyAttachments(XWikiDocument sourceDocument, boolean overwrite) {
        this.copyAttachments(sourceDocument, overwrite, false);
    }

    private void copyAttachments(XWikiDocument sourceDocument, boolean overwrite, boolean reset) {
        if (overwrite) {
            this.getAttachmentList().clear();
        }
        for (XWikiAttachment attachment : sourceDocument.getAttachmentList()) {
            if (!overwrite && this.getAttachment(attachment.getFilename()) != null) continue;
            try {
                this.copyAttachment(attachment, reset);
            }
            catch (XWikiException e) {
                LOGGER.warn("Cannot copy attachment [{}] from [{}] to [{}]. Root cause is [{}].", new Object[]{attachment.getFilename(), sourceDocument.getDocumentReference(), this.getDocumentReference(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }

    private void copyAttachment(XWikiAttachment attachment, boolean reset) throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiAttachment newAttachment = attachment.clone();
        newAttachment.setDoc(attachment.getDoc(), false);
        newAttachment.loadAttachmentContent(xcontext);
        newAttachment.getAttachment_content().setContentDirty(true);
        if (reset) {
            newAttachment.setRCSVersion(null);
            newAttachment.setAuthorReference(xcontext.getUserReference());
            newAttachment.setDate(new Date());
        }
        this.setAttachment(newAttachment);
    }

    public void loadAttachmentsContent(XWikiContext context) throws XWikiException {
        for (XWikiAttachment attachment : this.getAttachmentList()) {
            attachment.loadAttachmentContent(context);
        }
    }

    public void loadAttachmentsContentSafe(XWikiContext context) {
        for (XWikiAttachment attachment : this.getAttachmentList()) {
            try {
                attachment.loadAttachmentContent(context);
            }
            catch (XWikiException e) {
                LOGGER.warn("Failed to load attachment [{}]: {}", (Object)attachment.getReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public void loadAttachments(XWikiContext context) throws XWikiException {
        for (XWikiAttachment attachment : this.getAttachmentList()) {
            attachment.loadAttachmentContent(context);
            attachment.loadArchive(context);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        XWikiDocument doc = (XWikiDocument)object;
        if (!this.getDocumentReference().equals((Object)doc.getDocumentReference())) {
            return false;
        }
        if (!this.getDefaultLocale().equals(doc.getDefaultLocale())) {
            return false;
        }
        if (!this.getLocale().equals(doc.getLocale())) {
            return false;
        }
        if (this.getTranslation() != doc.getTranslation()) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getAuthorReference(), (Object)doc.getAuthorReference())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getContentAuthorReference(), (Object)doc.getContentAuthorReference())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getCreatorReference(), (Object)doc.getCreatorReference())) {
            return false;
        }
        if (!this.getVersion().equals(doc.getVersion())) {
            return false;
        }
        if (this.getDate().getTime() != doc.getDate().getTime()) {
            return false;
        }
        if (this.getContentUpdateDate().getTime() != doc.getContentUpdateDate().getTime()) {
            return false;
        }
        if (this.getCreationDate().getTime() != doc.getCreationDate().getTime()) {
            return false;
        }
        if (!this.getComment().equals(doc.getComment())) {
            return false;
        }
        if (this.isMinorEdit() != doc.isMinorEdit()) {
            return false;
        }
        return this.equalsData(doc);
    }

    public boolean equalsData(XWikiDocument otherDocument) {
        Set<DocumentReference> otherObjectClassReferences;
        if (this == otherDocument) {
            return true;
        }
        if (ObjectUtils.notEqual((Object)this.getParentReference(), (Object)otherDocument.getParentReference())) {
            return false;
        }
        if (!this.getFormat().equals(otherDocument.getFormat())) {
            return false;
        }
        if (!this.getTitle().equals(otherDocument.getTitle())) {
            return false;
        }
        if (!this.getContent().equals(otherDocument.getContent())) {
            return false;
        }
        if (!this.getDefaultTemplate().equals(otherDocument.getDefaultTemplate())) {
            return false;
        }
        if (!this.getValidationScript().equals(otherDocument.getValidationScript())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getSyntax(), (Object)otherDocument.getSyntax())) {
            return false;
        }
        if (this.isHidden() != otherDocument.isHidden()) {
            return false;
        }
        if (this.isEnforceRequiredRights() != otherDocument.isEnforceRequiredRights()) {
            return false;
        }
        if (!this.getXClass().equals(otherDocument.getXClass())) {
            return false;
        }
        Set<DocumentReference> myObjectClassReferences = this.getXObjects().keySet();
        if (!myObjectClassReferences.equals(otherObjectClassReferences = otherDocument.getXObjects().keySet())) {
            return false;
        }
        for (DocumentReference reference : myObjectClassReferences) {
            List<BaseObject> myObjects = this.getXObjects(reference);
            List<BaseObject> otherObjects = otherDocument.getXObjects(reference);
            if (myObjects.size() != otherObjects.size()) {
                return false;
            }
            for (int i = 0; i < myObjects.size(); ++i) {
                if (myObjects.get(i) == null && otherObjects.get(i) != null || myObjects.get(i) != null && otherObjects.get(i) == null) {
                    return false;
                }
                if (myObjects.get(i) == null && otherObjects.get(i) == null || myObjects.get(i).equals(otherObjects.get(i))) continue;
                return false;
            }
        }
        List<XWikiAttachment> attachments = this.getAttachmentList();
        List<XWikiAttachment> otherAttachments = otherDocument.getAttachmentList();
        if (attachments.size() != otherAttachments.size()) {
            return false;
        }
        for (XWikiAttachment attachment : attachments) {
            XWikiAttachment otherAttachment = otherDocument.getAttachment(attachment.getFilename());
            try {
                if (otherAttachment != null && attachment.equalsData(otherAttachment, null)) continue;
                return false;
            }
            catch (XWikiException e) {
                throw new RuntimeException(String.format("Failed to compare attachments with reference [%s]", attachment.getReference()), e);
            }
        }
        return true;
    }

    public String getXMLContent(XWikiContext context) throws XWikiException {
        XWikiDocument tdoc = this.getTranslatedDocument(context);
        return tdoc.toXML(true, true, false, false, context);
    }

    public String toXML(XWikiContext context) throws XWikiException {
        return this.toXML(true, false, false, false, context);
    }

    public String toFullXML(XWikiContext context) throws XWikiException {
        return this.toXML(true, false, true, true, context);
    }

    @Deprecated(since="4.1M2")
    public void addToZip(ZipOutputStream zos, String zipname, boolean withVersions, XWikiContext context) throws XWikiException, IOException {
        ZipEntry zipentry = new ZipEntry(zipname);
        zos.putNextEntry(zipentry);
        this.toXML(zos, true, false, true, withVersions, context);
        zos.closeEntry();
    }

    @Deprecated(since="4.2M2")
    public void addToZip(ZipOutputStream zos, boolean withVersions, XWikiContext context) throws XWikiException, IOException {
        String zipname = this.getDocumentReference().getLastSpaceReference().getName() + "/" + this.getDocumentReference().getName();
        String language = this.getLanguage();
        if (!StringUtils.isEmpty((CharSequence)language)) {
            zipname = zipname + SPACE_NAME_SEP + language;
        }
        this.addToZip(zos, zipname, withVersions, context);
    }

    @Deprecated(since="4.1M2")
    public void addToZip(ZipOutputStream zos, XWikiContext context) throws XWikiException, IOException {
        this.addToZip(zos, true, context);
    }

    public String toXML(boolean bWithObjects, boolean bWithRendering, boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException {
        StringWriter writer = new StringWriter();
        this.toXML((OutputTarget)new DefaultWriterOutputTarget((Writer)writer), bWithObjects, bWithRendering, bWithAttachmentContent, bWithVersions, true, context != null ? context.getWiki().getEncoding() : StandardCharsets.UTF_8.name());
        return writer.toString();
    }

    @Deprecated(since="9.0RC1")
    public Document toXMLDocument(XWikiContext context) throws XWikiException {
        return this.toXMLDocument(true, false, false, false, context);
    }

    @Deprecated(since="9.0RC1")
    public Document toXMLDocument(boolean bWithObjects, boolean bWithRendering, boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException {
        DOMDocument doc = new DOMDocument();
        DOMXMLWriter wr = new DOMXMLWriter((Document)doc, new OutputFormat("", true, context.getWiki().getEncoding()));
        try {
            this.toXML(wr, bWithObjects, bWithRendering, bWithAttachmentContent, bWithVersions, context);
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(since="9.0RC1")
    public void toXML(com.xpn.xwiki.internal.xml.XMLWriter wr, boolean bWithObjects, boolean bWithRendering, boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException, IOException {
        DocumentResult domResult = new DocumentResult();
        this.toXML((OutputTarget)new DefaultResultOutputTarget((Result)domResult), bWithObjects, bWithRendering, bWithAttachmentContent, bWithVersions, true, context != null ? context.getWiki().getEncoding() : StandardCharsets.UTF_8.name());
        wr.write(domResult.getDocument().getRootElement());
    }

    public void toXML(OutputStream out, boolean bWithObjects, boolean bWithRendering, boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException, IOException {
        this.toXML((OutputTarget)new DefaultOutputStreamOutputTarget(out), bWithObjects, bWithRendering, bWithAttachmentContent, bWithVersions, true, context != null ? context.getWiki().getEncoding() : StandardCharsets.UTF_8.name());
    }

    public void toXML(OutputTarget out, boolean bWithObjects, boolean bWithRendering, boolean bWithAttachmentContent, boolean bWithVersions, boolean format, String encoding) throws XWikiException {
        DocumentInstanceInputProperties documentProperties = new DocumentInstanceInputProperties();
        documentProperties.setWithWikiObjects(bWithObjects);
        documentProperties.setWithWikiDocumentContentHTML(bWithRendering);
        documentProperties.setWithWikiAttachmentsContent(bWithAttachmentContent);
        documentProperties.setWithJRCSRevisions(bWithVersions);
        documentProperties.setWithRevisions(false);
        XAROutputProperties xarProperties = new XAROutputProperties();
        xarProperties.setPreserveVersion(bWithVersions);
        xarProperties.setEncoding(encoding);
        xarProperties.setFormat(format);
        xarProperties.setTarget(out);
        this.toXML(documentProperties, xarProperties);
    }

    public void toXML(DocumentInstanceInputProperties documentProperties, XAROutputProperties xarProperties) throws XWikiException {
        try {
            Utils.getComponent(XWikiDocumentFilterUtils.class).exportEntity(this, xarProperties.getTarget(), xarProperties, documentProperties);
        }
        catch (Exception e) {
            throw new XWikiException(2, 2001, "Error serializing XML", e, null);
        }
    }

    protected String encodedXMLStringAsUTF8(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        int length = xmlString.length();
        StringBuilder result = new StringBuilder();
        block9: for (int i = 0; i < length; ++i) {
            char character = xmlString.charAt(i);
            switch (character) {
                case '&': {
                    result.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block9;
                }
                case '<': {
                    result.append("&lt;");
                    continue block9;
                }
                case '>': {
                    result.append("&gt;");
                    continue block9;
                }
                case '\n': {
                    result.append("\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\t");
                    continue block9;
                }
                default: {
                    if (character < ' ') continue block9;
                    if (character > '\u007f') {
                        result.append("&#x");
                        result.append(Integer.toHexString(character).toUpperCase());
                        result.append(";");
                        continue block9;
                    }
                    result.append(character);
                }
            }
        }
        return result.toString();
    }

    protected String getElement(Element docel, String name) {
        Element el = docel.element(name);
        if (el == null) {
            return "";
        }
        return el.getText();
    }

    public void fromXML(String xml) throws XWikiException {
        this.fromXML(xml, false);
    }

    public void fromXML(InputStream is) throws XWikiException {
        this.fromXML(is, false);
    }

    public void fromXML(InputSource source, boolean withArchive) throws XWikiException {
        DocumentInstanceOutputProperties documentProperties = new DocumentInstanceOutputProperties();
        XWikiContext xcontext = this.getXWikiContext();
        if (xcontext != null) {
            documentProperties.setDefaultReference((EntityReference)this.getXWikiContext().getWikiReference());
        }
        XARInputProperties xarProperties = new XARInputProperties();
        xarProperties.setWithHistory(withArchive);
        try {
            Utils.getComponent(XWikiDocumentFilterUtils.class).importEntity(XWikiDocument.class, this, source, xarProperties, documentProperties);
        }
        catch (Exception e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
        this.setMetaDataDirty(false);
        this.setContentDirty(false);
    }

    public void fromXML(String source, boolean withArchive) throws XWikiException {
        this.fromXML((InputSource)new StringInputSource(source), withArchive);
    }

    public void fromXML(InputStream source, boolean withArchive) throws XWikiException {
        this.fromXML((InputSource)new DefaultInputStreamInputSource(source), withArchive);
    }

    @Deprecated(since="9.0RC1")
    public void fromXML(Document domdoc, boolean withArchive) throws XWikiException {
        StringWriter writer = new StringWriter();
        try {
            XMLWriter domWriter = new XMLWriter((Writer)writer);
            domWriter.write(domdoc);
            domWriter.flush();
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
        this.fromXML(writer.toString(), withArchive);
    }

    public static boolean containsXMLWikiDocument(Document domdoc) {
        return domdoc.getRootElement().getName().equals("xwikidoc");
    }

    public void setAttachmentList(List<XWikiAttachment> list) {
        if (this.attachmentList != list) {
            this.attachmentList.clear();
            this.attachmentList.addAll(list);
        }
    }

    public List<XWikiAttachment> getAttachmentList() {
        return this.attachmentList;
    }

    @Deprecated
    public void saveAllAttachments(XWikiContext context) throws XWikiException {
        this.saveAllAttachments(true, true, context);
    }

    @Deprecated
    public void saveAllAttachments(boolean updateParent, boolean transaction, XWikiContext context) throws XWikiException {
        Iterator iterator = this.attachmentList.iterator();
        while (iterator.hasNext()) {
            XWikiAttachment attachment = (XWikiAttachment)iterator.next();
            this.saveAttachmentContent(attachment, false, transaction, context);
        }
        if (updateParent) {
            context.getWiki().saveDocument(this, context);
        }
    }

    @Deprecated
    public void saveAttachmentsContent(List<XWikiAttachment> attachments, XWikiContext context) throws XWikiException {
        for (XWikiAttachment attachment : attachments) {
            this.saveAttachmentContent(attachment, context);
        }
    }

    @Deprecated
    public void saveAttachmentContent(XWikiAttachment attachment, XWikiContext context) throws XWikiException {
        this.saveAttachmentContent(attachment, true, true, context);
    }

    @Deprecated
    public void saveAttachmentContent(XWikiAttachment attachment, boolean updateParent, boolean transaction, XWikiContext context) throws XWikiException {
        String currentWiki = context.getWikiId();
        try {
            if (this.getDatabase() != null) {
                context.setWikiId(this.getDatabase());
            }
            XWikiAttachmentStoreInterface store = this.resolveXWikiAttachmentStoreInterface(attachment.getContentStore(), context);
            store.saveAttachmentContent(attachment, false, context, transaction);
            this.setMetaDataDirty(true);
            if (updateParent) {
                context.getWiki().saveDocument(this, context);
            }
        }
        catch (OutOfMemoryError e) {
            throw new XWikiException(11, 11014, "Out Of Memory Exception");
        }
        finally {
            if (currentWiki != null) {
                context.setWikiId(currentWiki);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="9.9RC1")
    public void loadAttachmentContent(XWikiAttachment attachment, XWikiContext context) throws XWikiException {
        String database = context.getWikiId();
        try {
            if (this.getDatabase() != null) {
                context.setWikiId(this.getDatabase());
            }
            attachment.loadAttachmentContent(context);
        }
        finally {
            if (database != null) {
                context.setWikiId(database);
            }
        }
    }

    public XWikiAttachment removeAttachment(XWikiAttachment attachment) {
        return this.removeAttachment(attachment, true);
    }

    public XWikiAttachment removeAttachment(XWikiAttachment attachmentToRemove, boolean toRecycleBin) {
        if (this.attachmentList.remove(attachmentToRemove)) {
            this.attachmentsToRemove.add(new XWikiAttachmentToRemove(attachmentToRemove, toRecycleBin));
            this.setMetaDataDirty(true);
        } else {
            attachmentToRemove = null;
        }
        return attachmentToRemove;
    }

    public List<XWikiAttachmentToRemove> getAttachmentsToRemove() {
        return this.attachmentsToRemove;
    }

    public void clearAttachmentsToRemove() {
        this.attachmentsToRemove.clear();
    }

    public List<DocumentReference> getBackLinkedReferences(XWikiContext context) throws XWikiException {
        Set references;
        try {
            references = this.getLinkStore().resolveBackLinkedEntities((EntityReference)this.getDocumentReference());
        }
        catch (LinkException e) {
            throw new XWikiException("Failed to load backlinks for reference [" + String.valueOf(this.getDocumentReference()) + "]", e);
        }
        HashSet<DocumentReference> documentReferences = new HashSet<DocumentReference>(references.size());
        for (EntityReference entityReference : references) {
            DocumentReference linkReference = context.getWiki().getDocumentReference(entityReference, context);
            if (linkReference.getLocale() != null) {
                linkReference = new DocumentReference((EntityReference)linkReference, (Locale)null);
            }
            documentReferences.add(linkReference);
        }
        return new ArrayList<DocumentReference>(documentReferences);
    }

    @Deprecated(since="2.2M2")
    public List<String> getBackLinkedPages(XWikiContext context) throws XWikiException {
        List<DocumentReference> references = this.getBackLinkedReferences(context);
        EntityReferenceSerializer<String> serializer = XWikiDocument.getCompactWikiEntityReferenceSerializer();
        ArrayList<String> documentNames = new ArrayList<String>(references.size());
        for (DocumentReference reference : references) {
            documentNames.add((String)serializer.serialize((EntityReference)reference, new Object[0]));
        }
        return documentNames;
    }

    public Set<XWikiLink> getUniqueWikiLinkedPages(XWikiContext context) throws XWikiException {
        LinkedHashSet<XWikiLink> links;
        if (this.is10Syntax()) {
            links = new LinkedHashSet<XWikiLink>(this.getStore(context).loadLinks(this.getId(), context, true));
        } else {
            Set<String> linkedPages = this.getUniqueLinkedPages(context);
            links = new LinkedHashSet(linkedPages.size());
            for (String linkedPage : linkedPages) {
                XWikiLink wikiLink = new XWikiLink();
                wikiLink.setDocId(this.getId());
                wikiLink.setFullName(LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.getDocumentReference(), new Object[0]));
                wikiLink.setLink(linkedPage);
                links.add(wikiLink);
            }
        }
        return links;
    }

    /*
     * WARNING - void declaration
     */
    private Set<DocumentReference> getUniqueLinkedPages10(XWikiContext context) {
        try {
            List<String> list = context.getUtil().getUniqueMatches(this.getContent(), "\\[(.*?)\\]", 1);
            HashSet<DocumentReference> pageNames = new HashSet<DocumentReference>(list.size());
            DocumentReference currentDocumentReference = this.getDocumentReference();
            for (String string : list) {
                DocumentReference documentReference;
                void var6_7;
                void var6_16;
                void var6_14;
                void var6_12;
                void var6_10;
                int i1 = string.indexOf(62);
                if (i1 != -1) {
                    String string2 = string.substring(i1 + 1);
                }
                if ((i1 = var6_10.indexOf("&gt;")) != -1) {
                    String string3 = var6_10.substring(i1 + 4);
                }
                if ((i1 = var6_12.indexOf(35)) != -1) {
                    String string4 = var6_12.substring(0, i1);
                }
                if ((i1 = var6_14.indexOf(63)) != -1) {
                    String string5 = var6_14.substring(0, i1);
                }
                if (var6_16.trim().equals("") || var6_16.indexOf(36) != -1 || var6_16.indexOf("://") != -1 || var6_16.indexOf(34) != -1 || var6_16.indexOf(39) != -1 || var6_16.indexOf("..") != -1 || var6_16.indexOf(58) != -1 || var6_16.indexOf(61) != -1) continue;
                Object newname = StringUtils.replace((String)Util.noaccents((String)var6_16), (String)" ", (String)"");
                if (((String)newname).indexOf(46) == -1) {
                    newname = this.getSpace() + SPACE_NAME_SEP + (String)var6_16;
                }
                if (context.getWiki().exists((String)newname, context)) {
                    Object object = newname;
                } else if (var6_16.indexOf(46) == -1) {
                    String string6 = this.getSpace() + SPACE_NAME_SEP + (String)var6_16;
                }
                if (StringUtils.isEmpty((CharSequence)var6_7) || (documentReference = XWikiDocument.getCurrentDocumentReferenceResolver().resolve((Object)var6_7, new Object[0])).equals((Object)currentDocumentReference)) continue;
                pageNames.add(documentReference);
            }
            return pageNames;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get linked documents", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<EntityReference> getUniqueLinkedEntityReferences(XWikiContext context, Map<EntityType, Set<ResourceType>> entityTypes) {
        Set<DocumentReference> references;
        XWikiDocument contextDoc = context.getDoc();
        WikiReference contextWikiReference = context.getWikiReference();
        try {
            context.setDoc(this);
            context.setWikiReference(this.getDocumentReference().getWikiReference());
            if (this.is10Syntax()) {
                references = this.getUniqueLinkedPages10(context);
            } else {
                references = new LinkedHashSet<DocumentReference>();
                XDOM dom = this.getXDOM();
                this.getUniqueLinkedEntityReferences(dom, entityTypes, references);
                for (List<BaseObject> xobjects : this.getXObjects().values()) {
                    xobjects.stream().forEach(xobject -> this.getUniqueLinkedEntityReferences((BaseObject)xobject, entityTypes, (Set<EntityReference>)references, context));
                }
            }
        }
        finally {
            context.setDoc(contextDoc);
            context.setWikiReference(contextWikiReference);
        }
        return references;
    }

    private void getUniqueLinkedEntityReferences(BaseObject xobject, Map<EntityType, Set<ResourceType>> entityTypes, Set<EntityReference> references, XWikiContext xcontext) {
        if (xobject == null) {
            return;
        }
        BaseClass xclass = xobject.getXClass(xcontext);
        for (Object fieldClass : xclass.getProperties()) {
            TextAreaClass textAreaClass;
            PropertyInterface field;
            if (!(fieldClass instanceof TextAreaClass) || !((TextAreaClass)fieldClass).isWikiContent() || !((field = xobject.getField((textAreaClass = (TextAreaClass)fieldClass).getName())) instanceof LargeStringProperty)) continue;
            LargeStringProperty largeField = (LargeStringProperty)field;
            try {
                XDOM dom = XWikiDocument.parseContent(this.getSyntax(), largeField.getValue(), this.getDocumentReference());
                this.getUniqueLinkedEntityReferences(dom, entityTypes, references);
            }
            catch (XWikiException e) {
                LOGGER.warn("Failed to extract links from xobject property [{}], skipping it. Error: {}", largeField.getReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private void getUniqueLinkedEntityReferences(XDOM dom, Map<EntityType, Set<ResourceType>> entityTypes, Set<EntityReference> references) {
        Set uniqueLinkedEntityReferences = XWikiDocument.getLinkParser().getUniqueLinkedEntityReferences(dom, entityTypes, this.getDocumentReference());
        references.addAll(uniqueLinkedEntityReferences);
    }

    private Set<DocumentReference> toDocumentReferenceSet(Collection<? extends EntityReference> entityReferences, DocumentReference baseReference) {
        LinkedHashSet<DocumentReference> documentReferences = new LinkedHashSet<DocumentReference>(entityReferences.size());
        for (EntityReference entityReference : entityReferences) {
            documentReferences.add(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)entityReference, new Object[]{EntityType.DOCUMENT, baseReference}));
        }
        return documentReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUniqueLinkedPages(XWikiContext context) {
        Set<EntityReference> references = this.getUniqueLinkedEntityReferences(context, Map.of(EntityType.DOCUMENT, Set.of(ResourceType.SPACE, ResourceType.DOCUMENT, ResourceType.ATTACHMENT), EntityType.PAGE, Set.of(ResourceType.PAGE, ResourceType.PAGE_ATTACHMENT)));
        LinkedHashSet<String> documentNames = new LinkedHashSet<String>(references.size());
        XWikiDocument contextDoc = context.getDoc();
        String contextWiki = context.getWikiId();
        try {
            context.setDoc(this);
            context.setWikiId(this.getDocumentReference().getWikiReference().getName());
            EntityReferenceSerializer<String> serializer = this.is10Syntax() ? XWikiDocument.getCompactEntityReferenceSerializer() : XWikiDocument.getCompactWikiEntityReferenceSerializer();
            for (EntityReference reference : references) {
                DocumentReference linkDocumentReference = context.getWiki().getDocumentReference(reference, context);
                documentNames.add((String)serializer.serialize((EntityReference)linkDocumentReference, new Object[0]));
            }
        }
        finally {
            context.setDoc(contextDoc);
            context.setWikiId(contextWiki);
        }
        return documentNames;
    }

    public Set<EntityReference> getUniqueLinkedEntities(XWikiContext context) {
        return this.getUniqueLinkedEntityReferences(context, Map.of(EntityType.DOCUMENT, Set.of(ResourceType.SPACE, ResourceType.DOCUMENT), EntityType.PAGE, Set.of(ResourceType.PAGE), EntityType.ATTACHMENT, Set.of(ResourceType.ATTACHMENT), EntityType.PAGE_ATTACHMENT, Set.of(ResourceType.PAGE_ATTACHMENT)));
    }

    public List<DocumentReference> getChildrenReferences(XWikiContext context) throws XWikiException {
        return this.getChildrenReferences(0, 0, context);
    }

    @Deprecated(since="2.2M2")
    public List<String> getChildren(XWikiContext context) throws XWikiException {
        return this.getChildren(0, 0, context);
    }

    public List<DocumentReference> getChildrenReferences(int nb, int start, XWikiContext context) throws XWikiException {
        ArrayList<DocumentReference> children = new ArrayList<DocumentReference>();
        try {
            WikiReference wikiReference = this.getDocumentReference().getWikiReference();
            Query query = this.getStore().getQueryManager().createQuery("select distinct doc.fullName from XWikiDocument doc where doc.parent=:prefixedFullName or doc.parent=:fullName or (doc.parent=:name and doc.space=:space)", "xwql");
            query.addFilter(Utils.getComponent(QueryFilter.class, "hidden"));
            query.bindValue("prefixedFullName", this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new Object[0]));
            query.bindValue("fullName", (Object)LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.getDocumentReference(), new Object[0]));
            query.bindValue("name", (Object)this.getDocumentReference().getName());
            query.bindValue("space", (Object)LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.getDocumentReference().getLastSpaceReference(), new Object[0]));
            query.setLimit(nb).setOffset(start).setWiki(wikiReference.getName());
            List queryResults = query.execute();
            for (String fullName : queryResults) {
                children.add(XWikiDocument.getCurrentDocumentReferenceResolver().resolve((Object)fullName, new Object[]{wikiReference}));
            }
        }
        catch (QueryException e) {
            throw new XWikiException(3, 0, String.format("Failed to retrieve children for document [%s]", this.getDocumentReference()), e);
        }
        return children;
    }

    @Deprecated(since="2.2M2")
    public List<String> getChildren(int nb, int start, XWikiContext context) throws XWikiException {
        ArrayList<String> childrenNames = new ArrayList<String>();
        for (DocumentReference reference : this.getChildrenReferences(nb, start, context)) {
            childrenNames.add(LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)reference, new Object[0]));
        }
        return childrenNames;
    }

    public void renameProperties(DocumentReference classReference, Map<String, String> fieldsToRename) {
        List objects = this.xObjects.get(classReference);
        if (objects == null) {
            return;
        }
        boolean isDirty = false;
        for (BaseObject bobject : objects) {
            if (bobject == null) continue;
            for (Map.Entry<String, String> entry : fieldsToRename.entrySet()) {
                String origname = entry.getKey();
                String newname = entry.getValue();
                BaseProperty origprop = (BaseProperty)bobject.safeget(origname);
                if (origprop == null) continue;
                BaseElement prop = origprop.clone();
                bobject.removeField(origname);
                prop.setName(newname);
                bobject.addField(newname, (PropertyInterface)((Object)prop));
                isDirty = true;
            }
        }
        if (isDirty) {
            this.setMetaDataDirty(true);
        }
    }

    @Deprecated(since="2.2M2")
    public void renameProperties(String className, Map<String, String> fieldsToRename) {
        this.renameProperties(this.resolveClassReference(className), fieldsToRename);
    }

    public void addXObjectToRemove(BaseObject object) {
        this.getXObjectsToRemove().add(object);
        object.setOwnerDocument(null);
        this.setMetaDataDirty(true);
    }

    public void addXObjectsToRemoveFromVersion(XWikiDocument previousVersion) {
        if (previousVersion == null) {
            return;
        }
        for (List<BaseObject> objects : previousVersion.getXObjects().values()) {
            for (BaseObject originalObj : objects) {
                BaseObject newObj;
                if (originalObj == null || (newObj = this.getXObject(originalObj.getXClassReference(), originalObj.getNumber())) != null) continue;
                this.addXObjectToRemove(originalObj);
            }
        }
    }

    @Deprecated(since="2.2M2")
    public void addObjectsToRemove(BaseObject object) {
        this.addXObjectToRemove(object);
    }

    public List<BaseObject> getXObjectsToRemove() {
        return this.xObjectsToRemove;
    }

    @Deprecated(since="2.2M2")
    public ArrayList<BaseObject> getObjectsToRemove() {
        return (ArrayList)this.getXObjectsToRemove();
    }

    public void setXObjectsToRemove(List<BaseObject> objectsToRemove) {
        this.xObjectsToRemove = objectsToRemove;
        this.setMetaDataDirty(true);
    }

    public List<String> getIncludedPages(XWikiContext context) {
        try {
            return this.getIncludedPagesInternal(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get included pages for [{}]", (Object)this.getDocumentReference(), (Object)e);
            return Collections.emptyList();
        }
    }

    private List<String> getIncludedPagesInternal(XWikiContext context) {
        if (this.is10Syntax()) {
            return this.getIncludedPagesForXWiki10Syntax(this.getContent(), context);
        }
        XDOM dom = this.getXDOM();
        ArrayList<String> result = new ArrayList<String>();
        List macroBlocks = dom.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        for (MacroBlock macroBlock : macroBlocks) {
            if (macroBlock.getId().equalsIgnoreCase("include") || macroBlock.getId().equalsIgnoreCase("display")) {
                String documentName = (String)macroBlock.getParameters().get("reference");
                if (StringUtils.isEmpty((CharSequence)documentName) && StringUtils.isEmpty((CharSequence)(documentName = (String)macroBlock.getParameters().get("document")))) continue;
                DocumentReference documentReference = this.getExplicitDocumentReferenceResolver().resolve((Object)documentName, new Object[]{this.getDocumentReference()});
                if (this.getDocumentReference().equals((Object)documentReference)) continue;
                documentName = LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)documentReference, new Object[0]);
                result.add(documentName);
                continue;
            }
            if (!macroBlock.getId().equalsIgnoreCase("velocity") || StringUtils.isEmpty((CharSequence)macroBlock.getContent())) continue;
            result.addAll(this.getIncludedPagesForXWiki10Syntax(macroBlock.getContent(), context));
        }
        return result;
    }

    private List<String> getIncludedPagesForXWiki10Syntax(String content, XWikiContext context) {
        try {
            String pattern = "#include(Topic|InContext|Form|Macros|parseGroovyFromPage)\\([\"'](.*?)[\"']\\)";
            List<String> list = context.getUtil().getUniqueMatches(content, pattern, 2);
            for (int i = 0; i < list.size(); ++i) {
                String name = list.get(i);
                if (name.indexOf(46) != -1) continue;
                list.set(i, this.getSpace() + SPACE_NAME_SEP + name);
            }
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract include target from provided content [" + content + "]", (Throwable)e);
            return null;
        }
    }

    public List<String> getIncludedMacros(XWikiContext context) {
        return context.getWiki().getIncludedMacros(this.getSpace(), this.getContent(), context);
    }

    public String displayRendered(PropertyClass pclass, String prefix, BaseCollection object, XWikiContext context) throws XWikiException {
        String result = pclass.displayView(pclass.getName(), prefix, object, context);
        return this.getRenderedContent(result, Syntax.XWIKI_1_0.toIdString(), context);
    }

    public String displayView(PropertyClass pclass, String prefix, BaseCollection object, XWikiContext context) {
        return pclass == null ? "" : pclass.displayView(pclass.getName(), prefix, object, context);
    }

    public String displayEdit(PropertyClass pclass, String prefix, BaseCollection object, XWikiContext context) {
        return pclass == null ? "" : pclass.displayEdit(pclass.getName(), prefix, object, context);
    }

    public String displayHidden(PropertyClass pclass, String prefix, BaseCollection object, XWikiContext context) {
        return pclass == null ? "" : pclass.displayHidden(pclass.getName(), prefix, object, context);
    }

    public XWikiAttachment getAttachment(String filename) {
        XWikiAttachment output = this.attachmentList.getByFilename(filename);
        if (output == null && filename != null) {
            for (XWikiAttachment attach : this.getAttachmentList()) {
                if (!attach.getFilename().startsWith(filename + SPACE_NAME_SEP)) continue;
                output = attach;
                break;
            }
        }
        return output;
    }

    public XWikiAttachment getExactAttachment(String filename) {
        return this.attachmentList.getByFilename(filename);
    }

    @Deprecated(since="9.10RC1")
    public void addAttachment(XWikiAttachment attachment) {
        this.setAttachment(attachment);
    }

    public XWikiAttachment setAttachment(XWikiAttachment attachment) {
        return this.attachmentList.set(attachment);
    }

    @Deprecated
    public XWikiAttachment addAttachment(String fileName, byte[] content, XWikiContext context) throws XWikiException {
        try {
            return this.setAttachment(fileName, new ByteArrayInputStream(content != null ? content : new byte[]{}), context);
        }
        catch (IOException e) {
            throw new XWikiException(2, 0, "Failed to set Attachment content", e);
        }
    }

    @Deprecated(since="9.10RC1")
    public XWikiAttachment addAttachment(String fileName, InputStream content, XWikiContext context) throws XWikiException, IOException {
        return this.setAttachment(fileName, content, context);
    }

    public XWikiAttachment setAttachment(String fileName, InputStream content, XWikiContext context) throws IOException {
        String filename;
        XWikiAttachment attachment;
        int i = fileName.indexOf(92);
        if (i == -1) {
            i = fileName.indexOf(47);
        }
        if ((attachment = this.getExactAttachment(filename = fileName.substring(i + 1))) == null) {
            attachment = new XWikiAttachment(this, filename);
            this.setAttachment(attachment);
        }
        attachment.setContent(content);
        attachment.setAuthorReference(context.getUserReference());
        return attachment;
    }

    public BaseObject getFirstObject(String fieldname) {
        return this.getFirstObject(fieldname, null);
    }

    public BaseObject getFirstObject(String fieldname, XWikiContext context) {
        Collection<List<BaseObject>> objectscoll = this.getXObjects().values();
        if (objectscoll == null) {
            return null;
        }
        for (List<BaseObject> objects : objectscoll) {
            for (BaseObject obj : objects) {
                Set<String> set;
                if (obj == null) continue;
                BaseClass bclass = obj.getXClass(context);
                if (bclass != null && (set = bclass.getPropertyList()) != null && set.contains(fieldname)) {
                    return obj;
                }
                set = obj.getPropertyList();
                if (set == null || !set.contains(fieldname)) continue;
                return obj;
            }
        }
        return null;
    }

    public void setProperty(EntityReference classReference, String fieldName, BaseProperty value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.safeput(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setProperty(String className, String fieldName, BaseProperty value) {
        this.setProperty(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    public int getIntValue(DocumentReference classReference, String fieldName) {
        return this.getIntValue(classReference, fieldName, 0);
    }

    public int getIntValue(DocumentReference classReference, String fieldName, int defaultValue) {
        BaseObject obj = this.getXObject(classReference, 0);
        if (obj == null) {
            return defaultValue;
        }
        return obj.getIntValue(fieldName, defaultValue);
    }

    @Deprecated(since="2.2M2")
    public int getIntValue(String className, String fieldName) {
        return this.getIntValue(this.resolveClassReference(className), fieldName);
    }

    public long getLongValue(DocumentReference classReference, String fieldName) {
        BaseObject obj = this.getXObject(classReference, 0);
        if (obj == null) {
            return 0L;
        }
        return obj.getLongValue(fieldName);
    }

    @Deprecated(since="2.2M2")
    public long getLongValue(String className, String fieldName) {
        return this.getLongValue(this.resolveClassReference(className), fieldName);
    }

    public String getStringValue(EntityReference classReference, String fieldName) {
        return this.getStringValue(this.resolveClassReference(classReference), fieldName);
    }

    public String getStringValue(DocumentReference classReference, String fieldName) {
        BaseObject obj = this.getXObject(classReference);
        if (obj == null) {
            return "";
        }
        String result = obj.getStringValue(fieldName);
        if (result.equals(" ")) {
            return "";
        }
        return result;
    }

    @Deprecated(since="2.2M2")
    public String getStringValue(String className, String fieldName) {
        return this.getStringValue(this.resolveClassReference(className), fieldName);
    }

    public int getIntValue(String fieldName) {
        BaseObject object = this.getFirstObject(fieldName, null);
        if (object == null) {
            return 0;
        }
        return object.getIntValue(fieldName);
    }

    public long getLongValue(String fieldName) {
        BaseObject object = this.getFirstObject(fieldName, null);
        if (object == null) {
            return 0L;
        }
        return object.getLongValue(fieldName);
    }

    public String getStringValue(String fieldName) {
        BaseObject object = this.getFirstObject(fieldName, null);
        if (object == null) {
            return "";
        }
        String result = object.getStringValue(fieldName);
        if (result.equals(" ")) {
            return "";
        }
        return result;
    }

    public void setStringValue(EntityReference classReference, String fieldName, String value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.setStringValue(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setStringValue(String className, String fieldName, String value) {
        this.setStringValue(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    public List getListValue(DocumentReference classReference, String fieldName) {
        BaseObject obj = this.getXObject(classReference);
        if (obj == null) {
            return new ArrayList();
        }
        return obj.getListValue(fieldName);
    }

    @Deprecated(since="2.2M2")
    public List getListValue(String className, String fieldName) {
        return this.getListValue(this.resolveClassReference(className), fieldName);
    }

    public List getListValue(String fieldName) {
        BaseObject object = this.getFirstObject(fieldName, null);
        if (object == null) {
            return new ArrayList();
        }
        return object.getListValue(fieldName);
    }

    public void setStringListValue(EntityReference classReference, String fieldName, List value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.setStringListValue(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setStringListValue(String className, String fieldName, List value) {
        this.setStringListValue(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    public void setDBStringListValue(EntityReference classReference, String fieldName, List value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.setDBStringListValue(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setDBStringListValue(String className, String fieldName, List value) {
        this.setDBStringListValue(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    public void setLargeStringValue(EntityReference classReference, String fieldName, String value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.setLargeStringValue(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setLargeStringValue(String className, String fieldName, String value) {
        this.setLargeStringValue(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    public void setIntValue(EntityReference classReference, String fieldName, int value) {
        BaseObject bobject = this.prepareXObject(classReference);
        bobject.setIntValue(fieldName, value);
    }

    @Deprecated(since="2.2M2")
    public void setIntValue(String className, String fieldName, int value) {
        this.setIntValue(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), fieldName, value);
    }

    @Deprecated(since="2.2M1")
    public String getDatabase() {
        return this.getDocumentReference().getWikiReference().getName();
    }

    @Deprecated(since="2.2M1")
    public void setDatabase(String database) {
        DocumentReference reference;
        WikiReference wiki;
        WikiReference newWiki;
        if (database != null && !(newWiki = new WikiReference(database)).equals((Object)(wiki = (reference = this.getDocumentReference()).getWikiReference()))) {
            this.setDocumentReferenceInternal(reference.replaceParent((EntityReference)wiki, (EntityReference)newWiki));
        }
    }

    @Deprecated(since="4.3M2")
    public String getLanguage() {
        return this.getLocale().toString();
    }

    @Deprecated(since="4.3M2")
    public void setLanguage(String language) {
        this.setLocale(LocaleUtils.toLocale((String)Util.normalizeLanguage(language), (Locale)Locale.ROOT));
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.ROOT;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals(this.locale, locale)) {
            this.locale = locale;
            this.setMetaDataDirty(true);
            this.keyCache = null;
            this.localKeyCache = null;
            this.documentReferenceWithLocaleCache = null;
            this.pageReferenceWithLocaleCache = null;
        }
    }

    @Deprecated(since="4.3M2")
    public String getDefaultLanguage() {
        return this.getDefaultLocale().toString();
    }

    @Deprecated(since="4.3M2")
    public void setDefaultLanguage(String defaultLanguage) {
        this.setDefaultLocale(LocaleUtils.toLocale((String)defaultLanguage, (Locale)Locale.ROOT));
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale != null ? this.defaultLocale : Locale.ROOT;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        if (!Objects.equals(this.defaultLocale, defaultLocale)) {
            this.defaultLocale = defaultLocale;
            this.setMetaDataDirty(true);
        }
    }

    public int getTranslation() {
        return this.getLocale().equals(Locale.ROOT) ? 0 : 1;
    }

    @Deprecated(since="5.4.6")
    public void setTranslation(int translation) {
    }

    public String getTranslatedContent(XWikiContext context) throws XWikiException {
        String language = context.getWiki().getLanguagePreference(context);
        return this.getTranslatedContent(language, context);
    }

    public String getTranslatedContent(String locale, XWikiContext context) throws XWikiException {
        XWikiDocument tdoc = this.getTranslatedDocument(locale, context);
        return tdoc.getContent();
    }

    public XWikiDocument getTranslatedDocument(XWikiContext context) throws XWikiException {
        String locale = context.getWiki().getLanguagePreference(context);
        return this.getTranslatedDocument(locale, context);
    }

    @Deprecated(since="4.3M2")
    public XWikiDocument getTranslatedDocument(String language, XWikiContext context) throws XWikiException {
        return this.getTranslatedDocument(LocaleUtils.toLocale((String)language, (Locale)Locale.ROOT), context);
    }

    public XWikiDocument getTranslatedDocument(Locale locale, XWikiContext context) throws XWikiException {
        XWikiDocument tdoc = this;
        if (locale != null && !locale.equals(Locale.ROOT) && !locale.equals(this.getDefaultLocale())) {
            try {
                tdoc = context.getWiki().getDocument(new DocumentReference((EntityReference)this.getDocumentReference(), locale), context);
                if (!tdoc.isNew()) {
                    return tdoc;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error when loading document {} for locale {}", new Object[]{this.getDocumentReference(), locale, e});
            }
            tdoc = this.getTranslatedDocument(LocaleUtils.getParentLocale((Locale)locale), context);
        }
        return tdoc;
    }

    @Deprecated(since="4.3M1")
    public String getRealLanguage(XWikiContext context) throws XWikiException {
        return this.getRealLanguage();
    }

    @Deprecated(since="4.3M1")
    public String getRealLanguage() {
        String lang = this.getLanguage();
        if (lang.equals("")) {
            return this.getDefaultLanguage();
        }
        return lang;
    }

    public Locale getRealLocale() {
        Locale locale = this.getLocale();
        if (locale.equals(Locale.ROOT)) {
            locale = this.getDefaultLocale();
        }
        return locale;
    }

    @Deprecated(since="5.1M2")
    public List<String> getTranslationList(XWikiContext context) throws XWikiException {
        if (this.getStore() != null) {
            return this.getStore().getTranslationList(this, context);
        }
        return Collections.emptyList();
    }

    public List<Locale> getTranslationLocales(XWikiContext context) throws XWikiException {
        List<String> translations = this.getTranslationList(context);
        ArrayList<Locale> locales = new ArrayList<Locale>(translations.size());
        for (String translationString : translations) {
            locales.add(LocaleUtils.toLocale((String)translationString));
        }
        return locales;
    }

    public List<Delta> getXMLDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)fromDoc.toXML(context)), (Object[])ToString.stringToArray((String)toDoc.toXML(context))));
    }

    public List<Delta> getContentDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)fromDoc.getContent()), (Object[])ToString.stringToArray((String)toDoc.getContent())));
    }

    public List<Delta> getContentDiff(String fromRev, String toRev, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        XWikiDocument fromDoc = context.getWiki().getDocument(this, fromRev, context);
        XWikiDocument toDoc = context.getWiki().getDocument(this, toRev, context);
        if (fromDoc == null) {
            throw new XWikiException(13, 13021, String.format("The revision [%s] cannot be found in [%s] for making diff.", fromRev, this.getDocumentReference()));
        }
        if (toRev == null) {
            throw new XWikiException(13, 13021, String.format("The revision [%s] cannot be found in [%s] for making diff.", toRev, this.getDocumentReference()));
        }
        return this.getContentDiff(fromDoc, toDoc, context);
    }

    public List<Delta> getContentDiff(String fromRev, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        XWikiDocument revdoc = context.getWiki().getDocument(this, fromRev, context);
        return this.getContentDiff(revdoc, this, context);
    }

    public List<Delta> getLastChanges(XWikiContext context) throws XWikiException, DifferentiationFailedException {
        Version version = this.getRCSVersion();
        try {
            String prev = this.getDocumentArchive(context).getPrevVersion(version).toString();
            XWikiDocument prevDoc = context.getWiki().getDocument(this, prev, context);
            return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)prevDoc.getContent()), (Object[])ToString.stringToArray((String)this.getContent())));
        }
        catch (Exception ex) {
            LOGGER.debug("Exception getting differences from previous version", (Throwable)ex);
            return new ArrayList<Delta>();
        }
    }

    public List<Delta> getRenderedContentDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        String originalContent = fromDoc.getRenderedContent(context);
        String newContent = toDoc.getRenderedContent(context);
        return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)originalContent), (Object[])ToString.stringToArray((String)newContent)));
    }

    public List<Delta> getRenderedContentDiff(String fromRev, String toRev, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        XWikiDocument fromDoc = context.getWiki().getDocument(this, fromRev, context);
        XWikiDocument toDoc = context.getWiki().getDocument(this, toRev, context);
        return this.getRenderedContentDiff(fromDoc, toDoc, context);
    }

    public List<Delta> getRenderedContentDiff(String fromRev, XWikiContext context) throws XWikiException, DifferentiationFailedException {
        XWikiDocument revdoc = context.getWiki().getDocument(this, fromRev, context);
        return this.getRenderedContentDiff(revdoc, this, context);
    }

    protected List<Delta> getDeltas(Revision rev) {
        ArrayList<Delta> list = new ArrayList<Delta>();
        for (int i = 0; i < rev.size(); ++i) {
            list.add(rev.getDelta(i));
        }
        return list;
    }

    public List<MetaDataDiff> getMetaDataDiff(String fromRev, String toRev, XWikiContext context) throws XWikiException {
        XWikiDocument fromDoc = context.getWiki().getDocument(this, fromRev, context);
        XWikiDocument toDoc = context.getWiki().getDocument(this, toRev, context);
        return this.getMetaDataDiff(fromDoc, toDoc, context);
    }

    public List<MetaDataDiff> getMetaDataDiff(String fromRev, XWikiContext context) throws XWikiException {
        XWikiDocument revdoc = context.getWiki().getDocument(this, fromRev, context);
        return this.getMetaDataDiff(revdoc, this, context);
    }

    public List<MetaDataDiff> getMetaDataDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) throws XWikiException {
        UserReference toDocOriginalAuthor;
        UserReference fromDocOriginalAuthor;
        ArrayList<MetaDataDiff> list = new ArrayList<MetaDataDiff>();
        if (fromDoc == null || toDoc == null) {
            return list;
        }
        if (!fromDoc.getTitle().equals(toDoc.getTitle())) {
            list.add(new MetaDataDiff("title", fromDoc.getTitle(), toDoc.getTitle()));
        }
        if (ObjectUtils.notEqual((Object)fromDoc.getRelativeParentReference(), (Object)toDoc.getRelativeParentReference())) {
            list.add(new MetaDataDiff("parent", fromDoc.getParent(), toDoc.getParent()));
        }
        if (ObjectUtils.notEqual((Object)(fromDocOriginalAuthor = fromDoc.getAuthors().getOriginalMetadataAuthor()), (Object)(toDocOriginalAuthor = toDoc.getAuthors().getOriginalMetadataAuthor()))) {
            list.add(new MetaDataDiff("author", this.userReferenceToString(fromDocOriginalAuthor), this.userReferenceToString(toDocOriginalAuthor)));
        }
        if (ObjectUtils.notEqual((Object)fromDoc.getDocumentReference(), (Object)toDoc.getDocumentReference())) {
            list.add(new MetaDataDiff("reference", fromDoc.getDocumentReference(), toDoc.getDocumentReference()));
        }
        if (!fromDoc.getSpace().equals(toDoc.getSpace())) {
            list.add(new MetaDataDiff("web", fromDoc.getSpace(), toDoc.getSpace()));
        }
        if (!fromDoc.getName().equals(toDoc.getName())) {
            list.add(new MetaDataDiff("name", fromDoc.getName(), toDoc.getName()));
        }
        if (ObjectUtils.notEqual((Object)fromDoc.getLocale(), (Object)toDoc.getLocale())) {
            list.add(new MetaDataDiff("language", fromDoc.getLanguage(), toDoc.getLanguage()));
        }
        if (ObjectUtils.notEqual((Object)fromDoc.getDefaultLocale(), (Object)toDoc.getDefaultLocale())) {
            list.add(new MetaDataDiff("defaultLanguage", fromDoc.getDefaultLanguage(), toDoc.getDefaultLanguage()));
        }
        if (ObjectUtils.notEqual((Object)fromDoc.getSyntax(), (Object)toDoc.getSyntax())) {
            list.add(new MetaDataDiff("syntax", fromDoc.getSyntax(), toDoc.getSyntax()));
        }
        if (fromDoc.isHidden() != toDoc.isHidden()) {
            list.add(new MetaDataDiff("hidden", fromDoc.isHidden(), toDoc.isHidden()));
        }
        if (fromDoc.isEnforceRequiredRights() != toDoc.isEnforceRequiredRights()) {
            list.add(new MetaDataDiff("enforceRequiredRights", fromDoc.isEnforceRequiredRights(), toDoc.isEnforceRequiredRights()));
        }
        return list;
    }

    public List<List<ObjectDiff>> getObjectDiff(String fromRev, String toRev, XWikiContext context) throws XWikiException {
        XWikiDocument fromDoc = context.getWiki().getDocument(this, fromRev, context);
        XWikiDocument toDoc = context.getWiki().getDocument(this, toRev, context);
        return this.getObjectDiff(fromDoc, toDoc, context);
    }

    public List<List<ObjectDiff>> getObjectDiff(String fromRev, XWikiContext context) throws XWikiException {
        XWikiDocument revdoc = context.getWiki().getDocument(this, fromRev, context);
        return this.getObjectDiff(revdoc, this, context);
    }

    public List<List<ObjectDiff>> getObjectDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) {
        List<ObjectDiff> dlist;
        ArrayList<List<ObjectDiff>> difflist = new ArrayList<List<ObjectDiff>>();
        for (List<BaseObject> objects : fromDoc.getXObjects().values()) {
            for (BaseObject originalObj : objects) {
                if (originalObj == null) continue;
                BaseObject newObj = toDoc.getXObject(originalObj.getXClassReference(), originalObj.getNumber());
                if (newObj == null) {
                    newObj = new BaseObject();
                    newObj.setXClassReference((EntityReference)originalObj.getXClassReference());
                    dlist = newObj.getDiff(originalObj, context);
                    ObjectDiff deleteMarker = new ObjectDiff(originalObj.getXClassReference(), originalObj.getNumber(), originalObj.getGuid(), "object-removed", "", "", (Object)"", (Object)"");
                    dlist.add(0, deleteMarker);
                } else {
                    dlist = newObj.getDiff(originalObj, context);
                }
                if (dlist.isEmpty()) continue;
                difflist.add(dlist);
            }
        }
        for (List<BaseObject> objects : toDoc.getXObjects().values()) {
            for (BaseObject newObj : objects) {
                BaseObject originalObj;
                if (newObj == null || (originalObj = fromDoc.getXObject(newObj.getXClassReference(), newObj.getNumber())) != null) continue;
                originalObj = new BaseObject();
                originalObj.setXClassReference(newObj.getRelativeXClassReference());
                originalObj.setNumber(newObj.getNumber());
                originalObj.setGuid(newObj.getGuid());
                dlist = newObj.getDiff(originalObj, context);
                ObjectDiff addMarker = new ObjectDiff(newObj.getXClassReference(), newObj.getNumber(), newObj.getGuid(), "object-added", "", "", (Object)"", (Object)"");
                dlist.add(0, addMarker);
                if (dlist.isEmpty()) continue;
                difflist.add(dlist);
            }
        }
        return difflist;
    }

    public List<List<ObjectDiff>> getClassDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) {
        ArrayList<List<ObjectDiff>> difflist = new ArrayList<List<ObjectDiff>>();
        BaseClass oldClass = fromDoc.getXClass();
        BaseClass newClass = toDoc.getXClass();
        if (newClass == null && oldClass == null) {
            return difflist;
        }
        List<ObjectDiff> dlist = newClass.getDiff(oldClass, context);
        if (!dlist.isEmpty()) {
            difflist.add(dlist);
        }
        return difflist;
    }

    public List<AttachmentDiff> getAttachmentDiff(XWikiDocument fromDoc, XWikiDocument toDoc, XWikiContext context) {
        String fileName;
        ArrayList<AttachmentDiff> difflist = new ArrayList<AttachmentDiff>();
        for (XWikiAttachment origAttach : fromDoc.getAttachmentList()) {
            fileName = origAttach.getFilename();
            XWikiAttachment newAttach = toDoc.getAttachment(fileName);
            origAttach = this.retrieveDeletedAttachment(fromDoc, origAttach, context);
            if (newAttach == null) {
                difflist.add(new AttachmentDiff(fileName, Delta.Type.DELETE, origAttach, newAttach));
                continue;
            }
            newAttach = this.retrieveDeletedAttachment(toDoc, newAttach, context);
            try {
                if (origAttach.equalsData(newAttach, context)) continue;
                difflist.add(new AttachmentDiff(fileName, Delta.Type.CHANGE, origAttach, newAttach));
            }
            catch (XWikiException e) {
                LOGGER.error("Failed to compare attachments [{}] and [{}]", new Object[]{origAttach.getReference(), newAttach.getReference(), e});
            }
        }
        for (XWikiAttachment newAttach : toDoc.getAttachmentList()) {
            fileName = newAttach.getFilename();
            XWikiAttachment origAttach = fromDoc.getAttachment(fileName);
            newAttach = this.retrieveDeletedAttachment(toDoc, newAttach, context);
            if (origAttach != null) continue;
            difflist.add(new AttachmentDiff(fileName, Delta.Type.INSERT, origAttach, newAttach));
        }
        return difflist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XWikiAttachment retrieveDeletedAttachment(XWikiDocument doc, XWikiAttachment attachment, XWikiContext context) {
        XWikiAttachment result = null;
        InputStream is = null;
        try {
            is = attachment.getContentInputStream(context);
            if (is == null) {
                DeletedAttachment deletedAttachment;
                XWikiAttachment restoredAttachment;
                AttachmentRecycleBinStore attachmentRecycleBinStore = context.getWiki().getAttachmentRecycleBinStore();
                List<DeletedAttachment> allDeletedAttachments = attachmentRecycleBinStore.getAllDeletedAttachments(doc, context, true);
                Iterator<DeletedAttachment> iterator = allDeletedAttachments.iterator();
                while (iterator.hasNext() && !(restoredAttachment = (deletedAttachment = iterator.next()).restoreAttachment()).getDate().before(attachment.getDate())) {
                    result = restoredAttachment;
                }
                if (result != null && !Objects.equals(attachment.getVersion(), result.getVersion())) {
                    result = result.getAttachmentRevision(attachment.getVersion(), context);
                }
            }
        }
        catch (XWikiException e) {
            LOGGER.error("Error while trying to load deleted attachment [{}] for doc [{}]", new Object[]{attachment, doc, e});
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result == null) {
            result = attachment;
        } else {
            result.setDoc(doc);
        }
        return result;
    }

    public XWikiDocument cloneRename(DocumentReference newDocumentReference, XWikiContext context) throws XWikiException {
        this.loadAttachments(context);
        this.loadArchive(context);
        return this.cloneInternal(newDocumentReference, true, true);
    }

    public XWikiDocument copyDocument(DocumentReference newDocumentReference, XWikiContext context) throws XWikiException {
        return this.copyDocument(newDocumentReference, true, context);
    }

    public XWikiDocument copyDocument(DocumentReference newDocumentReference, boolean cloneArchive, XWikiContext context) throws XWikiException {
        XWikiDocument newdoc;
        this.loadAttachments(context);
        if (cloneArchive) {
            this.loadArchive(context);
        }
        if (Strings.CS.equals((newdoc = this.cloneInternal(newDocumentReference, false, cloneArchive)).getTitle(), this.getPrettyName(this.getDocumentReference()))) {
            newdoc.setTitle(this.getPrettyName(newDocumentReference));
        }
        newdoc.setOriginalDocument(null);
        newdoc.setContentDirty(true);
        newdoc.setNew(true);
        return newdoc;
    }

    private String getPrettyName(DocumentReference documentReference) {
        EntityReferenceProvider defaultEntityReferenceProvider = Utils.getComponent(EntityReferenceProvider.class);
        if (defaultEntityReferenceProvider.getDefaultReference(documentReference.getType()).getName().equals(documentReference.getName())) {
            return documentReference.getLastSpaceReference().getName();
        }
        return documentReference.getName();
    }

    @Deprecated(since="2.2M1")
    public XWikiDocument copyDocument(String newDocumentName, XWikiContext context) throws XWikiException {
        return this.copyDocument(XWikiDocument.getCurrentMixedDocumentReferenceResolver().resolve((Object)newDocumentName, new Object[0]), context);
    }

    public XWikiLock getLock(XWikiContext context) throws XWikiException {
        XWikiLock theLock = this.getStore(context).loadLock(this.getId(), context, true);
        if (theLock != null) {
            int timeout = context.getWiki().getXWikiPreferenceAsInt("lock_Timeout", 1800, context);
            if (theLock.getDate().getTime() + (long)(timeout * 1000) < new Date().getTime()) {
                this.getStore(context).deleteLock(theLock, context, true);
                theLock = null;
            }
        }
        return theLock;
    }

    public void setLock(String userName, XWikiContext context) throws XWikiException {
        XWikiLock lock = new XWikiLock(this.getId(), userName);
        this.getStore(context).saveLock(lock, context, true);
    }

    public void removeLock(XWikiContext context) throws XWikiException {
        XWikiLock lock = this.getStore(context).loadLock(this.getId(), context, true);
        if (lock != null) {
            this.getStore(context).deleteLock(lock, context, true);
        }
    }

    public void insertText(String text, String marker, XWikiContext context) throws XWikiException {
        this.setContent(StringUtils.replaceOnce((String)this.getContent(), (String)marker, (String)(text + marker)));
        context.getWiki().saveDocument(this, context);
    }

    public Object getWikiNode() {
        return this.wikiNode;
    }

    public void setWikiNode(Object wikiNode) {
        this.wikiNode = wikiNode;
    }

    public String getXClassXML() {
        return this.xClassXML;
    }

    @Deprecated(since="2.2M1")
    public String getxWikiClassXML() {
        return this.getXClassXML();
    }

    public void setXClassXML(String xClassXML) {
        this.xClassXML = xClassXML;
    }

    @Deprecated(since="2.2M1")
    public void setxWikiClassXML(String xClassXML) {
        this.setXClassXML(xClassXML);
    }

    public int getElements() {
        return this.elements;
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    public void setElement(int element, boolean toggle) {
        this.elements = toggle ? (this.elements |= element) : (this.elements &= ~element);
    }

    public boolean hasElement(int element) {
        return (this.elements & element) == element;
    }

    public String getDefaultEditMode(XWikiContext context) throws XWikiException {
        try {
            return this.getDefaultEditModeInternal(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get the default edit mode for [{}]", (Object)this.getDocumentReference(), (Object)e);
            return "edit";
        }
    }

    private String getDefaultEditModeInternal(XWikiContext context) throws XWikiException {
        String editModeProperty = "defaultEditMode";
        DocumentReference editModeClass = XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)XWikiConstant.EDIT_MODE_CLASS, new Object[0]);
        BaseObject editModeObject = this.getXObject(editModeClass);
        if (editModeObject != null) {
            String defaultEditMode = editModeObject.getStringValue(editModeProperty);
            if (StringUtils.isEmpty((CharSequence)defaultEditMode)) {
                return "edit";
            }
            return defaultEditMode;
        }
        XWiki xwiki = context.getWiki();
        if (this.is10Syntax()) {
            if (this.getContent().indexOf("includeForm(") != -1) {
                return "inline";
            }
        } else {
            for (Block macroBlock : this.getXDOM().getBlocks((BlockMatcher)new MacroBlockMatcher("include"), Block.Axes.CHILD)) {
                DocumentReference documentReference;
                XWikiDocument includedDocument;
                String includedDocumentReference = macroBlock.getParameter("reference");
                if (includedDocumentReference == null) {
                    includedDocumentReference = macroBlock.getParameter("document");
                }
                if (includedDocumentReference == null || (includedDocument = xwiki.getDocument(documentReference = XWikiDocument.getCurrentMixedDocumentReferenceResolver().resolve((Object)includedDocumentReference, new Object[0]), context)).isNew()) continue;
                editModeObject = includedDocument.getXObject(editModeClass);
                if (editModeObject == null) {
                    editModeObject = includedDocument.getXObject(SHEETCLASS_REFERENCE);
                }
                if (editModeObject == null) continue;
                String defaultEditMode = editModeObject.getStringValue(editModeProperty);
                if (StringUtils.isBlank((CharSequence)defaultEditMode)) {
                    return "inline";
                }
                return defaultEditMode;
            }
        }
        return "edit";
    }

    public String getDefaultEditURL(XWikiContext context) throws XWikiException {
        String editMode = this.getDefaultEditMode(context);
        if ("inline".equals(editMode)) {
            return this.getEditURL("inline", "", context);
        }
        XWiki xwiki = context.getWiki();
        String editor = xwiki.getEditorPreference(context);
        return this.getEditURL("edit", editor, context);
    }

    public String getEditURL(String action, String mode, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        String language = "";
        XWikiDocument tdoc = (XWikiDocument)context.get(CKEY_TDOC);
        String realLang = tdoc.getRealLanguage(context);
        if (xwiki.isMultiLingual(context) && !realLang.equals("")) {
            language = realLang;
        }
        return this.getEditURL(action, mode, language, context);
    }

    public String getEditURL(String action, String mode, String language, XWikiContext context) {
        StringBuilder editparams = new StringBuilder();
        if (!mode.equals("")) {
            editparams.append("xpage=");
            editparams.append(mode);
        }
        if (!language.equals("")) {
            if (!mode.equals("")) {
                editparams.append("&");
            }
            editparams.append("language=");
            editparams.append(language);
        }
        return this.getURL(action, editparams.toString(), context);
    }

    public String getDefaultTemplate() {
        if (this.defaultTemplate == null) {
            return "";
        }
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(String defaultTemplate) {
        if (!Objects.equals(this.defaultTemplate, defaultTemplate)) {
            this.defaultTemplate = defaultTemplate;
            this.setMetaDataDirty(true);
        }
    }

    public Vector<BaseObject> getComments() {
        return this.getComments(true);
    }

    public Syntax getSyntax() {
        if (this.isNew() && this.content.syntax == null) {
            this.content.syntax = this.getDefaultDocumentSyntax();
        }
        return this.content.syntax;
    }

    @Deprecated(since="2.3M1")
    public String getSyntaxId() {
        return this.getSyntax().toIdString();
    }

    public void setSyntax(Syntax syntax) {
        this.setContent(this.content.content, syntax);
    }

    @Deprecated(since="2.3M1")
    public void setSyntaxId(String syntaxId) {
        Syntax syntax = StringUtils.isBlank((CharSequence)syntaxId) ? Syntax.XWIKI_1_0 : this.resolveSyntax(syntaxId);
        this.setSyntax(syntax);
    }

    @Unstable
    public boolean isEnforceRequiredRights() {
        return this.enforceRequiredRights;
    }

    @Unstable
    public void setEnforceRequiredRights(boolean enforceRequiredRights) {
        this.enforceRequiredRights = enforceRequiredRights;
        this.setContentDirty(true);
    }

    public Vector<BaseObject> getComments(boolean asc) {
        List<BaseObject> list = this.getXObjects(COMMENTSCLASS_REFERENCE);
        if (list == null) {
            return null;
        }
        if (asc) {
            return new Vector<BaseObject>(list);
        }
        Vector<BaseObject> newlist = new Vector<BaseObject>();
        for (int i = list.size() - 1; i >= 0; --i) {
            newlist.add(list.get(i));
        }
        return newlist;
    }

    public boolean isCurrentUserCreator(XWikiContext context) {
        return this.isCreator(context.getUserReference());
    }

    @Deprecated
    public boolean isCreator(String username) {
        if (username.equals("XWiki.XWikiGuest")) {
            return false;
        }
        return username.equals(this.getCreator());
    }

    public boolean isCreator(DocumentReference username) {
        if (username == null) {
            return false;
        }
        return username.equals((Object)this.getCreatorReference());
    }

    public boolean isCurrentUserPage(XWikiContext context) {
        DocumentReference userReference = context.getUserReference();
        if (userReference == null) {
            return false;
        }
        return userReference.equals((Object)this.getDocumentReference());
    }

    public boolean isCurrentLocalUserPage(XWikiContext context) {
        DocumentReference userRef = context.getUserReference();
        return userRef != null && userRef.equals((Object)this.getDocumentReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetArchive(XWikiContext context) throws XWikiException {
        boolean hasVersioning = context.getWiki().hasVersioning(context);
        if (hasVersioning) {
            WikiReference currentWiki = context.getWikiReference();
            try {
                context.setWikiReference(this.getDocumentReference().getWikiReference());
                this.getVersioningStore(context).resetRCSArchive(this, true, context);
            }
            finally {
                context.setWikiReference(currentWiki);
            }
        }
    }

    public BaseObject addXObjectFromRequest(XWikiContext context) throws XWikiException {
        ObjectAddForm form = new ObjectAddForm();
        form.setRequest(context.getRequest());
        form.readRequest();
        EntityReference classReference = XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)form.getClassName(), EntityType.DOCUMENT, new Object[]{this.getDocumentReference()});
        BaseObject object = this.newXObject(classReference, context);
        BaseClass baseclass = object.getXClass(context);
        baseclass.fromMap(form.getObject(LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.resolveClassReference(classReference), new Object[0])), object);
        return object;
    }

    public BaseObject addXObjectFromRequest(EntityReference classReference, XWikiContext context) throws XWikiException {
        return this.addXObjectFromRequest(classReference, "", 0, context);
    }

    @Deprecated(since="2.2M2")
    public BaseObject addObjectFromRequest(String className, XWikiContext context) throws XWikiException {
        return this.addObjectFromRequest(className, "", 0, context);
    }

    public BaseObject addXObjectFromRequest(DocumentReference classReference, String prefix, XWikiContext context) throws XWikiException {
        return this.addXObjectFromRequest((EntityReference)classReference, prefix, 0, context);
    }

    @Deprecated(since="2.2M2")
    public BaseObject addObjectFromRequest(String className, String prefix, XWikiContext context) throws XWikiException {
        return this.addObjectFromRequest(className, prefix, 0, context);
    }

    public List<BaseObject> addXObjectsFromRequest(DocumentReference classReference, XWikiContext context) throws XWikiException {
        return this.addXObjectsFromRequest(classReference, "", context);
    }

    @Deprecated(since="2.2M2")
    public List<BaseObject> addObjectsFromRequest(String className, XWikiContext context) throws XWikiException {
        return this.addObjectsFromRequest(className, "", context);
    }

    public List<BaseObject> addXObjectsFromRequest(DocumentReference classReference, String pref, XWikiContext context) throws XWikiException {
        Map map = context.getRequest().getParameterMap();
        ArrayList<Integer> objectsNumberDone = new ArrayList<Integer>();
        ArrayList<BaseObject> objects = new ArrayList<BaseObject>();
        String start = pref + LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)classReference, new Object[0]) + "_";
        for (String name : map.keySet()) {
            int pos;
            String prefix;
            int num;
            if (!name.startsWith(start) || objectsNumberDone.contains(num = Integer.decode((prefix = name.substring(0, pos = name.indexOf(95, start.length() + 1))).substring(prefix.lastIndexOf(95) + 1)).intValue())) continue;
            objectsNumberDone.add(num);
            objects.add(this.addXObjectFromRequest((EntityReference)classReference, pref, num, context));
        }
        return objects;
    }

    @Deprecated(since="2.2M2")
    public List<BaseObject> addObjectsFromRequest(String className, String pref, XWikiContext context) throws XWikiException {
        return this.addXObjectsFromRequest(this.resolveClassReference(className), pref, context);
    }

    public BaseObject addXObjectFromRequest(DocumentReference classReference, int num, XWikiContext context) throws XWikiException {
        return this.addXObjectFromRequest((EntityReference)classReference, "", num, context);
    }

    @Deprecated(since="2.2M2")
    public BaseObject addObjectFromRequest(String className, int num, XWikiContext context) throws XWikiException {
        return this.addObjectFromRequest(className, "", num, context);
    }

    public BaseObject addXObjectFromRequest(EntityReference classReference, String prefix, int num, XWikiContext context) throws XWikiException {
        BaseObject object = this.newXObject(classReference, context);
        BaseClass baseclass = object.getXClass(context);
        String newPrefix = prefix + LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)this.resolveClassReference(classReference), new Object[0]) + "_" + num;
        baseclass.fromMap(Util.getObject(context.getRequest(), newPrefix), object);
        return object;
    }

    @Deprecated(since="2.2M2")
    public BaseObject addObjectFromRequest(String className, String prefix, int num, XWikiContext context) throws XWikiException {
        return this.addXObjectFromRequest((EntityReference)this.resolveClassReference(className), prefix, num, context);
    }

    public BaseObject updateXObjectFromRequest(EntityReference classReference, XWikiContext context) throws XWikiException {
        return this.updateXObjectFromRequest(classReference, "", context);
    }

    @Deprecated(since="2.2M2")
    public BaseObject updateObjectFromRequest(String className, XWikiContext context) throws XWikiException {
        return this.updateObjectFromRequest(className, "", context);
    }

    public BaseObject updateXObjectFromRequest(EntityReference classReference, String prefix, XWikiContext context) throws XWikiException {
        return this.updateXObjectFromRequest(classReference, prefix, 0, context);
    }

    @Deprecated(since="2.2M2")
    public BaseObject updateObjectFromRequest(String className, String prefix, XWikiContext context) throws XWikiException {
        return this.updateObjectFromRequest(className, prefix, 0, context);
    }

    public BaseObject updateXObjectFromRequest(EntityReference classReference, String prefix, int num, XWikiContext context) throws XWikiException {
        int nb;
        DocumentReference absoluteClassReference = this.resolveClassReference(classReference);
        BaseObject oldobject = this.getXObject(absoluteClassReference, num);
        if (oldobject == null) {
            nb = this.createXObject(classReference, context);
            oldobject = this.getXObject(absoluteClassReference, nb);
        } else {
            nb = oldobject.getNumber();
        }
        BaseClass baseclass = oldobject.getXClass(context);
        String newPrefix = prefix + LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)absoluteClassReference, new Object[0]) + "_" + nb;
        BaseObject newobject = (BaseObject)baseclass.fromMap(Util.getObject(context.getRequest(), newPrefix), oldobject);
        newobject.setNumber(oldobject.getNumber());
        newobject.setGuid(oldobject.getGuid());
        this.setXObject(nb, newobject);
        return newobject;
    }

    @Deprecated(since="2.2M2")
    public BaseObject updateObjectFromRequest(String className, String prefix, int num, XWikiContext context) throws XWikiException {
        return this.updateXObjectFromRequest(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), prefix, num, context);
    }

    public List<BaseObject> updateXObjectsFromRequest(EntityReference classReference, XWikiContext context) throws XWikiException {
        return this.updateXObjectsFromRequest(classReference, "", context);
    }

    @Deprecated(since="2.2M2")
    public List<BaseObject> updateObjectsFromRequest(String className, XWikiContext context) throws XWikiException {
        return this.updateObjectsFromRequest(className, "", context);
    }

    public List<BaseObject> updateXObjectsFromRequest(EntityReference classReference, String pref, XWikiContext context) throws XWikiException {
        DocumentReference absoluteClassReference = this.resolveClassReference(classReference);
        Map map = context.getRequest().getParameterMap();
        ArrayList<Integer> objectsNumberDone = new ArrayList<Integer>();
        ArrayList<BaseObject> objects = new ArrayList<BaseObject>();
        String start = pref + LOCAL_REFERENCE_SERIALIZER.serialize((EntityReference)absoluteClassReference, new Object[0]) + "_";
        for (String name : map.keySet()) {
            int pos;
            String prefix;
            int num;
            if (!name.startsWith(start) || objectsNumberDone.contains(num = Integer.decode((prefix = name.substring(0, pos = name.indexOf(95, start.length() + 1))).substring(prefix.lastIndexOf(95) + 1)).intValue())) continue;
            objectsNumberDone.add(num);
            objects.add(this.updateXObjectFromRequest(classReference, pref, num, context));
        }
        return objects;
    }

    @Deprecated(since="2.2M2")
    public List<BaseObject> updateObjectsFromRequest(String className, String pref, XWikiContext context) throws XWikiException {
        return this.updateXObjectsFromRequest(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), pref, context);
    }

    public boolean isAdvancedContent() {
        String[] matches = new String[]{"<%", "#set", "#include", "#if", "public class", "/* Advanced content */", "## Advanced content", "/* Programmatic content */", "## Programmatic content"};
        String content2 = this.getContent().toLowerCase();
        for (String match : matches) {
            if (content2.indexOf(match.toLowerCase()) == -1) continue;
            return true;
        }
        return HTML_TAG_PATTERN.matcher(content2).find();
    }

    public boolean isProgrammaticContent() {
        String[] matches = new String[]{"<%", "\\$xwiki.xWiki", "$xcontext.context", "$doc.document", "$xwiki.getXWiki()", "$xcontext.getContext()", "$doc.getDocument()", "WithProgrammingRights(", "/* Programmatic content */", "## Programmatic content", "$xwiki.search(", "$xwiki.createUser", "$xwiki.createNewWiki", "$xwiki.addToAllGroup", "$xwiki.sendMessage", "$xwiki.copyDocument", "$xwiki.copyWikiWeb", "$xwiki.copySpaceBetweenWikis", "$xwiki.parseGroovyFromString", "$doc.toXML()", "$doc.toXMLDocument()"};
        String content2 = this.getContent().toLowerCase();
        for (String match : matches) {
            if (content2.indexOf(match.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean removeXObject(BaseObject object) {
        List objects = this.xObjects.get(object.getXClassReference());
        if (objects == null) {
            return false;
        }
        int objectPosition = object.getNumber();
        if (objectPosition < objects.size()) {
            BaseObject storedObject = (BaseObject)objects.get(objectPosition);
            if (storedObject == null || !storedObject.equals(object)) {
                objectPosition = objects.indexOf(object);
            }
        } else {
            objectPosition = -1;
        }
        if (objectPosition < 0) {
            return false;
        }
        objects.set(objectPosition, null);
        this.addXObjectToRemove(object);
        return true;
    }

    @Deprecated(since="2.2M1")
    public boolean removeObject(BaseObject object) {
        return this.removeXObject(object);
    }

    public boolean removeXObjects(DocumentReference classReference) {
        List objects = this.xObjects.get(classReference);
        if (objects == null) {
            return false;
        }
        for (BaseObject object : objects) {
            if (object == null) continue;
            this.addXObjectToRemove(object);
        }
        int currentSize = objects.size();
        objects.clear();
        for (int i = 0; i < currentSize; ++i) {
            objects.add(null);
        }
        return true;
    }

    public boolean removeXObjects(EntityReference reference) {
        return this.removeXObjects(XWikiDocument.getCurrentReferenceDocumentReferenceResolver().resolve((Object)reference, new Object[]{this.getDocumentReference()}));
    }

    @Deprecated(since="2.2M1")
    public boolean removeObjects(String className) {
        return this.removeXObjects(this.resolveClassReference(className));
    }

    public List<DocumentSection> getSections() throws XWikiException {
        if (this.is10Syntax()) {
            return this.getSections10();
        }
        ArrayList<DocumentSection> splitSections = new ArrayList<DocumentSection>();
        List<HeaderBlock> headers = this.getFilteredHeaders();
        int sectionNumber = 1;
        for (HeaderBlock header : headers) {
            int documentSectionIndex = -1;
            String documentSectionLevel = StringUtils.repeat((String)"1.", (int)(header.getLevel().getAsInt() - 1)) + "1";
            DocumentSection docSection = new DocumentSection(sectionNumber++, documentSectionIndex, documentSectionLevel, XWikiDocument.renderXDOM(new XDOM(header.getChildren()), this.getSyntax()));
            splitSections.add(docSection);
        }
        return splitSections;
    }

    private XWikiContext getXWikiContext() {
        Provider xcontextProvider = (Provider)Utils.getComponent(XWikiContext.TYPE_PROVIDER);
        if (xcontextProvider != null) {
            return (XWikiContext)xcontextProvider.get();
        }
        return null;
    }

    private List<HeaderBlock> getFilteredHeaders() {
        XDOM xdom;
        ArrayList<HeaderBlock> filteredHeaders = new ArrayList<HeaderBlock>();
        int sectionDepth = 2;
        XWikiContext context = this.getXWikiContext();
        if (context != null) {
            sectionDepth = (int)context.getWiki().getSectionEditingDepth();
        }
        if (!(xdom = this.getXDOM()).getChildren().isEmpty()) {
            Block currentBlock = (Block)xdom.getChildren().get(0);
            block0: while (currentBlock != null) {
                if (currentBlock instanceof SectionBlock) {
                    HeaderBlock headerBlock;
                    Block nextChildrenBlock = (Block)currentBlock.getChildren().get(0);
                    if (nextChildrenBlock instanceof HeaderBlock && (headerBlock = (HeaderBlock)nextChildrenBlock).getLevel().getAsInt() <= sectionDepth) {
                        filteredHeaders.add(headerBlock);
                    }
                    currentBlock = nextChildrenBlock;
                    continue;
                }
                Block nextSibling = currentBlock.getNextSibling();
                if (nextSibling == null) {
                    for (currentBlock = currentBlock.getParent(); currentBlock != null; currentBlock = currentBlock.getParent()) {
                        if (currentBlock.getNextSibling() == null) continue;
                        currentBlock = currentBlock.getNextSibling();
                        continue block0;
                    }
                    continue;
                }
                currentBlock = nextSibling;
            }
        }
        return filteredHeaders;
    }

    private List<DocumentSection> getSections10() {
        Pattern headingPattern = Pattern.compile("^[ \\t]*+(1(\\.1){0,1}+)[ \\t]++(.++)$", 8);
        Matcher matcher = headingPattern.matcher(this.getContent());
        ArrayList<DocumentSection> splitSections = new ArrayList<DocumentSection>();
        int sectionNumber = 0;
        while (matcher.find()) {
            String sectionLevel = matcher.group(1);
            String sectionTitle = matcher.group(3);
            int sectionIndex = matcher.start();
            DocumentSection docSection = new DocumentSection(++sectionNumber, sectionIndex, sectionLevel, sectionTitle);
            splitSections.add(docSection);
        }
        return splitSections;
    }

    public DocumentSection getDocumentSection(int sectionNumber) throws XWikiException {
        return this.getSections().get(sectionNumber - 1);
    }

    public String getContentOfSection(int sectionNumber) throws XWikiException {
        String content = null;
        if (this.is10Syntax()) {
            content = this.getContentOfSection10(sectionNumber);
        } else {
            List<HeaderBlock> headers = this.getFilteredHeaders();
            if (headers.size() >= sectionNumber) {
                SectionBlock section = headers.get(sectionNumber - 1).getSection();
                content = XWikiDocument.renderXDOM(new XDOM(Collections.singletonList(section)), this.getSyntax());
            }
        }
        return content;
    }

    private String getContentOfSection10(int sectionNumber) throws XWikiException {
        List<DocumentSection> splitSections = this.getSections();
        int indexEnd = 0;
        DocumentSection section = splitSections.get(sectionNumber - 1);
        int indexStart = section.getSectionIndex();
        String sectionLevel = section.getSectionLevel();
        for (int i = sectionNumber; i < splitSections.size(); ++i) {
            DocumentSection nextSection = splitSections.get(i);
            String nextLevel = nextSection.getSectionLevel();
            if (!sectionLevel.equals(nextLevel) && sectionLevel.length() <= nextLevel.length()) continue;
            indexEnd = nextSection.getSectionIndex();
            break;
        }
        String sectionContent = null;
        if (indexStart < 0) {
            indexStart = 0;
        }
        sectionContent = indexEnd == 0 ? this.getContent().substring(indexStart) : this.getContent().substring(indexStart, indexEnd);
        return sectionContent;
    }

    public String updateDocumentSection(int sectionNumber, String newSectionContent) throws XWikiException {
        String content;
        if (this.is10Syntax()) {
            content = this.updateDocumentSection10(sectionNumber, newSectionContent);
        } else {
            HeaderBlock header = this.getFilteredHeaders().get(sectionNumber - 1);
            XDOM xdom = (XDOM)header.getRoot();
            List blocks = this.parseContent(newSectionContent).getChildren();
            int sectionLevel = header.getLevel().getAsInt();
            for (int level = 1; level < sectionLevel && blocks.size() == 1 && blocks.get(0) instanceof SectionBlock; ++level) {
                blocks = ((Block)blocks.get(0)).getChildren();
            }
            SectionBlock section = header.getSection();
            section.getParent().replaceChild(blocks, (Block)section);
            content = XWikiDocument.renderXDOM(xdom, this.getSyntax());
        }
        return content;
    }

    private String updateDocumentSection10(int sectionNumber, String newSectionContent) throws XWikiException {
        StringBuilder newContent = new StringBuilder();
        DocumentSection docSection = this.getDocumentSection(sectionNumber);
        int numberOfSections = this.getSections().size();
        int indexSection = docSection.getSectionIndex();
        if (numberOfSections == 1) {
            String contentBegin = this.getContent().substring(0, indexSection);
            newContent = newContent.append(contentBegin).append(newSectionContent);
            return newContent.toString();
        }
        if (sectionNumber == numberOfSections) {
            String contentBegin = this.getContent().substring(0, indexSection);
            newContent = newContent.append(contentBegin).append(newSectionContent);
            return newContent.toString();
        }
        String sectionLevel = docSection.getSectionLevel();
        int nextSectionIndex = 0;
        for (int i = sectionNumber; i < numberOfSections; ++i) {
            DocumentSection nextSection = this.getDocumentSection(i + 1);
            String nextSectionLevel = nextSection.getSectionLevel();
            if (sectionLevel.equals(nextSectionLevel)) {
                nextSectionIndex = nextSection.getSectionIndex();
                break;
            }
            if (sectionLevel.length() <= nextSectionLevel.length()) continue;
            nextSectionIndex = nextSection.getSectionIndex();
            break;
        }
        if (nextSectionIndex == 0) {
            newContent = newContent.append(this.getContent().substring(0, indexSection)).append(newSectionContent);
            return newContent.toString();
        }
        String contentAfter = this.getContent().substring(nextSectionIndex);
        String contentBegin = this.getContent().substring(0, indexSection);
        newContent = newContent.append(contentBegin).append(newSectionContent).append(contentAfter);
        return newContent.toString();
    }

    public String getVersionHashCode(XWikiContext context) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Cannot create MD5 object", (Throwable)ex);
            return "" + this.hashCode();
        }
        try {
            String valueBeforeMD5 = this.toXML(true, false, true, false, context);
            md5.update(valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuilder sb = new StringBuilder();
            for (byte element : array) {
                int b = element & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            return sb.toString();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while computing document hash", (Throwable)ex);
            return "" + this.hashCode();
        }
    }

    public static String getInternalPropertyName(String propname, XWikiContext context) {
        ContextualLocalizationManager localizationManager = Utils.getComponent(ContextualLocalizationManager.class);
        String cpropname = StringUtils.capitalize((String)propname);
        return localizationManager == null ? cpropname : localizationManager.getTranslationPlain(cpropname, new Object[0]);
    }

    public String getInternalProperty(String propname) {
        String methodName = "get" + StringUtils.capitalize((String)propname);
        try {
            Method method = this.getClass().getDeclaredMethod(methodName, null);
            return (String)method.invoke((Object)this, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCustomClass() {
        if (this.customClass == null) {
            return "";
        }
        return this.customClass;
    }

    public void setCustomClass(String customClass) {
        if (!Objects.equals(this.customClass, customClass)) {
            this.customClass = customClass;
            this.setMetaDataDirty(true);
        }
    }

    public void setValidationScript(String validationScript) {
        if (!Objects.equals(this.validationScript, validationScript)) {
            this.validationScript = validationScript;
            this.setMetaDataDirty(true);
        }
    }

    public String getValidationScript() {
        if (this.validationScript == null) {
            return "";
        }
        return this.validationScript;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isMinorEdit() {
        return this.isMinorEdit;
    }

    public void setMinorEdit(boolean isMinor) {
        this.isMinorEdit = isMinor;
    }

    protected Boolean getMinorEdit1() {
        return this.isMinorEdit();
    }

    protected void setMinorEdit1(Boolean isMinor) {
        this.isMinorEdit = isMinor != null && isMinor != false;
    }

    public BaseObject newXObject(EntityReference classReference, XWikiContext context) throws XWikiException {
        int nb = this.createXObject(classReference, context);
        return this.getXObject(this.resolveClassReference(classReference), nb);
    }

    @Deprecated(since="2.2M2")
    public BaseObject newObject(String className, XWikiContext context) throws XWikiException {
        return this.newXObject(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), context);
    }

    public BaseObject getXObject(DocumentReference classReference, boolean create, XWikiContext context) {
        try {
            BaseObject obj = this.getXObject(classReference);
            if (obj == null && create) {
                return this.newXObject((EntityReference)classReference, context);
            }
            if (obj == null) {
                return null;
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BaseObject getXObject(EntityReference classReference, boolean create, XWikiContext context) {
        try {
            BaseObject obj = this.getXObject(classReference);
            if (obj == null && create) {
                return this.newXObject(classReference, context);
            }
            if (obj == null) {
                return null;
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated(since="2.2M2")
    public BaseObject getObject(String className, boolean create, XWikiContext context) {
        return this.getXObject(XWikiDocument.getXClassEntityReferenceResolver().resolve((Object)className, EntityType.DOCUMENT, new Object[]{this.getDocumentReference()}), create, context);
    }

    public boolean validate(XWikiContext context) throws XWikiException {
        return this.validate(null, context);
    }

    public boolean validate(String[] classNames, XWikiContext context) throws XWikiException {
        boolean isValid = true;
        if (classNames == null || classNames.length == 0) {
            for (DocumentReference classReference : this.getXObjects().keySet()) {
                BaseClass bclass = context.getWiki().getXClass(classReference, context);
                List<BaseObject> objects = this.getXObjects(classReference);
                for (BaseObject obj : objects) {
                    if (obj == null) continue;
                    isValid &= bclass.validateObject(obj, context);
                }
            }
        } else {
            for (String className : classNames) {
                List<BaseObject> objects = this.getXObjects(XWikiDocument.getCurrentMixedDocumentReferenceResolver().resolve((Object)className, new Object[0]));
                if (objects == null) continue;
                for (BaseObject obj : objects) {
                    if (obj == null) continue;
                    BaseClass bclass = obj.getXClass(context);
                    isValid &= bclass.validateObject(obj, context);
                }
            }
        }
        String validationScript = "";
        XWikiRequest req = context.getRequest();
        if (req != null) {
            validationScript = req.get("xvalidation");
        }
        if (validationScript == null || validationScript.trim().equals("")) {
            validationScript = this.getValidationScript();
        }
        if (validationScript != null && !validationScript.trim().equals("")) {
            isValid &= this.executeValidationScript(context, validationScript);
        }
        return isValid;
    }

    public static void backupContext(Map<String, Object> backup, XWikiContext context) {
        backup.put("doc", context.getDoc());
        backup.put(CKEY_CDOC, context.get(CKEY_CDOC));
        backup.put(CKEY_TDOC, context.get(CKEY_TDOC));
        backup.put(CKEY_SDOC, context.get(CKEY_SDOC));
        Execution execution = Utils.getComponent(Execution.class);
        try {
            execution.pushContext(Utils.getComponent(ExecutionContextManager.class).clone(execution.getContext()));
        }
        catch (ExecutionContextException e) {
            throw new RuntimeException("Failed to clone the Execution Context", e);
        }
        execution.getContext().setProperty("xwikicontext", (Object)context);
    }

    public static void restoreContext(Map<String, Object> backup, XWikiContext context) {
        Execution execution = Utils.getComponent(Execution.class);
        execution.popContext();
        context.setDoc((XWikiDocument)backup.get("doc"));
        context.put(CKEY_CDOC, backup.get(CKEY_CDOC));
        context.put(CKEY_TDOC, backup.get(CKEY_TDOC));
        context.put(CKEY_SDOC, backup.get(CKEY_SDOC));
    }

    public void setAsContextDoc(XWikiContext context) {
        context.setDoc(this);
        context.remove(CKEY_CDOC);
        context.remove(CKEY_TDOC);
        context.remove(CKEY_SDOC);
    }

    public String getPreviousVersion() {
        Version prevVersion;
        XWikiDocumentArchive archive = this.loadDocumentArchive();
        if (archive != null && (prevVersion = archive.getPrevVersion(this.getRCSVersion())) != null) {
            return prevVersion.toString();
        }
        return null;
    }

    public String toString() {
        return this.getFullName();
    }

    public void setHidden(Boolean hidden) {
        boolean hiddenValue = hidden == null ? false : hidden;
        if (this.hidden != hiddenValue) {
            this.hidden = hiddenValue;
            this.setMetaDataDirty(hiddenValue);
        }
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void convertSyntax(String targetSyntaxId, XWikiContext context) throws XWikiException {
        try {
            this.convertSyntax(Syntax.valueOf((String)targetSyntaxId), context);
        }
        catch (Exception e) {
            throw new XWikiException(4, 0, "Failed to convert document to syntax [" + targetSyntaxId + "]", e);
        }
    }

    public void convertSyntax(Syntax targetSyntax, XWikiContext context) throws XWikiException {
        this.setContent(XWikiDocument.performSyntaxConversion(this.getContent(), this.getDocumentReference(), this.getSyntax(), targetSyntax));
        Map<DocumentReference, List<BaseObject>> objectsByClass = this.getXObjects();
        for (List<BaseObject> objects : objectsByClass.values()) {
            for (BaseObject bobject : objects) {
                if (bobject == null) continue;
                BaseClass bclass = bobject.getXClass(context);
                for (Object fieldClass : bclass.getProperties()) {
                    TextAreaClass textAreaClass;
                    PropertyInterface field;
                    if (!(fieldClass instanceof TextAreaClass) || !((TextAreaClass)fieldClass).isWikiContent() || !((field = bobject.getField((textAreaClass = (TextAreaClass)fieldClass).getName())) instanceof LargeStringProperty)) continue;
                    LargeStringProperty largeField = (LargeStringProperty)field;
                    largeField.setValue(XWikiDocument.performSyntaxConversion(largeField.getValue(), this.getDocumentReference(), this.getSyntax(), targetSyntax));
                }
            }
        }
        this.setSyntax(targetSyntax);
    }

    private XDOM parseContentNoException() {
        try {
            return this.parseContent(this.getContent());
        }
        catch (Exception e) {
            ErrorBlockGenerator errorBlockGenerator = Utils.getComponent(ErrorBlockGenerator.class);
            return new XDOM(errorBlockGenerator.generateErrorBlocks(false, TM_FAILEDDOCUMENTPARSE, "Failed to parse document content", null, new Object[]{e}));
        }
    }

    public XDOM getXDOM() {
        if (this.content.xdom == null) {
            this.content.xdom = this.parseContentNoException();
        }
        return this.content.xdom.clone();
    }

    public XDOM getPreparedXDOM() {
        LocalDateTime xdomPrepareDate = this.content.prepareDate;
        XDOM xdom = this.content.xdom;
        if (xdomPrepareDate != null) {
            if (XWikiDocument.getCacheControl().isCacheReadAllowed((ChronoLocalDateTime)xdomPrepareDate)) {
                return xdom.clone();
            }
            xdom = null;
        }
        xdom = xdom == null ? this.parseContentNoException() : xdom.clone();
        xdomPrepareDate = LocalDateTime.now();
        XWikiDocument.getMacroTransformation().prepare((Block)xdom);
        this.content.xdom = xdom;
        this.content.prepareDate = xdomPrepareDate;
        return this.content.xdom.clone();
    }

    public boolean is10Syntax() {
        return this.is10Syntax(this.getSyntaxId());
    }

    public boolean is10Syntax(String syntaxId) {
        return Syntax.XWIKI_1_0.toIdString().equalsIgnoreCase(syntaxId);
    }

    private void init(DocumentReference reference) {
        if (reference == null) {
            this.setDocumentReference((DocumentReference)((Provider)Utils.getComponent(DocumentReference.TYPE_PROVIDER)).get());
        } else {
            this.setDocumentReference(reference);
        }
        this.updateDate = new Date();
        this.updateDate.setTime(this.updateDate.getTime() / 1000L * 1000L);
        this.contentUpdateDate = new Date();
        this.contentUpdateDate.setTime(this.contentUpdateDate.getTime() / 1000L * 1000L);
        this.creationDate = new Date();
        this.creationDate.setTime(this.creationDate.getTime() / 1000L * 1000L);
        this.content = new Content("", this.content.syntax);
        this.format = "";
        this.locale = Locale.ROOT;
        this.defaultLocale = Locale.ROOT;
        this.customClass = "";
        this.comment = "";
    }

    private boolean executeValidationScript(XWikiContext context, String validationScript) {
        try {
            ContextualAuthorizationManager authorization = Utils.getComponent(ContextualAuthorizationManager.class);
            DocumentReference validationScriptReference = XWikiDocument.getCurrentDocumentReferenceResolver().resolve((Object)validationScript, new Object[]{this.getDocumentReference()});
            authorization.checkAccess(Right.PROGRAM, (EntityReference)validationScriptReference);
            XWikiValidationInterface validObject = (XWikiValidationInterface)context.getWiki().parseGroovyFromPage(validationScript, context);
            return validObject.validateDocument(this, context);
        }
        catch (Throwable e) {
            XWikiValidationStatus.addExceptionToContext(this.getFullName(), "", e, context);
            return false;
        }
    }

    private static String performSyntaxConversion(String content, DocumentReference source, Syntax currentSyntaxId, Syntax targetSyntax) throws XWikiException {
        try {
            XDOM dom = XWikiDocument.parseContent(currentSyntaxId, content, source);
            return XWikiDocument.renderXDOM(dom, targetSyntax);
        }
        catch (Exception e) {
            throw new XWikiException(4, 0, "Failed to convert document to syntax [" + String.valueOf(targetSyntax) + "]", e);
        }
    }

    protected static String renderXDOM(XDOM content, Syntax targetSyntax) throws XWikiException {
        try {
            BlockRenderer renderer = Utils.getComponent(BlockRenderer.class, targetSyntax.toIdString());
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            renderer.render((Block)content, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            throw new XWikiException(4, 0, "Failed to render document to syntax [" + String.valueOf(targetSyntax) + "]", e);
        }
    }

    private XDOM parseContent(String content) throws XWikiException {
        return XWikiDocument.parseContent(this.getSyntax(), content, this.getDocumentReference());
    }

    private static XDOM parseContent(Syntax syntax, String content, DocumentReference source) throws XWikiException {
        ContentParser parser = Utils.getComponent(ContentParser.class);
        try {
            return parser.parse(content, syntax, (EntityReference)source);
        }
        catch (MissingParserException e) {
            throw new XWikiException(4, 0, "Failed to find a parser for syntax [" + syntax.toIdString() + "]", e);
        }
        catch (ParseException e) {
            throw new XWikiException(4, 0, "Failed to parse content of syntax [" + syntax.toIdString() + "]", e);
        }
    }

    private Syntax getDefaultDocumentSyntax() {
        Syntax syntax = Utils.getComponent(CoreConfiguration.class).getDefaultDocumentSyntax();
        if (syntax == null || !Utils.getComponentManager().hasComponent(Parser.class, syntax.toIdString()) && !Syntax.XWIKI_2_1.equals((Object)syntax)) {
            LOGGER.warn("Failed to find parser for the default syntax [{}]. Defaulting to xwiki/2.1 syntax.", (Object)syntax);
            syntax = Syntax.XWIKI_2_1;
        }
        return syntax;
    }

    public DocumentReference resolveClassReference(String documentName) {
        DocumentReference defaultReference = new DocumentReference(this.getDocumentReference().getWikiReference().getName(), "XWiki", this.getDocumentReference().getName());
        return this.getExplicitDocumentReferenceResolver().resolve((Object)documentName, new Object[]{defaultReference});
    }

    private DocumentReference resolveClassReference(EntityReference reference) {
        if (reference instanceof DocumentReference) {
            return (DocumentReference)reference;
        }
        if (reference instanceof LocalDocumentReference) {
            return new DocumentReference((LocalDocumentReference)reference, this.getDocumentReference().getWikiReference());
        }
        DocumentReference defaultReference = new DocumentReference(this.getDocumentReference().getWikiReference().getName(), "XWiki", this.getDocumentReference().getName());
        return this.getExplicitReferenceDocumentReferenceResolver().resolve((Object)reference, new Object[]{defaultReference});
    }

    public EntityReference getRelativeParentReference() {
        return this.parentReference;
    }

    private BaseObject prepareXObject(EntityReference classReference) {
        DocumentReference absoluteClassReference = this.resolveClassReference(classReference);
        BaseObject bobject = this.getXObject(absoluteClassReference);
        if (bobject == null) {
            bobject = new BaseObject();
            bobject.setXClassReference(classReference);
            this.addXObject(bobject);
        }
        bobject.setDocumentReference(this.getDocumentReference());
        this.setMetaDataDirty(true);
        return bobject;
    }

    @Deprecated(since="11.8RC1")
    public MergeResult merge(XWikiDocument previousDocument, XWikiDocument newDocument, MergeConfiguration configuration, XWikiContext context) {
        MergeManager mergeManager = Utils.getComponent(MergeManager.class);
        MergeDocumentResult mergeDocumentResult = mergeManager.mergeDocument((DocumentModelBridge)previousDocument, (DocumentModelBridge)newDocument, (DocumentModelBridge)this, configuration);
        MergeResult mergeResult = new MergeResult();
        mergeResult.getLog().addAll((Collection)mergeDocumentResult.getLog());
        mergeResult.setModified(mergeResult.isModified() || mergeDocumentResult.isModified());
        if (!configuration.isProvidedVersionsModifiables()) {
            this.apply((XWikiDocument)mergeDocumentResult.getMergeResult());
        }
        return mergeResult;
    }

    public boolean apply(XWikiDocument document) {
        return this.apply(document, true);
    }

    public boolean apply(XWikiDocument document, boolean clean) {
        boolean modified = false;
        if (!Strings.CS.equals(this.getContent(), document.getContent())) {
            this.setContent(document.getContent());
            modified = true;
        }
        if (ObjectUtils.notEqual((Object)this.getSyntax(), (Object)document.getSyntax())) {
            this.setSyntax(document.getSyntax());
            modified = true;
        }
        if (ObjectUtils.notEqual((Object)this.getDefaultLocale(), (Object)document.getDefaultLocale())) {
            this.setDefaultLocale(document.getDefaultLocale());
            modified = true;
        }
        if (!Strings.CS.equals(this.getTitle(), document.getTitle())) {
            this.setTitle(document.getTitle());
            modified = true;
        }
        if (!Strings.CS.equals(this.getDefaultTemplate(), document.getDefaultTemplate())) {
            this.setDefaultTemplate(document.getDefaultTemplate());
            modified = true;
        }
        if (ObjectUtils.notEqual((Object)this.getRelativeParentReference(), (Object)document.getRelativeParentReference())) {
            this.setParentReference(document.getRelativeParentReference());
            modified = true;
        }
        if (!Strings.CS.equals(this.getCustomClass(), document.getCustomClass())) {
            this.setCustomClass(document.getCustomClass());
            modified = true;
        }
        if (!Strings.CS.equals(this.getValidationScript(), document.getValidationScript())) {
            this.setValidationScript(document.getValidationScript());
            modified = true;
        }
        if (this.isHidden() != document.isHidden()) {
            this.setHidden(document.isHidden());
            modified = true;
        }
        if (this.isEnforceRequiredRights() != document.isEnforceRequiredRights()) {
            this.setEnforceRequiredRights(document.isEnforceRequiredRights());
            modified = true;
        }
        if (clean) {
            for (List<BaseObject> objects : this.getXObjects().values()) {
                for (BaseObject originalObj : new ArrayList<BaseObject>(objects)) {
                    BaseObject newObj;
                    if (originalObj == null || (newObj = document.getXObject(originalObj.getXClassReference(), originalObj.getNumber())) != null) continue;
                    this.removeXObject(originalObj);
                    modified = true;
                }
            }
        }
        for (List<BaseObject> objects : document.getXObjects().values()) {
            for (BaseObject newObj : objects) {
                if (newObj == null) continue;
                BaseObject originalObj = this.getXObject(newObj.getXClassReference(), newObj.getNumber());
                if (originalObj == null) {
                    this.setXObject(newObj.getNumber(), newObj);
                    modified = true;
                    continue;
                }
                modified |= originalObj.apply(newObj, clean);
            }
        }
        modified |= this.getXClass().apply(document.getXClass(), clean);
        if (ObjectUtils.notEqual((Object)this.getXClassXML(), (Object)document.getXClassXML())) {
            this.setXClassXML(document.getXClassXML());
            modified = true;
        }
        if (clean) {
            for (XWikiAttachment attachment : new ArrayList<XWikiAttachment>(this.getAttachmentList())) {
                if (document.getAttachment(attachment.getFilename()) != null) continue;
                this.removeAttachment(attachment);
            }
        }
        for (XWikiAttachment attachment : document.getAttachmentList()) {
            XWikiAttachment originalAttachment = this.getAttachment(attachment.getFilename());
            if (originalAttachment == null) {
                this.addAttachment(attachment);
                continue;
            }
            originalAttachment.apply(attachment);
        }
        return modified;
    }

    private XWikiAttachmentStoreInterface resolveXWikiAttachmentStoreInterface(String storeType, XWikiContext xcontext) {
        XWikiAttachmentStoreInterface store = this.getXWikiAttachmentStoreInterface(storeType);
        if (store != null) {
            return store;
        }
        return xcontext.getWiki().getDefaultAttachmentContentStore();
    }

    private XWikiAttachmentStoreInterface getXWikiAttachmentStoreInterface(String storeType) {
        if (storeType != null && !storeType.equals("hibernate")) {
            try {
                return (XWikiAttachmentStoreInterface)Utils.getContextComponentManager().getInstance(XWikiAttachmentStoreInterface.class, storeType);
            }
            catch (ComponentLookupException e) {
                LOGGER.warn("Can't find attachment content store for type [{}]", (Object)storeType, (Object)e);
            }
        }
        return null;
    }

    public int getLocalReferenceMaxLength() {
        return this.getStore().getLimitSize(this.getXWikiContext(), this.getClass(), "fullName");
    }

    public DocumentAuthors getAuthors() {
        return this.authors;
    }

    @Unstable
    public void setAuthor(UserReference userReference) {
        this.getAuthors().setEffectiveMetadataAuthor(userReference);
        this.getAuthors().setOriginalMetadataAuthor(userReference);
    }

    private String getOriginalMetadataAuthorReference() {
        if (this.getAuthors().getOriginalMetadataAuthor() == null || this.getAuthors().getOriginalMetadataAuthor() == GuestUserReference.INSTANCE) {
            return "";
        }
        return this.userReferenceToString(this.getAuthors().getOriginalMetadataAuthor());
    }

    private void setOriginalMetadataAuthorReference(String serializedUserReference) {
        if (!StringUtils.isEmpty((CharSequence)serializedUserReference)) {
            UserReference userReference = this.userStringToUserReference(serializedUserReference);
            this.authors.setOriginalMetadataAuthor(userReference);
        }
    }

    public void initialize() {
        this.setSyntax(this.getSyntax());
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    static {
        XWikiDocumentCompatibilityAspect.ajc$interFieldInit$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$XWIKI10_SYNTAXID();
        XWikiDocumentCompatibilityAspect.ajc$interFieldInit$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$XWIKI20_SYNTAXID();
        LOGGER = LoggerFactory.getLogger(XWikiDocument.class);
        HTML_MACRO_SEARCH_STRINGS = new String[]{"{{html", "{{/html"};
        HTML_MACRO_REPLACE_STRINGS = new String[]{"&#123;&#123;html", "&#123;&#123;/html"};
        HTML_TAG_PATTERN = Pattern.compile("</?+(html|img|a|i|br?|embed|script|form|input|textarea|object|font|li|[dou]l|table|center|hr|p) ?([^>]*+)>");
        COMMENTSCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiComments");
        SHEETCLASS_REFERENCE = new LocalDocumentReference("XWiki", "SheetClass");
        LOCAL_REFERENCE_SERIALIZER = new LocalStringEntityReferenceSerializer((SymbolScheme)new DefaultSymbolScheme());
    }

    public static /* synthetic */ Content ajc$get$content(XWikiDocument xWikiDocument) {
        return xWikiDocument.content;
    }

    public static /* synthetic */ void ajc$set$content(XWikiDocument xWikiDocument, Content content) {
        xWikiDocument.content = content;
    }

    public static /* synthetic */ DocumentReference ajc$get$templateDocumentReference(XWikiDocument xWikiDocument) {
        return xWikiDocument.templateDocumentReference;
    }

    public static /* synthetic */ void ajc$set$templateDocumentReference(XWikiDocument xWikiDocument, DocumentReference documentReference) {
        xWikiDocument.templateDocumentReference = documentReference;
    }

    public static /* synthetic */ String ajc$get$title(XWikiDocument xWikiDocument) {
        return xWikiDocument.title;
    }

    public static /* synthetic */ void ajc$set$title(XWikiDocument xWikiDocument, String string) {
        xWikiDocument.title = string;
    }

    public static /* synthetic */ EntityReference ajc$get$parentReference(XWikiDocument xWikiDocument) {
        return xWikiDocument.parentReference;
    }

    public static /* synthetic */ void ajc$set$parentReference(XWikiDocument xWikiDocument, EntityReference entityReference) {
        xWikiDocument.parentReference = entityReference;
    }

    public static /* synthetic */ DocumentReferenceResolver ajc$privMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getCurrentMixedDocumentReferenceResolver() {
        return XWikiDocument.getCurrentMixedDocumentReferenceResolver();
    }

    public static /* synthetic */ Logger ajc$get$LOGGER() {
        return LOGGER;
    }

    public static /* synthetic */ void ajc$set$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    public /* synthetic */ XWikiContext ajc$privMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getXWikiContext() {
        return this.getXWikiContext();
    }

    public static /* synthetic */ EntityReferenceSerializer ajc$privMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getCompactWikiEntityReferenceSerializer() {
        return XWikiDocument.getCompactWikiEntityReferenceSerializer();
    }

    @Deprecated
    public BaseObject addObjectFromRequest(XWikiContext xWikiContext) throws XWikiException {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$addObjectFromRequest(this, xWikiContext);
    }

    @Deprecated
    public /* synthetic */ void ajc$interMethodDispatch2$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$deleteAttachment(XWikiAttachment xWikiAttachment, boolean bl, boolean bl2, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$deleteAttachment(this, xWikiAttachment, bl, bl2, xWikiContext);
    }

    @Deprecated
    public /* synthetic */ String ajc$interMethodDispatch2$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$extractTitle10() {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$extractTitle10(this);
    }

    public /* synthetic */ String ajc$interMethodDispatch2$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$serializeReference(DocumentReference documentReference, EntityReferenceSerializer<String> entityReferenceSerializer, DocumentReference documentReference2) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$serializeReference(this, documentReference, entityReferenceSerializer, documentReference2);
    }

    @Deprecated
    public void clonexWikiObjects(XWikiDocument xWikiDocument) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$clonexWikiObjects(this, xWikiDocument);
    }

    @Deprecated
    public void deleteAttachment(XWikiAttachment xWikiAttachment, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$deleteAttachment(this, xWikiAttachment, xWikiContext);
    }

    @Deprecated
    public void deleteAttachment(XWikiAttachment xWikiAttachment, boolean bl, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$deleteAttachment(this, xWikiAttachment, bl, xWikiContext);
    }

    @Deprecated
    public String displaySearch(PropertyClass propertyClass, String string, XWikiCriteria xWikiCriteria, XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$displaySearch(this, propertyClass, string, xWikiCriteria, xWikiContext);
    }

    @Deprecated(since="16.0RC1")
    public String displayTooltip(String string, XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$displayTooltip(this, string, xWikiContext);
    }

    @Deprecated(since="16.0RC1")
    public String displayTooltip(String string, BaseObject baseObject, XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$displayTooltip(this, string, baseObject, xWikiContext);
    }

    @Deprecated
    public String extractTitle() {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$extractTitle(this);
    }

    @Deprecated
    public List<String> getBacklinks(XWikiContext xWikiContext) throws XWikiException {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getBacklinks(this, xWikiContext);
    }

    @Deprecated
    public String getDisplayTitle(XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getDisplayTitle(this, xWikiContext);
    }

    @Deprecated
    public List<String> getLinkedPages(XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getLinkedPages(this, xWikiContext);
    }

    @Deprecated
    public List<XWikiLink> getLinks(XWikiContext xWikiContext) throws XWikiException {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getLinks(this, xWikiContext);
    }

    @Deprecated
    public String getRenderedContent(String string, XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getRenderedContent(this, string, xWikiContext);
    }

    @Deprecated
    public List<DocumentSection> getSplitSectionsAccordingToTitle() throws XWikiException {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getSplitSectionsAccordingToTitle(this);
    }

    @Deprecated
    public List<XWikiLink> getWikiLinkedPages(XWikiContext xWikiContext) throws XWikiException {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getWikiLinkedPages(this, xWikiContext);
    }

    @Deprecated
    public BaseClass getxWikiClass() {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getxWikiClass(this);
    }

    @Deprecated
    public List<BaseClass> getxWikiClasses(XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getxWikiClasses(this, xWikiContext);
    }

    @Deprecated
    public Map<String, Vector<BaseObject>> getxWikiObjects() {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$getxWikiObjects(this);
    }

    @Deprecated
    public void readFromTemplate(EditForm editForm, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$readFromTemplate(this, editForm, xWikiContext);
    }

    @Deprecated
    public void readFromTemplate(String string, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$readFromTemplate(this, string, xWikiContext);
    }

    @Deprecated
    public void rename(String string, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, string, xWikiContext);
    }

    @Deprecated
    public void rename(String string, List<String> list, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, string, list, xWikiContext);
    }

    @Deprecated
    public void rename(String string, List<String> list, List<String> list2, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, string, list, list2, xWikiContext);
    }

    @Deprecated(since="12.5RC1")
    public void rename(DocumentReference documentReference, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, documentReference, xWikiContext);
    }

    @Deprecated(since="12.5RC1")
    public void rename(DocumentReference documentReference, List<DocumentReference> list, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, documentReference, list, xWikiContext);
    }

    @Deprecated(since="12.5RC1")
    public void rename(DocumentReference documentReference, List<DocumentReference> list, List<DocumentReference> list2, XWikiContext xWikiContext) throws XWikiException {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$rename(this, documentReference, list, list2, xWikiContext);
    }

    @Deprecated
    public void setListValue(String string, String string2, List list) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setListValue(this, string, string2, list);
    }

    @Deprecated
    public void setObjects(String string, Vector<BaseObject> vector) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setObjects(this, string, vector);
    }

    @Deprecated
    public void setObjectsToRemove(ArrayList<BaseObject> arrayList) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setObjectsToRemove(this, arrayList);
    }

    @Deprecated
    public void setParentReference(DocumentReference documentReference) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setParentReference(this, documentReference);
    }

    @Deprecated
    public void setxWikiClass(BaseClass baseClass) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setxWikiClass(this, baseClass);
    }

    @Deprecated
    public void setxWikiObjects(Map<String, Vector<BaseObject>> map) {
        XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$setxWikiObjects(this, map);
    }

    @Deprecated
    public String toXML(Document document, XWikiContext xWikiContext) {
        return XWikiDocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_doc_XWikiDocumentCompatibilityAspect$com_xpn_xwiki_doc_XWikiDocument$toXML(this, document, xWikiContext);
    }

    private class Content {
        final String content;
        Syntax syntax;
        XDOM xdom;
        volatile LocalDateTime prepareDate;

        Content(String content, Syntax syntax) {
            this.content = StringUtils.defaultString((String)content);
            this.syntax = syntax;
        }
    }

    public static class XWikiAttachmentToRemove {
        private XWikiAttachment attachment;
        private boolean toRecycleBin;

        public XWikiAttachmentToRemove(XWikiAttachment attachment, boolean toRecycleBin) {
            this.attachment = attachment;
            this.toRecycleBin = toRecycleBin;
        }

        public XWikiAttachment getAttachment() {
            return this.attachment;
        }

        public boolean isToRecycleBin() {
            return this.toRecycleBin;
        }

        public int hashCode() {
            return this.attachment.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof XWikiAttachmentToRemove) {
                return this.attachment.equals(((XWikiAttachmentToRemove)obj).getAttachment());
            }
            return false;
        }

        public String toString() {
            return this.attachment.toString();
        }
    }
}

