/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDeletedDocumentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.store.hibernate.XWikiHibernateDeletedDocumentContent;
import com.xpn.xwiki.util.AbstractSimpleClass;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

public class XWikiDeletedDocument
extends AbstractSimpleClass {
    private long id;
    private String fullName;
    private Locale locale;
    private Date date;
    private String deleter;
    private String xmlStore;
    private XWikiDeletedDocumentContent content;
    private String batchId;

    protected XWikiDeletedDocument() {
    }

    private XWikiDeletedDocument(String fullName, Locale locale, String storeType, String deleter, Date deleteDate) throws XWikiException {
        this.fullName = fullName;
        this.locale = locale;
        this.deleter = deleter;
        this.date = deleteDate;
        this.xmlStore = storeType;
    }

    public XWikiDeletedDocument(XWikiDocument doc, String deleter, Date deleteDate, XWikiContext context) throws XWikiException {
        this(doc.getFullName(), doc.getLocale(), null, deleter, deleteDate);
        this.setDocument(doc, context);
    }

    public XWikiDeletedDocument(String fullName, Locale locale, String storeType, String deleter, Date deleteDate, XWikiDeletedDocumentContent content) throws XWikiException {
        this(fullName, locale, storeType, deleter, deleteDate);
        this.content = content;
    }

    public XWikiDeletedDocument(String fullName, Locale locale, String storeType, String deleter, Date deleteDate, XWikiDeletedDocumentContent content, String batchId) throws XWikiException {
        this(fullName, locale, storeType, deleter, deleteDate, content);
        this.batchId = batchId;
    }

    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void setFullName(String docFullName) {
        this.fullName = docFullName;
    }

    public DocumentReference getDocumentReference() {
        DocumentReference documentReference = XWikiDeletedDocument.getDocumentReferenceResolver().resolve((Object)this.getFullName(), new Object[0]);
        Locale localeValue = this.getLocale();
        if (localeValue != null) {
            documentReference = new DocumentReference((EntityReference)documentReference, localeValue);
        }
        return documentReference;
    }

    private static DocumentReferenceResolver<String> getDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    }

    @Deprecated
    public String getLanguage() {
        return this.getLocale().toString();
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.ROOT;
    }

    @Deprecated
    protected void setLanguage(String locale) {
        this.locale = LocaleUtils.toLocale((String)Util.normalizeLanguage(locale), (Locale)Locale.ROOT);
    }

    public Date getDate() {
        return this.date;
    }

    protected void setDate(Date date) {
        this.date = date;
    }

    public String getDeleter() {
        return this.deleter;
    }

    public DocumentReference getDeleterReference() {
        return XWikiDeletedDocument.getDocumentReferenceResolver().resolve((Object)this.deleter, new Object[0]);
    }

    protected void setDeleter(String deleter) {
        this.deleter = deleter;
    }

    public String getXmlStore() {
        return this.xmlStore;
    }

    protected void setXmlStore(String xmlStore) {
        this.xmlStore = xmlStore;
    }

    public String getXml() {
        if (this.content != null) {
            try {
                return this.content.getContentAsString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    protected void setXml(String xml) {
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            try {
                this.content = new XWikiHibernateDeletedDocumentContent(xml);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    protected void setDocument(XWikiDocument doc, XWikiContext context) throws XWikiException {
        this.content = new XWikiHibernateDeletedDocumentContent(doc);
    }

    public XWikiDocument restoreDocument(XWikiDocument doc, XWikiContext context) throws XWikiException {
        if (this.content == null) {
            throw new XWikiException(2, 2002, "Cannot find any content for the deleted document [" + this.fullName + " (" + String.valueOf(this.locale) + ")]");
        }
        try {
            return this.content.getXWikiDocument(doc);
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error restoring document", e, null);
        }
    }

    public XWikiDocument restoreDocument(XWikiContext context) throws XWikiException {
        return this.restoreDocument(null, context);
    }

    protected void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("fullName", (Object)this.fullName).append("locale", (Object)this.locale).toString();
    }
}

