/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.xwiki.environment.Environment;
import org.xwiki.store.UnexpectedException;

public class XWikiAttachmentContent
implements Cloneable {
    private static final byte[] NULLFILE = new byte[0];
    private XWikiAttachment attachment;
    private boolean isContentDirty;
    private FileItem file;
    private XWikiDocument ownerDocument;

    public XWikiAttachmentContent(XWikiAttachmentContent original) {
        this.file = original.file;
        this.attachment = original.attachment;
        this.isContentDirty = original.isContentDirty;
        this.ownerDocument = original.ownerDocument;
    }

    public XWikiAttachmentContent(XWikiAttachment attachment) {
        this.setAttachment(attachment);
    }

    public XWikiAttachmentContent() {
    }

    protected XWikiAttachmentContent(XWikiAttachment attachment, FileItem f) {
        this.setAttachment(attachment);
        this.file = f;
    }

    protected FileItem getFileItem() {
        return this.file;
    }

    private static FileItem getNewFileItem() {
        Environment env = Utils.getComponent(Environment.class);
        File dir = new File(env.getTemporaryDirectory(), "attachment-cache");
        try {
            if (!dir.mkdirs() && !dir.exists()) {
                throw new UnexpectedException("Failed to create directory for attachments " + String.valueOf(dir));
            }
            DiskFileItem dfi = new DiskFileItem(null, null, false, null, 10000, dir);
            dfi.getOutputStream().close();
            return dfi;
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to create new attachment temporary file.", (Throwable)e);
        }
    }

    public long getId() {
        return this.attachment.getId();
    }

    public void setId(long id) {
    }

    public Object clone() {
        return new XWikiAttachmentContent(this);
    }

    @Deprecated
    public byte[] getContent() {
        if (this.file == null) {
            return NULLFILE;
        }
        return this.file.get();
    }

    @Deprecated
    public void setContent(byte[] content) {
        try {
            byte[] internalContent = new byte[]{};
            if (content != null) {
                internalContent = content;
            }
            this.setContent(new ByteArrayInputStream(internalContent));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy data to storage.", e);
        }
    }

    public XWikiAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(XWikiAttachment attachment) {
        this.attachment = attachment;
        if (this.attachment != null) {
            this.setOwnerDocument(this.attachment.getDoc());
        }
    }

    public boolean isContentDirty() {
        return this.isContentDirty;
    }

    public void setContentDirty(boolean contentDirty) {
        this.isContentDirty = contentDirty;
        if (contentDirty && this.ownerDocument != null) {
            this.ownerDocument.setMetaDataDirty(contentDirty);
        }
    }

    public boolean exists() {
        return true;
    }

    public InputStream getContentInputStream() {
        if (this.file == null) {
            return new ByteArrayInputStream(NULLFILE);
        }
        try {
            return new AutoCloseInputStream(this.file.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get InputStream", e);
        }
    }

    public OutputStream getContentOutputStream() {
        OutputStream fios;
        final FileItem fi = XWikiAttachmentContent.getNewFileItem();
        final XWikiAttachmentContent xac = this;
        try {
            fios = fi.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception getting attachment OutputStream.", e);
        }
        return new ProxyOutputStream(fios){

            public void close() throws IOException {
                super.close();
                xac.file = fi;
                xac.setContentDirty(true);
                if (xac.attachment != null) {
                    xac.attachment.setLongSize(xac.getLongSize());
                }
            }
        };
    }

    public void setContent(InputStream is, int len) throws IOException {
        this.setContent((InputStream)new BoundedInputStream(is, (long)len));
    }

    public void setContent(InputStream is) throws IOException {
        try (OutputStream fios = this.getContentOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)fios);
        }
        this.setContentDirty(true);
    }

    @Deprecated
    public int getSize() {
        long longSize = this.getLongSize();
        return longSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longSize;
    }

    public long getLongSize() {
        return this.file != null ? this.file.getSize() : -1L;
    }

    public void setOwnerDocument(XWikiDocument ownerDocument) {
        if (this.ownerDocument != ownerDocument) {
            this.ownerDocument = ownerDocument;
            if (this.isContentDirty && ownerDocument != null) {
                ownerDocument.setMetaDataDirty(true);
            }
        }
    }

    public void dispose() {
        if (this.file != null && this.isContentDirty()) {
            this.file.delete();
            this.file = null;
        }
    }
}

