/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterUtils;
import com.xpn.xwiki.internal.xml.XMLWriter;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.web.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Result;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tika.mime.MediaType;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.output.DefaultWriterOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.filter.xml.output.DefaultResultOutputTarget;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;
import org.xwiki.tika.internal.TikaUtils;

public class XWikiAttachment
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiAttachment.class);
    private XWikiDocument doc;
    private Long size;
    private String mimeType;
    private String charset;
    private String filename = "";
    private String author;
    private DocumentReference authorReference;
    private Version version;
    private String comment = "";
    private Date date = new Date();
    private String contentStore;
    private boolean contentStoreSet;
    private XWikiAttachmentStoreInterface contentStoreInstance;
    private String archiveStore;
    private boolean archiveStoreSet;
    private AttachmentVersioningStore archiveStoreInstance;
    private XWikiAttachmentContent content;
    private XWikiAttachmentArchive attachment_archive;
    private boolean isMetaDataDirty = false;
    private AttachmentReference reference;
    private boolean forceSetFilesize = false;
    private AttachmentContainer container;

    private static EntityReferenceSerializer<String> getCompactWikiEntityReferenceSerializer() {
        return (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    }

    private static EntityReferenceResolver<String> getXClassEntityReferenceResolver() {
        return (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "xclass");
    }

    private DocumentReferenceResolver<EntityReference> getExplicitReferenceDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, "explicit");
    }

    private AttachmentReferenceResolver<String> getCurentAttachmentReferenceResolver() {
        return (AttachmentReferenceResolver)Utils.getComponent(AttachmentReferenceResolver.TYPE_STRING, "current");
    }

    public XWikiAttachment(XWikiDocument doc, String filename) {
        this();
        this.setDoc(doc);
        this.setFilename(filename);
        this.forceSetFilesize = true;
    }

    public XWikiAttachment() {
    }

    public AttachmentReference getReference() {
        if (this.reference == null) {
            if (this.doc != null) {
                this.reference = new AttachmentReference(this.filename, this.doc.getDocumentReference());
            } else {
                return this.getCurentAttachmentReferenceResolver().resolve((Object)this.filename, new Object[0]);
            }
        }
        return this.reference;
    }

    public long getId() {
        if (this.doc == null) {
            return this.filename.hashCode();
        }
        return (this.doc.getFullName() + "/" + this.filename).hashCode();
    }

    public void setDocId(long id) {
    }

    public long getDocId() {
        return this.doc.getId();
    }

    public void setId(long id) {
    }

    public XWikiAttachment clone() {
        return this.internalClone(false, false);
    }

    public XWikiAttachment clone(String name, XWikiContext context) throws XWikiException, IOException {
        XWikiAttachment clone = this.internalClone(true, true);
        if (clone == null) {
            throw new XWikiException("Failed to clone the attachment", null);
        }
        clone.setFilename(name);
        clone.setContent(this.getContentInputStream(context));
        clone.setAttachment_archive(this.getAttachmentArchive(context).clone(clone, context));
        return clone;
    }

    @Deprecated
    public int getFilesize() {
        long longSize = this.getLongSize();
        return longSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longSize;
    }

    @Deprecated
    public void setFilesize(int filesize) {
        if (filesize >= 0 || filesize < Integer.MAX_VALUE || this.forceSetFilesize) {
            this.setLongSize(filesize);
        }
    }

    public long getLongSize() {
        XWikiAttachmentContent attachmentContent = this.getAttachment_content();
        if (attachmentContent != null) {
            this.size = attachmentContent.getLongSize();
        }
        return this.size == null ? -1L : this.size;
    }

    public void setLongSize(long size) {
        if (this.size == null || size != this.size) {
            this.setMetaDataDirty(true);
        }
        this.size = size;
    }

    @Deprecated
    public int getContentSize(XWikiContext context) throws XWikiException {
        long longSize = this.getContentLongSize(context);
        return longSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longSize;
    }

    public long getContentLongSize(XWikiContext context) throws XWikiException {
        if (this.content == null && context != null) {
            this.loadAttachmentContent(context);
        }
        return this.content != null ? this.content.getLongSize() : -1L;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (ObjectUtils.notEqual((Object)this.getFilename(), (Object)filename)) {
            this.setMetaDataDirty(true);
            String previousFileName = this.getFilename();
            this.filename = filename;
            this.notificateNameModifed(previousFileName, this);
        }
        this.reference = null;
    }

    public DocumentReference getAuthorReference() {
        if (this.authorReference == null) {
            if (this.doc != null) {
                this.authorReference = this.userStringToReference(this.author);
            } else {
                return this.userStringToReference(this.author);
            }
        }
        return this.authorReference;
    }

    public void setAuthorReference(DocumentReference authorReference) {
        if (ObjectUtils.notEqual((Object)authorReference, (Object)this.getAuthorReference())) {
            this.setMetaDataDirty(true);
        }
        this.authorReference = authorReference;
        this.author = null;
        if (this.authorReference != null && this.authorReference.getName().equals("XWikiGuest")) {
            LOGGER.warn("A reference to XWikiGuest user has been set instead of null. This is probably a mistake.", (Throwable)new Exception("See stack trace"));
        }
    }

    @Deprecated
    public String getAuthor() {
        if (this.author == null) {
            this.author = this.userReferenceToString(this.getAuthorReference());
        }
        return this.author != null ? this.author : "";
    }

    @Deprecated
    public void setAuthor(String author) {
        if (!Objects.equals(this.getAuthor(), author)) {
            this.author = author;
            this.authorReference = null;
            this.setMetaDataDirty(true);
        }
    }

    public String getVersion() {
        return this.getRCSVersion().toString();
    }

    public void setVersion(String version) {
        this.version = new Version(version);
    }

    public String getNextVersion() {
        if (this.version == null) {
            return "1.1";
        }
        return ((Version)this.version.clone()).next().toString();
    }

    public Version getRCSVersion() {
        if (this.version == null) {
            return new Version("1.1");
        }
        return (Version)this.version.clone();
    }

    public void setRCSVersion(Version version) {
        this.version = version;
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    public void setComment(String comment) {
        if (ObjectUtils.notEqual((Object)this.getComment(), (Object)comment)) {
            this.setMetaDataDirty(true);
            this.comment = comment;
        }
    }

    public XWikiDocument getDoc() {
        return this.doc;
    }

    public void setDoc(XWikiDocument doc) {
        this.setDoc(doc, true);
    }

    public void setDoc(XWikiDocument doc, boolean updateDirty) {
        if (this.doc != doc) {
            this.doc = doc;
            this.reference = null;
            if (updateDirty) {
                if (this.isMetaDataDirty() && doc != null) {
                    doc.setMetaDataDirty(true);
                }
                if (this.getAttachment_content() != null) {
                    this.getAttachment_content().setOwnerDocument(doc);
                }
            }
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date != null) {
            date.setTime(date.getTime() / 1000L * 1000L);
        }
        this.date = date;
    }

    public boolean isContentDirty() {
        if (this.content == null) {
            return false;
        }
        return this.content.isContentDirty();
    }

    public void incrementVersion() {
        this.version = this.version == null ? new Version("1.1") : this.version.next();
    }

    public boolean isMetaDataDirty() {
        return this.isMetaDataDirty;
    }

    public void setMetaDataDirty(boolean metaDataDirty) {
        this.isMetaDataDirty = metaDataDirty;
        if (metaDataDirty && this.doc != null) {
            this.doc.setMetaDataDirty(true);
        }
    }

    @Unstable
    public void setDirty(boolean dirty, boolean deep) {
        this.setMetaDataDirty(dirty);
        if (deep && this.content != null) {
            this.content.setContentDirty(dirty);
        }
    }

    public String toStringXML(boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException {
        try {
            StringWriter writer = new StringWriter();
            this.toXML((OutputTarget)new DefaultWriterOutputTarget((Writer)writer), bWithAttachmentContent, bWithVersions, true, context);
            return writer.toString();
        }
        catch (IOException e) {
            LOGGER.error("Failed to write attachment XML", (Throwable)e);
            return "";
        }
    }

    public String toXML() throws XWikiException {
        StringWriter writer = new StringWriter();
        this.toXML((OutputTarget)new DefaultWriterOutputTarget((Writer)writer), true, true, true, StandardCharsets.UTF_8.name());
        return writer.toString();
    }

    public Element toXML(XWikiContext context) throws XWikiException {
        return this.toXML(false, false, context);
    }

    public void toXML(XMLWriter wr, boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws IOException, XWikiException {
        DocumentResult domResult = new DocumentResult();
        this.toXML((OutputTarget)new DefaultResultOutputTarget((Result)domResult), bWithAttachmentContent, bWithVersions, true, context);
        wr.write(domResult.getDocument().getRootElement());
    }

    public void toXML(OutputTarget out, boolean bWithAttachmentContent, boolean bWithVersions, boolean format, XWikiContext context) throws IOException, XWikiException {
        this.toXML(out, bWithAttachmentContent, bWithVersions, format, context.getWiki().getEncoding());
    }

    public void toXML(OutputTarget out, boolean bWithAttachmentContent, boolean bWithVersions, boolean format, String encoding) throws XWikiException {
        DocumentInstanceInputProperties documentProperties = new DocumentInstanceInputProperties();
        documentProperties.setWithWikiAttachmentsContent(bWithAttachmentContent);
        documentProperties.setWithJRCSRevisions(bWithVersions);
        documentProperties.setWithRevisions(false);
        XAROutputProperties xarProperties = new XAROutputProperties();
        xarProperties.setPreserveVersion(bWithVersions);
        xarProperties.setEncoding(encoding);
        xarProperties.setFormat(format);
        try {
            Utils.getComponent(XWikiDocumentFilterUtils.class).exportEntity(this, out, xarProperties, documentProperties);
        }
        catch (Exception e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
    }

    public Element toXML(boolean bWithAttachmentContent, boolean bWithVersions, XWikiContext context) throws XWikiException {
        DocumentResult domResult = new DocumentResult();
        try {
            this.toXML((OutputTarget)new DefaultResultOutputTarget((Result)domResult), bWithAttachmentContent, bWithVersions, true, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return domResult.getDocument().getRootElement();
    }

    public void fromXML(String source) throws XWikiException {
        if (!source.isEmpty()) {
            this.fromXML((InputSource)new StringInputSource(source));
        }
    }

    public void fromXML(InputSource source) throws XWikiException {
        try {
            Utils.getComponent(XWikiDocumentFilterUtils.class).importEntity(this, source);
        }
        catch (Exception e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
        this.setMetaDataDirty(false);
    }

    public void fromXML(Element docel) throws XWikiException {
        StringWriter writer = new StringWriter();
        try {
            org.dom4j.io.XMLWriter domWriter = new org.dom4j.io.XMLWriter((Writer)writer);
            domWriter.write(docel);
            domWriter.flush();
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error parsing xml", e, null);
        }
        this.fromXML(writer.toString());
    }

    public String getContentStore() {
        return this.contentStore;
    }

    public boolean isContentStoreSet() {
        return this.contentStoreSet;
    }

    public void setContentStore(String contentStore) {
        this.contentStore = contentStore;
        this.contentStoreSet = true;
    }

    public XWikiAttachmentContent getAttachmentContent(XWikiContext xcontext) throws XWikiException {
        this.loadAttachmentContent(xcontext);
        return this.getAttachment_content();
    }

    public boolean contentExists(XWikiContext xcontext) throws XWikiException {
        if (this.content != null) {
            return this.content.exists();
        }
        XWikiAttachmentStoreInterface store = this.getAttachmentContentStore(xcontext);
        return store.attachmentContentExists(this, xcontext, true);
    }

    public XWikiAttachmentContent getAttachment_content() {
        return this.content;
    }

    public void setAttachment_content(XWikiAttachmentContent attachment_content) {
        this.content = attachment_content;
        if (this.content != null) {
            this.content.setAttachment(this);
        }
    }

    public String getArchiveStore() {
        return this.archiveStore;
    }

    public boolean isArchiveStoreSet() {
        return this.archiveStoreSet;
    }

    public void setArchiveStore(String archiveStore) {
        this.archiveStore = archiveStore;
        this.archiveStoreSet = true;
    }

    public XWikiAttachmentArchive getAttachmentArchive(XWikiContext xcontext) throws XWikiException {
        this.loadArchive(xcontext);
        return this.getAttachment_archive();
    }

    public XWikiAttachmentArchive getAttachment_archive() {
        return this.attachment_archive;
    }

    public void setAttachment_archive(XWikiAttachmentArchive attachment_archive) {
        this.attachment_archive = attachment_archive;
    }

    @Deprecated
    public byte[] getContent(XWikiContext xcontext) throws XWikiException {
        InputStream inputStream = this.getContentInputStream(xcontext);
        if (inputStream != null) {
            try {
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                return byArray;
            }
            catch (IOException e) {
                throw new XWikiException("Failed to read attachment content", e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close attachment content input stream: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
        }
        return null;
    }

    public InputStream getContentInputStream(XWikiContext xcontext) throws XWikiException {
        if (this.content == null && xcontext != null) {
            this.reloadAttachmentContent(xcontext);
        } else {
            try {
                return this.getContentInputStream();
            }
            catch (Exception e) {
                this.reloadAttachmentContent(xcontext);
            }
        }
        return this.getContentInputStream();
    }

    private InputStream getContentInputStream() {
        return this.content != null ? this.content.getContentInputStream() : null;
    }

    private void reloadAttachmentContent(XWikiContext xcontext) throws XWikiException {
        if (Objects.equals(this.getVersion(), this.getLatestStoredVersion(xcontext))) {
            this.loadAttachmentContent(xcontext);
        } else {
            XWikiAttachmentContent archivedContent;
            XWikiAttachment archivedVersion = this.loadArchive(xcontext).getRevision(this, this.getVersion(), xcontext);
            XWikiAttachmentContent xWikiAttachmentContent = archivedContent = archivedVersion != null ? archivedVersion.getAttachment_content() : null;
            if (archivedContent != null) {
                this.setAttachment_content(archivedContent);
            }
        }
    }

    private String getLatestStoredVersion(XWikiContext context) {
        try {
            XWikiDocument ownerDocumentLastestVersion = context.getWiki().getDocument(this.doc.getDocumentReference(), context);
            XWikiAttachment latestStoredVersion = ownerDocumentLastestVersion.getAttachment(this.filename);
            return latestStoredVersion != null ? latestStoredVersion.getVersion() : null;
        }
        catch (XWikiException e) {
            LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    @Deprecated
    public Archive getArchive() {
        if (this.attachment_archive == null) {
            return null;
        }
        return this.attachment_archive.getRCSArchive();
    }

    @Deprecated
    public void setArchive(Archive archive) {
        if (this.attachment_archive == null) {
            this.attachment_archive = new XWikiAttachmentArchive();
            this.attachment_archive.setAttachment(this);
        }
        this.attachment_archive.setRCSArchive(archive);
    }

    public void setArchive(String data) throws XWikiException {
        if (this.attachment_archive == null) {
            this.attachment_archive = new XWikiAttachmentArchive();
            this.attachment_archive.setAttachment(this);
        }
        this.attachment_archive.setArchive(data);
    }

    public synchronized Version[] getVersions() {
        try {
            return this.getAttachment_archive().getVersions();
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot retrieve versions of attachment [{}@{}]: {}", new Object[]{this.getFilename(), this.getDoc().getDocumentReference(), ex.getMessage()});
            return new Version[]{new Version(this.getVersion())};
        }
    }

    public List<Version> getVersionList() throws XWikiException {
        ArrayList<Version> list = new ArrayList<Version>();
        String currentVersion = this.version.toString();
        Version v = new Version("1.1");
        while (true) {
            list.add(v);
            if (v.toString().equals(currentVersion)) break;
            v = v.next();
        }
        return list;
    }

    @Deprecated
    public void setContent(byte[] data) {
        if (this.content == null) {
            this.content = new XWikiAttachmentContent();
            this.content.setAttachment(this);
        }
        this.content.setContent(data);
        this.size = this.content.getLongSize();
    }

    public void setContent(InputStream is, int length) throws IOException {
        if (this.content == null) {
            this.content = new XWikiAttachmentContent();
            this.content.setAttachment(this);
        }
        this.content.setContent(is, length);
        this.size = this.content.getLongSize();
    }

    public void setContent(InputStream is) throws IOException {
        if (this.content == null) {
            this.content = new XWikiAttachmentContent(this);
        }
        this.content.setContent(is);
        this.size = this.content.getLongSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAttachmentContent(XWikiContext xcontext) throws XWikiException {
        if (this.content == null) {
            WikiReference currentWiki = xcontext.getWikiReference();
            try {
                WikiReference attachmentWiki = this.getReference().getDocumentReference().getWikiReference();
                if (attachmentWiki != null) {
                    xcontext.setWikiReference(attachmentWiki);
                }
                XWikiAttachmentStoreInterface store = this.getAttachmentContentStore(xcontext);
                store.loadAttachmentContent(this, xcontext, true);
            }
            finally {
                if (currentWiki != null) {
                    xcontext.setWikiReference(currentWiki);
                }
            }
        }
    }

    @Deprecated
    public void loadContent(XWikiContext xcontext) {
        try {
            this.loadAttachmentContent(xcontext);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load content for attachment [{}@{}]. This attachment is broken, please consider re-uploading it", new Object[]{this.doc != null ? this.doc.getDocumentReference() : "<unknown>", this.getFilename(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiAttachmentArchive loadArchive(XWikiContext xcontext) {
        if (this.attachment_archive == null) {
            WikiReference currentWiki = xcontext.getWikiReference();
            try {
                WikiReference attachmentWiki = this.getReference().getDocumentReference().getWikiReference();
                if (attachmentWiki != null) {
                    xcontext.setWikiReference(attachmentWiki);
                }
                try {
                    AttachmentVersioningStore store = this.getAttachmentVersioningStore(xcontext);
                    this.attachment_archive = store.loadArchive(this, xcontext, true);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load archive for attachment [{}@{}]. This attachment is broken, please consider re-uploading it", new Object[]{this.doc != null ? this.doc.getDocumentReference() : "<unknown>", this.getFilename(), e});
                }
            }
            finally {
                if (currentWiki != null) {
                    xcontext.setWikiReference(currentWiki);
                }
            }
        }
        return this.attachment_archive;
    }

    public void updateContentArchive(XWikiContext context) throws XWikiException {
        if (this.content == null) {
            return;
        }
        this.loadArchive(context).updateArchive(context);
    }

    public String getMimeType(XWikiContext xcontext) {
        String type = this.getMimeType();
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = this.extractMimeType(xcontext);
        }
        return type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (!Objects.equals(mimeType, this.mimeType)) {
            this.mimeType = mimeType;
            this.setMetaDataDirty(true);
        }
    }

    public void resetMimeType(XWikiContext xcontext) {
        this.mimeType = this.extractMimeType(xcontext);
    }

    private String extractMimeType(XWikiContext xcontext) {
        String mediaType;
        String string = mediaType = this.getFilename() != null ? TikaUtils.detect((String)this.getFilename()) : MediaType.OCTET_STREAM.toString();
        if (MediaType.OCTET_STREAM.toString().equals(mediaType)) {
            try {
                mediaType = TikaUtils.detect((InputStream)new BufferedInputStream(this.getContentInputStream(xcontext)));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read the content of [{}] in order to detect its mime type. Root cause: [{}]", (Object)this.getReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return mediaType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isImage(XWikiContext context) {
        String contenttype = this.getMimeType(context);
        return contenttype.startsWith("image/");
    }

    public XWikiAttachment getAttachmentRevision(String rev, XWikiContext context) throws XWikiException {
        if (Strings.CS.equals(rev, this.getVersion())) {
            return this;
        }
        return this.loadArchive(context).getRevision(this, rev, context);
    }

    public boolean apply(XWikiAttachment attachment) {
        boolean modified;
        block10: {
            modified = false;
            if (this.getLongSize() != attachment.getLongSize()) {
                this.setLongSize(attachment.getLongSize());
                modified = true;
            }
            if (Strings.CS.equals(this.getMimeType(), attachment.getMimeType())) {
                this.setMimeType(attachment.getMimeType());
                modified = true;
            }
            try {
                if (!this.isContentDifferentButNotNull(attachment)) break block10;
                try (InputStream attachmentIs = attachment.getContentInputStream(null);){
                    this.setContent(attachment.getContentInputStream(null));
                    modified = true;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to set content of attachment [{}] onto [{}]", new Object[]{this, attachment, e});
            }
        }
        return modified;
    }

    private boolean isContentDifferentButNotNull(XWikiAttachment attachment) throws Exception {
        boolean isDifferent;
        block14: {
            isDifferent = false;
            try (InputStream attachmentIs = attachment.getContentInputStream(null);){
                if (attachmentIs == null) break block14;
                if (this.content == null) {
                    isDifferent = true;
                    break block14;
                }
                try (InputStream is = this.getContentInputStream(null);){
                    if (is != null && !IOUtils.contentEquals((InputStream)is, (InputStream)attachmentIs)) {
                        isDifferent = true;
                    }
                }
            }
        }
        return isDifferent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean equalsData(XWikiAttachment otherAttachment, XWikiContext xcontext) throws XWikiException {
        block9: {
            try {
                InputStream is;
                if (this.getContentLongSize(xcontext) != otherAttachment.getContentLongSize(xcontext) || (is = this.getContentInputStream(xcontext)) == null) break block9;
                try {
                    InputStream otherIS = otherAttachment.getContentInputStream(xcontext);
                    if (otherIS != null) {
                        boolean bl;
                        try {
                            bl = IOUtils.contentEquals((InputStream)is, (InputStream)otherIS);
                        }
                        catch (Throwable throwable) {
                            otherIS.close();
                            throw throwable;
                        }
                        otherIS.close();
                        return bl;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                throw new XWikiException(2, 0, "Failed to compare attachments", e);
            }
        }
        return false;
    }

    public void merge(XWikiAttachment previousAttachment, XWikiAttachment nextAttachment, MergeConfiguration configuration, XWikiContext xcontext, MergeResult mergeResult) {
        try {
            if (this.equalsData(previousAttachment, xcontext)) {
                this.apply(nextAttachment);
                mergeResult.setModified(true);
            } else if (this.equals(nextAttachment)) {
                mergeResult.getLog().warn("Attachment [{}] already modified", (Object)this.getReference());
            }
        }
        catch (Exception e) {
            mergeResult.getLog().error("Failed to merge attachment [{}]", (Object)this, (Object)e);
        }
    }

    private String userReferenceToString(DocumentReference userReference) {
        String userString = userReference != null ? (String)XWikiAttachment.getCompactWikiEntityReferenceSerializer().serialize((EntityReference)userReference, new Object[]{this.getReference()}) : "XWiki.XWikiGuest";
        return userString;
    }

    private DocumentReference userStringToReference(String userString) {
        DocumentReference userReference;
        if (StringUtils.isEmpty((CharSequence)userString)) {
            userReference = null;
        } else {
            userReference = this.getExplicitReferenceDocumentReferenceResolver().resolve((Object)XWikiAttachment.getXClassEntityReferenceResolver().resolve((Object)userString, EntityType.DOCUMENT, new Object[0]), new Object[]{this.getReference()});
            if (userReference.getName().equals("XWikiGuest")) {
                userReference = null;
            }
        }
        return userReference;
    }

    private XWikiAttachmentStoreInterface getAttachmentContentStore(XWikiContext xcontext) throws XWikiException {
        try {
            if (this.contentStoreInstance == null) {
                if (!this.contentStoreSet) {
                    this.contentStoreInstance = xcontext.getWiki().getDefaultAttachmentContentStore();
                    this.setContentStore(this.contentStoreInstance.getHint());
                } else {
                    String hint = this.getContentStore();
                    if (hint != null) {
                        this.contentStoreInstance = (XWikiAttachmentStoreInterface)Utils.getContextComponentManager().getInstance(XWikiAttachmentStoreInterface.class, hint);
                    } else {
                        return (XWikiAttachmentStoreInterface)Utils.getContextComponentManager().getInstance(XWikiAttachmentStoreInterface.class, "hibernate");
                    }
                }
            }
            return this.contentStoreInstance;
        }
        catch (ComponentLookupException e) {
            throw new XWikiException("Failed to find store for attachment [" + String.valueOf(this.getReference()) + "]", e);
        }
    }

    private AttachmentVersioningStore getAttachmentVersioningStore(XWikiContext xcontext) throws ComponentLookupException {
        if (this.archiveStoreInstance == null) {
            if (!this.archiveStoreSet) {
                this.archiveStoreInstance = xcontext.getWiki().getDefaultAttachmentArchiveStore();
                this.setArchiveStore(this.archiveStoreInstance.getHint());
            } else {
                String hint = this.getArchiveStore();
                this.archiveStoreInstance = hint != null ? (AttachmentVersioningStore)Utils.getContextComponentManager().getInstance(AttachmentVersioningStore.class, hint) : (AttachmentVersioningStore)Utils.getContextComponentManager().getInstance(AttachmentVersioningStore.class, "hibernate");
            }
        }
        return this.archiveStoreInstance;
    }

    public void setAttachmentContainer(AttachmentContainer container) {
        this.container = container;
    }

    private void notificateNameModifed(String previousAttachmentName, XWikiAttachment attachment) {
        if (this.container != null) {
            this.container.onAttachmentNameModified(previousAttachmentName, attachment);
        }
    }

    private XWikiAttachment internalClone(boolean skipArchive, boolean skipContent) {
        XWikiAttachment attachment = null;
        try {
            attachment = (XWikiAttachment)super.clone();
            attachment.setDoc(null, false);
            attachment.setComment(this.getComment());
            attachment.setDate(this.getDate());
            attachment.setFilename(this.getFilename());
            attachment.setMimeType(this.getMimeType());
            attachment.setLongSize(this.getLongSize());
            attachment.setRCSVersion(this.getRCSVersion());
            attachment.setMetaDataDirty(this.isMetaDataDirty());
            if (!skipContent && this.getAttachment_content() != null) {
                attachment.setAttachment_content((XWikiAttachmentContent)this.getAttachment_content().clone());
                attachment.getAttachment_content().setAttachment(attachment);
            }
            if (!skipArchive && this.getAttachment_archive() != null) {
                attachment.setAttachment_archive((XWikiAttachmentArchive)this.getAttachment_archive().clone());
                attachment.getAttachment_archive().setAttachment(attachment);
            }
            attachment.container = null;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("exception while attach.clone", (Throwable)e);
        }
        return attachment;
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("parentReference", (Object)this.getDoc().getDocumentReference());
        builder.append("filename", (Object)this.getFilename());
        builder.append("version", (Object)this.getVersion());
        return builder.toString();
    }

    public static interface AttachmentContainer {
        public void onAttachmentNameModified(String var1, XWikiAttachment var2);
    }
}

