/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.criteria.impl;

public class Scope {
    public static final int PAGE_SCOPE = 1;
    public static final int SPACE_SCOPE = 2;
    public static final int WIKI_SCOPE = 3;
    public static final int GLOBAL_SCOPE = 4;
    private int type;
    private String name;
    private boolean deep;

    public Scope(int type, String name, boolean deep) {
        this.type = type;
        this.name = name;
        this.deep = deep;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public String getPattern() {
        switch (this.type) {
            case 1: {
                return this.getPagePattern();
            }
            case 2: {
                return this.getSpacePattern();
            }
        }
        return this.getGlobalPattern();
    }

    private String getPagePattern() {
        if ("".equals(this.name)) {
            return "%.%";
        }
        return this.name;
    }

    private String getSpacePattern() {
        if ("".equals(this.name)) {
            return null;
        }
        if (this.deep) {
            return this.name + ".%";
        }
        return this.name;
    }

    private String getGlobalPattern() {
        return "";
    }
}

