/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.criteria.impl;

import com.xpn.xwiki.criteria.impl.Period;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PeriodFactory {
    private static final DateTime MIN_DATE = new DateTime(1000, 1, 1, 0, 0, 0, 0);
    private static final DateTime MAX_DATE = new DateTime(9999, 12, 31, 23, 59, 59, 999);
    public static final Period ALL_TIME = PeriodFactory.createPeriod(MIN_DATE.getMillis(), MAX_DATE.getMillis());
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyyMMdd");

    public static Period createPeriod(long start, long end) {
        return new Period(start, end);
    }

    public static Period createPeriod(String start, String end) {
        return PeriodFactory.createPeriod(formatter.parseMillis(start), formatter.parseMillis(end));
    }

    public static Period createDayPeriod(long timestamp) {
        MutableDateTime mdt = new MutableDateTime(timestamp);
        return PeriodFactory.createPeriod(PeriodFactory.toDayStart(mdt).getMillis(), PeriodFactory.toDayEnd(mdt).getMillis());
    }

    public static Period createDayPeriod(String date) {
        return PeriodFactory.createDayPeriod(formatter.parseMillis(date));
    }

    public static Period createHourPeriod(long timestamp) {
        MutableDateTime mdt = new MutableDateTime(timestamp);
        return PeriodFactory.createPeriod(PeriodFactory.toHourStart(mdt).getMillis(), PeriodFactory.toHourEnd(mdt).getMillis());
    }

    public static Period createHourPeriod(String date) {
        return PeriodFactory.createHourPeriod(formatter.parseMillis(date));
    }

    public static Period createSinceHoursPeriod(int numberOfHours) {
        DateTime dt = new DateTime();
        return PeriodFactory.createPeriod(dt.minusHours(numberOfHours).getMillis(), dt.getMillis());
    }

    public static Period createSinceDaysPeriod(int numberOfDays) {
        DateTime dt = new DateTime();
        return PeriodFactory.createPeriod(dt.minusDays(numberOfDays).getMillis(), dt.getMillis());
    }

    public static Period createSinceWeeksPeriod(int numberOfWeeks) {
        DateTime dt = new DateTime();
        return PeriodFactory.createPeriod(dt.minusWeeks(numberOfWeeks).getMillis(), dt.getMillis());
    }

    public static Period createSinceMonthsPeriod(int numberOfMonths) {
        DateTime dt = new DateTime();
        return PeriodFactory.createPeriod(dt.minusMonths(numberOfMonths).getMillis(), dt.getMillis());
    }

    public static Period createSinceYearsPeriod(int numberOfYears) {
        DateTime dt = new DateTime();
        return PeriodFactory.createPeriod(dt.minusYears(numberOfYears).getMillis(), dt.getMillis());
    }

    public static Period getCurrentDay() {
        return PeriodFactory.createDayPeriod(new DateTime().getMillis());
    }

    public static Period createWeekPeriod(long timestamp) {
        MutableDateTime mdt = new MutableDateTime(timestamp);
        return PeriodFactory.createPeriod(PeriodFactory.toWeekStart(mdt).getMillis(), PeriodFactory.toWeekEnd(mdt).getMillis());
    }

    public static Period createWeekPeriod(String date) {
        return PeriodFactory.createWeekPeriod(formatter.parseMillis(date));
    }

    public static Period getCurrentWeek() {
        return PeriodFactory.createWeekPeriod(new DateTime().getMillis());
    }

    public static Period createMonthPeriod(long timestamp) {
        MutableDateTime mdt = new MutableDateTime(timestamp);
        return PeriodFactory.createPeriod(PeriodFactory.toMonthStart(mdt).getMillis(), PeriodFactory.toMonthEnd(mdt).getMillis());
    }

    public static Period createMonthPeriod(String date) {
        return PeriodFactory.createMonthPeriod(formatter.parseMillis(date));
    }

    public static Period getCurrentMonth() {
        return PeriodFactory.createMonthPeriod(new DateTime().getMillis());
    }

    public static Period createYearPeriod(long timestamp) {
        MutableDateTime mdt = new MutableDateTime(timestamp);
        return PeriodFactory.createPeriod(PeriodFactory.toYearStart(mdt).getMillis(), PeriodFactory.toYearEnd(mdt).getMillis());
    }

    public static Period createYearPeriod(String date) {
        return PeriodFactory.createYearPeriod(formatter.parseMillis(date));
    }

    public static Period createMaximumPeriod() {
        return PeriodFactory.createPeriod(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static Period getCurrentYear() {
        return PeriodFactory.createYearPeriod(new DateTime().getMillis());
    }

    private static MutableDateTime toHourStart(MutableDateTime mdt) {
        mdt.setMinuteOfHour(mdt.minuteOfHour().getMinimumValue());
        mdt.setSecondOfMinute(mdt.secondOfMinute().getMinimumValue());
        mdt.setMillisOfSecond(mdt.millisOfSecond().getMinimumValue());
        return mdt;
    }

    private static MutableDateTime toHourEnd(MutableDateTime mdt) {
        mdt.addHours(1);
        return PeriodFactory.toHourStart(mdt);
    }

    private static MutableDateTime toDayStart(MutableDateTime mdt) {
        mdt.setMillisOfDay(mdt.millisOfDay().getMinimumValue());
        return mdt;
    }

    private static MutableDateTime toDayEnd(MutableDateTime mdt) {
        mdt.addDays(1);
        return PeriodFactory.toDayStart(mdt);
    }

    private static MutableDateTime toWeekStart(MutableDateTime mdt) {
        mdt.setDayOfWeek(mdt.dayOfWeek().getMinimumValue());
        return PeriodFactory.toDayStart(mdt);
    }

    private static MutableDateTime toWeekEnd(MutableDateTime mdt) {
        mdt.setDayOfWeek(mdt.dayOfWeek().getMaximumValue());
        return PeriodFactory.toDayEnd(mdt);
    }

    private static MutableDateTime toMonthStart(MutableDateTime mdt) {
        mdt.setDayOfMonth(mdt.dayOfMonth().getMinimumValue());
        return PeriodFactory.toDayStart(mdt);
    }

    private static MutableDateTime toMonthEnd(MutableDateTime mdt) {
        mdt.setDayOfMonth(mdt.dayOfMonth().getMaximumValue());
        return PeriodFactory.toDayEnd(mdt);
    }

    private static MutableDateTime toYearStart(MutableDateTime mdt) {
        mdt.setDayOfYear(mdt.dayOfYear().getMinimumValue());
        return PeriodFactory.toDayStart(mdt);
    }

    private static MutableDateTime toYearEnd(MutableDateTime mdt) {
        mdt.setDayOfYear(mdt.dayOfYear().getMaximumValue());
        return PeriodFactory.toDayEnd(mdt);
    }

    public static Period getALL_TIME() {
        return ALL_TIME;
    }
}

