/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.CriteriaService;
import com.xpn.xwiki.api.DeletedAttachment;
import com.xpn.xwiki.api.DeletedDocument;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.PropertyClass;
import com.xpn.xwiki.api.StatsService;
import com.xpn.xwiki.api.User;
import com.xpn.xwiki.api.Util;
import com.xpn.xwiki.api.XWikiCompatibilityAspect;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.XWikiInitializerJob;
import com.xpn.xwiki.internal.XWikiInitializerJobStatus;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import com.xpn.xwiki.objects.meta.MetaClass;
import com.xpn.xwiki.plugin.query.XWikiCriteria;
import com.xpn.xwiki.plugin.query.XWikiQuery;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.Programming;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryManager;
import org.xwiki.query.hql.internal.HQLStatementValidator;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;

public class XWiki
extends Api {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XWiki.class);
    private com.xpn.xwiki.XWiki xwiki;
    private StatsService statsService;
    private CriteriaService criteriaService;
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    private DocumentReferenceResolver<String> defaultDocumentReferenceResolver;
    private EntityReferenceSerializer<String> defaultStringEntityReferenceSerializer;
    private DocumentReferenceResolver<EntityReference> currentgetdocumentResolver;
    private DocumentRevisionProvider documentRevisionProvider;
    private ContextualAuthorizationManager contextualAuthorizationManager;
    private HQLStatementValidator hqlValidator;
    private Util util;

    public XWiki(com.xpn.xwiki.XWiki xwiki, XWikiContext context) {
        super(context);
        XWikiCompatibilityAspect.ajc$interFieldInit$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$util(this);
        try {
            this.xwiki = xwiki;
            this.statsService = new StatsService(context);
            this.criteriaService = new CriteriaService(context);
        }
        finally {
            XWikiCompatibilityAspect.aspectOf().ajc$after$com_xpn_xwiki_api_XWikiCompatibilityAspect$1$4ba62052(this);
        }
    }

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    private DocumentReferenceResolver<EntityReference> getCurrentgetdocumentResolver() {
        if (this.currentgetdocumentResolver == null) {
            this.currentgetdocumentResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, "currentgetdocument");
        }
        return this.currentgetdocumentResolver;
    }

    private DocumentReferenceResolver<String> getDefaultDocumentReferenceResolver() {
        if (this.defaultDocumentReferenceResolver == null) {
            this.defaultDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING);
        }
        return this.defaultDocumentReferenceResolver;
    }

    private EntityReferenceSerializer<String> getDefaultStringEntityReferenceSerializer() {
        if (this.defaultStringEntityReferenceSerializer == null) {
            this.defaultStringEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
        }
        return this.defaultStringEntityReferenceSerializer;
    }

    private DocumentRevisionProvider getDocumentRevisionProvider() {
        if (this.documentRevisionProvider == null) {
            this.documentRevisionProvider = Utils.getComponent(DocumentRevisionProvider.class);
        }
        return this.documentRevisionProvider;
    }

    private HQLStatementValidator getHQLStatementValidator() {
        if (this.hqlValidator == null) {
            this.hqlValidator = Utils.getComponent(HQLStatementValidator.class);
        }
        return this.hqlValidator;
    }

    @Programming
    public com.xpn.xwiki.XWiki getXWiki() {
        if (this.hasProgrammingRights()) {
            return this.xwiki;
        }
        return null;
    }

    public XWikiInitializerJobStatus getJobStatus() {
        XWikiInitializerJob job = (XWikiInitializerJob)((java.lang.Object)Utils.getComponent(Job.class, "xwiki.init"));
        return job != null ? (XWikiInitializerJobStatus)job.getStatus() : null;
    }

    public JobStatus getCurrentInitializerJobStatus() {
        XWikiInitializerJobStatus jobStatus = this.getJobStatus();
        if (jobStatus == null) {
            return null;
        }
        if (jobStatus.getState() != JobStatus.State.FINISHED) {
            return jobStatus;
        }
        if (this.xwiki != null) {
            Job wikiJob = this.xwiki.getWikiInitializerJob(this.context.getWikiId());
            jobStatus = wikiJob != null ? wikiJob.getStatus() : null;
        }
        return jobStatus;
    }

    public String getVersion() {
        return this.xwiki.getVersion();
    }

    public String getRequestURL() throws XWikiException {
        return this.getXWikiContext().getURLFactory().getRequestURL(this.getXWikiContext()).toString();
    }

    public String getRelativeRequestURL() throws XWikiException {
        XWikiURLFactory urlFactory = this.getXWikiContext().getURLFactory();
        return urlFactory.getURL(urlFactory.getRequestURL(this.getXWikiContext()), this.getXWikiContext());
    }

    public Document getDocument(String documentReference) throws XWikiException {
        DocumentReference reference = documentReference != null ? this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)documentReference, new java.lang.Object[0]) : this.getDefaultDocumentReferenceResolver().resolve((java.lang.Object)"", new java.lang.Object[0]);
        return this.getDocument(reference);
    }

    public Document getEntityDocument(String reference, EntityType type) throws XWikiException {
        XWikiDocument doc = this.xwiki.getDocument(reference, type, this.getXWikiContext());
        if (!this.getContextualAuthorizationManager().hasAccess(Right.VIEW, (EntityReference)doc.getDocumentReference())) {
            return null;
        }
        return doc.newDocument(this.getXWikiContext());
    }

    public Document getDocument(DocumentReference reference) throws XWikiException {
        try {
            XWikiDocument doc = this.xwiki.getDocument(reference, this.getXWikiContext());
            if (!this.xwiki.getRightService().hasAccessLevel("view", this.getXWikiContext().getUser(), doc.getPrefixedFullName(), this.getXWikiContext())) {
                return null;
            }
            return doc.newDocument(this.getXWikiContext());
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to access document [{}]. Root reason: [{}]", (java.lang.Object)reference, (java.lang.Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return new Document(new XWikiDocument(reference), this.getXWikiContext());
        }
    }

    public Document getDocument(EntityReference reference) throws XWikiException {
        return this.getDocument(this.xwiki.getDocumentReference(reference, this.getXWikiContext()));
    }

    public Document getDocumentAsAuthor(String fullName) throws XWikiException {
        DocumentReference reference = fullName != null ? this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)fullName, new java.lang.Object[0]) : this.getDefaultDocumentReferenceResolver().resolve((java.lang.Object)"", new java.lang.Object[0]);
        return this.getDocumentAsAuthor(reference);
    }

    public Document getDocumentAsAuthor(DocumentReference reference) throws XWikiException {
        if (!this.getAuthorizationManager().hasAccess(Right.VIEW, this.getEffectiveAuthorReference(), (EntityReference)reference)) {
            return null;
        }
        return this.xwiki.getDocument(reference, this.getXWikiContext()).newDocument(this.getXWikiContext());
    }

    public List<DeletedDocument> getDeletedDocuments(String fullname, String locale) throws XWikiException {
        XWikiDeletedDocument[] deletedDocuments = this.xwiki.getDeletedDocuments(fullname, locale, this.context);
        List<DeletedDocument> result = this.wrapDeletedDocuments(deletedDocuments);
        return result;
    }

    public List<DeletedDocument> getDeletedDocuments(String batchId) throws XWikiException {
        XWikiDeletedDocument[] deletedDocuments = this.xwiki.getDeletedDocuments(batchId, this.context);
        List<DeletedDocument> result = this.wrapDeletedDocuments(deletedDocuments);
        return result;
    }

    private List<DeletedDocument> wrapDeletedDocuments(XWikiDeletedDocument[] deletedDocuments) {
        if (deletedDocuments == null || deletedDocuments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DeletedDocument> result = new ArrayList<DeletedDocument>(deletedDocuments.length);
        for (XWikiDeletedDocument deletedDocument : deletedDocuments) {
            result.add(new DeletedDocument(deletedDocument, this.context));
        }
        return result;
    }

    @Deprecated
    public DeletedDocument getDeletedDocument(String fullname, String locale, String index) throws XWikiException {
        return this.getDeletedDocument(index);
    }

    public DeletedDocument getDeletedDocument(String index) throws XWikiException {
        if (!NumberUtils.isDigits((String)index)) {
            return null;
        }
        XWikiDeletedDocument dd = this.xwiki.getDeletedDocument(Long.parseLong(index), this.context);
        if (dd == null) {
            return null;
        }
        return new DeletedDocument(dd, this.context);
    }

    public List<DeletedAttachment> getDeletedAttachments(String docName) {
        try {
            List<com.xpn.xwiki.doc.DeletedAttachment> attachments = this.xwiki.getDeletedAttachments(docName, this.context);
            if (attachments == null || attachments.isEmpty()) {
                attachments = Collections.emptyList();
            }
            ArrayList<DeletedAttachment> result = new ArrayList<DeletedAttachment>(attachments.size());
            for (com.xpn.xwiki.doc.DeletedAttachment attachment : attachments) {
                result.add(new DeletedAttachment(attachment, this.context));
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to retrieve deleted attachments", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public List<DeletedAttachment> getDeletedAttachments(String docName, String filename) {
        try {
            List<com.xpn.xwiki.doc.DeletedAttachment> attachments = this.xwiki.getDeletedAttachments(docName, filename, this.context);
            if (attachments == null) {
                attachments = Collections.emptyList();
            }
            ArrayList<DeletedAttachment> result = new ArrayList<DeletedAttachment>(attachments.size());
            for (com.xpn.xwiki.doc.DeletedAttachment attachment : attachments) {
                result.add(new DeletedAttachment(attachment, this.context));
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to retrieve deleted attachments", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public DeletedAttachment getDeletedAttachment(String id) {
        try {
            com.xpn.xwiki.doc.DeletedAttachment attachment = this.xwiki.getDeletedAttachment(id, this.context);
            if (attachment != null) {
                return new DeletedAttachment(attachment, this.context);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to retrieve deleted attachment", (Throwable)ex);
        }
        return null;
    }

    public boolean exists(String fullname) throws XWikiException {
        return this.xwiki.exists(fullname, this.getXWikiContext());
    }

    public boolean exists(DocumentReference reference) throws XWikiException {
        return this.xwiki.exists(reference, this.getXWikiContext());
    }

    public boolean exists(PageReference reference) throws XWikiException {
        return this.xwiki.exists(reference, this.getXWikiContext());
    }

    public boolean checkAccess(String docname, String right) {
        try {
            DocumentReference docReference = this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)docname, new java.lang.Object[0]);
            XWikiDocument doc = this.getXWikiContext().getWiki().getDocument(docReference, this.context);
            return this.getXWikiContext().getWiki().checkAccess(right, doc, this.getXWikiContext());
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public Document getDocument(String space, String fullname) throws XWikiException {
        XWikiDocument doc = this.xwiki.getDocument(space, fullname, this.getXWikiContext());
        if (!this.xwiki.getRightService().hasAccessLevel("view", this.getXWikiContext().getUser(), doc.getFullName(), this.getXWikiContext())) {
            return null;
        }
        return doc.newDocument(this.getXWikiContext());
    }

    public Document getDocument(Document doc, String rev) throws XWikiException {
        if (doc == null || doc.getDoc() == null) {
            return null;
        }
        if (!this.getContextualAuthorizationManager().hasAccess(Right.VIEW, (EntityReference)doc.getDocumentReference())) {
            return null;
        }
        return doc.getDocumentRevision(rev);
    }

    public Document getDocument(DocumentReference reference, String revision) throws XWikiException {
        try {
            if (reference != null && this.getContextualAuthorizationManager().hasAccess(Right.VIEW, (EntityReference)reference)) {
                DocumentRevisionProvider revisionProvider = this.getDocumentRevisionProvider();
                revisionProvider.checkAccess(Right.VIEW, (UserReference)CurrentUserReference.INSTANCE, reference, revision);
                XWikiDocument documentRevision = revisionProvider.getRevision(reference, revision);
                if (documentRevision != null) {
                    return new Document(documentRevision, this.context);
                }
            }
        }
        catch (AuthorizationException e) {
            LOGGER.info("Access denied for loading revision [{}] of document [{}]: [{}]", new java.lang.Object[]{revision, reference, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
        catch (Exception e) {
            LOGGER.error("Failed to access revision [{}] of document {}", new java.lang.Object[]{revision, reference, e});
        }
        return null;
    }

    public String getTextArea(String content) {
        return com.xpn.xwiki.XWiki.getTextArea(content, this.getXWikiContext());
    }

    public List<String> getClassList() throws XWikiException {
        return this.xwiki.getClassList(this.getXWikiContext());
    }

    public MetaClass getMetaclass() {
        return this.xwiki.getMetaclass();
    }

    private void checkSearchQueryAllowed(String whereSQL) throws XWikiException {
        if (!this.hasProgrammingRights()) {
            try {
                if (!this.getHQLStatementValidator().isSafe(HqlQueryUtils.createLegacySQLQuery("select distinct doc.fullName", whereSQL))) {
                    throw new XWikiException(3, 9001, "The query [" + whereSQL + "] requires programming right");
                }
            }
            catch (Exception e) {
                throw new XWikiException(3, 9001, "Failed to validate the query [" + whereSQL + "], requiring programming right", e);
            }
        }
    }

    @Deprecated
    public List<String> searchDocuments(String wheresql) throws XWikiException {
        this.checkSearchQueryAllowed(wheresql);
        return this.xwiki.getStore().searchDocumentsNames(wheresql, this.getXWikiContext());
    }

    @Deprecated
    public List<String> searchDocuments(String wheresql, int nb, int start) throws XWikiException {
        this.checkSearchQueryAllowed(wheresql);
        return this.xwiki.getStore().searchDocumentsNames(wheresql, nb, start, this.getXWikiContext());
    }

    @Deprecated
    public List<String> searchDocuments(String wheresql, int nb, int start, String selectColumns) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.xwiki.getStore().searchDocumentsNames(wheresql, nb, start, selectColumns, this.getXWikiContext());
        }
        return Collections.emptyList();
    }

    public List<Document> searchDocuments(String wheresql, boolean distinctbylocale) throws XWikiException {
        this.checkSearchQueryAllowed(wheresql);
        return this.convert(this.xwiki.getStore().searchDocuments(wheresql, distinctbylocale, this.getXWikiContext()));
    }

    public List<Document> searchDocuments(String wheresql, boolean distinctbylocale, int nb, int start) throws XWikiException {
        this.checkSearchQueryAllowed(wheresql);
        return this.convert(this.xwiki.getStore().searchDocuments(wheresql, distinctbylocale, nb, start, this.getXWikiContext()));
    }

    @Deprecated
    public List<String> searchDocuments(String parameterizedWhereClause, int maxResults, int startOffset, List<?> parameterValues) throws XWikiException {
        this.checkSearchQueryAllowed(parameterizedWhereClause);
        return this.xwiki.getStore().searchDocumentsNames(parameterizedWhereClause, maxResults, startOffset, parameterValues, this.getXWikiContext());
    }

    @Deprecated
    public List<String> searchDocuments(String parameterizedWhereClause, List<?> parameterValues) throws XWikiException {
        this.checkSearchQueryAllowed(parameterizedWhereClause);
        return this.xwiki.getStore().searchDocumentsNames(parameterizedWhereClause, parameterValues, this.getXWikiContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<String> searchDocumentsNames(String wikiName, String parameterizedWhereClause, int maxResults, int startOffset, List<?> parameterValues) throws XWikiException {
        String database = this.context.getWikiId();
        try {
            this.context.setWikiId(wikiName);
            this.checkSearchQueryAllowed(parameterizedWhereClause);
            List<String> list = this.searchDocuments(parameterizedWhereClause, maxResults, startOffset, parameterValues);
            return list;
        }
        finally {
            this.context.setWikiId(database);
        }
    }

    public List<String> searchSpacesNames(String parameterizedSqlClause, int nb, int start, List<?> parameterValues) throws XWikiException {
        this.checkSearchQueryAllowed(parameterizedSqlClause);
        return this.xwiki.getStore().search("select distinct doc.space from XWikiDocument doc " + parameterizedSqlClause, nb, start, parameterValues, this.context);
    }

    public List<Attachment> searchAttachments(String parameterizedSqlClause, int nb, int start, List<?> parameterValues) throws XWikiException {
        this.checkSearchQueryAllowed(parameterizedSqlClause);
        return this.convertAttachments(this.xwiki.searchAttachments(parameterizedSqlClause, true, nb, start, parameterValues, this.context));
    }

    public int countAttachments(String parameterizedSqlClause, List<?> parameterValues) throws XWikiException {
        this.checkSearchQueryAllowed(parameterizedSqlClause);
        return this.xwiki.countAttachments(parameterizedSqlClause, parameterValues, this.context);
    }

    public List<Document> wrapDocs(List<?> docs) {
        ArrayList<Document> result = new ArrayList<Document>();
        if (docs != null) {
            for (java.lang.Object obj : docs) {
                try {
                    java.lang.Object doc;
                    if (obj instanceof XWikiDocument) {
                        doc = (XWikiDocument)obj;
                        Document wrappedDoc = ((XWikiDocument)doc).newDocument(this.getXWikiContext());
                        result.add(wrappedDoc);
                        continue;
                    }
                    if (obj instanceof Document) {
                        result.add((Document)obj);
                        continue;
                    }
                    if (!(obj instanceof String) || (doc = this.getDocument(obj.toString())) == null) continue;
                    result.add((Document)doc);
                }
                catch (XWikiException xWikiException) {}
            }
        }
        return result;
    }

    @Deprecated
    public String parseContent(String content) {
        return this.xwiki.parseContent(content, this.getXWikiContext());
    }

    public String parseTemplate(String template) {
        return this.xwiki.parseTemplate(template, this.getXWikiContext());
    }

    public String renderTemplate(String template) {
        return this.xwiki.renderTemplate(template, this.getXWikiContext());
    }

    public String getSkinFile(String filename) {
        return this.xwiki.getSkinFile(filename, this.getXWikiContext());
    }

    public String getSkinFile(String filename, boolean forceSkinAction) {
        return this.xwiki.getSkinFile(filename, forceSkinAction, this.getXWikiContext());
    }

    public String getSkin() {
        return this.xwiki.getSkin(this.getXWikiContext());
    }

    public String getBaseSkin() {
        return this.xwiki.getBaseSkin(this.getXWikiContext());
    }

    public String getSpaceCopyright() {
        return this.xwiki.getSpaceCopyright(this.getXWikiContext());
    }

    public String getXWikiPreference(String preference) {
        return this.xwiki.getXWikiPreference(preference, this.getXWikiContext());
    }

    public String getXWikiPreference(String preference, String defaultValue) {
        return this.xwiki.getXWikiPreference(preference, defaultValue, this.getXWikiContext());
    }

    public String getSpacePreference(String preference) {
        return this.xwiki.getSpacePreference(preference, this.getXWikiContext());
    }

    public String getSpacePreference(String preference, String defaultValue) {
        return this.xwiki.getSpacePreference(preference, defaultValue, this.getXWikiContext());
    }

    public String getSkinPreference(String preference) {
        return this.xwiki.getSkinPreference(preference, this.getXWikiContext());
    }

    public String getSkinPreference(String preference, String defaultValue) {
        return this.xwiki.getSkinPreference(preference, defaultValue, this.getXWikiContext());
    }

    public String getSpacePreferenceFor(String preference, SpaceReference spaceReference) {
        return this.xwiki.getSpacePreference(preference, spaceReference, this.getXWikiContext());
    }

    public String getSpacePreferenceFor(String preference, SpaceReference spaceReference, String defaultValue) {
        return this.xwiki.getSpacePreference(preference, spaceReference, defaultValue, this.getXWikiContext());
    }

    public long getXWikiPreferenceAsLong(String preference, long defaultValue) {
        return this.xwiki.getXWikiPreferenceAsLong(preference, defaultValue, this.getXWikiContext());
    }

    public long getXWikiPreferenceAsLong(String preference) {
        return this.xwiki.getXWikiPreferenceAsLong(preference, this.getXWikiContext());
    }

    public long getSpacePreferenceAsLong(String preference, long defaultValue) {
        return this.xwiki.getSpacePreferenceAsLong(preference, defaultValue, this.getXWikiContext());
    }

    public long getSpacePreferenceAsLong(String preference) {
        return this.xwiki.getSpacePreferenceAsLong(preference, this.getXWikiContext());
    }

    public int getXWikiPreferenceAsInt(String preference, int defaultValue) {
        return this.xwiki.getXWikiPreferenceAsInt(preference, defaultValue, this.getXWikiContext());
    }

    public int getXWikiPreferenceAsInt(String preference) {
        return this.xwiki.getXWikiPreferenceAsInt(preference, this.getXWikiContext());
    }

    public int getSpacePreferenceAsInt(String preference, int defaultValue) {
        return this.xwiki.getSpacePreferenceAsInt(preference, defaultValue, this.getXWikiContext());
    }

    public int getSpacePreferenceAsInt(String preference) {
        return this.xwiki.getSpacePreferenceAsInt(preference, this.getXWikiContext());
    }

    public String getUserPreference(String preference) {
        return this.xwiki.getUserPreference(preference, this.getXWikiContext());
    }

    public String getUserPreferenceFromCookie(String preference) {
        return this.xwiki.getUserPreferenceFromCookie(preference, this.getXWikiContext());
    }

    @Deprecated
    public String getLanguagePreference() {
        return this.xwiki.getLanguagePreference(this.getXWikiContext());
    }

    public Locale getLocalePreference() {
        return this.xwiki.getLocalePreference(this.getXWikiContext());
    }

    @Deprecated
    public String getInterfaceLanguagePreference() {
        return this.xwiki.getInterfaceLanguagePreference(this.getXWikiContext());
    }

    public Locale getInterfaceLocalePreference() {
        return this.xwiki.getInterfaceLocalePreference(this.getXWikiContext());
    }

    public List<Locale> getAvailableLocales() {
        return this.xwiki.getAvailableLocales(this.getXWikiContext());
    }

    public List<String> getWikiNames() {
        ArrayList<String> result = new ArrayList();
        try {
            result = this.xwiki.getVirtualWikisDatabaseNames(this.getXWikiContext());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get the list of all wiki names", (Throwable)e);
        }
        return result;
    }

    public boolean hasSubWikis() {
        return this.getWikiNames().size() > 1;
    }

    public boolean isMultiLingual() {
        return this.xwiki.isMultiLingual(this.getXWikiContext());
    }

    public void flushCache() {
        if (this.hasProgrammingRights()) {
            this.xwiki.flushCache(this.getXWikiContext());
        }
    }

    public int createUser() throws XWikiException {
        return this.createUser(false, "edit");
    }

    public int createUser(boolean withValidation) throws XWikiException {
        return this.createUser(withValidation, "edit");
    }

    public int createUser(boolean withValidation, String userRights) throws XWikiException {
        try {
            boolean registerRight = this.hasProgrammingRights() ? true : this.xwiki.getRightService().hasAccessLevel("register", this.getXWikiContext().getUser(), "XWiki.XWikiPreferences", this.getXWikiContext());
            if (registerRight) {
                return this.xwiki.createUser(withValidation, userRights, this.getXWikiContext());
            }
            return -1;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create user", (Throwable)e);
            return -10;
        }
    }

    public int validateUser(boolean withConfirmEmail) throws XWikiException {
        return this.xwiki.validateUser(withConfirmEmail, this.getXWikiContext());
    }

    public void addToAllGroup(String fullwikiname) throws XWikiException {
        if (this.hasProgrammingRights()) {
            this.xwiki.setUserDefaultGroup(fullwikiname, this.getXWikiContext());
        }
    }

    public void sendConfirmationMail(String xwikiname, String password, String email, String add_message, String contentfield) throws XWikiException {
        if (this.hasProgrammingRights()) {
            this.xwiki.sendConfirmationEmail(xwikiname, password, email, add_message, contentfield, this.getXWikiContext());
        }
    }

    public void sendConfirmationMail(String xwikiname, String password, String email, String contentfield) throws XWikiException {
        if (this.hasProgrammingRights()) {
            this.xwiki.sendConfirmationEmail(xwikiname, password, email, "", contentfield, this.getXWikiContext());
        }
    }

    public boolean renameDocument(DocumentReference sourceDocumentReference, DocumentReference targetDocumentReference, boolean overwrite, List<DocumentReference> backlinkDocumentReferences, List<DocumentReference> childDocumentReferences) throws XWikiException {
        if (this.hasAccess(Right.DELETE, sourceDocumentReference) && (overwrite && this.hasAccess(Right.DELETE, targetDocumentReference) || !overwrite && this.hasAccess(Right.EDIT, targetDocumentReference))) {
            return this.xwiki.renameDocument(sourceDocumentReference, targetDocumentReference, overwrite, backlinkDocumentReferences, childDocumentReferences, this.getXWikiContext());
        }
        return false;
    }

    public boolean copyDocument(String docname, String targetdocname) throws XWikiException {
        return this.copyDocument(docname, targetdocname, null, null, null, false, false);
    }

    public boolean copyDocument(String docname, String targetdocname, String wikilocale) throws XWikiException {
        return this.copyDocument(docname, targetdocname, null, null, wikilocale, false, false);
    }

    public boolean copyDocument(String docname, String sourceWiki, String targetWiki, String wikilocale) throws XWikiException {
        return this.copyDocument(docname, docname, sourceWiki, targetWiki, wikilocale, true, false);
    }

    public boolean copyDocument(String docname, String targetdocname, String sourceWiki, String targetWiki, String wikilocale, boolean reset) throws XWikiException {
        return this.copyDocument(docname, targetdocname, sourceWiki, targetWiki, wikilocale, reset, false);
    }

    public boolean copyDocument(String docname, String targetdocname, String sourceWiki, String targetWiki, String wikilocale, boolean reset, boolean force) throws XWikiException {
        DocumentReference sourceDocumentReference = this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)docname, new java.lang.Object[0]);
        if (!StringUtils.isEmpty((CharSequence)sourceWiki)) {
            sourceDocumentReference = sourceDocumentReference.replaceParent((EntityReference)sourceDocumentReference.getWikiReference(), (EntityReference)new WikiReference(sourceWiki));
        }
        DocumentReference targetDocumentReference = this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)targetdocname, new java.lang.Object[0]);
        if (!StringUtils.isEmpty((CharSequence)targetWiki)) {
            targetDocumentReference = targetDocumentReference.replaceParent((EntityReference)targetDocumentReference.getWikiReference(), (EntityReference)new WikiReference(targetWiki));
        }
        return this.copyDocument(sourceDocumentReference, targetDocumentReference, wikilocale, reset, force);
    }

    public boolean copyDocument(DocumentReference sourceDocumentReference, DocumentReference targetDocumentReference, String wikilocale, boolean resetHistory, boolean overwrite) throws XWikiException {
        String targetDocStringRef;
        if (this.hasAccessLevel("view", (String)this.getDefaultStringEntityReferenceSerializer().serialize((EntityReference)sourceDocumentReference, new java.lang.Object[0])) && this.hasAccessLevel("edit", targetDocStringRef = (String)this.getDefaultStringEntityReferenceSerializer().serialize((EntityReference)targetDocumentReference, new java.lang.Object[0])) && (!overwrite || !this.exists(targetDocumentReference) || this.hasAccessLevel("delete", targetDocStringRef))) {
            return this.xwiki.copyDocument(sourceDocumentReference, targetDocumentReference, wikilocale, resetHistory, overwrite, true, this.getXWikiContext());
        }
        return false;
    }

    public int copySpaceBetweenWikis(String space, String sourceWiki, String targetWiki, String locale, boolean clean) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.xwiki.copySpaceBetweenWikis(space, sourceWiki, targetWiki, locale, clean, this.getXWikiContext());
        }
        return -1;
    }

    public String includeTopic(String topic) throws XWikiException {
        return this.includeTopic(topic, true);
    }

    public String includeForm(String topic) throws XWikiException {
        return this.includeForm(topic, true);
    }

    public String includeTopic(String topic, boolean pre) throws XWikiException {
        String includerSyntax;
        java.lang.Object result = this.xwiki.include(topic, false, this.getXWikiContext());
        if (pre && (includerSyntax = this.xwiki.getCurrentContentSyntaxId(null, this.context)) != null && Syntax.XWIKI_1_0.toIdString().equals(includerSyntax)) {
            result = "{pre}" + (String)result + "{/pre}";
        }
        return result;
    }

    public String includeForm(String topic, boolean pre) throws XWikiException {
        String includerSyntax;
        java.lang.Object result = this.xwiki.include(topic, true, this.getXWikiContext());
        if (pre && (includerSyntax = this.xwiki.getCurrentContentSyntaxId(null, this.context)) != null && Syntax.XWIKI_1_0.toIdString().equals(includerSyntax)) {
            result = "{pre}" + (String)result + "{/pre}";
        }
        return result;
    }

    public boolean hasAccessLevel(String level) {
        return this.hasAccessLevel(level, this.getXWikiContext().getUser(), this.getXWikiContext().getDoc().getFullName());
    }

    public boolean hasAccessLevel(String level, String user, String docname) {
        try {
            return this.xwiki.getRightService().hasAccessLevel(level, user, docname, this.getXWikiContext());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public List<String> getSpaces() throws XWikiException {
        return this.xwiki.getSpaces(this.getXWikiContext());
    }

    @Deprecated
    public List<String> getSpaceDocsName(String spaceReference) throws XWikiException {
        return this.xwiki.getSpaceDocsName(spaceReference, this.getXWikiContext());
    }

    public String getEncoding() {
        return this.xwiki.getEncoding();
    }

    public String getAttachmentURL(String fullname, String filename) throws XWikiException {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{fullname, filename})) {
            return "";
        }
        return this.xwiki.getAttachmentURL(fullname, filename, this.getXWikiContext());
    }

    public String getURL(String fullname) throws XWikiException {
        return this.xwiki.getURL(fullname, "view", this.getXWikiContext());
    }

    public String getURL(EntityReference reference) throws XWikiException {
        return this.xwiki.getURL(reference, this.getXWikiContext());
    }

    public String getURL(EntityReference reference, String action, String querystring) throws XWikiException {
        return this.xwiki.getURL(reference, action, querystring, null, this.getXWikiContext());
    }

    public String getURL(DocumentReference reference) throws XWikiException {
        return this.xwiki.getURL(reference, "view", this.getXWikiContext());
    }

    public String getURL(String fullname, String action) throws XWikiException {
        return this.xwiki.getURL(fullname, action, this.getXWikiContext());
    }

    public String getURL(String fullname, String action, String querystring) throws XWikiException {
        return this.xwiki.getURL(fullname, action, querystring, this.getXWikiContext());
    }

    public String getURL(DocumentReference reference, String action, String querystring) throws XWikiException {
        return this.xwiki.getURL(reference, action, querystring, null, this.getXWikiContext());
    }

    public String getURL(String fullname, String action, String querystring, String anchor) throws XWikiException {
        return this.xwiki.getURL(fullname, action, querystring, anchor, this.getXWikiContext());
    }

    public String getRefererText(String referer) {
        try {
            return this.xwiki.getRefererText(referer, this.getXWikiContext());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getShortRefererText(String referer, int length) {
        try {
            return this.xwiki.getRefererText(referer, this.getXWikiContext()).substring(0, length);
        }
        catch (Exception e) {
            return this.xwiki.getRefererText(referer, this.getXWikiContext());
        }
    }

    public String getPlainUserName(DocumentReference userReference) {
        return this.xwiki.getPlainUserName(userReference, this.getXWikiContext());
    }

    public String getUserName(String user) {
        return this.xwiki.getUserName(user, null, this.getXWikiContext());
    }

    public String getUserName(String user, String format) {
        return this.xwiki.getUserName(user, format, this.getXWikiContext());
    }

    public String getLocalUserName(String user) {
        try {
            return this.xwiki.getUserName(user.substring(user.indexOf(":") + 1), null, this.getXWikiContext());
        }
        catch (Exception e) {
            return this.xwiki.getUserName(user, null, this.getXWikiContext());
        }
    }

    public String getLocalUserName(String user, String format) {
        try {
            return this.xwiki.getUserName(user.substring(user.indexOf(":") + 1), format, this.getXWikiContext());
        }
        catch (Exception e) {
            return this.xwiki.getUserName(user, format, this.getXWikiContext());
        }
    }

    public String getUserName(String user, boolean link) {
        return this.xwiki.getUserName(user, null, link, this.getXWikiContext());
    }

    public String getUserName(String user, String format, boolean link) {
        return this.xwiki.getUserName(user, format, link, this.getXWikiContext());
    }

    public String getLocalUserName(String user, boolean link) {
        try {
            return this.xwiki.getUserName(user.substring(user.indexOf(":") + 1), null, link, this.getXWikiContext());
        }
        catch (Exception e) {
            return this.xwiki.getUserName(user, null, link, this.getXWikiContext());
        }
    }

    public String getLocalUserName(String user, String format, boolean link) {
        try {
            return this.xwiki.getUserName(user.substring(user.indexOf(":") + 1), format, link, this.getXWikiContext());
        }
        catch (Exception e) {
            return this.xwiki.getUserName(user, format, link, this.getXWikiContext());
        }
    }

    public User getUser() {
        return this.xwiki.getUser(this.getXWikiContext());
    }

    public User getUser(String username) {
        return this.xwiki.getUser(username, this.getXWikiContext());
    }

    public User getUser(DocumentReference userReference) {
        return this.xwiki.getUser(userReference, this.getXWikiContext());
    }

    public String formatDate(Date date) {
        return this.xwiki.formatDate(date, null, this.getXWikiContext());
    }

    public String formatDate(Date date, String format) {
        return this.xwiki.formatDate(date, format, this.getXWikiContext());
    }

    public String getUserTimeZone() {
        return this.xwiki.getUserTimeZone(this.context);
    }

    public Api get(String name) {
        return this.getPlugin(name);
    }

    public Api getPlugin(String name) {
        return this.xwiki != null ? this.xwiki.getPluginApi(name, this.getXWikiContext()) : null;
    }

    public String getAdType() {
        return this.xwiki.getAdType(this.getXWikiContext());
    }

    public String getAdClientId() {
        return this.xwiki.getAdClientId(this.getXWikiContext());
    }

    @Programming
    public String getURLContent(String surl, String username, String password) throws IOException {
        if (!this.hasProgrammingRights()) {
            return "";
        }
        try {
            return this.xwiki.getURLContent(surl, username, password, this.context);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to retrieve content from [" + surl + "]", (Throwable)e);
            return "";
        }
    }

    @Programming
    public String getURLContent(String surl) throws IOException {
        if (!this.hasProgrammingRights()) {
            return "";
        }
        try {
            return this.xwiki.getURLContent(surl, this.context);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to retrieve content from [" + surl + "]", (Throwable)e);
            return "";
        }
    }

    @Programming
    public String getURLContent(String surl, String username, String password, int timeout) throws IOException {
        if (!this.hasProgrammingRights()) {
            return "";
        }
        try {
            return this.xwiki.getURLContent(surl, username, password, timeout, this.xwiki.getHttpUserAgent(this.context));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Programming
    public String getURLContent(String surl, int timeout) throws IOException {
        if (!this.hasProgrammingRights()) {
            return "";
        }
        try {
            return this.xwiki.getURLContent(surl, timeout, this.xwiki.getHttpUserAgent(this.context));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Programming
    public byte[] getURLContentAsBytes(String surl, String username, String password) throws IOException {
        if (!this.hasProgrammingRights()) {
            return null;
        }
        try {
            return this.xwiki.getURLContentAsBytes(surl, username, password, this.context);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Programming
    public byte[] getURLContentAsBytes(String surl) throws IOException {
        if (!this.hasProgrammingRights()) {
            return null;
        }
        try {
            return this.xwiki.getURLContentAsBytes(surl, this.context);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getIncludedMacros(String defaultSpace, String content) {
        return this.xwiki.getIncludedMacros(defaultSpace, content, this.getXWikiContext());
    }

    public boolean isReadOnly() {
        return this.xwiki.isReadOnly();
    }

    public void setReadOnly(boolean ro) {
        if (this.hasAdminRights()) {
            this.xwiki.setReadOnly(ro);
        }
    }

    public void refreshLinks() throws XWikiException {
        if (this.hasAdminRights()) {
            this.xwiki.refreshLinks(this.getXWikiContext());
        }
    }

    public boolean hasBacklinks() throws XWikiException {
        return this.xwiki.hasBacklinks(this.getXWikiContext());
    }

    public boolean hasTags() throws XWikiException {
        return this.xwiki.hasTags(this.getXWikiContext());
    }

    public boolean hasEditComment() {
        return this.xwiki.hasEditComment(this.context);
    }

    public boolean isEditCommentFieldHidden() {
        return this.xwiki.isEditCommentFieldHidden(this.context);
    }

    public boolean isEditCommentSuggested() {
        return this.xwiki.isEditCommentSuggested(this.context);
    }

    public boolean isEditCommentMandatory() {
        return this.xwiki.isEditCommentMandatory(this.context);
    }

    public boolean hasMinorEdit() {
        return this.xwiki.hasMinorEdit(this.context);
    }

    public boolean hasRecycleBin() {
        return this.xwiki.hasRecycleBin(this.context);
    }

    public String getEditorPreference() {
        return this.xwiki.getEditorPreference(this.getXWikiContext());
    }

    public java.lang.Object parseGroovyFromString(String script) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.xwiki.parseGroovyFromString(script, this.getXWikiContext());
        }
        return "groovy_missingrights";
    }

    public java.lang.Object parseGroovyFromPage(String script, String jarWikiPage) throws XWikiException {
        XWikiDocument doc = this.xwiki.getDocument(script, this.getXWikiContext());
        if (this.xwiki.getRightService().hasProgrammingRights(doc, this.getXWikiContext())) {
            return this.xwiki.parseGroovyFromString(doc.getContent(), jarWikiPage, this.getXWikiContext());
        }
        return "groovy_missingrights";
    }

    public java.lang.Object parseGroovyFromPage(String fullname) throws XWikiException {
        XWikiDocument doc = this.xwiki.getDocument(fullname, this.getXWikiContext());
        if (this.xwiki.getRightService().hasProgrammingRights(doc, this.getXWikiContext())) {
            return this.xwiki.parseGroovyFromString(doc.getContent(), this.getXWikiContext());
        }
        return "groovy_missingrights";
    }

    public String getMacroList() {
        return this.xwiki.getMacroList(this.getXWikiContext());
    }

    public String getWysiwygToolbars() {
        return this.xwiki.getWysiwygToolbars(this.getXWikiContext());
    }

    public Object getObjectFromRequest(String className) throws XWikiException {
        return new Object(this.xwiki.getObjectFromRequest(className, this.getXWikiContext()), this.getXWikiContext());
    }

    public Document createDocument() {
        return new XWikiDocument().newDocument(this.getXWikiContext());
    }

    public String convertUsername(String username) {
        return this.xwiki.convertUsername(username, this.getXWikiContext());
    }

    public PropertyClass getPropertyClassFromName(String propPath) {
        return new PropertyClass(this.xwiki.getPropertyClassFromName(propPath, this.getXWikiContext()), this.getXWikiContext());
    }

    public String getUniquePageName(String space) throws XWikiException {
        return this.xwiki.getUniquePageName(space, this.getXWikiContext());
    }

    public String getUniquePageName(String space, String name) throws XWikiException {
        return this.xwiki.getUniquePageName(space, name, this.getXWikiContext());
    }

    public String addMandatory() {
        return this.xwiki.addMandatory(this.getXWikiContext());
    }

    public Class getClass(String documentName) throws XWikiException {
        DocumentReference docReference = this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)documentName, new java.lang.Object[0]);
        return this.getClass((EntityReference)docReference);
    }

    public Class getClass(EntityReference docReference) throws XWikiException {
        return new Class(this.xwiki.getDocument(docReference, this.context).getXClass(), this.context);
    }

    public String getCounter(String name) {
        XWikiEngineContext econtext = this.context.getEngineContext();
        Integer counter = (Integer)econtext.getAttribute(name);
        if (counter == null) {
            counter = 0;
        }
        counter = counter + 1;
        econtext.setAttribute(name, counter);
        return counter.toString();
    }

    public XWikiUser checkAuth() throws XWikiException {
        return this.context.getWiki().checkAuth(this.context);
    }

    public XWikiUser checkAuth(String username, String password, String rememberme) throws XWikiException {
        XWikiUser user = this.context.getWiki().getAuthService().checkAuth(username, password, rememberme, this.context);
        if (user.isDisabled(this.context)) {
            this.context.put("inactiveUserReference", user.getUserReference());
            user = null;
        }
        return user;
    }

    public StatsService getStatsService() {
        return this.statsService;
    }

    public CriteriaService getCriteriaService() {
        return this.criteriaService;
    }

    public String getServletPath(String wikiName) {
        return this.xwiki.getServletPath(wikiName, this.context);
    }

    public String getServletPath() {
        return this.xwiki.getServletPath(this.context.getWikiId(), this.context);
    }

    public String getWebAppPath() {
        return this.xwiki.getWebAppPath(this.context);
    }

    public String getDefaultDocumentSyntax() {
        return this.xwiki.getDefaultDocumentSyntax();
    }

    public Syntax getAvailableRendererSyntax(String syntaxType, String syntaxVersion) {
        Syntax syntax = null;
        try {
            List factories = Utils.getContextComponentManager().getInstanceList(PrintRendererFactory.class);
            for (PrintRendererFactory factory : factories) {
                Syntax factorySyntax = factory.getSyntax();
                if (syntaxVersion != null) {
                    if (!factorySyntax.getType().getId().equalsIgnoreCase(syntaxType) || !factorySyntax.getVersion().equals(syntaxVersion)) continue;
                    syntax = factorySyntax;
                    break;
                }
                if (!factorySyntax.getType().getId().equalsIgnoreCase(syntaxType) || syntax != null && factorySyntax.getVersion().compareTo(syntax.getVersion()) <= 0) continue;
                syntax = factorySyntax;
            }
        }
        catch (ComponentLookupException e) {
            LOGGER.error("Failed to lookup available renderer syntaxes", (Throwable)e);
        }
        return syntax;
    }

    public boolean hasSectionEdit() {
        return this.xwiki.hasSectionEdit(this.getXWikiContext());
    }

    public long getSectionEditingDepth() {
        return this.xwiki.getSectionEditingDepth();
    }

    public boolean isTitleInCompatibilityMode() {
        return this.xwiki.isTitleInCompatibilityMode();
    }

    public String getCurrentContentSyntaxId() {
        return this.xwiki.getCurrentContentSyntaxId(this.getXWikiContext());
    }

    public static /* synthetic */ Util ajc$get$util(XWiki xWiki) {
        return xWiki.util;
    }

    public static /* synthetic */ void ajc$set$util(XWiki xWiki, Util util) {
        xWiki.util = util;
    }

    public static /* synthetic */ com.xpn.xwiki.XWiki ajc$get$xwiki(XWiki xWiki) {
        return xWiki.xwiki;
    }

    public static /* synthetic */ void ajc$set$xwiki(XWiki xWiki, com.xpn.xwiki.XWiki xWiki2) {
        xWiki.xwiki = xWiki2;
    }

    @Deprecated
    public int add(int n, int n2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$add(this, n, n2);
    }

    @Deprecated
    public long add(long l, long l2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$add(this, l, l2);
    }

    @Deprecated
    public String add(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$add(this, string, string2);
    }

    @Deprecated(since="16.0RC1")
    public String addTooltip(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$addTooltip(this, string, string2);
    }

    @Deprecated(since="16.0RC1")
    public String addTooltip(String string, String string2, String string3) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$addTooltip(this, string, string2, string3);
    }

    @Deprecated(since="16.0RC1")
    public String addTooltipJS() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$addTooltipJS(this);
    }

    public /* synthetic */ XWikiContext ajc$superDispatch$com_xpn_xwiki_api_XWiki$getXWikiContext() {
        return super.getXWikiContext();
    }

    @Deprecated
    public String clearAccents(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$clearAccents(this, string);
    }

    @Deprecated
    public String clearName(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$clearName(this, string);
    }

    @Deprecated
    public int copyWikiWeb(String string, String string2, String string3, String string4, boolean bl) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$copyWikiWeb(this, string, string2, string3, string4, bl);
    }

    @Deprecated
    public int countDocuments(String string) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$countDocuments(this, string);
    }

    @Deprecated
    public int countDocuments(String string, List<?> list) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$countDocuments(this, string, list);
    }

    @Deprecated
    public int createNewWiki(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$createNewWiki(this, string, string2, string3, string4, string5, string6, bl);
    }

    @Deprecated
    public int createNewWiki(String string, String string2, String string3, String string4, String string5, boolean bl) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$createNewWiki(this, string, string2, string3, string4, string5, bl);
    }

    @Deprecated
    public int createNewWiki(String string, String string2, String string3, String string4, boolean bl) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$createNewWiki(this, string, string2, string3, string4, bl);
    }

    public XWikiQuery createQueryFromRequest(String string) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$createQueryFromRequest(this, string);
    }

    public String displaySearch(String string, String string2) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearch(this, string, string2);
    }

    public String displaySearch(String string, String string2, XWikiCriteria xWikiCriteria) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearch(this, string, string2, xWikiCriteria);
    }

    public String displaySearch(String string, String string2, String string3, XWikiCriteria xWikiCriteria) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearch(this, string, string2, string3, xWikiCriteria);
    }

    @Deprecated
    public String displaySearchColumns(String string, XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearchColumns(this, string, xWikiQuery);
    }

    @Deprecated
    public String displaySearchColumns(String string, String string2, XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearchColumns(this, string, string2, xWikiQuery);
    }

    @Deprecated
    public String displaySearchOrder(String string, XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearchOrder(this, string, xWikiQuery);
    }

    @Deprecated
    public String displaySearchOrder(String string, String string2, XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$displaySearchOrder(this, string, string2, xWikiQuery);
    }

    @Deprecated
    public String escapeText(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$escapeText(this, string);
    }

    @Deprecated
    public String escapeURL(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$escapeURL(this, string);
    }

    @Deprecated
    public String generateRandomString(int n) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$generateRandomString(this, n);
    }

    @Deprecated
    public List getArrayList() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getArrayList(this);
    }

    @Deprecated
    public List<String> getConfiguredSyntaxes() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getConfiguredSyntaxes(this);
    }

    @Deprecated
    public Date getCurrentDate() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getCurrentDate(this);
    }

    @Deprecated
    public DocumentStats getCurrentMonthXWikiStats(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getCurrentMonthXWikiStats(this, string);
    }

    @Deprecated
    public Date getDate() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getDate(this);
    }

    @Deprecated
    public Date getDate(long l) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getDate(this, l);
    }

    @Deprecated
    public String getDocLanguagePreference() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getDocLanguagePreference(this);
    }

    @Deprecated
    public String getFormEncoded(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getFormEncoded(this, string);
    }

    @Deprecated
    public String getFullNameSQL() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getFullNameSQL(this);
    }

    @Deprecated
    public String getHTMLArea(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getHTMLArea(this, string);
    }

    @Deprecated
    public Map getHashMap() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getHashMap(this);
    }

    @Deprecated
    public String getMessage(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getMessage(this, string);
    }

    @Deprecated
    public String getNl() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getNl(this);
    }

    @Deprecated
    public Object getNull() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getNull(this);
    }

    @Deprecated
    public QueryManager getQueryManager() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getQueryManager(this);
    }

    @Deprecated
    public Collection getRecentActions(String string, int n) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getRecentActions(this, string, n);
    }

    @Deprecated(since="14.8RC1")
    public String getSpacePreferenceFor(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getSpacePreferenceFor(this, string, string2);
    }

    @Deprecated(since="14.8RC1")
    public String getSpacePreferenceFor(String string, String string2, String string3) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getSpacePreferenceFor(this, string, string2, string3);
    }

    @Deprecated
    public int getTimeDelta(long l) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getTimeDelta(this, l);
    }

    @Deprecated
    public Map getTreeMap() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getTreeMap(this);
    }

    @Deprecated
    public String getURLEncoded(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getURLEncoded(this, string);
    }

    @Deprecated
    public String getWebCopyright() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebCopyright(this);
    }

    @Deprecated
    public String getWebPreference(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreference(this, string);
    }

    @Deprecated
    public String getWebPreference(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreference(this, string, string2);
    }

    @Deprecated
    public int getWebPreferenceAsInt(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceAsInt(this, string);
    }

    @Deprecated
    public int getWebPreferenceAsInt(String string, int n) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceAsInt(this, string, n);
    }

    @Deprecated
    public long getWebPreferenceAsLong(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceAsLong(this, string);
    }

    @Deprecated
    public long getWebPreferenceAsLong(String string, long l) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceAsLong(this, string, l);
    }

    @Deprecated
    public String getWebPreferenceFor(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceFor(this, string, string2);
    }

    @Deprecated
    public String getWebPreferenceFor(String string, String string2, String string3) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getWebPreferenceFor(this, string, string2, string3);
    }

    @Deprecated
    public String getXMLEncoded(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$getXMLEncoded(this, string);
    }

    @Deprecated
    public String invokeServletAndReturnAsString(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$invokeServletAndReturnAsString(this, string);
    }

    @Deprecated
    public boolean isVirtual() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$isVirtual(this);
    }

    @Deprecated
    public boolean isVirtualMode() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$isVirtualMode(this);
    }

    @Deprecated
    public void outputImage(BufferedImage bufferedImage) throws IOException {
        XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$outputImage(this, bufferedImage);
    }

    @Deprecated
    public double parseDouble(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseDouble(this, string);
    }

    @Deprecated
    public float parseFloat(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseFloat(this, string);
    }

    @Deprecated
    public int parseInt(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseInt(this, string);
    }

    @Deprecated
    public Integer parseInteger(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseInteger(this, string);
    }

    @Deprecated
    public long parseLong(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseLong(this, string);
    }

    @Deprecated
    public String parseMessage() {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseMessage(this);
    }

    @Deprecated
    public String parseMessage(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$parseMessage(this, string);
    }

    @Deprecated
    public String printStrackTrace(Throwable throwable) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$printStrackTrace(this, throwable);
    }

    @Deprecated
    public boolean renamePage(Document document, String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$renamePage(this, document, string);
    }

    @Deprecated
    public String renderChunk(Chunk chunk, Document document) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$renderChunk(this, chunk, document);
    }

    @Deprecated
    public String renderChunk(Chunk chunk, boolean bl, Document document) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$renderChunk(this, chunk, bl, document);
    }

    @Deprecated
    public String renderText(String string, Document document) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$renderText(this, string, document);
    }

    @Deprecated
    public void resetRenderingEngine() {
        XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$resetRenderingEngine(this);
    }

    public <T> List<T> search(XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$search(this, xWikiQuery);
    }

    @Deprecated
    public <T> List<T> search(String string) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$search(this, string);
    }

    @Deprecated
    public <T> List<T> search(String string, int n, int n2) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$search(this, string, n, n2);
    }

    @Deprecated
    public <T> List<T> search(String string, int n, int n2, List<?> list) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$search(this, string, n, n2, list);
    }

    @Deprecated
    public <T> List<T> search(String string, List<?> list) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$search(this, string, list);
    }

    public String searchAsTable(XWikiQuery xWikiQuery) throws XWikiException {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$searchAsTable(this, xWikiQuery);
    }

    @Deprecated
    public void sendMessage(String string, String string2, String string3) throws XWikiException {
        XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$sendMessage(this, string, string2, string3);
    }

    @Deprecated
    public void sendMessage(String string, String[] stringArray, String string2) throws XWikiException {
        XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$sendMessage(this, string, stringArray, string2);
    }

    @Deprecated
    public List sort(List list) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$sort(this, list);
    }

    @Deprecated
    public String[] split(String string, String string2) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$split(this, string, string2);
    }

    @Deprecated
    public String sqlfilter(String string) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$sqlfilter(this, string);
    }

    @Deprecated
    public Number toNumber(Object object) {
        return XWikiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_XWikiCompatibilityAspect$com_xpn_xwiki_api_XWiki$toNumber(this, object);
    }
}

