/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.Programming;
import com.xpn.xwiki.web.Utils;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

public class User
extends Api {
    protected static final Logger LOGGER = LoggerFactory.getLogger(User.class);
    private static final EntityReference USERCLASS_REFERENCE = new EntityReference("XWikiUsers", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final DocumentReferenceResolver<String> REFERENCE_RESOLVER = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    private XWikiUser user;

    public User(XWikiUser user, XWikiContext context) {
        super(context);
        this.user = user;
    }

    @Programming
    public XWikiUser getUser() {
        if (this.hasProgrammingRights()) {
            return this.user;
        }
        return null;
    }

    public void setDisabledStatus(boolean disabledStatus) {
        if (this.hasAdminRights()) {
            this.user.setDisabled(disabledStatus, this.getXWikiContext());
        }
    }

    public boolean isDisabled() {
        return this.user.isDisabled(this.getXWikiContext());
    }

    public boolean isUserInGroup(String groupName) {
        boolean result = false;
        try {
            if (this.user == null) {
                LOGGER.warn("User considered not part of group [{}] since user is null", (Object)groupName);
            } else {
                result = this.user.isUserInGroup(groupName, this.getXWikiContext());
            }
        }
        catch (Exception ex) {
            LOGGER.warn(new MessageFormat("Unhandled exception while checking if user {0} belongs to group {1}").format(new Object[]{this.user, groupName}), (Throwable)ex);
        }
        return result;
    }

    protected boolean isMain() {
        return this.user.isMain();
    }

    public String getEmail() {
        try {
            XWikiDocument userDoc = this.getXWikiContext().getWiki().getDocument(this.user.getUser(), this.getXWikiContext());
            BaseObject obj = userDoc.getObject("XWiki.XWikiUsers");
            return obj.getStringValue("email");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean checkPassword(String password) throws XWikiException {
        DocumentReference userReference = REFERENCE_RESOLVER.resolve((Object)this.user.getUser(), new Object[0]);
        DocumentReference docReference = this.getXWikiContext().getDoc().getDocumentReference();
        if (userReference.equals((Object)this.getXWikiContext().getUserReference()) && userReference.equals((Object)docReference)) {
            try {
                boolean result = false;
                XWikiDocument userDoc = this.getXWikiContext().getWiki().getDocument((EntityReference)userReference, this.getXWikiContext());
                BaseObject obj = userDoc.getXObject(USERCLASS_REFERENCE);
                if (obj != null) {
                    String stored = obj.getStringValue("password");
                    result = new PasswordClass().getEquivalentPassword(stored, password).equals(stored);
                }
                return result;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to check password", e);
                return false;
            }
        }
        throw new XWikiException(9, 9001, "You cannot use this method for checking another user password.", null);
    }
}

