/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.server.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.text.CaseUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.ModelContext;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;
import org.xwiki.officeimporter.server.OfficeServerException;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="officemanager")
@Singleton
public class OfficeServerScriptService
implements ScriptService {
    public static final String OFFICE_MANAGER_ERROR = "OFFICE_MANAGER_ERROR";
    private static final String ERROR_FORBIDDEN = "Office server administration is forbidden for sub-wikis.";
    private static final String ERROR_PRIVILEGES = "Inadequate privileges.";
    private static final String TRANSLATION_KEY_SERVER_STATE_PREFIX = "office.config.serverState.";
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private ModelContext modelContext;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private DocumentAccessBridge docBridge;
    @Inject
    private OfficeServerConfiguration officeServerConfig;

    public boolean startServer() {
        if (!this.isMainXWiki()) {
            this.setErrorMessage(ERROR_FORBIDDEN);
        } else if (!this.docBridge.hasProgrammingRights()) {
            this.setErrorMessage(ERROR_PRIVILEGES);
        } else {
            try {
                this.officeServer.start();
                return true;
            }
            catch (OfficeServerException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                this.setErrorMessage(ex.getMessage());
            }
        }
        return false;
    }

    public boolean stopServer() {
        if (!this.isMainXWiki()) {
            this.setErrorMessage(ERROR_FORBIDDEN);
        } else if (!this.docBridge.hasProgrammingRights()) {
            this.setErrorMessage(ERROR_PRIVILEGES);
        } else {
            try {
                this.officeServer.stop();
                return true;
            }
            catch (OfficeServerException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                this.setErrorMessage(ex.getMessage());
            }
        }
        return false;
    }

    public boolean isConnected() {
        this.officeServer.refreshState();
        return this.officeServer.getState() == OfficeServer.ServerState.CONNECTED;
    }

    public String displayServerState() {
        this.officeServer.refreshState();
        String normalizedStatusKey = CaseUtils.toCamelCase((String)this.officeServer.getState().name().toLowerCase(), (boolean)false, (char[])new char[]{'_'});
        return this.contextualLocalizationManager.getTranslationPlain(TRANSLATION_KEY_SERVER_STATE_PREFIX + normalizedStatusKey, new Object[0]);
    }

    @Deprecated
    public String getServerState() {
        this.officeServer.refreshState();
        return this.officeServer.getState().toString();
    }

    public OfficeServerConfiguration getConfig() {
        return this.officeServerConfig;
    }

    public String getLastErrorMessage() {
        Object error = this.execution.getContext().getProperty(OFFICE_MANAGER_ERROR);
        return error != null ? (String)error : null;
    }

    private void setErrorMessage(String message) {
        this.execution.getContext().setProperty(OFFICE_MANAGER_ERROR, (Object)message);
    }

    private boolean isMainXWiki() {
        String currentWiki = this.modelContext.getCurrentEntityReference().getName();
        return currentWiki != null && currentWiki.equals("xwiki");
    }
}

