/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.script;

import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.builder.XHTMLOfficeDocumentBuilder;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.document.XHTMLOfficeDocument;
import org.xwiki.officeimporter.internal.ModelBridge;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;
import org.xwiki.officeimporter.server.OfficeServerException;
import org.xwiki.officeimporter.splitter.OfficeDocumentSplitterParameters;
import org.xwiki.officeimporter.splitter.TargetDocumentDescriptor;
import org.xwiki.officeimporter.splitter.XDOMOfficeDocumentSplitter;
import org.xwiki.rendering.configuration.ExtendedRenderingConfiguration;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="officeimporter")
@Singleton
public class OfficeImporterScriptService
implements ScriptService {
    public static final String OFFICE_IMPORTER_ERROR = "OFFICE_IMPORTER_ERROR";
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private OfficeServerConfiguration officeServerConfiguration;
    @Inject
    private XHTMLOfficeDocumentBuilder xhtmlBuilder;
    @Inject
    private XDOMOfficeDocumentBuilder xdomBuilder;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private XDOMOfficeDocumentSplitter xdomSplitter;
    @Inject
    private ExtendedRenderingConfiguration extendedRenderingConfiguration;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private ModelBridge modelBridge;

    public XHTMLOfficeDocument officeToXHTML(InputStream officeFileStream, String officeFileName, DocumentReference targetDocumentReference, boolean filterStyles) {
        try {
            this.assertConnected();
            return this.xhtmlBuilder.build(officeFileStream, officeFileName, targetDocumentReference, filterStyles);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public XDOMOfficeDocument xhtmlToXDOM(XHTMLOfficeDocument xhtmlOfficeDocument) {
        try {
            return this.xdomBuilder.build(xhtmlOfficeDocument);
        }
        catch (OfficeImporterException ex) {
            this.setErrorMessage(ex.getMessage());
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public XDOMOfficeDocument officeToXDOM(InputStream officeFileStream, String officeFileName, DocumentReference targetDocumentReference, boolean filterStyles) {
        try {
            this.assertConnected();
            if (this.officeServer.getConverter().isPresentation(officeFileName)) {
                return this.presentationBuilder.build(officeFileStream, officeFileName, targetDocumentReference);
            }
            return this.xdomBuilder.build(officeFileStream, officeFileName, targetDocumentReference, filterStyles);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Map<TargetDocumentDescriptor, XDOMOfficeDocument> split(XDOMOfficeDocument xdomDocument, String[] headingLevels, String namingCriterionHint, DocumentReference rootDocumentReference) {
        String defaultDocumentName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        boolean useTerminalPages = !defaultDocumentName.equals(rootDocumentReference.getName());
        return this.split(xdomDocument, headingLevels, namingCriterionHint, useTerminalPages, rootDocumentReference);
    }

    public Map<TargetDocumentDescriptor, XDOMOfficeDocument> split(XDOMOfficeDocument xdomDocument, String[] headingLevels, String namingCriterionHint, boolean useTerminalPages, DocumentReference rootDocumentReference) {
        int[] splitLevels = new int[headingLevels.length];
        for (int i = 0; i < headingLevels.length; ++i) {
            splitLevels[i] = Integer.parseInt(headingLevels[i]);
        }
        OfficeDocumentSplitterParameters parameters = new OfficeDocumentSplitterParameters();
        parameters.setHeadingLevelsToSplit(splitLevels);
        parameters.setNamingCriterionHint(namingCriterionHint);
        parameters.setUseTerminalPages(useTerminalPages);
        parameters.setBaseDocumentReference(rootDocumentReference);
        try {
            return this.xdomSplitter.split(xdomDocument, parameters);
        }
        catch (OfficeImporterException ex) {
            this.setErrorMessage(ex.getMessage());
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public boolean save(XDOMOfficeDocument doc, DocumentReference documentReference, boolean append) {
        return this.save(doc, documentReference, null, null, append);
    }

    public boolean save(XDOMOfficeDocument doc, DocumentReference documentReference, DocumentReference parentReference, String title, boolean append) {
        return this.save(doc, documentReference, this.extendedRenderingConfiguration.getDefaultContentSyntax().toIdString(), parentReference, title, append);
    }

    public boolean save(XDOMOfficeDocument doc, DocumentReference documentReference, String syntaxId, DocumentReference parentReference, String title, boolean append) {
        try {
            this.modelBridge.save(doc, documentReference, syntaxId, parentReference, title, append);
            return true;
        }
        catch (OfficeImporterException ex) {
            this.setErrorMessage(ex.getMessage());
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            String message = "Error while saving document [%s].";
            message = String.format(message, documentReference);
            this.setErrorMessage(message);
            this.logger.error(message, (Throwable)ex);
        }
        return false;
    }

    public String getErrorMessage() {
        return (String)this.execution.getContext().getProperty(OFFICE_IMPORTER_ERROR);
    }

    private void setErrorMessage(String message) {
        this.execution.getContext().setProperty(OFFICE_IMPORTER_ERROR, (Object)message);
    }

    private void assertConnected() throws OfficeImporterException, OfficeServerException {
        boolean connected = this.officeServer.getState().equals((Object)OfficeServer.ServerState.CONNECTED);
        if (!connected) {
            if (this.officeServerConfiguration.isAutoStart()) {
                this.officeServer.start();
                connected = this.officeServer.getState().equals((Object)OfficeServer.ServerState.CONNECTED);
            }
            if (!connected) {
                throw new OfficeImporterException("Office server unavailable.");
            }
        }
    }
}

