/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.splitter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.splitter.OfficeDocumentSplitterParameters;
import org.xwiki.officeimporter.splitter.TargetDocumentDescriptor;
import org.xwiki.officeimporter.splitter.XDOMOfficeDocumentSplitter;
import org.xwiki.refactoring.WikiDocument;
import org.xwiki.refactoring.splitter.DocumentSplitter;
import org.xwiki.refactoring.splitter.criterion.HeadingLevelSplittingCriterion;
import org.xwiki.refactoring.splitter.criterion.SplittingCriterion;
import org.xwiki.refactoring.splitter.criterion.naming.NamingCriterion;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;

@Component
@Singleton
public class DefaultXDOMOfficeDocumentSplitter
implements XDOMOfficeDocumentSplitter {
    @Inject
    private DocumentSplitter documentSplitter;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public Map<TargetDocumentDescriptor, XDOMOfficeDocument> split(XDOMOfficeDocument officeDocument, OfficeDocumentSplitterParameters parameters) throws OfficeImporterException {
        NamingCriterion namingCriterion;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        HashMap<TargetDocumentDescriptor, XDOMOfficeDocument> result = new HashMap<TargetDocumentDescriptor, XDOMOfficeDocument>();
        HeadingLevelSplittingCriterion splittingCriterion = new HeadingLevelSplittingCriterion(parameters.getHeadingLevelsToSplit());
        try {
            namingCriterion = (NamingCriterion)componentManager.getInstance(NamingCriterion.class, parameters.getNamingCriterionHint());
        }
        catch (ComponentLookupException e) {
            throw new OfficeImporterException("Failed to create the naming criterion.", e);
        }
        namingCriterion.getParameters().setBaseDocumentReference(parameters.getBaseDocumentReference());
        namingCriterion.getParameters().setUseTerminalPages(parameters.isUseTerminalPages());
        WikiDocument rootDoc = new WikiDocument(parameters.getBaseDocumentReference(), officeDocument.getContentDocument(), null);
        List documents = this.documentSplitter.split(rootDoc, (SplittingCriterion)splittingCriterion, namingCriterion);
        for (WikiDocument doc : documents) {
            TargetDocumentDescriptor targetDocumentDescriptor = new TargetDocumentDescriptor(doc.getDocumentReference(), componentManager);
            if (doc.getParent() != null) {
                targetDocumentDescriptor.setParentReference(doc.getParent().getDocumentReference());
            }
            Map<String, OfficeDocumentArtifact> artifactsMap = this.relocateArtifacts(doc, officeDocument);
            XDOMOfficeDocument splitDocument = new XDOMOfficeDocument(doc.getXdom(), artifactsMap, componentManager, officeDocument.getConverterResult());
            result.put(targetDocumentDescriptor, splitDocument);
        }
        return result;
    }

    private Map<String, OfficeDocumentArtifact> relocateArtifacts(WikiDocument sectionDoc, XDOMOfficeDocument officeDocument) {
        Map<String, OfficeDocumentArtifact> artifacts = officeDocument.getArtifactsMap();
        HashMap<String, OfficeDocumentArtifact> result = new HashMap<String, OfficeDocumentArtifact>();
        List imageBlocks = sectionDoc.getXdom().getBlocks((BlockMatcher)new ClassBlockMatcher(ImageBlock.class), Block.Axes.DESCENDANT);
        for (ImageBlock imageBlock : imageBlocks) {
            String imageReference = imageBlock.getReference().getReference();
            OfficeDocumentArtifact artifact = artifacts.get(imageReference);
            if (artifact == null) continue;
            result.put(imageReference, artifact);
        }
        return result;
    }
}

