/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.openoffice;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.internal.openoffice.DefaultOpenOfficeConverter;
import org.xwiki.officeimporter.openoffice.OpenOfficeConverter;
import org.xwiki.officeimporter.openoffice.OpenOfficeManager;
import org.xwiki.officeimporter.openoffice.OpenOfficeManagerException;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerException;

@Component
@Singleton
public class DefaultOpenOfficeManager
implements OpenOfficeManager {
    @Inject
    private OfficeServer officeServer;
    private OpenOfficeConverter converter;

    @Override
    public OpenOfficeManager.ManagerState getState() {
        OfficeServer.ServerState serverState = this.officeServer.getState();
        if (serverState != null) {
            OpenOfficeManager.ManagerState[] managerStateArray = OpenOfficeManager.ManagerState.values();
            int n = managerStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                OpenOfficeManager.ManagerState managerState = managerStateArray[n2];
                if (managerState.ordinal() == serverState.ordinal()) {
                    return managerState;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void start() throws OpenOfficeManagerException {
        try {
            this.officeServer.start();
        }
        catch (OfficeServerException e) {
            throw new OpenOfficeManagerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void stop() throws OpenOfficeManagerException {
        try {
            this.officeServer.stop();
        }
        catch (OfficeServerException e) {
            throw new OpenOfficeManagerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public OpenOfficeConverter getConverter() {
        OfficeConverter officeConverter;
        if (this.converter == null && (officeConverter = this.officeServer.getConverter()) != null) {
            this.converter = new DefaultOpenOfficeConverter(officeConverter);
        }
        return this.converter;
    }
}

