/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.html.filter.ElementSelector;

@Component
@Named(value="officeimporter/redundancy")
@Singleton
public class RedundancyFilter
extends AbstractHTMLFilter {
    private static final String[] FILTERED_IF_NO_ATTRIBUTES_TAGS = new String[]{"span", "div"};
    private static final String[] FILTERED_IF_NO_CONTENT_TAGS = new String[]{"em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "address", "blockquote", "q", "pre", "h1", "h2", "h3", "h4", "h5", "h6"};

    public void filter(Document document, Map<String, String> cleaningParams) {
        List elementsWithNoAttributes = this.filterDescendants(document.getDocumentElement(), FILTERED_IF_NO_ATTRIBUTES_TAGS, new ElementSelector(){

            public boolean isSelected(Element element) {
                return !element.hasAttributes();
            }
        });
        for (Element element : elementsWithNoAttributes) {
            this.replaceWithChildren(element);
        }
        List elementsWithNoContent = this.filterDescendants(document.getDocumentElement(), FILTERED_IF_NO_CONTENT_TAGS, new ElementSelector(){

            public boolean isSelected(Element element) {
                return element.getTextContent().trim().equals("");
            }
        });
        for (Element element : elementsWithNoContent) {
            String textContent = element.getTextContent();
            if (textContent.equals("")) {
                element.getParentNode().removeChild(element);
                continue;
            }
            element.setTextContent(textContent.replaceAll(" ", "&nbsp;"));
        }
    }
}

