/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.html.filter.ElementSelector;

@Component
@Named(value="officeimporter/paragraph")
@Singleton
public class ParagraphFilter
extends AbstractHTMLFilter {
    public void filter(Document document, Map<String, String> cleaningParams) {
        for (Node p : this.findEmptyLineParagraphSequences(document)) {
            Node next = p.getNextSibling();
            p.getParentNode().removeChild(p);
            while (this.isEmptyLineParagraph(next)) {
                Node following = next.getNextSibling();
                this.replaceWithChildren((Element)next);
                next = following;
            }
        }
    }

    private List<Node> findEmptyLineParagraphSequences(Document document) {
        List emptyLineParagraphs = this.filterDescendants(document.getDocumentElement(), new String[]{"p"}, new ElementSelector(){

            public boolean isSelected(Element element) {
                return ParagraphFilter.this.isEmptyLineParagraph(element);
            }
        });
        ArrayList<Node> sequences = new ArrayList<Node>();
        for (Element emptyLineParagraph : emptyLineParagraphs) {
            Node prev = emptyLineParagraph.getPreviousSibling();
            while (this.isEmptyTextNode(prev) || this.isCommentNode(prev)) {
                Node oneBefore = prev.getPreviousSibling();
                prev.getParentNode().removeChild(prev);
                prev = oneBefore;
            }
            if (this.isEmptyLineParagraph(prev)) continue;
            sequences.add(emptyLineParagraph);
        }
        return sequences;
    }

    private boolean isParagraph(Node node) {
        return null != node && node.getNodeName().equals("p");
    }

    private boolean isEmptyLineParagraph(Node node) {
        boolean isEmptyLine = false;
        if (this.isParagraph(node)) {
            isEmptyLine = true;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (this.isEmptyTextNode(child) || this.isCommentNode(child) || this.isLineBreak(child)) continue;
                isEmptyLine = false;
            }
        }
        return isEmptyLine;
    }

    private boolean isEmptyTextNode(Node node) {
        return null != node && node.getNodeType() == 3 && node.getTextContent().trim().equals("");
    }

    private boolean isCommentNode(Node node) {
        return null != node && node.getNodeType() == 8;
    }

    private boolean isLineBreak(Node node) {
        return null != node && node.getNodeName().equals("br");
    }
}

