/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.html.filter.ElementSelector;

@Component
@Named(value="officeimporter/linebreak")
@Singleton
public class LineBreakFilter
extends AbstractHTMLFilter {
    private static final String[] BLOCK_ELEMENT_TAGS = new String[]{"p", "ul", "ol", "h1", "h2", "h3", "h4", "h5", "h6", "table"};

    public void filter(Document document, Map<String, String> cleaningParams) {
        List lineBreaksToReplace = this.filterDescendants(document.getDocumentElement(), new String[]{"br"}, new ElementSelector(){

            public boolean isSelected(Element element) {
                Node prev = LineBreakFilter.this.findPreviousNode(element);
                Node next = LineBreakFilter.this.findNextNode(element);
                return !(null == prev && null == next || !LineBreakFilter.this.isBlockElement(prev) && !LineBreakFilter.this.isBlockElement(next));
            }
        });
        for (Element lineBreak : lineBreaksToReplace) {
            Node parent = lineBreak.getParentNode();
            Element element = document.createElement("div");
            element.setAttribute("class", "wikimodel-emptyline");
            parent.insertBefore(element, lineBreak);
            parent.removeChild(lineBreak);
        }
    }

    private Node findPreviousNode(Element element) {
        Node prev;
        for (prev = element.getPreviousSibling(); prev != null && (this.isLineBreak(prev) || this.isEmptyTextNode(prev) || this.isCommentNode(prev)); prev = prev.getPreviousSibling()) {
        }
        return prev;
    }

    private Node findNextNode(Element element) {
        Node next;
        for (next = element.getNextSibling(); next != null && (this.isLineBreak(next) || this.isEmptyTextNode(next) || this.isCommentNode(next)); next = next.getNextSibling()) {
        }
        return next;
    }

    private boolean isBlockElement(Node node) {
        boolean isBlockElement = false;
        if (null != node) {
            for (String blockElement : BLOCK_ELEMENT_TAGS) {
                isBlockElement = blockElement.equals(node.getNodeName()) ? true : isBlockElement;
            }
        }
        return isBlockElement;
    }

    private boolean isEmptyTextNode(Node node) {
        return null != node && node.getNodeType() == 3 && node.getTextContent().trim().equals("");
    }

    private boolean isCommentNode(Node node) {
        return null != node && node.getNodeType() == 8;
    }

    private boolean isLineBreak(Node node) {
        return null != node && node.getNodeName().equals("br");
    }

    static {
        Arrays.sort(BLOCK_ELEMENT_TAGS);
    }
}

