/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import com.github.ooxi.jdatauri.DataUri;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="officeimporter/image")
@Singleton
public class ImageFilter
extends AbstractHTMLFilter {
    private static final String UTF_8 = "UTF-8";
    private static final String EMBEDDED_IMAGES = "embeddedImages";
    @Inject
    private Logger logger;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceSerializer xhtmlMarkerSerializer;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> stringDocumentReferenceResolver;

    public void filter(Document htmlDocument, Map<String, String> cleaningParams) {
        String targetDocumentName = cleaningParams.get("targetDocument");
        DocumentReference targetDocumentReference = targetDocumentName == null ? null : this.stringDocumentReferenceResolver.resolve((Object)targetDocumentName, new Object[0]);
        boolean attachEmbeddedImages = Boolean.valueOf(cleaningParams.get("attachEmbeddedImages"));
        if (attachEmbeddedImages) {
            htmlDocument.setUserData(EMBEDDED_IMAGES, new HashMap(), null);
        }
        String replaceAttachmentPrefix = cleaningParams.get("replaceImagePrefix");
        String replacementAttachmentPrefix = cleaningParams.get("replacementImagePrefix");
        List images = this.filterDescendants(htmlDocument.getDocumentElement(), new String[]{"img"});
        for (Element image : images) {
            Attr source = image.getAttributeNode("src");
            if (source != null && targetDocumentReference != null) {
                this.filterImageSource(source, targetDocumentReference, replaceAttachmentPrefix, replacementAttachmentPrefix);
            }
            image.removeAttribute("align");
        }
    }

    private void filterImageSource(Attr source, DocumentReference targetDocumentReference, String replacePrefix, String replacementPrefix) {
        String fileName = null;
        try {
            fileName = this.getFileName(source, replacePrefix, replacementPrefix);
        }
        catch (Exception e) {
            this.logger.warn("Failed to extract the image file name. Root cause is [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.logger.debug("Full stacktrace is: ", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        AttachmentReference attachmentReference = new AttachmentReference(fileName, targetDocumentReference);
        source.setValue(this.documentAccessBridge.getAttachmentURL(attachmentReference, false));
        ResourceReference imageReference = new ResourceReference(fileName, ResourceType.ATTACHMENT);
        imageReference.setTyped(false);
        Comment beforeComment = source.getOwnerDocument().createComment(XMLUtils.escapeXMLComment((String)("startimage:" + this.xhtmlMarkerSerializer.serialize(imageReference))));
        Comment afterComment = source.getOwnerDocument().createComment("stopimage");
        Element image = source.getOwnerElement();
        image.getParentNode().insertBefore(beforeComment, image);
        image.getParentNode().insertBefore(afterComment, image.getNextSibling());
    }

    private String getFileName(Attr source, String replacePrefix, String replacementPrefix) throws MimeTypeException {
        String value = source.getValue();
        Object fileName = null;
        Map embeddedImages = (Map)source.getOwnerDocument().getUserData(EMBEDDED_IMAGES);
        if (embeddedImages != null && value.startsWith("data:")) {
            DataUri dataURI = DataUri.parse((String)value, (Charset)Charset.forName(UTF_8));
            fileName = dataURI.getFilename();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                fileName = String.valueOf(Math.abs(dataURI.hashCode()));
                if (!StringUtils.isEmpty((CharSequence)dataURI.getMime())) {
                    String extension = MimeTypes.getDefaultMimeTypes().forName(dataURI.getMime()).getExtension();
                    fileName = (String)fileName + extension;
                }
            }
            embeddedImages.put(fileName, dataURI.getData());
        } else if (!value.contains("://")) {
            int separator = value.lastIndexOf(47);
            fileName = separator < 0 ? value : value.substring(separator + 1);
            try {
                fileName = ((String)fileName).replaceAll("\\+", "%2B");
                fileName = URLDecoder.decode((String)fileName, UTF_8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileName = ImageFilter.replacePrefix(replacePrefix, replacementPrefix, (String)fileName);
            fileName = ((String)fileName).replace("@", "\\@");
        }
        return fileName;
    }

    private static String replacePrefix(String replacePrefix, String replacementPrefix, String fileName) {
        Object result = fileName;
        if (Strings.CS.startsWith((CharSequence)fileName, (CharSequence)replacePrefix) && replacementPrefix != null) {
            result = replacementPrefix + Strings.CS.removeStart(fileName, (CharSequence)replacePrefix);
        }
        return result;
    }
}

