/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.document;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;

public class FileOfficeDocumentArtifact
implements OfficeDocumentArtifact {
    private final String name;
    private final File content;

    public FileOfficeDocumentArtifact(String name, File content) {
        this.name = name;
        this.content = content;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getContentInputStream() throws OfficeImporterException {
        try {
            return new FileInputStream(this.content);
        }
        catch (FileNotFoundException e) {
            throw new OfficeImporterException("Artifact file not found", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileOfficeDocumentArtifact that = (FileOfficeDocumentArtifact)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append((Object)this.content, (Object)that.content).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).append((Object)this.content).toHashCode();
    }
}

