/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.converter;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xwiki.officeimporter.converter.OfficeConverterException;
import org.xwiki.officeimporter.converter.OfficeConverterResult;
import org.xwiki.officeimporter.internal.converter.OfficeConverterFileStorage;

public class DefaultOfficeConverterResult
implements OfficeConverterResult {
    private final OfficeConverterFileStorage fileStorage;
    private final Set<File> allFiles;

    public DefaultOfficeConverterResult(OfficeConverterFileStorage fileStorage) throws OfficeConverterException {
        this.fileStorage = fileStorage;
        File[] files = fileStorage.getOutputDir().listFiles();
        if (files == null) {
            throw new OfficeConverterException(String.format("The output directory of the office conversion does not contain any files: [%s]", fileStorage.getOutputDir().getAbsolutePath()));
        }
        this.allFiles = new HashSet<File>(Arrays.asList(files));
        if (!this.fileStorage.getOutputFile().exists()) {
            throw new OfficeConverterException(String.format("Output file [%s] does not exist.", fileStorage.getOutputFile().getAbsolutePath()));
        }
    }

    @Override
    public File getOutputFile() {
        return this.fileStorage.getOutputFile();
    }

    @Override
    public File getOutputDirectory() {
        return this.fileStorage.getOutputDir();
    }

    @Override
    public Set<File> getAllFiles() {
        return this.allFiles;
    }

    @Override
    public void close() {
        this.fileStorage.cleanUp();
    }
}

