/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.converter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.converter.OfficeConverterException;
import org.xwiki.officeimporter.converter.OfficeDocumentFormat;
import org.xwiki.officeimporter.internal.converter.DefaultOfficeConverterCompatibilityAspect;
import org.xwiki.officeimporter.internal.converter.DefaultOfficeConverterResult;
import org.xwiki.officeimporter.internal.converter.DefaultOfficeDocumentFormat;
import org.xwiki.officeimporter.internal.converter.OfficeConverterFileStorage;

public class DefaultOfficeConverter
implements OfficeConverter {
    private static final String CONVERSION_ERROR_MESSAGE = "Error while performing conversion.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOfficeConverter.class);
    private DocumentConverter converter;
    private File workDir;

    public DefaultOfficeConverter(DocumentConverter converter, File workDir) {
        this.converter = converter;
        this.workDir = workDir;
    }

    private void checkInputStream(Map<String, InputStream> inputStreams, String inputFileName) throws OfficeConverterException {
        if (null == inputStreams.get(inputFileName)) {
            String message = "No input stream specified for main input file [%s].";
            throw new OfficeConverterException(String.format(message, inputFileName));
        }
    }

    @Override
    public DefaultOfficeConverterResult convertDocument(Map<String, InputStream> inputStreams, String inputFileName, String outputFileName) throws OfficeConverterException {
        this.checkInputStream(inputStreams, inputFileName);
        try {
            OfficeConverterFileStorage storage = new OfficeConverterFileStorage(this.workDir, inputFileName, outputFileName);
            this.checkInputStream(inputStreams, storage.getInputFile().getName());
            for (Map.Entry<String, InputStream> entry : inputStreams.entrySet()) {
                File temp = new File(storage.getInputDir(), entry.getKey());
                try (FileOutputStream fos = new FileOutputStream(temp);){
                    IOUtils.copy((InputStream)entry.getValue(), (OutputStream)fos);
                }
            }
            this.converter.convert(storage.getInputFile()).to(storage.getOutputFile()).execute();
            return new DefaultOfficeConverterResult(storage);
        }
        catch (Exception ex) {
            throw new OfficeConverterException(CONVERSION_ERROR_MESSAGE, ex);
        }
    }

    @Override
    public boolean isPresentation(String officeFileName) {
        String extension = officeFileName.substring(officeFileName.lastIndexOf(46) + 1);
        DocumentFormat format = this.converter.getFormatRegistry().getFormatByExtension(extension);
        return format != null && format.getInputFamily() == DocumentFamily.PRESENTATION;
    }

    @Override
    public boolean isMediaTypeSupported(String mediaType) {
        return this.converter.getFormatRegistry().getFormatByMediaType(mediaType) != null;
    }

    @Override
    public boolean isConversionSupported(String inputMediaType, String outputMediaType) {
        DocumentFormat inputFormat = this.converter.getFormatRegistry().getFormatByMediaType(inputMediaType);
        DocumentFormat outputFormat = this.converter.getFormatRegistry().getFormatByMediaType(outputMediaType);
        return inputFormat != null && outputFormat != null && outputFormat.getStoreProperties(inputFormat.getInputFamily()) != null;
    }

    @Override
    public OfficeDocumentFormat getDocumentFormat(String officeFileName) {
        String extension = officeFileName.substring(officeFileName.lastIndexOf(46) + 1);
        DocumentFormat format = this.converter.getFormatRegistry().getFormatByExtension(extension);
        return format != null ? new DefaultOfficeDocumentFormat(format) : null;
    }

    public static /* synthetic */ File ajc$get$workDir(DefaultOfficeConverter defaultOfficeConverter) {
        return defaultOfficeConverter.workDir;
    }

    public static /* synthetic */ void ajc$set$workDir(DefaultOfficeConverter defaultOfficeConverter, File file) {
        defaultOfficeConverter.workDir = file;
    }

    public /* synthetic */ void ajc$privMethod$org_xwiki_officeimporter_internal_converter_DefaultOfficeConverterCompatibilityAspect$org_xwiki_officeimporter_internal_converter_DefaultOfficeConverter$checkInputStream(Map map, String string) throws OfficeConverterException {
        this.checkInputStream(map, string);
    }

    public static /* synthetic */ DocumentConverter ajc$get$converter(DefaultOfficeConverter defaultOfficeConverter) {
        return defaultOfficeConverter.converter;
    }

    public static /* synthetic */ void ajc$set$converter(DefaultOfficeConverter defaultOfficeConverter, DocumentConverter documentConverter) {
        defaultOfficeConverter.converter = documentConverter;
    }

    public static /* synthetic */ String ajc$get$CONVERSION_ERROR_MESSAGE() {
        return CONVERSION_ERROR_MESSAGE;
    }

    public static /* synthetic */ void ajc$set$CONVERSION_ERROR_MESSAGE(String string) {
        CONVERSION_ERROR_MESSAGE = string;
    }

    public static /* synthetic */ Logger ajc$get$LOGGER() {
        return LOGGER;
    }

    public static /* synthetic */ void ajc$set$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    @Override
    @Deprecated
    public Map<String, byte[]> convert(Map<String, InputStream> map, String string, String string2) throws OfficeConverterException {
        return DefaultOfficeConverterCompatibilityAspect.ajc$interMethod$org_xwiki_officeimporter_internal_converter_DefaultOfficeConverterCompatibilityAspect$org_xwiki_officeimporter_internal_converter_DefaultOfficeConverter$convert(this, map, string, string2);
    }
}

