/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;

@Component(roles={PresentationBuilderConfiguration.class})
@Singleton
public class PresentationBuilderConfiguration
implements Initializable {
    private static final String DEFAULT_IMAGE_FORMAT = "jpg";
    private int slideWidth = 1920;
    private float quality = 95.0f;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        try {
            if (!this.extractConfigurationFromJsonRegistry("/custom-document-formats.json")) {
                this.extractConfigurationFromJsonRegistry("/document-formats.js");
            }
        }
        catch (Exception e) {
            this.logger.error("Error when initializing values from document format registry, default values will be used.", (Throwable)e);
        }
    }

    private boolean extractConfigurationFromJsonRegistry(String filename) throws IOException {
        AtomicBoolean result = new AtomicBoolean(false);
        try (InputStream configurationInput = this.getClass().getResourceAsStream(filename);){
            if (configurationInput != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(configurationInput);
                for (JsonNode formatNode : jsonNode) {
                    this.getJsonNode(formatNode, "name").filter(nameNode -> "HTML".equals(nameNode.asText())).flatMap(nameNode -> this.getJsonNode(formatNode, "storeProperties")).flatMap(storeProperties -> this.getJsonNode((JsonNode)storeProperties, "PRESENTATION")).flatMap(presentationProperties -> this.getJsonNode((JsonNode)presentationProperties, "FilterData")).ifPresent(filterData -> {
                        result.set(true);
                        this.getJsonNode((JsonNode)filterData, "Quality").ifPresent(qualityNode -> {
                            this.quality = qualityNode.asInt();
                        });
                        this.getJsonNode((JsonNode)filterData, "Width").ifPresent(widthNode -> {
                            this.slideWidth = widthNode.asInt();
                        });
                    });
                }
            }
        }
        return result.get();
    }

    private Optional<JsonNode> getJsonNode(JsonNode jsonNode, String fieldName) {
        return Optional.ofNullable(jsonNode.get(fieldName));
    }

    public int getSlideWidth() {
        return (Integer)this.configurationSource.getProperty("officeimporter.presentation.slideWidth", (Object)this.slideWidth);
    }

    public float getQuality() {
        if ("png".equals(this.getImageFormat())) {
            return 0.0f;
        }
        return ((Float)this.configurationSource.getProperty("officeimporter.presentation.quality", (Object)Float.valueOf(this.quality))).floatValue() / 100.0f;
    }

    public String getImageFormat() {
        return (String)this.configurationSource.getProperty("officeimporter.presentation.imageFormat", (Object)DEFAULT_IMAGE_FORMAT);
    }
}

