/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.builder.XHTMLOfficeDocumentBuilder;
import org.xwiki.officeimporter.converter.OfficeConverterException;
import org.xwiki.officeimporter.converter.OfficeConverterResult;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XHTMLOfficeDocument;
import org.xwiki.officeimporter.internal.converter.OfficeConverterFileStorage;
import org.xwiki.officeimporter.internal.document.ByteArrayOfficeDocumentArtifact;
import org.xwiki.officeimporter.internal.document.FileOfficeDocumentArtifact;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;

@Component
@Singleton
public class DefaultXHTMLOfficeDocumentBuilder
implements XHTMLOfficeDocumentBuilder {
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private OfficeServer officeServer;
    @Inject
    @Named(value="openoffice")
    private HTMLCleaner officeHtmlCleaner;

    @Override
    public XHTMLOfficeDocument build(InputStream officeFileStream, String officeFileName, DocumentReference reference, boolean filterStyles) throws OfficeImporterException {
        OfficeConverterResult officeConverterResult;
        String inputFileName = OfficeConverterFileStorage.getSafeInputFilenameFromExtension(officeFileName);
        HashMap<String, InputStream> inputStreams = new HashMap<String, InputStream>();
        inputStreams.put(inputFileName, officeFileStream);
        String outputFileName = "output.html";
        try {
            officeConverterResult = this.officeServer.getConverter().convertDocument(inputStreams, inputFileName, outputFileName);
        }
        catch (OfficeConverterException ex) {
            String message = "Error while converting document [%s] into html.";
            throw new OfficeImporterException(String.format(message, officeFileName), ex);
        }
        String replacePrefix = "output_html_";
        String replacementPrefix = StringUtils.substringBeforeLast((String)officeFileName, (String)".") + "_";
        Document xhtmlDoc = this.cleanAndCreateFile(reference, filterStyles, officeConverterResult, replacePrefix, replacementPrefix);
        Map<String, OfficeDocumentArtifact> artifacts = this.handleArtifacts(xhtmlDoc, officeConverterResult, replacePrefix, replacementPrefix);
        return new XHTMLOfficeDocument(xhtmlDoc, artifacts, officeConverterResult);
    }

    private Document cleanAndCreateFile(DocumentReference reference, boolean filterStyles, OfficeConverterResult officeConverterResult, String replacePrefix, String replacementPrefix) throws OfficeImporterException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetDocument", (String)this.entityReferenceSerializer.serialize((EntityReference)reference, new Object[0]));
        params.put("attachEmbeddedImages", "true");
        params.put("replaceImagePrefix", replacePrefix);
        params.put("replacementImagePrefix", replacementPrefix);
        if (filterStyles) {
            params.put("filterStyles", "strict");
        }
        HTMLCleanerConfiguration configuration = this.officeHtmlCleaner.getDefaultConfiguration();
        configuration.setParameters(params);
        FileReader html = null;
        try {
            html = new FileReader(officeConverterResult.getOutputFile());
        }
        catch (FileNotFoundException e) {
            throw new OfficeImporterException(String.format("The output file cannot be found: [%s].", officeConverterResult.getOutputFile()), e);
        }
        return this.officeHtmlCleaner.clean((Reader)html, configuration);
    }

    private Map<String, OfficeDocumentArtifact> handleArtifacts(Document xhtmlDoc, OfficeConverterResult officeConverterResult, String replacePrefix, String replacementPrefix) {
        HashMap<String, OfficeDocumentArtifact> artifacts = new HashMap<String, OfficeDocumentArtifact>();
        for (File file : officeConverterResult.getAllFiles()) {
            Object filename = file.getName();
            if (Strings.CS.startsWith((CharSequence)filename, (CharSequence)replacePrefix)) {
                filename = replacementPrefix + Strings.CS.removeStart((String)filename, (CharSequence)replacePrefix);
            }
            artifacts.put((String)filename, new FileOfficeDocumentArtifact(file.getName(), file));
        }
        artifacts.remove(officeConverterResult.getOutputFile().getName());
        Map embeddedImages = (Map)xhtmlDoc.getUserData("embeddedImages");
        if (embeddedImages != null) {
            for (Map.Entry embeddedImage : embeddedImages.entrySet()) {
                String fileName = (String)embeddedImage.getKey();
                artifacts.put(fileName, new ByteArrayOfficeDocumentArtifact(fileName, (byte[])embeddedImage.getValue()));
            }
        }
        return artifacts;
    }
}

