/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.builder;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.builder.XHTMLOfficeDocumentBuilder;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.document.XHTMLOfficeDocument;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
public class DefaultXDOMOfficeDocumentBuilder
implements XDOMOfficeDocumentBuilder {
    @Inject
    private XHTMLOfficeDocumentBuilder xhtmlOfficeDocumentBuilder;
    @Inject
    @Named(value="xhtml/1.0")
    private Parser xHtmlParser;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    public XDOMOfficeDocument build(InputStream officeFileStream, String officeFileName, DocumentReference reference, boolean filterStyles) throws OfficeImporterException {
        XDOMOfficeDocument xdomOfficeDocument = this.build(this.xhtmlOfficeDocumentBuilder.build(officeFileStream, officeFileName, reference, filterStyles));
        xdomOfficeDocument.getContentDocument().getMetaData().addMetaData("base", this.entityReferenceSerializer.serialize((EntityReference)reference, new Object[0]));
        return xdomOfficeDocument;
    }

    @Override
    public XDOMOfficeDocument build(XHTMLOfficeDocument xhtmlOfficeDocument) throws OfficeImporterException {
        Document xhtmlDoc = xhtmlOfficeDocument.getContentDocument();
        HTMLUtils.stripHTMLEnvelope((Document)xhtmlDoc);
        XDOM xdom = null;
        try {
            xdom = this.xHtmlParser.parse((Reader)new StringReader(HTMLUtils.toString((Document)xhtmlDoc)));
        }
        catch (ParseException ex) {
            throw new OfficeImporterException("Error: Could not parse xhtml office content.", ex);
        }
        return new XDOMOfficeDocument(xdom, xhtmlOfficeDocument.getArtifactsMap(), this.componentManager, xhtmlOfficeDocument.getConverterResult());
    }
}

