/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.builder;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.w3c.dom.Document;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.converter.OfficeConverterException;
import org.xwiki.officeimporter.converter.OfficeConverterResult;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.internal.builder.PresentationBuilderConfiguration;
import org.xwiki.officeimporter.internal.converter.OfficeConverterFileStorage;
import org.xwiki.officeimporter.internal.document.FileOfficeDocumentArtifact;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ExpandedMacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
public class DefaultPresentationBuilder
implements PresentationBuilder {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="openoffice")
    private HTMLCleaner officeHTMLCleaner;
    @Inject
    @Named(value="xhtml/1.0")
    private Parser xhtmlParser;
    @Inject
    private PresentationBuilderConfiguration presentationBuilderConfiguration;

    @Override
    public XDOMOfficeDocument build(InputStream officeFileStream, String officeFileName, DocumentReference documentReference) throws OfficeImporterException {
        Pair<String, Map<String, OfficeDocumentArtifact>> htmlPresentationResult;
        OfficeConverterResult officeConverterResult = this.importPresentation(officeFileStream, officeFileName);
        try {
            htmlPresentationResult = this.buildPresentationHTML(officeConverterResult, StringUtils.substringBeforeLast((String)officeFileName, (String)"."));
        }
        catch (IOException e) {
            throw new OfficeImporterException("Error while preparing the presentation artifacts.", e);
        }
        String html = this.cleanPresentationHTML((String)htmlPresentationResult.getLeft(), documentReference);
        XDOM xdom = this.buildPresentationXDOM(html, documentReference);
        return new XDOMOfficeDocument(xdom, (Map)htmlPresentationResult.getRight(), (ComponentManager)this.contextComponentManagerProvider.get(), officeConverterResult);
    }

    protected OfficeConverterResult importPresentation(InputStream officeFileStream, String officeFileName) throws OfficeImporterException {
        String inputFileName = OfficeConverterFileStorage.getSafeInputFilenameFromExtension(officeFileName);
        Map<String, InputStream> inputStreams = Map.of(inputFileName, officeFileStream);
        try {
            return this.officeServer.getConverter().convertDocument(inputStreams, inputFileName, "presentation.pdf");
        }
        catch (OfficeConverterException e) {
            String message = "Error while converting document [%s] into html.";
            throw new OfficeImporterException(String.format(message, officeFileName), e);
        }
    }

    protected Pair<String, Map<String, OfficeDocumentArtifact>> buildPresentationHTML(OfficeConverterResult officeConverterResult, String nameSpace) throws IOException {
        HashMap<String, FileOfficeDocumentArtifact> artifactFiles = new HashMap<String, FileOfficeDocumentArtifact>();
        String imageFormat = this.presentationBuilderConfiguration.getImageFormat();
        float quality = this.presentationBuilderConfiguration.getQuality();
        ArrayList<String> filenames = new ArrayList<String>();
        try (PDDocument document = PDDocument.load((File)officeConverterResult.getOutputFile());){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            int numberOfPages = document.getPages().getCount();
            for (int pageCounter = 0; pageCounter < numberOfPages; ++pageCounter) {
                int outputWidth = this.presentationBuilderConfiguration.getSlideWidth();
                float pageWidth = document.getPage(pageCounter).getMediaBox().getWidth();
                float scale = ((float)outputWidth + 0.5f) / pageWidth;
                BufferedImage bim = pdfRenderer.renderImage(pageCounter, scale, ImageType.RGB);
                String slideFileName = String.format("slide%s.%s", pageCounter, imageFormat);
                File imageFile = new File(officeConverterResult.getOutputDirectory(), slideFileName);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(imageFile));){
                    ImageIOUtil.writeImage((BufferedImage)bim, (String)imageFormat, (OutputStream)outputStream, (int)((int)(scale * 72.0f)), (float)quality);
                }
                String slideImageName = String.format("%s-slide%s.%s", nameSpace, pageCounter, imageFormat);
                artifactFiles.put(slideImageName, new FileOfficeDocumentArtifact(slideImageName, imageFile));
                String slideImageURL = URLEncoder.encode(slideImageName, StandardCharsets.UTF_8);
                slideImageURL = slideImageURL.replace('+', ' ');
                filenames.add(slideImageURL);
            }
        }
        String presentationHTML = filenames.stream().map(entry -> String.format("<p><img src=\"%s\"/></p>", XMLUtils.escapeAttributeValue((String)entry))).collect(Collectors.joining());
        return Pair.of((Object)presentationHTML, artifactFiles);
    }

    protected String cleanPresentationHTML(String dirtyHTML, DocumentReference targetDocumentReference) {
        HTMLCleanerConfiguration configuration = this.officeHTMLCleaner.getDefaultConfiguration();
        configuration.setParameters(Collections.singletonMap("targetDocument", (String)this.entityReferenceSerializer.serialize((EntityReference)targetDocumentReference, new Object[0])));
        Document xhtmlDocument = this.officeHTMLCleaner.clean((Reader)new StringReader(dirtyHTML), configuration);
        HTMLUtils.stripHTMLEnvelope((Document)xhtmlDocument);
        return HTMLUtils.toString((Document)xhtmlDocument);
    }

    protected XDOM buildPresentationXDOM(String html, DocumentReference targetDocumentReference) throws OfficeImporterException {
        try {
            ComponentManager contextComponentManager = (ComponentManager)this.contextComponentManagerProvider.get();
            String syntaxId = this.documentAccessBridge.getTranslatedDocumentInstance(targetDocumentReference).getSyntax().toIdString();
            BlockRenderer renderer = (BlockRenderer)contextComponentManager.getInstance(BlockRenderer.class, syntaxId);
            Map galleryParameters = Collections.emptyMap();
            ExpandedMacroBlock gallery = new ExpandedMacroBlock("gallery", galleryParameters, renderer, false, contextComponentManager);
            gallery.addChild((Block)this.xhtmlParser.parse((Reader)new StringReader(html)));
            XDOM xdom = new XDOM(Collections.singletonList(gallery));
            xdom.getMetaData().addMetaData("base", this.entityReferenceSerializer.serialize((EntityReference)targetDocumentReference, new Object[0]));
            return xdom;
        }
        catch (Exception e) {
            throw new OfficeImporterException("Failed to build presentation XDOM.", e);
        }
    }
}

