/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.document;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.officeimporter.converter.OfficeConverterResult;
import org.xwiki.officeimporter.document.OfficeDocument;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XDOMOfficeDocumentCompatibilityAspect;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

public class XDOMOfficeDocument
implements OfficeDocument {
    private XDOM xdom;
    private final Map<String, OfficeDocumentArtifact> artifactsMap;
    private ComponentManager componentManager;
    private OfficeConverterResult converterResult;
    @Deprecated
    private Map<String, byte[]> artifacts;
    @Deprecated
    private Set<File> fileArtifacts;

    public XDOMOfficeDocument(XDOM xdom, Map<String, OfficeDocumentArtifact> artifacts, ComponentManager componentManager, OfficeConverterResult converterResult) {
        XDOMOfficeDocumentCompatibilityAspect.ajc$interFieldInit$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument$artifacts(this);
        XDOMOfficeDocumentCompatibilityAspect.ajc$interFieldInit$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument$fileArtifacts(this);
        this.xdom = xdom;
        this.artifactsMap = artifacts;
        this.componentManager = componentManager;
        this.converterResult = converterResult;
    }

    public XDOM getContentDocument() {
        return this.xdom;
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString(Syntax.XWIKI_2_1.toIdString());
    }

    public String getContentAsString(String syntaxId) {
        try {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, syntaxId);
            renderer.render((Block)this.xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }

    @Override
    public Map<String, OfficeDocumentArtifact> getArtifactsMap() {
        return this.artifactsMap;
    }

    public String getTitle() {
        String title = this.getTitle((Block)this.xdom);
        if (null != title && (title = title.replaceAll("[\n\r]", "")).length() > 768) {
            title = title.substring(0, 768);
        }
        return title;
    }

    private String getTitle(Block parent) {
        for (Block block : parent.getChildren()) {
            if (block instanceof HeaderBlock) {
                String title = this.renderTitle((HeaderBlock)block);
                if (StringUtils.isBlank((CharSequence)title)) continue;
                return title;
            }
            if (!(block instanceof SectionBlock)) continue;
            return this.getTitle(block);
        }
        return null;
    }

    private String renderTitle(HeaderBlock header) {
        try {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, "plain/1.0");
            renderer.render((Block)header, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.converterResult != null) {
            this.converterResult.close();
        }
    }

    @Override
    public OfficeConverterResult getConverterResult() {
        return this.converterResult;
    }

    @Deprecated
    public XDOMOfficeDocument(XDOM xDOM, Map map, ComponentManager componentManager) {
        Object[] objectArray = XDOMOfficeDocumentCompatibilityAspect.ajc$preInterConstructor$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument(xDOM, map, componentManager);
        this((XDOM)objectArray[0], (Map)objectArray[1], (ComponentManager)objectArray[2], (OfficeConverterResult)objectArray[3]);
        XDOMOfficeDocumentCompatibilityAspect.ajc$postInterConstructor$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument(this, (XDOM)objectArray[4], (Map)objectArray[5], (ComponentManager)objectArray[6]);
    }

    @Deprecated(since="14.10.8, 15.3RC1")
    public XDOMOfficeDocument(XDOM xDOM, Set set, ComponentManager componentManager, OfficeConverterResult officeConverterResult) {
        Object[] objectArray = XDOMOfficeDocumentCompatibilityAspect.ajc$preInterConstructor$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument(xDOM, set, componentManager, officeConverterResult);
        this((XDOM)objectArray[0], (Map)objectArray[1], (ComponentManager)objectArray[2], (OfficeConverterResult)objectArray[3]);
        XDOMOfficeDocumentCompatibilityAspect.ajc$postInterConstructor$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument(this, (XDOM)objectArray[4], (Set)objectArray[5], (ComponentManager)objectArray[6], (OfficeConverterResult)objectArray[7]);
    }

    public static /* synthetic */ Set ajc$get$fileArtifacts(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.fileArtifacts;
    }

    public static /* synthetic */ void ajc$set$fileArtifacts(XDOMOfficeDocument xDOMOfficeDocument, Set set) {
        xDOMOfficeDocument.fileArtifacts = set;
    }

    public static /* synthetic */ XDOM ajc$get$xdom(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.xdom;
    }

    public static /* synthetic */ void ajc$set$xdom(XDOMOfficeDocument xDOMOfficeDocument, XDOM xDOM) {
        xDOMOfficeDocument.xdom = xDOM;
    }

    public static /* synthetic */ Map ajc$get$artifactsMap(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.artifactsMap;
    }

    public static /* synthetic */ void ajc$set$artifactsMap(XDOMOfficeDocument xDOMOfficeDocument, Map map) {
        xDOMOfficeDocument.artifactsMap = map;
    }

    public static /* synthetic */ OfficeConverterResult ajc$get$converterResult(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.converterResult;
    }

    public static /* synthetic */ void ajc$set$converterResult(XDOMOfficeDocument xDOMOfficeDocument, OfficeConverterResult officeConverterResult) {
        xDOMOfficeDocument.converterResult = officeConverterResult;
    }

    public static /* synthetic */ ComponentManager ajc$get$componentManager(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.componentManager;
    }

    public static /* synthetic */ void ajc$set$componentManager(XDOMOfficeDocument xDOMOfficeDocument, ComponentManager componentManager) {
        xDOMOfficeDocument.componentManager = componentManager;
    }

    public static /* synthetic */ Map ajc$get$artifacts(XDOMOfficeDocument xDOMOfficeDocument) {
        return xDOMOfficeDocument.artifacts;
    }

    public static /* synthetic */ void ajc$set$artifacts(XDOMOfficeDocument xDOMOfficeDocument, Map map) {
        xDOMOfficeDocument.artifacts = map;
    }

    @Override
    @Deprecated
    public Map<String, byte[]> getArtifacts() {
        return XDOMOfficeDocumentCompatibilityAspect.ajc$interMethod$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument$getArtifacts(this);
    }

    @Override
    @Deprecated
    public Set<File> getArtifactsFiles() {
        return XDOMOfficeDocumentCompatibilityAspect.ajc$interMethod$org_xwiki_officeimporter_document_XDOMOfficeDocumentCompatibilityAspect$org_xwiki_officeimporter_document_XDOMOfficeDocument$getArtifactsFiles(this);
    }
}

