/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.eventstream.Event;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.internal.SimilarityCalculator;
import org.xwiki.notifications.notifiers.internal.email.live.LiveNotificationEmailSender;

@Component(roles={LiveNotificationEmailManager.class})
@Singleton
@Deprecated(since="15.5RC1")
public class LiveNotificationEmailManager
implements Initializable {
    @Inject
    private SimilarityCalculator similarityCalculator;
    @Inject
    private LiveNotificationEmailSender liveNotificationEmailSender;
    @Inject
    private NotificationConfiguration notificationConfiguration;
    private int graceTime = 10;
    private Queue<QueueElement> queue = new ConcurrentLinkedDeque<QueueElement>();

    public void addEvent(Event event) {
        for (QueueElement element : this.queue) {
            int similarity = this.similarityCalculator.computeSimilarity(event, (Event)element.event.getEvents().get(0));
            if (similarity <= 0 || element.event.getSimilarityBetweenEvents() > similarity) continue;
            try {
                element.event.add(event, similarity);
                return;
            }
            catch (NotificationException notificationException) {
            }
        }
        this.queue.add(new QueueElement(new CompositeEvent(event), DateTime.now().plusMinutes(this.graceTime)));
    }

    public void run() {
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            QueueElement element = (QueueElement)it.next();
            if (element.date.isBeforeNow()) {
                this.liveNotificationEmailSender.sendEmails(element.event);
                it.remove();
                continue;
            }
            return;
        }
    }

    public DateTime getNextExecutionDate() {
        if (!this.queue.isEmpty()) {
            return this.queue.peek().date;
        }
        return null;
    }

    public void initialize() throws InitializationException {
        this.graceTime = this.notificationConfiguration.liveNotificationsGraceTime();
    }

    private class QueueElement {
        private CompositeEvent event;
        private DateTime date;

        QueueElement(CompositeEvent event, DateTime date) {
            this.event = event;
            this.date = date;
        }
    }
}

