/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.user;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.preferences.NotificationPreference;

@Component
@Singleton
@Named(value="ownEventsNotificationFilter")
public class OwnEventFilter
implements NotificationFilter,
ToggleableNotificationFilter {
    public static final String FILTER_NAME = "ownEventsNotificationFilter";
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return event.getTarget().isEmpty() && user != null && user.equals((Object)event.getUser()) ? NotificationFilter.FilterPolicy.FILTER : NotificationFilter.FilterPolicy.NO_EFFECT;
    }

    @Override
    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (type == NotificationFilterType.EXCLUSIVE && user != null) {
            return ExpressionBuilder.value(EventProperty.USER).notEq(ExpressionBuilder.value((String)this.serializer.serialize((EntityReference)user, new Object[0])));
        }
        return null;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }
}

