/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.text.XWikiToStringBuilder;

public class ScopeNotificationFilterPreferencesHierarchy {
    private List<ScopeNotificationFilterPreference> preferences;

    public ScopeNotificationFilterPreferencesHierarchy(List<ScopeNotificationFilterPreference> preferences) {
        this.preferences = preferences;
        List<ScopeNotificationFilterPreference> potentialParents = preferences.stream().filter(ScopeNotificationFilterPreference::isPotentialParent).toList();
        List<ScopeNotificationFilterPreference> potentialChildren = preferences.stream().filter(ScopeNotificationFilterPreference::isPotentialChild).toList();
        for (ScopeNotificationFilterPreference potentialParent : potentialParents) {
            for (ScopeNotificationFilterPreference potentialChild : potentialChildren) {
                if (potentialChild == potentialParent || !potentialParent.isParentOf(potentialChild)) continue;
                potentialParent.addChild(potentialChild);
            }
        }
    }

    public Iterator<ScopeNotificationFilterPreference> getExclusiveFiltersThatHasNoParents() {
        return this.preferences.stream().filter(pref -> !pref.hasParent() && pref.getFilterType() == NotificationFilterType.EXCLUSIVE).iterator();
    }

    public Iterator<ScopeNotificationFilterPreference> getInclusiveFiltersThatHasNoParents() {
        return this.preferences.stream().filter(pref -> !pref.hasParent() && pref.getFilterType() == NotificationFilterType.INCLUSIVE).iterator();
    }

    public boolean isEmpty() {
        return this.preferences.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeNotificationFilterPreferencesHierarchy that = (ScopeNotificationFilterPreferencesHierarchy)o;
        return new EqualsBuilder().append(this.preferences, that.preferences).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 37).append(this.preferences).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("preferences", this.preferences).toString();
    }
}

