/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreferencesGetter;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreferencesHierarchy;
import org.xwiki.notifications.filters.internal.scope.WatchedLocationState;

@Component(roles={ScopeNotificationFilterLocationStateComputer.class})
@Singleton
public class ScopeNotificationFilterLocationStateComputer {
    @Inject
    private ScopeNotificationFilterPreferencesGetter preferencesGetter;

    public WatchedLocationState isLocationWatchedWithAllTypesAndFormats(Collection<NotificationFilterPreference> filterPreferences, EntityReference location) {
        ScopeNotificationFilterPreferencesHierarchy preferencesAllFormatsAndAllEventsTypes = this.preferencesGetter.getScopeFilterPreferences(filterPreferences, null, null, true, true);
        ScopeNotificationFilterPreferencesHierarchy preferencesAnyFormatAnyEventTypes = this.preferencesGetter.getScopeFilterPreferences(filterPreferences, null, null, false, false);
        WatchedLocationState result = new WatchedLocationState();
        if (!filterPreferences.isEmpty()) {
            Optional<WatchedLocationState> optionalWatchedLocationState = this.handleExclusiveFilters(location, preferencesAllFormatsAndAllEventsTypes, true);
            if (optionalWatchedLocationState.isPresent()) {
                result = optionalWatchedLocationState.get();
            } else {
                optionalWatchedLocationState = this.handleExclusiveFilters(location, preferencesAnyFormatAnyEventTypes, false);
                if (optionalWatchedLocationState.isPresent()) {
                    result = optionalWatchedLocationState.get();
                }
            }
            optionalWatchedLocationState = this.handleInclusiveFilters(location, preferencesAllFormatsAndAllEventsTypes, true);
            if (result.getState() == WatchedLocationState.WatchedState.NOT_SET && optionalWatchedLocationState.isPresent()) {
                result = optionalWatchedLocationState.get();
            } else if (result.getState() == WatchedLocationState.WatchedState.NOT_SET && (optionalWatchedLocationState = this.handleInclusiveFilters(location, preferencesAnyFormatAnyEventTypes, false)).isPresent()) {
                result = optionalWatchedLocationState.get();
            }
        }
        return result;
    }

    public WatchedLocationState isLocationWatched(Collection<NotificationFilterPreference> filterPreferences, EntityReference location, String eventType, NotificationFormat format, boolean onlyGivenType, boolean handleInclusiveFilters, boolean onlyGivenFormat) {
        ScopeNotificationFilterPreferencesHierarchy preferences = this.preferencesGetter.getScopeFilterPreferences(filterPreferences, eventType, format, onlyGivenType, onlyGivenFormat);
        WatchedLocationState result = new WatchedLocationState();
        if (!filterPreferences.isEmpty()) {
            Optional<WatchedLocationState> optionalWatchedLocationState = this.handleExclusiveFilters(location, preferences, true);
            if (optionalWatchedLocationState.isPresent()) {
                result = optionalWatchedLocationState.get();
            } else if (handleInclusiveFilters && (optionalWatchedLocationState = this.handleInclusiveFilters(location, preferences, true)).isPresent()) {
                result = optionalWatchedLocationState.get();
            }
        }
        return result;
    }

    private Optional<WatchedLocationState> handleInclusiveFilters(EntityReference location, ScopeNotificationFilterPreferencesHierarchy preferencesHierarchy, boolean allEventsAllFormats) {
        Optional<WatchedLocationState> result = Optional.empty();
        boolean match = false;
        Date startingDate = null;
        Iterator<ScopeNotificationFilterPreference> inclusiveFiltersIterator = preferencesHierarchy.getInclusiveFiltersThatHasNoParents();
        boolean exactMatch = false;
        boolean spaceMatch = false;
        while (inclusiveFiltersIterator.hasNext()) {
            ScopeNotificationFilterPreference pref = inclusiveFiltersIterator.next();
            boolean isExactMatch = this.isExactMatch(pref, location);
            boolean isParentMatch = this.isParentMatch(pref, location);
            boolean isSpaceMatch = this.isSpaceMatch(pref, location);
            if (!isExactMatch && !isParentMatch) continue;
            match = true;
            exactMatch = isExactMatch;
            spaceMatch |= isSpaceMatch;
            startingDate = pref.getStartingDate();
            if (!exactMatch) continue;
            break;
        }
        if (match) {
            WatchedLocationState.WatchedState watchedState = ScopeNotificationFilterLocationStateComputer.getWatchedState(allEventsAllFormats, exactMatch, spaceMatch, true);
            result = Optional.of(new WatchedLocationState(watchedState, startingDate));
        }
        return result;
    }

    private static WatchedLocationState.WatchedState getWatchedState(boolean allEventsAllFormats, boolean exactMatch, boolean spaceMatch, boolean isInclusive) {
        WatchedLocationState.WatchedState watchedState = !allEventsAllFormats ? WatchedLocationState.WatchedState.CUSTOM : (exactMatch ? (isInclusive ? WatchedLocationState.WatchedState.WATCHED : WatchedLocationState.WatchedState.BLOCKED) : (spaceMatch ? (isInclusive ? WatchedLocationState.WatchedState.WATCHED_WITH_CHILDREN : WatchedLocationState.WatchedState.BLOCKED_WITH_CHILDREN) : (isInclusive ? WatchedLocationState.WatchedState.WATCHED_BY_ANCESTOR : WatchedLocationState.WatchedState.BLOCKED_BY_ANCESTOR)));
        return watchedState;
    }

    private Optional<WatchedLocationState> handleExclusiveFilters(EntityReference location, ScopeNotificationFilterPreferencesHierarchy preferences, boolean allTypesAndEvents) {
        WatchedLocationState.WatchedState state = null;
        int deepestLevel = 0;
        Date startingDate = null;
        Iterator<ScopeNotificationFilterPreference> it = preferences.getExclusiveFiltersThatHasNoParents();
        while (it.hasNext()) {
            ScopeNotificationFilterPreference pref = it.next();
            int deepLevel = pref.getScopeReference().size();
            boolean isExactMatch = this.isExactMatch(pref, location);
            boolean isParentMatch = this.isParentMatch(pref, location);
            boolean isSpaceMatch = this.isSpaceMatch(pref, location);
            if (!isExactMatch && !isParentMatch || deepLevel <= deepestLevel) continue;
            state = ScopeNotificationFilterLocationStateComputer.getWatchedState(allTypesAndEvents, isExactMatch, isSpaceMatch, false);
            startingDate = pref.getStartingDate();
            deepestLevel = deepLevel;
            for (ScopeNotificationFilterPreference child : pref.getChildren()) {
                int childDeepLevel = child.getScopeReference().size();
                boolean isChildExactMatch = this.isExactMatch(child, location);
                boolean isChildParentMatch = this.isParentMatch(child, location);
                boolean isChildSpaceMatch = this.isSpaceMatch(child, location);
                if (!isChildExactMatch && !isChildParentMatch || childDeepLevel <= deepestLevel) continue;
                state = ScopeNotificationFilterLocationStateComputer.getWatchedState(allTypesAndEvents, isChildExactMatch, isChildSpaceMatch, true);
                deepestLevel = childDeepLevel;
                startingDate = child.getStartingDate();
            }
        }
        if (state != null) {
            return Optional.of(new WatchedLocationState(state, startingDate));
        }
        return Optional.empty();
    }

    private boolean isSpaceMatch(ScopeNotificationFilterPreference pref, EntityReference location) {
        boolean result = false;
        EntityReference scopeReference = pref.getScopeReference();
        if (scopeReference.getType() == EntityType.SPACE) {
            result = new DocumentReference("WebHome", new SpaceReference(scopeReference)).equals((Object)location);
        }
        return result;
    }

    private boolean isExactMatch(ScopeNotificationFilterPreference pref, EntityReference location) {
        return location.equals((Object)pref.getScopeReference());
    }

    private boolean isParentMatch(ScopeNotificationFilterPreference pref, EntityReference location) {
        return location.hasParent(pref.getScopeReference());
    }
}

