/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.minor;

import java.util.Collection;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.preferences.NotificationPreference;

public abstract class AbstractMinorEventNotificationFilter
implements NotificationFilter,
ToggleableNotificationFilter {
    private static final String UPDATE_TYPE = "update";
    private static final String VERSION_SCHEME = ".1";
    private String filterName;
    private NotificationFormat format;

    public AbstractMinorEventNotificationFilter(String filterName, NotificationFormat format) {
        this.filterName = filterName;
        this.format = format;
    }

    @Override
    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.getFormats().contains(format) && event.getType().equals(UPDATE_TYPE) && !event.getDocumentVersion().endsWith(VERSION_SCHEME) ? NotificationFilter.FilterPolicy.FILTER : NotificationFilter.FilterPolicy.NO_EFFECT;
    }

    @Override
    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (type == NotificationFilterType.EXCLUSIVE && format == this.format) {
            return ExpressionBuilder.not(ExpressionBuilder.value(EventProperty.TYPE).eq(ExpressionBuilder.value(UPDATE_TYPE)).and(ExpressionBuilder.not(ExpressionBuilder.value(EventProperty.DOCUMENT_VERSION).endsWith(ExpressionBuilder.value(VERSION_SCHEME)))));
        }
        return null;
    }

    @Override
    public String getName() {
        return this.filterName;
    }

    @Override
    public int getPriority() {
        return 4000;
    }
}

