/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.event.CleaningFilterEvent;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component(roles={DeletedDocumentCleanUpFilterProcessingQueue.class})
@Singleton
public class DeletedDocumentCleanUpFilterProcessingQueue
implements Initializable,
Disposable {
    private static final CleanUpFilterData STOP_DATA = new CleanUpFilterData(null, null);
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private Logger logger;
    private final BlockingQueue<CleanUpFilterData> cleanupQueue = new LinkedBlockingQueue<CleanUpFilterData>();
    private boolean disposed;

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        this.cleanupQueue.clear();
        this.cleanupQueue.add(STOP_DATA);
    }

    public void initialize() throws InitializationException {
        Thread optimizeThreadthread = new Thread((Runnable)new ExecutionContextRunnable(this::cleanup, this.componentManager));
        optimizeThreadthread.setName("Notification filters clean up queue");
        optimizeThreadthread.setPriority(4);
        optimizeThreadthread.setDaemon(true);
        optimizeThreadthread.start();
    }

    public void addCleanUpTask(DocumentReference user, DocumentReference deletedDocument) {
        if (!this.disposed) {
            this.cleanupQueue.add(new CleanUpFilterData(user, deletedDocument));
        }
    }

    private void cleanup() {
        while (!this.disposed) {
            CleanUpFilterData cleanUpFilterData;
            try {
                cleanUpFilterData = this.cleanupQueue.take();
            }
            catch (InterruptedException e) {
                this.logger.warn("The thread handling filter clean up has been interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            if (cleanUpFilterData == STOP_DATA) continue;
            this.performCleanup(cleanUpFilterData);
        }
    }

    private void performCleanup(CleanUpFilterData data) {
        DocumentReference deletedDocumentReference = data.deletedDocument;
        DocumentReference user = data.user;
        String serializedReference = (String)this.entityReferenceSerializer.serialize((EntityReference)deletedDocumentReference, new Object[0]);
        try {
            Set matchingPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(user).stream().filter(pref -> Strings.CS.equals(pref.getPageOnly(), serializedReference)).collect(Collectors.toSet());
            if (!matchingPreferences.isEmpty()) {
                CleaningFilterEvent cleaningFilterEvent = new CleaningFilterEvent();
                this.observationManager.notify((Event)cleaningFilterEvent, (Object)deletedDocumentReference, matchingPreferences);
                if (!cleaningFilterEvent.isCanceled()) {
                    this.notificationFilterPreferenceManager.deleteFilterPreferences(user, matchingPreferences.stream().map(NotificationFilterPreference::getId).collect(Collectors.toSet()));
                }
            }
        }
        catch (NotificationException e) {
            this.logger.error("Error while trying to clean up filter for user [{}] and document [{}]", new Object[]{user, deletedDocumentReference, e});
        }
    }

    private static class CleanUpFilterData {
        private final DocumentReference user;
        private final DocumentReference deletedDocument;

        CleanUpFilterData(DocumentReference user, DocumentReference deletedDocument) {
            this.user = user;
            this.deletedDocument = deletedDocument;
        }
    }
}

