/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;

@Component
@Singleton
public class DefaultNotificationFilterPreferenceManager
implements NotificationFilterPreferenceManager {
    @Inject
    @Named(value="cached")
    private FilterPreferencesModelBridge filterPreferencesModelBridge;

    public Set<NotificationFilterPreference> getFilterPreferences(DocumentReference user) throws NotificationException {
        return this.filterPreferencesModelBridge.getFilterPreferences(user);
    }

    public Set<NotificationFilterPreference> getFilterPreferences(WikiReference wikiReference) throws NotificationException {
        return this.filterPreferencesModelBridge.getFilterPreferences(wikiReference);
    }

    @Override
    public Stream<NotificationFilterPreference> getFilterPreferences(Collection<NotificationFilterPreference> filterPreferences, NotificationFilter filter) {
        return filterPreferences.stream().filter(preference -> filter.getName().equals(preference.getFilterName()));
    }

    @Override
    public Stream<NotificationFilterPreference> getFilterPreferences(Collection<NotificationFilterPreference> filterPreferences, NotificationFilter filter, NotificationFilterType filterType) {
        return this.getFilterPreferences(filterPreferences, filter).filter(preference -> preference.getFilterType() == filterType);
    }

    @Override
    public Stream<NotificationFilterPreference> getFilterPreferences(Collection<NotificationFilterPreference> filterPreferences, NotificationFilter filter, NotificationFilterType filterType, NotificationFormat format) {
        return this.getFilterPreferences(filterPreferences, filter, filterType).filter(preference -> preference.getNotificationFormats().contains(format));
    }

    @Override
    public void saveFilterPreferences(DocumentReference user, Set<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.filterPreferencesModelBridge.saveFilterPreferences(user, filterPreferences);
    }

    @Override
    public void deleteFilterPreference(DocumentReference user, String filterPreferenceId) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreference(user, filterPreferenceId);
    }

    @Override
    public void deleteFilterPreferences(DocumentReference user, Set<String> filterPreferenceIds) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreferences(user, filterPreferenceIds);
    }

    @Override
    public void deleteFilterPreference(WikiReference wikiReference, String filterPreferenceId) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreference(wikiReference, filterPreferenceId);
    }

    @Override
    public void setFilterPreferenceEnabled(DocumentReference user, String filterPreferenceId, boolean enabled) throws NotificationException {
        this.filterPreferencesModelBridge.setFilterPreferenceEnabled(user, filterPreferenceId, enabled);
    }

    @Override
    public void setFilterPreferenceEnabled(WikiReference wikiReference, String filterPreferenceId, boolean enabled) throws NotificationException {
        this.filterPreferencesModelBridge.setFilterPreferenceEnabled(wikiReference, filterPreferenceId, enabled);
    }

    @Override
    public void setStartDateForUser(DocumentReference user, Date startDate) throws NotificationException {
        this.filterPreferencesModelBridge.setStartDateForUser(user, startDate);
    }
}

