/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.internal.DefaultNotificationConfigurationCompatibilityAspect;

@Component
@Singleton
public class DefaultNotificationConfiguration
implements NotificationConfiguration {
    private static final String CONFIGURATION_PREFIX = "notifications.";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;

    @Override
    public boolean isEnabled() {
        return (Boolean)this.configurationSource.getProperty("notifications.enabled", (Object)true);
    }

    @Override
    public boolean areEmailsEnabled() {
        return (Boolean)this.configurationSource.getProperty("notifications.emails.enabled", (Object)true);
    }

    @Override
    public int liveNotificationsGraceTime() {
        int graceTime = (Integer)this.configurationSource.getProperty("notifications.emails.live.graceTime", (Object)10);
        return graceTime < 0 ? 0 : graceTime;
    }

    @Override
    public boolean isRestCacheEnabled() {
        return (Boolean)this.configurationSource.getProperty("notifications.rest.cache", (Object)true);
    }

    @Override
    public int getRESTPoolSize() {
        return (Integer)this.configurationSource.getProperty("notifications.rest.poolSize", (Object)2);
    }

    @Override
    public int getAsyncPoolSize() {
        return (Integer)this.configurationSource.getProperty("notifications.async.poolSize", (Object)2);
    }

    @Override
    public String getEmailGroupingStrategyHint() {
        return (String)this.configurationSource.getProperty("notifications.emailGroupingStrategyHint", (Object)"default");
    }

    public static /* synthetic */ ConfigurationSource ajc$get$configurationSource(DefaultNotificationConfiguration defaultNotificationConfiguration) {
        return defaultNotificationConfiguration.configurationSource;
    }

    public static /* synthetic */ void ajc$set$configurationSource(DefaultNotificationConfiguration defaultNotificationConfiguration, ConfigurationSource configurationSource) {
        defaultNotificationConfiguration.configurationSource = configurationSource;
    }

    public static /* synthetic */ String ajc$get$CONFIGURATION_PREFIX() {
        return CONFIGURATION_PREFIX;
    }

    public static /* synthetic */ void ajc$set$CONFIGURATION_PREFIX(String string) {
        CONFIGURATION_PREFIX = string;
    }

    @Override
    public boolean isEventPrefilteringEnabled() {
        return DefaultNotificationConfigurationCompatibilityAspect.ajc$interMethod$org_xwiki_notifications_internal_DefaultNotificationConfigurationCompatibilityAspect$org_xwiki_notifications_internal_DefaultNotificationConfiguration$isEventPrefilteringEnabled(this);
    }
}

