/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventStrategy;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.internal.SimilarityCalculator;

@Component
@Singleton
public class DefaultGroupingEventStrategy
implements GroupingEventStrategy {
    @Inject
    private SimilarityCalculator similarityCalculator;

    private void recordEvent(List<CompositeEvent> results, Event event) throws NotificationException {
        BestSimilarity bestSimilarity = this.getBestSimilarity(results, event);
        if (bestSimilarity.compositeEvent != null) {
            if (bestSimilarity.value > bestSimilarity.compositeEvent.getSimilarityBetweenEvents() && bestSimilarity.compositeEvent.getEvents().size() > 1) {
                bestSimilarity.compositeEvent.remove(bestSimilarity.event);
                BestSimilarity bestSecondChoice = this.getBestSimilarity(results, event);
                if (bestSecondChoice.compositeEvent != null && bestSecondChoice.isCompositeEventCompatibleWith(event)) {
                    bestSecondChoice.compositeEvent.add(bestSimilarity.event, bestSecondChoice.compositeEvent.getSimilarityBetweenEvents());
                    bestSecondChoice.compositeEvent.add(event, bestSecondChoice.compositeEvent.getSimilarityBetweenEvents());
                } else {
                    CompositeEvent newCompositeEvent = new CompositeEvent(event);
                    newCompositeEvent.add(bestSimilarity.event, bestSimilarity.value);
                    results.add(newCompositeEvent);
                }
                return;
            }
            if (bestSimilarity.value >= bestSimilarity.compositeEvent.getSimilarityBetweenEvents()) {
                bestSimilarity.compositeEvent.add(event, bestSimilarity.value);
                return;
            }
            if (bestSimilarity.isCompositeEventCompatibleWith(event)) {
                bestSimilarity.compositeEvent.add(event, bestSimilarity.compositeEvent.getSimilarityBetweenEvents());
                return;
            }
        }
        results.add(new CompositeEvent(event));
    }

    private BestSimilarity getBestSimilarity(List<CompositeEvent> results, Event event) {
        BestSimilarity bestSimilarity = new BestSimilarity();
        for (CompositeEvent existingCompositeEvent : results) {
            for (Event existingEvent : existingCompositeEvent.getEvents()) {
                int similarity = this.similarityCalculator.computeSimilarity(event, existingEvent);
                if (similarity < existingCompositeEvent.getSimilarityBetweenEvents()) {
                    similarity -= 5;
                }
                if (similarity <= bestSimilarity.value) continue;
                bestSimilarity.value = similarity;
                bestSimilarity.event = existingEvent;
                bestSimilarity.compositeEvent = existingCompositeEvent;
            }
        }
        return bestSimilarity;
    }

    @Override
    public List<CompositeEvent> group(List<Event> eventList) throws NotificationException {
        ArrayList<CompositeEvent> result = new ArrayList<CompositeEvent>();
        for (Event event : eventList) {
            this.recordEvent(result, event);
        }
        return result;
    }

    @Override
    public void group(List<CompositeEvent> compositeEvents, List<Event> newEvents) throws NotificationException {
        for (Event newEvent : newEvents) {
            this.recordEvent(compositeEvents, newEvent);
        }
    }

    private static final class BestSimilarity {
        private int value;
        private CompositeEvent compositeEvent;
        private Event event;

        private BestSimilarity() {
        }

        public boolean isCompositeEventCompatibleWith(Event event) {
            return this.compositeEvent.getSimilarityBetweenEvents() >= 10000 && this.compositeEvent.getType().equals(event.getType());
        }
    }
}

