/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.CompositeEventStatusManager;

@Component
@Singleton
public class DefaultCompositeEventStatusManager
implements CompositeEventStatusManager {
    private static final int BATCH_SIZE = 50;
    @Inject
    private EventStore eventStore;

    @Override
    public List<CompositeEventStatus> getCompositeEventStatuses(List<CompositeEvent> compositeEvents, String entityId) throws Exception {
        HashMap<String, CompositeEventStatus> statusMap = new HashMap<String, CompositeEventStatus>();
        ArrayList<CompositeEventStatus> results = new ArrayList<CompositeEventStatus>();
        LinkedList<Event> eventsToProcess = new LinkedList<Event>();
        for (CompositeEvent compositeEvent : compositeEvents) {
            CompositeEventStatus compositeEventStatus = new CompositeEventStatus(compositeEvent);
            results.add(compositeEventStatus);
            for (Event event : compositeEvent.getEvents()) {
                statusMap.put(event.getId(), compositeEventStatus);
                eventsToProcess.add(event);
            }
        }
        do {
            ArrayList<Event> subList = new ArrayList<Event>();
            for (int i = 0; i < 50 && !eventsToProcess.isEmpty(); ++i) {
                Event event = (Event)eventsToProcess.pop();
                subList.add(event);
            }
            for (EventStatus eventStatus : this.getEventStatuses(subList, entityId)) {
                ((CompositeEventStatus)statusMap.get(eventStatus.getEvent().getId())).add(eventStatus);
            }
        } while (!eventsToProcess.isEmpty());
        return results;
    }

    private List<EventStatus> getEventStatuses(List<Event> events, String entityId) throws Exception {
        return this.eventStore.getEventStatuses(events, Collections.singletonList(entityId));
    }
}

