/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.messagestream.internal.AbstractMessageStreamNotificationFilter;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.user.EventUserFilterPreferencesGetter;

@Component
@Singleton
@Named(value="PersonalMessageStreamNotificationFilter")
public class PersonalMessageStreamNotificationFilter
extends AbstractMessageStreamNotificationFilter {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private EventUserFilterPreferencesGetter preferencesGetter;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        if (!this.getEventType().equals(event.getType())) {
            return NotificationFilter.FilterPolicy.NO_EFFECT;
        }
        String sender = (String)this.serializer.serialize((EntityReference)event.getUser(), new Object[0]);
        return this.preferencesGetter.isUserFollowed(sender, filterPreferences, format) ? NotificationFilter.FilterPolicy.KEEP : NotificationFilter.FilterPolicy.FILTER;
    }

    public String getName() {
        return "Personal Message Stream Notification Filter";
    }

    @Override
    String getEventType() {
        return "personalMessage";
    }
}

